/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.config;

import java.util.Arrays;
import org.apache.kafka.common.config.ConfigResource;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ConfigResourceTest {
    @Test
    public void shouldGetTypeFromId() {
        Assertions.assertEquals((Object)ConfigResource.Type.TOPIC, (Object)ConfigResource.Type.forId((byte)2));
        Assertions.assertEquals((Object)ConfigResource.Type.BROKER, (Object)ConfigResource.Type.forId((byte)4));
        Assertions.assertEquals((Object)ConfigResource.Type.CLIENT_METRICS, (Object)ConfigResource.Type.forId((byte)16));
        Assertions.assertEquals((Object)ConfigResource.Type.GROUP, (Object)ConfigResource.Type.forId((byte)32));
    }

    @Test
    public void shouldReturnUnknownForUnknownCode() {
        Assertions.assertEquals((Object)ConfigResource.Type.UNKNOWN, (Object)ConfigResource.Type.forId((byte)-1));
        Assertions.assertEquals((Object)ConfigResource.Type.UNKNOWN, (Object)ConfigResource.Type.forId((byte)0));
        Assertions.assertEquals((Object)ConfigResource.Type.UNKNOWN, (Object)ConfigResource.Type.forId((byte)1));
    }

    @Test
    public void shouldRoundTripEveryType() {
        Arrays.stream(ConfigResource.Type.values()).forEach(type -> Assertions.assertEquals((Object)type, (Object)ConfigResource.Type.forId((byte)type.id()), (String)type.toString()));
    }
}

