/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.consumer.internals;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.kafka.clients.Metadata;
import org.apache.kafka.clients.consumer.internals.AutoOffsetResetStrategy;
import org.apache.kafka.clients.consumer.internals.ConsumerMetadata;
import org.apache.kafka.clients.consumer.internals.SubscriptionState;
import org.apache.kafka.common.Cluster;
import org.apache.kafka.common.ClusterResource;
import org.apache.kafka.common.ClusterResourceListener;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.internals.ClusterResourceListeners;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.MetadataRequest;
import org.apache.kafka.common.requests.MetadataResponse;
import org.apache.kafka.common.requests.RequestTestUtils;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class ConsumerMetadataTest {
    private final Node node = new Node(1, "localhost", 9092);
    private final SubscriptionState subscription = new SubscriptionState(new LogContext(), AutoOffsetResetStrategy.EARLIEST);
    private final Time time = new MockTime();

    @Test
    public void testPatternSubscriptionNoInternalTopics() {
        this.testPatternSubscription(false);
    }

    @Test
    public void testPatternSubscriptionIncludeInternalTopics() {
        this.testPatternSubscription(true);
    }

    private void testPatternSubscription(boolean includeInternalTopics) {
        this.subscription.subscribe(Pattern.compile("__.*"), Optional.empty());
        ConsumerMetadata metadata = this.newConsumerMetadata(includeInternalTopics);
        MetadataRequest.Builder builder = metadata.newMetadataRequestBuilder();
        Assertions.assertTrue((boolean)builder.isAllTopics());
        ArrayList<MetadataResponse.TopicMetadata> topics = new ArrayList<MetadataResponse.TopicMetadata>();
        topics.add(this.topicMetadata("__consumer_offsets", true));
        topics.add(this.topicMetadata("__matching_topic", false));
        topics.add(this.topicMetadata("non_matching_topic", false));
        MetadataResponse response = RequestTestUtils.metadataResponse(Collections.singletonList(this.node), "clusterId", this.node.id(), topics);
        metadata.updateWithCurrentRequestVersion(response, false, this.time.milliseconds());
        if (includeInternalTopics) {
            Assertions.assertEquals(Set.of("__matching_topic", "__consumer_offsets"), (Object)metadata.fetch().topics());
        } else {
            Assertions.assertEquals(Collections.singleton("__matching_topic"), (Object)metadata.fetch().topics());
        }
    }

    @Test
    public void testUserAssignment() {
        this.subscription.assignFromUser(Set.of(new TopicPartition("foo", 0), new TopicPartition("bar", 0), new TopicPartition("__consumer_offsets", 0)));
        this.testBasicSubscription(Set.of("foo", "bar"), Set.of("__consumer_offsets"));
        this.subscription.assignFromUser(Set.of(new TopicPartition("baz", 0), new TopicPartition("__consumer_offsets", 0)));
        this.testBasicSubscription(Set.of("baz"), Set.of("__consumer_offsets"));
    }

    @Test
    public void testNormalSubscription() {
        this.subscription.subscribe(Set.of("foo", "bar", "__consumer_offsets"), Optional.empty());
        this.subscription.groupSubscribe(Set.of("baz", "foo", "bar", "__consumer_offsets"));
        this.testBasicSubscription(Set.of("foo", "bar", "baz"), Set.of("__consumer_offsets"));
        this.subscription.resetGroupSubscription();
        this.testBasicSubscription(Set.of("foo", "bar"), Set.of("__consumer_offsets"));
    }

    @Test
    public void testTransientTopics() {
        HashMap<String, Uuid> topicIds = new HashMap<String, Uuid>();
        topicIds.put("foo", Uuid.randomUuid());
        this.subscription.subscribe(Collections.singleton("foo"), Optional.empty());
        ConsumerMetadata metadata = this.newConsumerMetadata(false);
        metadata.updateWithCurrentRequestVersion(RequestTestUtils.metadataUpdateWithIds(1, Collections.singletonMap("foo", 1), topicIds), false, this.time.milliseconds());
        Assertions.assertEquals(topicIds.get("foo"), metadata.topicIds().get("foo"));
        Assertions.assertFalse((boolean)metadata.updateRequested());
        metadata.addTransientTopics(Collections.singleton("foo"));
        Assertions.assertFalse((boolean)metadata.updateRequested());
        metadata.addTransientTopics(Collections.singleton("bar"));
        Assertions.assertTrue((boolean)metadata.updateRequested());
        HashMap<String, Integer> topicPartitionCounts = new HashMap<String, Integer>();
        topicPartitionCounts.put("foo", 1);
        topicPartitionCounts.put("bar", 1);
        topicIds.put("bar", Uuid.randomUuid());
        metadata.updateWithCurrentRequestVersion(RequestTestUtils.metadataUpdateWithIds(1, topicPartitionCounts, topicIds), false, this.time.milliseconds());
        Map metadataTopicIds = metadata.topicIds();
        topicIds.forEach((topicName, topicId) -> Assertions.assertEquals((Object)topicId, metadataTopicIds.get(topicName)));
        Assertions.assertFalse((boolean)metadata.updateRequested());
        Assertions.assertEquals(Set.of("foo", "bar"), new HashSet(metadata.fetch().topics()));
        metadata.clearTransientTopics();
        topicIds.remove("bar");
        metadata.updateWithCurrentRequestVersion(RequestTestUtils.metadataUpdateWithIds(1, topicPartitionCounts, topicIds), false, this.time.milliseconds());
        Assertions.assertEquals(Collections.singleton("foo"), new HashSet(metadata.fetch().topics()));
        Assertions.assertEquals(topicIds.get("foo"), metadata.topicIds().get("foo"));
        Assertions.assertNull(topicIds.get("bar"));
    }

    private void testBasicSubscription(Set<String> expectedTopics, Set<String> expectedInternalTopics) {
        HashSet<String> allTopics = new HashSet<String>();
        allTopics.addAll(expectedTopics);
        allTopics.addAll(expectedInternalTopics);
        ConsumerMetadata metadata = this.newConsumerMetadata(false);
        MetadataRequest.Builder builder = metadata.newMetadataRequestBuilder();
        Assertions.assertEquals(allTopics, new HashSet(builder.topics()));
        ArrayList<MetadataResponse.TopicMetadata> topics = new ArrayList<MetadataResponse.TopicMetadata>();
        for (String expectedTopic : expectedTopics) {
            topics.add(this.topicMetadata(expectedTopic, false));
        }
        for (String expectedInternalTopic : expectedInternalTopics) {
            topics.add(this.topicMetadata(expectedInternalTopic, true));
        }
        MetadataResponse response = RequestTestUtils.metadataResponse(Collections.singletonList(this.node), "clusterId", this.node.id(), topics);
        metadata.updateWithCurrentRequestVersion(response, false, this.time.milliseconds());
        Assertions.assertEquals(allTopics, (Object)metadata.fetch().topics());
    }

    private MetadataResponse.TopicMetadata topicMetadata(String topic, boolean isInternal) {
        MetadataResponse.PartitionMetadata partitionMetadata = new MetadataResponse.PartitionMetadata(Errors.NONE, new TopicPartition(topic, 0), Optional.of(this.node.id()), Optional.of(5), Collections.singletonList(this.node.id()), Collections.singletonList(this.node.id()), Collections.singletonList(this.node.id()));
        return new MetadataResponse.TopicMetadata(Errors.NONE, topic, isInternal, Collections.singletonList(partitionMetadata));
    }

    private ConsumerMetadata newConsumerMetadata(boolean includeInternalTopics) {
        long refreshBackoffMs = 50L;
        long expireMs = 50000L;
        return new ConsumerMetadata(refreshBackoffMs, refreshBackoffMs, expireMs, includeInternalTopics, false, this.subscription, new LogContext(), new ClusterResourceListeners());
    }

    @Test
    public void testInvalidPartitionLeadershipUpdates() {
        Metadata metadata = this.initializeMetadata();
        List<Node> originalNodes = this.initializeNodes(metadata);
        ClusterResourceListener mockListener = this.initializeMockListener(metadata);
        HashMap<TopicPartition, Metadata.LeaderIdAndEpoch> invalidUpdates = new HashMap<TopicPartition, Metadata.LeaderIdAndEpoch>();
        invalidUpdates.put(new TopicPartition("topic1", 999), new Metadata.LeaderIdAndEpoch(Optional.empty(), Optional.empty()));
        invalidUpdates.put(new TopicPartition("topic2", 0), new Metadata.LeaderIdAndEpoch(Optional.of(99999), Optional.of(99999)));
        invalidUpdates.put(new TopicPartition("topic_missing_from_existing_metadata", 1), new Metadata.LeaderIdAndEpoch(Optional.of(0), Optional.of(99999)));
        invalidUpdates.put(new TopicPartition("topic1", 0), new Metadata.LeaderIdAndEpoch(Optional.of(1), Optional.of(99)));
        Set updatedTps = metadata.updatePartitionLeadership(invalidUpdates, originalNodes);
        Assertions.assertTrue((boolean)updatedTps.isEmpty(), (String)"Invalid updates should be ignored");
        Cluster updatedCluster = metadata.fetch();
        Assertions.assertEquals(new HashSet<Node>(originalNodes), new HashSet(updatedCluster.nodes()));
        ((ClusterResourceListener)Mockito.verify((Object)mockListener, (VerificationMode)Mockito.never())).onUpdate((ClusterResource)ArgumentMatchers.any());
        this.validateForUpdatePartitionLeadership(metadata, this.metadataSupplier(Errors.NONE, new TopicPartition("topic1", 0), Optional.of(1), Optional.of(100), Arrays.asList(1, 2), Arrays.asList(1, 2), Collections.singletonList(3)), this.metadataSupplier(Errors.NONE, new TopicPartition("topic2", 0), Optional.of(2), Optional.of(200), Arrays.asList(2, 3), Arrays.asList(2, 3), Collections.singletonList(1)), this.metadataSupplier(Errors.NONE, new TopicPartition("topic1", 1), Optional.of(2), Optional.of(200), Arrays.asList(2, 3), Arrays.asList(2, 3), Collections.singletonList(1)), this.metadataSupplier(Errors.NONE, new TopicPartition("__consumer_offsets", 0), Optional.of(2), Optional.of(300), Arrays.asList(2, 3), Arrays.asList(2, 3), Collections.singletonList(1)), originalNodes, "kafka-cluster", Collections.singleton("topic4"), Collections.singleton("topic3"), Collections.singleton("__consumer_offsets"), updatedCluster.controller(), metadata.topicIds());
    }

    @Test
    public void testValidPartitionLeadershipUpdate() {
        Metadata metadata = this.initializeMetadata();
        List<Node> originalNodes = this.initializeNodes(metadata);
        ClusterResourceListener mockListener = this.initializeMockListener(metadata);
        HashMap<TopicPartition, Metadata.LeaderIdAndEpoch> validUpdates = new HashMap<TopicPartition, Metadata.LeaderIdAndEpoch>();
        TopicPartition tp11 = new TopicPartition("topic1", 0);
        Integer newLeaderId = 2;
        Integer newLeaderEpoch = 101;
        validUpdates.put(tp11, new Metadata.LeaderIdAndEpoch(Optional.of(newLeaderId), Optional.of(newLeaderEpoch)));
        Set updatedTps = metadata.updatePartitionLeadership(validUpdates, originalNodes);
        Assertions.assertEquals((int)1, (int)updatedTps.size());
        Assertions.assertEquals((Object)tp11, updatedTps.iterator().next(), (String)"tp11 should be updated");
        Cluster updatedCluster = metadata.fetch();
        Assertions.assertEquals(new HashSet<Node>(originalNodes), new HashSet(updatedCluster.nodes()));
        ((ClusterResourceListener)Mockito.verify((Object)mockListener, (VerificationMode)Mockito.times((int)1))).onUpdate((ClusterResource)ArgumentMatchers.any());
        this.validateForUpdatePartitionLeadership(metadata, new MetadataResponse.PartitionMetadata(Errors.NONE, tp11, Optional.of(newLeaderId), Optional.of(newLeaderEpoch), Arrays.asList(1, 2), Arrays.asList(1, 2), Collections.singletonList(3)), this.metadataSupplier(Errors.NONE, new TopicPartition("topic2", 0), Optional.of(2), Optional.of(200), Arrays.asList(2, 3), Arrays.asList(2, 3), Collections.singletonList(1)), this.metadataSupplier(Errors.NONE, new TopicPartition("topic1", 1), Optional.of(2), Optional.of(200), Arrays.asList(2, 3), Arrays.asList(2, 3), Collections.singletonList(1)), this.metadataSupplier(Errors.NONE, new TopicPartition("__consumer_offsets", 0), Optional.of(2), Optional.of(300), Arrays.asList(2, 3), Arrays.asList(2, 3), Collections.singletonList(1)), originalNodes, "kafka-cluster", Collections.singleton("topic4"), Collections.singleton("topic3"), Collections.singleton("__consumer_offsets"), updatedCluster.controller(), metadata.topicIds());
    }

    private Metadata initializeMetadata() {
        Metadata metadata = new Metadata(100L, 1000L, 1000L, new LogContext(), new ClusterResourceListeners());
        String topic1 = "topic1";
        String topic2 = "topic2";
        String topic3 = "topic3";
        String topic4 = "topic4";
        String clusterId = "kafka-cluster";
        Uuid topic1Id = Uuid.randomUuid();
        Uuid topic2Id = Uuid.randomUuid();
        Uuid internalTopicId = Uuid.randomUuid();
        HashMap<String, Uuid> topicIds = new HashMap<String, Uuid>();
        topicIds.put(topic1, topic1Id);
        topicIds.put(topic2, topic2Id);
        topicIds.put("__consumer_offsets", internalTopicId);
        HashMap<String, Errors> errorCounts = new HashMap<String, Errors>();
        errorCounts.put(topic3, Errors.INVALID_TOPIC_EXCEPTION);
        errorCounts.put(topic4, Errors.TOPIC_AUTHORIZATION_FAILED);
        HashMap<String, Integer> topicPartitionCounts = new HashMap<String, Integer>();
        topicPartitionCounts.put(topic1, 2);
        topicPartitionCounts.put(topic2, 1);
        topicPartitionCounts.put("__consumer_offsets", 1);
        metadata.requestUpdate(true);
        Metadata.MetadataRequestAndVersion versionAndBuilder = metadata.newMetadataRequestAndVersion(this.time.milliseconds());
        metadata.update(versionAndBuilder.requestVersion, RequestTestUtils.metadataUpdateWith(clusterId, 5, errorCounts, topicPartitionCounts, tp -> null, this::metadataSupplier, ApiKeys.METADATA.latestVersion(), topicIds), false, this.time.milliseconds());
        return metadata;
    }

    private List<Node> initializeNodes(Metadata metadata) {
        return new ArrayList<Node>(metadata.fetch().nodes());
    }

    private ClusterResourceListener initializeMockListener(Metadata metadata) {
        ClusterResourceListener mockListener = (ClusterResourceListener)Mockito.mock(ClusterResourceListener.class);
        metadata.addClusterUpdateListener(mockListener);
        return mockListener;
    }

    private MetadataResponse.PartitionMetadata metadataSupplier(Errors error, TopicPartition partition, Optional<Integer> leaderId, Optional<Integer> leaderEpoch, List<Integer> replicas, List<Integer> isr, List<Integer> offlineReplicas) {
        if ("topic1".equals(partition.topic()) && partition.partition() == 0) {
            return new MetadataResponse.PartitionMetadata(Errors.NONE, partition, Optional.of(1), Optional.of(100), Arrays.asList(1, 2), Arrays.asList(1, 2), Collections.singletonList(3));
        }
        if ("topic1".equals(partition.topic()) && partition.partition() == 1) {
            return new MetadataResponse.PartitionMetadata(Errors.NONE, partition, Optional.of(2), Optional.of(200), Arrays.asList(2, 3), Arrays.asList(2, 3), Collections.singletonList(1));
        }
        if ("topic2".equals(partition.topic()) && partition.partition() == 0) {
            return new MetadataResponse.PartitionMetadata(Errors.NONE, partition, Optional.of(2), Optional.of(200), Arrays.asList(2, 3), Arrays.asList(2, 3), Collections.singletonList(1));
        }
        if ("__consumer_offsets".equals(partition.topic()) && partition.partition() == 0) {
            return new MetadataResponse.PartitionMetadata(Errors.NONE, partition, Optional.of(2), Optional.of(300), Arrays.asList(2, 3), Arrays.asList(2, 3), Collections.singletonList(1));
        }
        throw new RuntimeException("Unexpected partition " + String.valueOf(partition));
    }

    private void validateForUpdatePartitionLeadership(Metadata updatedMetadata, MetadataResponse.PartitionMetadata part1Metadata, MetadataResponse.PartitionMetadata part2Metadata, MetadataResponse.PartitionMetadata part12Metadata, MetadataResponse.PartitionMetadata internalPartMetadata, List<Node> expectedNodes, String expectedClusterId, Set<String> expectedUnauthorisedTopics, Set<String> expectedInvalidTopics, Set<String> expectedInternalTopics, Node expectedController, Map<String, Uuid> expectedTopicIds) {
        Cluster updatedCluster = updatedMetadata.fetch();
        Assertions.assertEquals((Object)updatedCluster.clusterResource().clusterId(), (Object)expectedClusterId);
        Assertions.assertEquals(new HashSet<Node>(expectedNodes), new HashSet(updatedCluster.nodes()));
        Assertions.assertEquals((int)3, (int)updatedCluster.topics().size());
        Assertions.assertEquals(expectedInternalTopics, (Object)updatedCluster.internalTopics());
        Assertions.assertEquals(expectedInvalidTopics, (Object)updatedCluster.invalidTopics());
        Assertions.assertEquals(expectedUnauthorisedTopics, (Object)updatedCluster.unauthorizedTopics());
        Assertions.assertEquals((Object)expectedController, (Object)updatedCluster.controller());
        Assertions.assertEquals(expectedTopicIds, (Object)updatedMetadata.topicIds());
        Map nodeMap = expectedNodes.stream().collect(Collectors.toMap(Node::id, Function.identity()));
        for (MetadataResponse.PartitionMetadata partitionMetadata : Arrays.asList(part1Metadata, part2Metadata, part12Metadata, internalPartMetadata)) {
            TopicPartition tp = new TopicPartition(partitionMetadata.topic(), partitionMetadata.partition());
            Metadata.LeaderAndEpoch expectedLeaderInfo = new Metadata.LeaderAndEpoch(Optional.of((Node)nodeMap.get(partitionMetadata.leaderId.get())), partitionMetadata.leaderEpoch);
            Assertions.assertEquals((Object)expectedLeaderInfo, (Object)updatedMetadata.currentLeader(tp));
            Optional optionalUpdatedMetadata = updatedMetadata.partitionMetadataIfCurrent(tp);
            Assertions.assertTrue((boolean)optionalUpdatedMetadata.isPresent());
            MetadataResponse.PartitionMetadata updatedPartMetadata = (MetadataResponse.PartitionMetadata)optionalUpdatedMetadata.get();
            Assertions.assertEquals((Object)partitionMetadata.topicPartition, (Object)updatedPartMetadata.topicPartition);
            Assertions.assertEquals((Object)partitionMetadata.error, (Object)updatedPartMetadata.error);
            Assertions.assertEquals((Object)partitionMetadata.leaderId, (Object)updatedPartMetadata.leaderId);
            Assertions.assertEquals((Object)partitionMetadata.leaderEpoch, (Object)updatedPartMetadata.leaderEpoch);
            Assertions.assertEquals((Object)partitionMetadata.replicaIds, (Object)updatedPartMetadata.replicaIds);
            Assertions.assertEquals((Object)partitionMetadata.inSyncReplicaIds, (Object)updatedPartMetadata.inSyncReplicaIds);
            Assertions.assertEquals((Object)partitionMetadata.offlineReplicaIds, (Object)partitionMetadata.offlineReplicaIds);
        }
    }
}

