/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.message.AddPartitionsToTxnResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AddPartitionsToTxnResponse;
import org.apache.kafka.common.utils.ImplicitLinkedHashCollection;
import org.apache.kafka.common.utils.annotation.ApiKeyVersionsSource;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;

public class AddPartitionsToTxnResponseTest {
    protected final int throttleTimeMs = 10;
    protected final String topicOne = "topic1";
    protected final int partitionOne = 1;
    protected final Errors errorOne = Errors.COORDINATOR_NOT_AVAILABLE;
    protected final Errors errorTwo = Errors.NOT_COORDINATOR;
    protected final String topicTwo = "topic2";
    protected final int partitionTwo = 2;
    protected final TopicPartition tp1 = new TopicPartition("topic1", 1);
    protected final TopicPartition tp2 = new TopicPartition("topic2", 2);
    protected Map<Errors, Integer> expectedErrorCounts;
    protected Map<TopicPartition, Errors> errorsMap;

    @BeforeEach
    public void setUp() {
        this.expectedErrorCounts = new HashMap<Errors, Integer>();
        this.expectedErrorCounts.put(this.errorOne, 1);
        this.expectedErrorCounts.put(this.errorTwo, 1);
        this.errorsMap = new HashMap<TopicPartition, Errors>();
        this.errorsMap.put(this.tp1, this.errorOne);
        this.errorsMap.put(this.tp2, this.errorTwo);
    }

    @ParameterizedTest
    @ApiKeyVersionsSource(apiKey=ApiKeys.ADD_PARTITIONS_TO_TXN)
    public void testParse(short version) {
        AddPartitionsToTxnResponseData.AddPartitionsToTxnTopicResultCollection topicCollection = new AddPartitionsToTxnResponseData.AddPartitionsToTxnTopicResultCollection();
        AddPartitionsToTxnResponseData.AddPartitionsToTxnTopicResult topicResult = new AddPartitionsToTxnResponseData.AddPartitionsToTxnTopicResult();
        topicResult.setName("topic1");
        topicResult.resultsByPartition().add((ImplicitLinkedHashCollection.Element)new AddPartitionsToTxnResponseData.AddPartitionsToTxnPartitionResult().setPartitionErrorCode(this.errorOne.code()).setPartitionIndex(1));
        topicResult.resultsByPartition().add((ImplicitLinkedHashCollection.Element)new AddPartitionsToTxnResponseData.AddPartitionsToTxnPartitionResult().setPartitionErrorCode(this.errorTwo.code()).setPartitionIndex(2));
        topicCollection.add((ImplicitLinkedHashCollection.Element)topicResult);
        if (version < 4) {
            AddPartitionsToTxnResponseData data = new AddPartitionsToTxnResponseData().setResultsByTopicV3AndBelow(topicCollection).setThrottleTimeMs(10);
            AddPartitionsToTxnResponse response = new AddPartitionsToTxnResponse(data);
            AddPartitionsToTxnResponse parsedResponse = AddPartitionsToTxnResponse.parse((ByteBuffer)response.serialize(version), (short)version);
            Assertions.assertEquals(this.expectedErrorCounts, (Object)parsedResponse.errorCounts());
            Assertions.assertEquals((int)10, (int)parsedResponse.throttleTimeMs());
            Assertions.assertEquals((Object)(version >= 1 ? 1 : 0), (Object)parsedResponse.shouldClientThrottle(version));
        } else {
            AddPartitionsToTxnResponseData.AddPartitionsToTxnResultCollection results = new AddPartitionsToTxnResponseData.AddPartitionsToTxnResultCollection();
            results.add((ImplicitLinkedHashCollection.Element)new AddPartitionsToTxnResponseData.AddPartitionsToTxnResult().setTransactionalId("txn1").setTopicResults(topicCollection));
            Map<TopicPartition, Errors> txnTwoExpectedErrors = Collections.singletonMap(this.tp2, this.errorOne);
            results.add((ImplicitLinkedHashCollection.Element)AddPartitionsToTxnResponse.resultForTransaction((String)"txn2", txnTwoExpectedErrors));
            AddPartitionsToTxnResponseData data = new AddPartitionsToTxnResponseData().setResultsByTransaction(results).setThrottleTimeMs(10);
            AddPartitionsToTxnResponse response = new AddPartitionsToTxnResponse(data);
            HashMap<Errors, Integer> newExpectedErrorCounts = new HashMap<Errors, Integer>();
            newExpectedErrorCounts.put(Errors.NONE, 1);
            newExpectedErrorCounts.put(this.errorOne, 2);
            newExpectedErrorCounts.put(this.errorTwo, 1);
            AddPartitionsToTxnResponse parsedResponse = AddPartitionsToTxnResponse.parse((ByteBuffer)response.serialize(version), (short)version);
            Assertions.assertEquals(txnTwoExpectedErrors, (Object)AddPartitionsToTxnResponse.errorsForTransaction((AddPartitionsToTxnResponseData.AddPartitionsToTxnTopicResultCollection)response.getTransactionTopicResults("txn2")));
            Assertions.assertEquals(newExpectedErrorCounts, (Object)parsedResponse.errorCounts());
            Assertions.assertEquals((int)10, (int)parsedResponse.throttleTimeMs());
            Assertions.assertTrue((boolean)parsedResponse.shouldClientThrottle(version));
        }
    }

    @Test
    public void testBatchedErrors() {
        Map<TopicPartition, Errors> txn1Errors = Collections.singletonMap(this.tp1, this.errorOne);
        Map<TopicPartition, Errors> txn2Errors = Collections.singletonMap(this.tp1, this.errorOne);
        AddPartitionsToTxnResponseData.AddPartitionsToTxnResult transaction1 = AddPartitionsToTxnResponse.resultForTransaction((String)"txn1", txn1Errors);
        AddPartitionsToTxnResponseData.AddPartitionsToTxnResult transaction2 = AddPartitionsToTxnResponse.resultForTransaction((String)"txn2", txn2Errors);
        AddPartitionsToTxnResponseData.AddPartitionsToTxnResultCollection results = new AddPartitionsToTxnResponseData.AddPartitionsToTxnResultCollection();
        results.add((ImplicitLinkedHashCollection.Element)transaction1);
        results.add((ImplicitLinkedHashCollection.Element)transaction2);
        AddPartitionsToTxnResponse response = new AddPartitionsToTxnResponse(new AddPartitionsToTxnResponseData().setResultsByTransaction(results));
        Assertions.assertEquals(txn1Errors, (Object)AddPartitionsToTxnResponse.errorsForTransaction((AddPartitionsToTxnResponseData.AddPartitionsToTxnTopicResultCollection)response.getTransactionTopicResults("txn1")));
        Assertions.assertEquals(txn2Errors, (Object)AddPartitionsToTxnResponse.errorsForTransaction((AddPartitionsToTxnResponseData.AddPartitionsToTxnTopicResultCollection)response.getTransactionTopicResults("txn2")));
        HashMap<String, Map<TopicPartition, Errors>> expectedErrors = new HashMap<String, Map<TopicPartition, Errors>>();
        expectedErrors.put("txn1", txn1Errors);
        expectedErrors.put("txn2", txn2Errors);
        Assertions.assertEquals(expectedErrors, (Object)response.errors());
    }
}

