/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.admin.internals;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import org.apache.kafka.clients.admin.internals.AdminApiDriver;
import org.apache.kafka.clients.admin.internals.AdminApiFuture;
import org.apache.kafka.clients.admin.internals.AdminApiHandler;
import org.apache.kafka.clients.admin.internals.AdminApiLookupStrategy;
import org.apache.kafka.clients.admin.internals.ApiRequestScope;
import org.apache.kafka.clients.admin.internals.CoordinatorKey;
import org.apache.kafka.clients.admin.internals.CoordinatorStrategy;
import org.apache.kafka.clients.admin.internals.DeleteConsumerGroupsHandler;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.errors.DisconnectException;
import org.apache.kafka.common.errors.UnknownServerException;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.message.MetadataResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.FindCoordinatorRequest;
import org.apache.kafka.common.requests.MetadataRequest;
import org.apache.kafka.common.requests.MetadataResponse;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Utils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class AdminApiDriverTest {
    private static final int API_TIMEOUT_MS = 30000;
    private static final int RETRY_BACKOFF_MS = 100;

    AdminApiDriverTest() {
    }

    @Test
    public void testCoalescedLookup() {
        TestContext ctx = TestContext.dynamicMapped(AdminApiDriverTest.map("foo", "c1", "bar", "c1"));
        Map<Set<String>, AdminApiLookupStrategy.LookupResult<String>> lookupRequests = AdminApiDriverTest.map(Utils.mkSet((Object[])new String[]{"foo", "bar"}), AdminApiDriverTest.mapped("foo", 1, "bar", 2));
        ctx.poll(lookupRequests, Collections.emptyMap());
        Map<Set<String>, AdminApiHandler.ApiResult<String, Long>> fulfillmentResults = AdminApiDriverTest.map(Utils.mkSet((Object[])new String[]{"foo"}), AdminApiDriverTest.completed("foo", 15L), Utils.mkSet((Object[])new String[]{"bar"}), AdminApiDriverTest.completed("bar", 30L));
        ctx.poll(Collections.emptyMap(), fulfillmentResults);
        ctx.poll(Collections.emptyMap(), Collections.emptyMap());
    }

    @Test
    public void testCoalescedFulfillment() {
        TestContext ctx = TestContext.dynamicMapped(AdminApiDriverTest.map("foo", "c1", "bar", "c2"));
        Map<Set<String>, AdminApiLookupStrategy.LookupResult<String>> lookupRequests = AdminApiDriverTest.map(Utils.mkSet((Object[])new String[]{"foo"}), AdminApiDriverTest.mapped("foo", 1), Utils.mkSet((Object[])new String[]{"bar"}), AdminApiDriverTest.mapped("bar", 1));
        ctx.poll(lookupRequests, Collections.emptyMap());
        Map<Set<String>, AdminApiHandler.ApiResult<String, Long>> fulfillmentResults = AdminApiDriverTest.map(Utils.mkSet((Object[])new String[]{"foo", "bar"}), AdminApiDriverTest.completed("foo", 15L, "bar", 30L));
        ctx.poll(Collections.emptyMap(), fulfillmentResults);
        ctx.poll(Collections.emptyMap(), Collections.emptyMap());
    }

    @Test
    public void testKeyLookupFailure() {
        Exception[] keyLookupExceptions;
        for (Exception keyLookupException : keyLookupExceptions = new Exception[]{new UnknownServerException(), new UnsupportedVersionException("")}) {
            TestContext ctx = TestContext.dynamicMapped(AdminApiDriverTest.map("foo", "c1", "bar", "c2"));
            Map<Set<String>, AdminApiLookupStrategy.LookupResult<String>> lookupRequests = AdminApiDriverTest.map(Utils.mkSet((Object[])new String[]{"foo"}), AdminApiDriverTest.failedLookup("foo", keyLookupException), Utils.mkSet((Object[])new String[]{"bar"}), AdminApiDriverTest.mapped("bar", 1));
            ctx.poll(lookupRequests, Collections.emptyMap());
            Map<Set<String>, AdminApiHandler.ApiResult<String, Long>> fulfillmentResults = AdminApiDriverTest.map(Utils.mkSet((Object[])new String[]{"bar"}), AdminApiDriverTest.completed("bar", 30L));
            ctx.poll(Collections.emptyMap(), fulfillmentResults);
            ctx.poll(Collections.emptyMap(), Collections.emptyMap());
        }
    }

    @Test
    public void testKeyLookupRetry() {
        TestContext ctx = TestContext.dynamicMapped(AdminApiDriverTest.map("foo", "c1", "bar", "c2"));
        Map<Set<String>, AdminApiLookupStrategy.LookupResult<String>> lookupRequests = AdminApiDriverTest.map(Utils.mkSet((Object[])new String[]{"foo"}), AdminApiDriverTest.emptyLookup(), Utils.mkSet((Object[])new String[]{"bar"}), AdminApiDriverTest.mapped("bar", 1));
        ctx.poll(lookupRequests, Collections.emptyMap());
        Map<Set<String>, AdminApiLookupStrategy.LookupResult<String>> fooRetry = AdminApiDriverTest.map(Utils.mkSet((Object[])new String[]{"foo"}), AdminApiDriverTest.mapped("foo", 1));
        Map<Set<String>, AdminApiHandler.ApiResult<String, Long>> barFulfillment = AdminApiDriverTest.map(Utils.mkSet((Object[])new String[]{"bar"}), AdminApiDriverTest.completed("bar", 30L));
        ctx.poll(fooRetry, barFulfillment);
        Map<Set<String>, AdminApiHandler.ApiResult<String, Long>> fooFulfillment = AdminApiDriverTest.map(Utils.mkSet((Object[])new String[]{"foo"}), AdminApiDriverTest.completed("foo", 15L));
        ctx.poll(Collections.emptyMap(), fooFulfillment);
        ctx.poll(Collections.emptyMap(), Collections.emptyMap());
    }

    @Test
    public void testStaticMapping() {
        TestContext ctx = TestContext.staticMapped(AdminApiDriverTest.map("foo", 0, "bar", 1, "baz", 1));
        Map<Set<String>, AdminApiHandler.ApiResult<String, Long>> fulfillmentResults = AdminApiDriverTest.map(Utils.mkSet((Object[])new String[]{"foo"}), AdminApiDriverTest.completed("foo", 15L), Utils.mkSet((Object[])new String[]{"bar", "baz"}), AdminApiDriverTest.completed("bar", 30L, "baz", 45L));
        ctx.poll(Collections.emptyMap(), fulfillmentResults);
        ctx.poll(Collections.emptyMap(), Collections.emptyMap());
    }

    @Test
    public void testFulfillmentFailure() {
        TestContext ctx = TestContext.staticMapped(AdminApiDriverTest.map("foo", 0, "bar", 1, "baz", 1));
        Map<Set<String>, AdminApiHandler.ApiResult<String, Long>> fulfillmentResults = AdminApiDriverTest.map(Utils.mkSet((Object[])new String[]{"foo"}), AdminApiDriverTest.failed("foo", (Throwable)new UnknownServerException()), Utils.mkSet((Object[])new String[]{"bar", "baz"}), AdminApiDriverTest.completed("bar", 30L, "baz", 45L));
        ctx.poll(Collections.emptyMap(), fulfillmentResults);
        ctx.poll(Collections.emptyMap(), Collections.emptyMap());
    }

    @Test
    public void testFulfillmentRetry() {
        TestContext ctx = TestContext.staticMapped(AdminApiDriverTest.map("foo", 0, "bar", 1, "baz", 1));
        Map<Set<String>, AdminApiHandler.ApiResult<String, Long>> fulfillmentResults = AdminApiDriverTest.map(Utils.mkSet((Object[])new String[]{"foo"}), AdminApiDriverTest.completed("foo", 15L), Utils.mkSet((Object[])new String[]{"bar", "baz"}), AdminApiDriverTest.completed("bar", 30L));
        ctx.poll(Collections.emptyMap(), fulfillmentResults);
        Map<Set<String>, AdminApiHandler.ApiResult<String, Long>> bazRetry = AdminApiDriverTest.map(Utils.mkSet((Object[])new String[]{"baz"}), AdminApiDriverTest.completed("baz", 45L));
        ctx.poll(Collections.emptyMap(), bazRetry);
        ctx.poll(Collections.emptyMap(), Collections.emptyMap());
    }

    @Test
    public void testFulfillmentUnmapping() {
        TestContext ctx = TestContext.dynamicMapped(AdminApiDriverTest.map("foo", "c1", "bar", "c2"));
        Map<Set<String>, AdminApiLookupStrategy.LookupResult<String>> lookupRequests = AdminApiDriverTest.map(Utils.mkSet((Object[])new String[]{"foo"}), AdminApiDriverTest.mapped("foo", 0), Utils.mkSet((Object[])new String[]{"bar"}), AdminApiDriverTest.mapped("bar", 1));
        ctx.poll(lookupRequests, Collections.emptyMap());
        Map<Set<String>, AdminApiHandler.ApiResult<String, Long>> fulfillmentResults = AdminApiDriverTest.map(Utils.mkSet((Object[])new String[]{"foo"}), AdminApiDriverTest.completed("foo", 15L), Utils.mkSet((Object[])new String[]{"bar"}), AdminApiDriverTest.unmapped("bar"));
        ctx.poll(Collections.emptyMap(), fulfillmentResults);
        Map<Set<String>, AdminApiLookupStrategy.LookupResult<String>> barLookupRetry = AdminApiDriverTest.map(Utils.mkSet((Object[])new String[]{"bar"}), AdminApiDriverTest.mapped("bar", 1));
        ctx.poll(barLookupRetry, Collections.emptyMap());
        Map<Set<String>, AdminApiHandler.ApiResult<String, Long>> barFulfillRetry = AdminApiDriverTest.map(Utils.mkSet((Object[])new String[]{"bar"}), AdminApiDriverTest.completed("bar", 30L));
        ctx.poll(Collections.emptyMap(), barFulfillRetry);
        ctx.poll(Collections.emptyMap(), Collections.emptyMap());
    }

    @Test
    public void testFulfillmentFailureUnsupportedVersion() {
        TestContext ctx = TestContext.staticMapped(AdminApiDriverTest.map("foo", 0, "bar", 1, "baz", 1));
        Map<Set<String>, AdminApiHandler.ApiResult<String, Long>> fulfillmentResults = AdminApiDriverTest.map(Utils.mkSet((Object[])new String[]{"foo"}), AdminApiDriverTest.failed("foo", (Throwable)new UnsupportedVersionException("")), Utils.mkSet((Object[])new String[]{"bar", "baz"}), AdminApiDriverTest.completed("bar", 30L, "baz", 45L));
        ctx.poll(Collections.emptyMap(), fulfillmentResults);
        ctx.poll(Collections.emptyMap(), Collections.emptyMap());
    }

    @Test
    public void testFulfillmentRetriableUnsupportedVersion() {
        TestContext ctx = TestContext.staticMapped(AdminApiDriverTest.map("foo", 0, "bar", 1, "baz", 2));
        ctx.handler.addRetriableUnsupportedVersionKey("foo");
        ctx.handler.expectRequest(Utils.mkSet((Object[])new String[]{"foo"}), AdminApiDriverTest.failed("foo", (Throwable)new UnsupportedVersionException("")));
        ctx.handler.expectRequest(Utils.mkSet((Object[])new String[]{"bar"}), AdminApiDriverTest.failed("bar", (Throwable)new UnsupportedVersionException("")));
        ctx.handler.expectRequest(Utils.mkSet((Object[])new String[]{"baz"}), AdminApiDriverTest.completed("baz", 45L));
        List requestSpecs = ctx.driver.poll();
        requestSpecs.forEach(requestSpec -> {
            if (requestSpec.keys.contains("foo") || requestSpec.keys.contains("bar")) {
                ctx.driver.onFailure(ctx.time.milliseconds(), requestSpec, (Throwable)new UnsupportedVersionException(""));
            } else {
                ctx.driver.onResponse(ctx.time.milliseconds(), requestSpec, (AbstractResponse)new MetadataResponse(new MetadataResponseData(), ApiKeys.METADATA.latestVersion()), Node.noNode());
            }
        });
        ctx.poll(Collections.emptyMap(), AdminApiDriverTest.map(Utils.mkSet((Object[])new String[]{"foo"}), AdminApiDriverTest.failed("foo", (Throwable)new UnsupportedVersionException(""))));
        ctx.poll(Collections.emptyMap(), Collections.emptyMap());
    }

    @Test
    public void testRecoalescedLookup() {
        TestContext ctx = TestContext.dynamicMapped(AdminApiDriverTest.map("foo", "c1", "bar", "c1"));
        Map<Set<String>, AdminApiLookupStrategy.LookupResult<String>> lookupRequests = AdminApiDriverTest.map(Utils.mkSet((Object[])new String[]{"foo", "bar"}), AdminApiDriverTest.mapped("foo", 1, "bar", 2));
        ctx.poll(lookupRequests, Collections.emptyMap());
        Map<Set<String>, AdminApiHandler.ApiResult<String, Long>> fulfillment = AdminApiDriverTest.map(Utils.mkSet((Object[])new String[]{"foo"}), AdminApiDriverTest.unmapped("foo"), Utils.mkSet((Object[])new String[]{"bar"}), AdminApiDriverTest.unmapped("bar"));
        ctx.poll(Collections.emptyMap(), fulfillment);
        Map<Set<String>, AdminApiLookupStrategy.LookupResult<String>> retryLookupRequests = AdminApiDriverTest.map(Utils.mkSet((Object[])new String[]{"foo", "bar"}), AdminApiDriverTest.mapped("foo", 3, "bar", 3));
        ctx.poll(retryLookupRequests, Collections.emptyMap());
        Map<Set<String>, AdminApiHandler.ApiResult<String, Long>> retryFulfillment = AdminApiDriverTest.map(Utils.mkSet((Object[])new String[]{"foo", "bar"}), AdminApiDriverTest.completed("foo", 15L, "bar", 30L));
        ctx.poll(Collections.emptyMap(), retryFulfillment);
        ctx.poll(Collections.emptyMap(), Collections.emptyMap());
    }

    @Test
    public void testRetryLookupAfterDisconnect() {
        TestContext ctx = TestContext.dynamicMapped(AdminApiDriverTest.map("foo", "c1"));
        int initialLeaderId = 1;
        Map<Set<String>, AdminApiLookupStrategy.LookupResult<String>> initialLookup = AdminApiDriverTest.map(Utils.mkSet((Object[])new String[]{"foo"}), AdminApiDriverTest.mapped("foo", initialLeaderId));
        ctx.poll(initialLookup, Collections.emptyMap());
        AdminApiDriverTest.assertMappedKey(ctx, "foo", initialLeaderId);
        ctx.handler.expectRequest(Utils.mkSet((Object[])new String[]{"foo"}), AdminApiDriverTest.completed("foo", 15L));
        List requestSpecs = ctx.driver.poll();
        Assertions.assertEquals((int)1, (int)requestSpecs.size());
        AdminApiDriver.RequestSpec requestSpec = (AdminApiDriver.RequestSpec)requestSpecs.get(0);
        Assertions.assertEquals((Object)OptionalInt.of(initialLeaderId), (Object)requestSpec.scope.destinationBrokerId());
        ctx.driver.onFailure(ctx.time.milliseconds(), requestSpec, (Throwable)new DisconnectException());
        AdminApiDriverTest.assertUnmappedKey(ctx, "foo");
        int retryLeaderId = 2;
        ctx.lookupStrategy().expectLookup(Utils.mkSet((Object[])new String[]{"foo"}), AdminApiDriverTest.mapped("foo", retryLeaderId));
        List retryLookupSpecs = ctx.driver.poll();
        Assertions.assertEquals((int)1, (int)retryLookupSpecs.size());
        AdminApiDriver.RequestSpec retryLookupSpec = (AdminApiDriver.RequestSpec)retryLookupSpecs.get(0);
        Assertions.assertEquals((long)ctx.time.milliseconds(), (long)retryLookupSpec.nextAllowedTryMs);
        Assertions.assertEquals((int)1, (int)retryLookupSpec.tries);
    }

    @Test
    public void testRetryLookupAndDisableBatchAfterNoBatchedFindCoordinatorsException() {
        MockTime time = new MockTime();
        LogContext lc = new LogContext();
        HashSet<String> groupIds = new HashSet<String>(Arrays.asList("g1", "g2"));
        DeleteConsumerGroupsHandler handler = new DeleteConsumerGroupsHandler(lc);
        AdminApiFuture.SimpleAdminApiFuture future = AdminApiFuture.forKeys(groupIds.stream().map(g -> CoordinatorKey.byGroupId((String)g)).collect(Collectors.toSet()));
        AdminApiDriver driver = new AdminApiDriver((AdminApiHandler)handler, (AdminApiFuture)future, time.milliseconds() + 30000L, 100L, new LogContext());
        Assertions.assertTrue((boolean)((CoordinatorStrategy)handler.lookupStrategy()).batch);
        List requestSpecs = driver.poll();
        Assertions.assertEquals((int)1, (int)requestSpecs.size());
        AdminApiDriver.RequestSpec requestSpec = (AdminApiDriver.RequestSpec)requestSpecs.get(0);
        driver.onFailure(time.milliseconds(), requestSpec, (Throwable)new FindCoordinatorRequest.NoBatchedFindCoordinatorsException("message"));
        Assertions.assertFalse((boolean)((CoordinatorStrategy)handler.lookupStrategy()).batch);
        List retryLookupSpecs = driver.poll();
        Assertions.assertEquals((int)groupIds.size(), (int)retryLookupSpecs.size());
        for (AdminApiDriver.RequestSpec retryLookupSpec : retryLookupSpecs) {
            Assertions.assertEquals((long)0L, (long)retryLookupSpec.nextAllowedTryMs);
            Assertions.assertEquals((int)0, (int)retryLookupSpec.tries);
        }
    }

    @Test
    public void testCoalescedStaticAndDynamicFulfillment() {
        Map<String, String> dynamicMapping = AdminApiDriverTest.map("foo", "c1");
        Map<String, Integer> staticMapping = AdminApiDriverTest.map("bar", 1);
        TestContext ctx = new TestContext(staticMapping, dynamicMapping);
        AdminApiLookupStrategy.LookupResult<String> lookupResult = AdminApiDriverTest.mapped("foo", 1);
        ctx.lookupStrategy().expectLookup(Utils.mkSet((Object[])new String[]{"foo"}), lookupResult);
        ctx.handler.expectRequest(Utils.mkSet((Object[])new String[]{"bar"}), AdminApiDriverTest.completed("bar", 10L));
        List requestSpecs = ctx.driver.poll();
        Assertions.assertEquals((int)2, (int)requestSpecs.size());
        AdminApiDriver.RequestSpec lookupSpec = (AdminApiDriver.RequestSpec)requestSpecs.get(0);
        Assertions.assertEquals((Object)Utils.mkSet((Object[])new String[]{"foo"}), (Object)lookupSpec.keys);
        ctx.assertLookupResponse((AdminApiDriver.RequestSpec<String>)lookupSpec, (AdminApiLookupStrategy.LookupResult<String>)lookupResult);
        AdminApiDriver.RequestSpec fulfillmentSpec = (AdminApiDriver.RequestSpec)requestSpecs.get(1);
        Assertions.assertEquals((Object)Utils.mkSet((Object[])new String[]{"bar"}), (Object)fulfillmentSpec.keys);
        ctx.driver.onFailure(ctx.time.milliseconds(), fulfillmentSpec, (Throwable)new DisconnectException());
        ctx.handler.reset();
        ctx.handler.expectRequest(Utils.mkSet((Object[])new String[]{"foo", "bar"}), AdminApiDriverTest.completed("foo", 15L, "bar", 30L));
        List coalescedSpecs = ctx.driver.poll();
        Assertions.assertEquals((int)1, (int)coalescedSpecs.size());
        AdminApiDriver.RequestSpec coalescedSpec = (AdminApiDriver.RequestSpec)coalescedSpecs.get(0);
        Assertions.assertEquals((Object)Utils.mkSet((Object[])new String[]{"foo", "bar"}), (Object)coalescedSpec.keys);
        ctx.driver.onFailure(ctx.time.milliseconds(), coalescedSpec, (Throwable)new DisconnectException());
        Map<Set<String>, AdminApiLookupStrategy.LookupResult<String>> fooLookupRetry = AdminApiDriverTest.map(Utils.mkSet((Object[])new String[]{"foo"}), AdminApiDriverTest.mapped("foo", 3));
        Map<Set<String>, AdminApiHandler.ApiResult<String, Long>> barFulfillmentRetry = AdminApiDriverTest.map(Utils.mkSet((Object[])new String[]{"bar"}), AdminApiDriverTest.completed("bar", 30L));
        ctx.poll(fooLookupRetry, barFulfillmentRetry);
        Map<Set<String>, AdminApiHandler.ApiResult<String, Long>> fooFulfillmentRetry = AdminApiDriverTest.map(Utils.mkSet((Object[])new String[]{"foo"}), AdminApiDriverTest.completed("foo", 15L));
        ctx.poll(Collections.emptyMap(), fooFulfillmentRetry);
        ctx.poll(Collections.emptyMap(), Collections.emptyMap());
    }

    @Test
    public void testLookupRetryBookkeeping() {
        TestContext ctx = TestContext.dynamicMapped(AdminApiDriverTest.map("foo", "c1"));
        AdminApiLookupStrategy.LookupResult<String> emptyLookup = AdminApiDriverTest.emptyLookup();
        ctx.lookupStrategy().expectLookup(Utils.mkSet((Object[])new String[]{"foo"}), emptyLookup);
        List requestSpecs = ctx.driver.poll();
        Assertions.assertEquals((int)1, (int)requestSpecs.size());
        AdminApiDriver.RequestSpec requestSpec = (AdminApiDriver.RequestSpec)requestSpecs.get(0);
        Assertions.assertEquals((int)0, (int)requestSpec.tries);
        Assertions.assertEquals((long)0L, (long)requestSpec.nextAllowedTryMs);
        ctx.assertLookupResponse((AdminApiDriver.RequestSpec<String>)requestSpec, (AdminApiLookupStrategy.LookupResult<String>)emptyLookup);
        List retrySpecs = ctx.driver.poll();
        Assertions.assertEquals((int)1, (int)retrySpecs.size());
        AdminApiDriver.RequestSpec retrySpec = (AdminApiDriver.RequestSpec)retrySpecs.get(0);
        Assertions.assertEquals((int)1, (int)retrySpec.tries);
        Assertions.assertEquals((long)ctx.time.milliseconds(), (long)retrySpec.nextAllowedTryMs);
    }

    @Test
    public void testFulfillmentRetryBookkeeping() {
        TestContext ctx = TestContext.staticMapped(AdminApiDriverTest.map("foo", 0));
        AdminApiHandler.ApiResult<String, Long> emptyFulfillment = AdminApiDriverTest.emptyFulfillment();
        ctx.handler.expectRequest(Utils.mkSet((Object[])new String[]{"foo"}), emptyFulfillment);
        List requestSpecs = ctx.driver.poll();
        Assertions.assertEquals((int)1, (int)requestSpecs.size());
        AdminApiDriver.RequestSpec requestSpec = (AdminApiDriver.RequestSpec)requestSpecs.get(0);
        Assertions.assertEquals((int)0, (int)requestSpec.tries);
        Assertions.assertEquals((long)0L, (long)requestSpec.nextAllowedTryMs);
        ctx.assertResponse((AdminApiDriver.RequestSpec<String>)requestSpec, (AdminApiHandler.ApiResult<String, Long>)emptyFulfillment, Node.noNode());
        List retrySpecs = ctx.driver.poll();
        Assertions.assertEquals((int)1, (int)retrySpecs.size());
        AdminApiDriver.RequestSpec retrySpec = (AdminApiDriver.RequestSpec)retrySpecs.get(0);
        Assertions.assertEquals((int)1, (int)retrySpec.tries);
        Assertions.assertEquals((long)(ctx.time.milliseconds() + 100L), (long)retrySpec.nextAllowedTryMs);
    }

    private static void assertMappedKey(TestContext context, String key, Integer expectedBrokerId) {
        OptionalInt brokerIdOpt = context.driver.keyToBrokerId((Object)key);
        Assertions.assertEquals((Object)OptionalInt.of(expectedBrokerId), (Object)brokerIdOpt);
    }

    private static void assertUnmappedKey(TestContext context, String key) {
        OptionalInt brokerIdOpt = context.driver.keyToBrokerId((Object)key);
        Assertions.assertEquals((Object)OptionalInt.empty(), (Object)brokerIdOpt);
        KafkaFuture future = (KafkaFuture)context.future.all().get(key);
        Assertions.assertFalse((boolean)future.isDone());
    }

    private static void assertFailedKey(TestContext context, String key, Throwable expectedException) {
        KafkaFuture future = (KafkaFuture)context.future.all().get(key);
        Assertions.assertTrue((boolean)future.isCompletedExceptionally());
        Throwable exception = Assertions.assertThrows(ExecutionException.class, () -> ((KafkaFuture)future).get());
        Assertions.assertEquals((Object)expectedException, (Object)exception.getCause());
    }

    private static void assertCompletedKey(TestContext context, String key, Long expected) {
        KafkaFuture future = (KafkaFuture)context.future.all().get(key);
        Assertions.assertTrue((boolean)future.isDone());
        try {
            Assertions.assertEquals((Long)expected, (Long)((Long)future.get()));
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    private static <K, V> Map<K, V> map(K key, V value) {
        return Collections.singletonMap(key, value);
    }

    private static <K, V> Map<K, V> map(K k1, V v1, K k2, V v2) {
        HashMap<K, V> map = new HashMap<K, V>(2);
        map.put(k1, v1);
        map.put(k2, v2);
        return map;
    }

    private static <K, V> Map<K, V> map(K k1, V v1, K k2, V v2, K k3, V v3) {
        HashMap<K, V> map = new HashMap<K, V>(3);
        map.put(k1, v1);
        map.put(k2, v2);
        map.put(k3, v3);
        return map;
    }

    private static AdminApiHandler.ApiResult<String, Long> completed(String key, Long value) {
        return new AdminApiHandler.ApiResult(AdminApiDriverTest.map(key, value), Collections.emptyMap(), Collections.emptyList());
    }

    private static AdminApiHandler.ApiResult<String, Long> failed(String key, Throwable exception) {
        return new AdminApiHandler.ApiResult(Collections.emptyMap(), AdminApiDriverTest.map(key, exception), Collections.emptyList());
    }

    private static AdminApiHandler.ApiResult<String, Long> unmapped(String ... keys) {
        return new AdminApiHandler.ApiResult(Collections.emptyMap(), Collections.emptyMap(), Arrays.asList(keys));
    }

    private static AdminApiHandler.ApiResult<String, Long> completed(String k1, Long v1, String k2, Long v2) {
        return new AdminApiHandler.ApiResult(AdminApiDriverTest.map(k1, v1, k2, v2), Collections.emptyMap(), Collections.emptyList());
    }

    private static AdminApiHandler.ApiResult<String, Long> emptyFulfillment() {
        return new AdminApiHandler.ApiResult(Collections.emptyMap(), Collections.emptyMap(), Collections.emptyList());
    }

    private static AdminApiLookupStrategy.LookupResult<String> failedLookup(String key, Throwable exception) {
        return new AdminApiLookupStrategy.LookupResult(AdminApiDriverTest.map(key, exception), Collections.emptyMap());
    }

    private static AdminApiLookupStrategy.LookupResult<String> emptyLookup() {
        return new AdminApiLookupStrategy.LookupResult(Collections.emptyMap(), Collections.emptyMap());
    }

    private static AdminApiLookupStrategy.LookupResult<String> mapped(String key, Integer brokerId) {
        return new AdminApiLookupStrategy.LookupResult(Collections.emptyMap(), AdminApiDriverTest.map(key, brokerId));
    }

    private static AdminApiLookupStrategy.LookupResult<String> mapped(String k1, Integer broker1, String k2, Integer broker2) {
        return new AdminApiLookupStrategy.LookupResult(Collections.emptyMap(), AdminApiDriverTest.map(k1, broker1, k2, broker2));
    }

    private static class MockAdminApiHandler<K, V>
    extends AdminApiHandler.Batched<K, V> {
        private final Map<Set<K>, AdminApiHandler.ApiResult<K, V>> expectedRequests = new HashMap<Set<K>, AdminApiHandler.ApiResult<K, V>>();
        private final MockLookupStrategy<K> lookupStrategy;
        private final Map<K, Boolean> retriableUnsupportedVersionKeys;

        private MockAdminApiHandler(MockLookupStrategy<K> lookupStrategy) {
            this.lookupStrategy = lookupStrategy;
            this.retriableUnsupportedVersionKeys = new ConcurrentHashMap<K, Boolean>();
        }

        public String apiName() {
            return "mock-api";
        }

        public AdminApiLookupStrategy<K> lookupStrategy() {
            return this.lookupStrategy;
        }

        public void expectRequest(Set<K> keys, AdminApiHandler.ApiResult<K, V> result) {
            this.expectedRequests.put(keys, result);
        }

        public AbstractRequest.Builder<?> buildBatchedRequest(int brokerId, Set<K> keys) {
            Assertions.assertTrue((boolean)this.expectedRequests.containsKey(keys), (String)("Unexpected fulfillment request for keys " + keys));
            return new MetadataRequest.Builder(Collections.emptyList(), false);
        }

        public AdminApiHandler.ApiResult<K, V> handleResponse(Node broker, Set<K> keys, AbstractResponse response) {
            return Optional.ofNullable(this.expectedRequests.get(keys)).orElseThrow(() -> new AssertionError((Object)("Unexpected fulfillment request for keys " + keys)));
        }

        public Map<K, Throwable> handleUnsupportedVersionException(int brokerId, UnsupportedVersionException exception, Set<K> keys) {
            return keys.stream().filter(k -> !this.retriableUnsupportedVersionKeys.containsKey(k)).collect(Collectors.toMap(k -> k, k -> exception));
        }

        public void reset() {
            this.expectedRequests.clear();
        }

        public void addRetriableUnsupportedVersionKey(K key) {
            this.retriableUnsupportedVersionKeys.put(key, Boolean.TRUE);
        }
    }

    private static class MockLookupStrategy<K>
    implements AdminApiLookupStrategy<K> {
        private final Map<Set<K>, AdminApiLookupStrategy.LookupResult<K>> expectedLookups = new HashMap<Set<K>, AdminApiLookupStrategy.LookupResult<K>>();
        private final Map<K, MockRequestScope> lookupScopes;

        private MockLookupStrategy(Map<K, MockRequestScope> lookupScopes) {
            this.lookupScopes = lookupScopes;
        }

        public ApiRequestScope lookupScope(K key) {
            return this.lookupScopes.get(key);
        }

        public void expectLookup(Set<K> keys, AdminApiLookupStrategy.LookupResult<K> result) {
            this.expectedLookups.put(keys, result);
        }

        public AbstractRequest.Builder<?> buildRequest(Set<K> keys) {
            Assertions.assertTrue((boolean)this.expectedLookups.containsKey(keys), (String)("Unexpected lookup request for keys " + keys));
            return new MetadataRequest.Builder(Collections.emptyList(), false);
        }

        public AdminApiLookupStrategy.LookupResult<K> handleResponse(Set<K> keys, AbstractResponse response) {
            return Optional.ofNullable(this.expectedLookups.get(keys)).orElseThrow(() -> new AssertionError((Object)("Unexpected fulfillment request for keys " + keys)));
        }

        public void reset() {
            this.expectedLookups.clear();
        }
    }

    private static class TestContext {
        private final MockTime time = new MockTime();
        private final MockAdminApiHandler<String, Long> handler;
        private final AdminApiDriver<String, Long> driver;
        private final AdminApiFuture.SimpleAdminApiFuture<String, Long> future;

        public TestContext(Map<String, Integer> staticKeys, Map<String, String> dynamicKeys) {
            HashMap lookupScopes = new HashMap();
            staticKeys.forEach((key, brokerId) -> {
                MockRequestScope scope = new MockRequestScope(OptionalInt.of(brokerId), null);
                lookupScopes.put(key, scope);
            });
            dynamicKeys.forEach((key, context) -> {
                MockRequestScope scope = new MockRequestScope(OptionalInt.empty(), (String)context);
                lookupScopes.put(key, scope);
            });
            MockLookupStrategy lookupStrategy = new MockLookupStrategy(lookupScopes);
            this.handler = new MockAdminApiHandler(lookupStrategy);
            this.future = AdminApiFuture.forKeys(lookupStrategy.lookupScopes.keySet());
            this.driver = new AdminApiDriver(this.handler, this.future, this.time.milliseconds() + 30000L, 100L, new LogContext());
            staticKeys.forEach((key, brokerId) -> AdminApiDriverTest.assertMappedKey(this, key, brokerId));
            dynamicKeys.keySet().forEach(key -> AdminApiDriverTest.assertUnmappedKey(this, key));
        }

        public static TestContext staticMapped(Map<String, Integer> staticKeys) {
            return new TestContext(staticKeys, Collections.emptyMap());
        }

        public static TestContext dynamicMapped(Map<String, String> dynamicKeys) {
            return new TestContext(Collections.emptyMap(), dynamicKeys);
        }

        private void assertLookupResponse(AdminApiDriver.RequestSpec<String> requestSpec, AdminApiLookupStrategy.LookupResult<String> result) {
            requestSpec.keys.forEach(key -> AdminApiDriverTest.assertUnmappedKey(this, key));
            MetadataResponse response = new MetadataResponse(new MetadataResponseData(), ApiKeys.METADATA.latestVersion());
            this.driver.onResponse(this.time.milliseconds(), requestSpec, (AbstractResponse)response, Node.noNode());
            result.mappedKeys.forEach((key, brokerId) -> AdminApiDriverTest.assertMappedKey(this, key, brokerId));
            result.failedKeys.forEach((key, exception) -> AdminApiDriverTest.assertFailedKey(this, key, exception));
        }

        private void assertResponse(AdminApiDriver.RequestSpec<String> requestSpec, AdminApiHandler.ApiResult<String, Long> result, Node node) {
            int brokerId = requestSpec.scope.destinationBrokerId().orElseThrow(() -> new AssertionError((Object)"Fulfillment requests must specify a target brokerId"));
            requestSpec.keys.forEach(key -> AdminApiDriverTest.assertMappedKey(this, key, brokerId));
            MetadataResponse response = new MetadataResponse(new MetadataResponseData(), ApiKeys.METADATA.latestVersion());
            this.driver.onResponse(this.time.milliseconds(), requestSpec, (AbstractResponse)response, node);
            result.unmappedKeys.forEach(key -> AdminApiDriverTest.assertUnmappedKey(this, key));
            result.failedKeys.forEach((key, exception) -> AdminApiDriverTest.assertFailedKey(this, key, exception));
            result.completedKeys.forEach((key, value) -> AdminApiDriverTest.assertCompletedKey(this, key, value));
        }

        private MockLookupStrategy<String> lookupStrategy() {
            return ((MockAdminApiHandler)this.handler).lookupStrategy;
        }

        public void poll(Map<Set<String>, AdminApiLookupStrategy.LookupResult<String>> expectedLookups, Map<Set<String>, AdminApiHandler.ApiResult<String, Long>> expectedRequests) {
            if (!expectedLookups.isEmpty()) {
                MockLookupStrategy<String> lookupStrategy = this.lookupStrategy();
                lookupStrategy.reset();
                expectedLookups.forEach(lookupStrategy::expectLookup);
            }
            this.handler.reset();
            expectedRequests.forEach(this.handler::expectRequest);
            List requestSpecs = this.driver.poll();
            Assertions.assertEquals((int)(expectedLookups.size() + expectedRequests.size()), (int)requestSpecs.size(), (String)"Driver generated an unexpected number of requests");
            for (AdminApiDriver.RequestSpec requestSpec : requestSpecs) {
                AdminApiLookupStrategy.LookupResult<String> result;
                Set keys = requestSpec.keys;
                if (expectedLookups.containsKey(keys)) {
                    result = expectedLookups.get(keys);
                    this.assertLookupResponse((AdminApiDriver.RequestSpec<String>)requestSpec, result);
                    continue;
                }
                if (expectedRequests.containsKey(keys)) {
                    result = expectedRequests.get(keys);
                    this.assertResponse((AdminApiDriver.RequestSpec<String>)requestSpec, (AdminApiHandler.ApiResult<String, Long>)result, Node.noNode());
                    continue;
                }
                Assertions.fail((String)("Unexpected request for keys " + keys));
            }
        }
    }

    private static class MockRequestScope
    implements ApiRequestScope {
        private final OptionalInt destinationBrokerId;
        private final String id;

        private MockRequestScope(OptionalInt destinationBrokerId, String id) {
            this.destinationBrokerId = destinationBrokerId;
            this.id = id;
        }

        public OptionalInt destinationBrokerId() {
            return this.destinationBrokerId;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MockRequestScope that = (MockRequestScope)o;
            return Objects.equals(this.destinationBrokerId, that.destinationBrokerId) && Objects.equals(this.id, that.id);
        }

        public int hashCode() {
            return Objects.hash(this.destinationBrokerId, this.id);
        }
    }
}

