/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import org.apache.kafka.clients.NodeApiVersions;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.message.ApiMessageType;
import org.apache.kafka.common.message.ApiVersionsResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.requests.ApiVersionsResponse;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.EnumSource;

public class NodeApiVersionsTest {
    @Test
    public void testUnsupportedVersionsToString() {
        NodeApiVersions versions = new NodeApiVersions((Collection)new ApiVersionsResponseData.ApiVersionCollection(), Collections.emptyList(), false);
        StringBuilder bld = new StringBuilder();
        String prefix = "(";
        for (ApiKeys apiKey : ApiKeys.clientApis()) {
            bld.append(prefix).append(apiKey.name).append("(").append(apiKey.id).append("): UNSUPPORTED");
            prefix = ", ";
        }
        bld.append(")");
        Assertions.assertEquals((Object)bld.toString(), (Object)versions.toString());
    }

    @Test
    public void testUnknownApiVersionsToString() {
        NodeApiVersions versions = NodeApiVersions.create((short)337, (short)0, (short)1);
        Assertions.assertTrue((boolean)versions.toString().endsWith("UNKNOWN(337): 0 to 1)"));
    }

    @Test
    public void testVersionsToString() {
        ArrayList<ApiVersionsResponseData.ApiVersion> versionList = new ArrayList<ApiVersionsResponseData.ApiVersion>();
        for (ApiKeys apiKey : ApiKeys.values()) {
            if (apiKey == ApiKeys.DELETE_TOPICS) {
                versionList.add(new ApiVersionsResponseData.ApiVersion().setApiKey(apiKey.id).setMinVersion((short)10000).setMaxVersion((short)10001));
                continue;
            }
            versionList.add(ApiVersionsResponse.toApiVersion((ApiKeys)apiKey));
        }
        NodeApiVersions versions = new NodeApiVersions(versionList, Collections.emptyList(), false);
        StringBuilder bld = new StringBuilder();
        String prefix = "(";
        for (ApiKeys apiKey : ApiKeys.values()) {
            bld.append(prefix);
            if (apiKey == ApiKeys.DELETE_TOPICS) {
                bld.append("DeleteTopics(20): 10000 to 10001 [unusable: node too new]");
            } else {
                bld.append(apiKey.name).append("(").append(apiKey.id).append("): ");
                if (apiKey.oldestVersion() == apiKey.latestVersion()) {
                    bld.append(apiKey.oldestVersion());
                } else {
                    bld.append(apiKey.oldestVersion()).append(" to ").append(apiKey.latestVersion());
                }
                bld.append(" [usable: ").append(apiKey.latestVersion()).append("]");
            }
            prefix = ", ";
        }
        bld.append(")");
        Assertions.assertEquals((Object)bld.toString(), (Object)versions.toString());
    }

    @Test
    public void testLatestUsableVersion() {
        NodeApiVersions apiVersions = NodeApiVersions.create((short)ApiKeys.PRODUCE.id, (short)1, (short)3);
        Assertions.assertEquals((int)3, (int)apiVersions.latestUsableVersion(ApiKeys.PRODUCE));
        Assertions.assertEquals((int)1, (int)apiVersions.latestUsableVersion(ApiKeys.PRODUCE, (short)0, (short)1));
        Assertions.assertEquals((int)1, (int)apiVersions.latestUsableVersion(ApiKeys.PRODUCE, (short)1, (short)1));
        Assertions.assertEquals((int)2, (int)apiVersions.latestUsableVersion(ApiKeys.PRODUCE, (short)1, (short)2));
        Assertions.assertEquals((int)3, (int)apiVersions.latestUsableVersion(ApiKeys.PRODUCE, (short)1, (short)3));
        Assertions.assertEquals((int)2, (int)apiVersions.latestUsableVersion(ApiKeys.PRODUCE, (short)2, (short)2));
        Assertions.assertEquals((int)3, (int)apiVersions.latestUsableVersion(ApiKeys.PRODUCE, (short)2, (short)3));
        Assertions.assertEquals((int)3, (int)apiVersions.latestUsableVersion(ApiKeys.PRODUCE, (short)3, (short)3));
        Assertions.assertEquals((int)3, (int)apiVersions.latestUsableVersion(ApiKeys.PRODUCE, (short)3, (short)4));
    }

    @Test
    public void testLatestUsableVersionOutOfRangeLow() {
        NodeApiVersions apiVersions = NodeApiVersions.create((short)ApiKeys.PRODUCE.id, (short)1, (short)2);
        Assertions.assertThrows(UnsupportedVersionException.class, () -> apiVersions.latestUsableVersion(ApiKeys.PRODUCE, (short)3, (short)4));
    }

    @Test
    public void testLatestUsableVersionOutOfRangeHigh() {
        NodeApiVersions apiVersions = NodeApiVersions.create((short)ApiKeys.PRODUCE.id, (short)2, (short)3);
        Assertions.assertThrows(UnsupportedVersionException.class, () -> apiVersions.latestUsableVersion(ApiKeys.PRODUCE, (short)0, (short)1));
    }

    @Test
    public void testUsableVersionCalculationNoKnownVersions() {
        NodeApiVersions versions = new NodeApiVersions((Collection)new ApiVersionsResponseData.ApiVersionCollection(), Collections.emptyList(), false);
        Assertions.assertThrows(UnsupportedVersionException.class, () -> versions.latestUsableVersion(ApiKeys.FETCH));
    }

    @Test
    public void testLatestUsableVersionOutOfRange() {
        NodeApiVersions apiVersions = NodeApiVersions.create((short)ApiKeys.PRODUCE.id, (short)300, (short)300);
        Assertions.assertThrows(UnsupportedVersionException.class, () -> apiVersions.latestUsableVersion(ApiKeys.PRODUCE));
    }

    @ParameterizedTest
    @EnumSource(value=ApiMessageType.ListenerType.class)
    public void testUsableVersionLatestVersions(ApiMessageType.ListenerType scope) {
        ApiVersionsResponse defaultResponse = TestUtils.defaultApiVersionsResponse(scope);
        LinkedList<ApiVersionsResponseData.ApiVersion> versionList = new LinkedList<ApiVersionsResponseData.ApiVersion>((Collection<ApiVersionsResponseData.ApiVersion>)defaultResponse.data().apiKeys());
        versionList.add(new ApiVersionsResponseData.ApiVersion().setApiKey((short)100).setMinVersion((short)0).setMaxVersion((short)1));
        NodeApiVersions versions = new NodeApiVersions(versionList, Collections.emptyList(), false);
        for (ApiKeys apiKey : ApiKeys.apisForListener((ApiMessageType.ListenerType)scope)) {
            Assertions.assertEquals((short)apiKey.latestVersion(), (short)versions.latestUsableVersion(apiKey));
        }
    }

    @ParameterizedTest
    @EnumSource(value=ApiMessageType.ListenerType.class)
    public void testConstructionFromApiVersionsResponse(ApiMessageType.ListenerType scope) {
        ApiVersionsResponse apiVersionsResponse = TestUtils.defaultApiVersionsResponse(scope);
        NodeApiVersions versions = new NodeApiVersions((Collection)apiVersionsResponse.data().apiKeys(), Collections.emptyList(), false);
        for (ApiVersionsResponseData.ApiVersion apiVersionKey : apiVersionsResponse.data().apiKeys()) {
            ApiVersionsResponseData.ApiVersion apiVersion = versions.apiVersion(ApiKeys.forId((int)apiVersionKey.apiKey()));
            Assertions.assertEquals((short)apiVersionKey.apiKey(), (short)apiVersion.apiKey());
            Assertions.assertEquals((short)apiVersionKey.minVersion(), (short)apiVersion.minVersion());
            Assertions.assertEquals((short)apiVersionKey.maxVersion(), (short)apiVersion.maxVersion());
        }
    }
}

