/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.record;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.header.Header;
import org.apache.kafka.common.header.internals.RecordHeader;
import org.apache.kafka.common.network.TransferableChannel;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.ControlRecordType;
import org.apache.kafka.common.record.EndTransactionMarker;
import org.apache.kafka.common.record.FileRecords;
import org.apache.kafka.common.record.LazyDownConversionRecords;
import org.apache.kafka.common.record.LazyDownConversionRecordsSend;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.MemoryRecordsBuilder;
import org.apache.kafka.common.record.Record;
import org.apache.kafka.common.record.RecordBatch;
import org.apache.kafka.common.record.Records;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.record.TimestampType;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

public class LazyDownConversionRecordsTest {
    @Test
    public void testConversionOfCommitMarker() throws IOException {
        MemoryRecords recordsToConvert = MemoryRecords.withEndTransactionMarker((long)0L, (long)Time.SYSTEM.milliseconds(), (int)-1, (long)1L, (short)1, (EndTransactionMarker)new EndTransactionMarker(ControlRecordType.COMMIT, 0));
        MemoryRecords convertedRecords = LazyDownConversionRecordsTest.convertRecords(recordsToConvert, (byte)1, recordsToConvert.sizeInBytes());
        ByteBuffer buffer = convertedRecords.buffer();
        buffer.getLong();
        int sizeOfConvertedRecords = buffer.getInt();
        Assertions.assertTrue((sizeOfConvertedRecords > buffer.limit() ? 1 : 0) != 0);
        Assertions.assertFalse((boolean)convertedRecords.batchIterator().hasNext());
    }

    private static Collection<Arguments> parameters() {
        ArrayList<Arguments> arguments = new ArrayList<Arguments>();
        for (byte toMagic = 0; toMagic <= 2; toMagic = (byte)((byte)(toMagic + 1))) {
            for (boolean overflow : Arrays.asList(true, false)) {
                arguments.add(Arguments.of((Object[])new Object[]{CompressionType.NONE, toMagic, overflow}));
                arguments.add(Arguments.of((Object[])new Object[]{CompressionType.GZIP, toMagic, overflow}));
            }
        }
        return arguments;
    }

    @ParameterizedTest(name="compressionType={0}, toMagic={1}, overflow={2}")
    @MethodSource(value={"parameters"})
    public void testConversion(CompressionType compressionType, byte toMagic, boolean overflow) throws IOException {
        this.doTestConversion(compressionType, toMagic, overflow);
    }

    private void doTestConversion(CompressionType compressionType, byte toMagic, boolean testConversionOverflow) throws IOException {
        int i;
        List<Long> offsets = Arrays.asList(0L, 2L, 3L, 9L, 11L, 15L, 16L, 17L, 22L, 24L);
        Header[] headers = new Header[]{new RecordHeader("headerKey1", "headerValue1".getBytes()), new RecordHeader("headerKey2", "headerValue2".getBytes()), new RecordHeader("headerKey3", "headerValue3".getBytes())};
        List<SimpleRecord> records = Arrays.asList(new SimpleRecord(1L, "k1".getBytes(), "hello".getBytes()), new SimpleRecord(2L, "k2".getBytes(), "goodbye".getBytes()), new SimpleRecord(3L, "k3".getBytes(), "hello again".getBytes()), new SimpleRecord(4L, "k4".getBytes(), "goodbye for now".getBytes()), new SimpleRecord(5L, "k5".getBytes(), "hello again".getBytes()), new SimpleRecord(6L, "k6".getBytes(), "I sense indecision".getBytes()), new SimpleRecord(7L, "k7".getBytes(), "what now".getBytes()), new SimpleRecord(8L, "k8".getBytes(), "running out".getBytes(), headers), new SimpleRecord(9L, "k9".getBytes(), "ok, almost done".getBytes()), new SimpleRecord(10L, "k10".getBytes(), "finally".getBytes(), headers));
        Assertions.assertEquals((int)offsets.size(), (int)records.size(), (String)"incorrect test setup");
        ByteBuffer buffer = ByteBuffer.allocate(1024);
        MemoryRecordsBuilder builder = MemoryRecords.builder((ByteBuffer)buffer, (byte)2, (CompressionType)compressionType, (TimestampType)TimestampType.CREATE_TIME, (long)0L);
        for (i = 0; i < 3; ++i) {
            builder.appendWithOffset(offsets.get(i).longValue(), records.get(i));
        }
        builder.close();
        builder = MemoryRecords.builder((ByteBuffer)buffer, (byte)2, (CompressionType)compressionType, (TimestampType)TimestampType.CREATE_TIME, (long)0L);
        for (i = 3; i < 6; ++i) {
            builder.appendWithOffset(offsets.get(i).longValue(), records.get(i));
        }
        builder.close();
        builder = MemoryRecords.builder((ByteBuffer)buffer, (byte)2, (CompressionType)compressionType, (TimestampType)TimestampType.CREATE_TIME, (long)0L);
        for (i = 6; i < 10; ++i) {
            builder.appendWithOffset(offsets.get(i).longValue(), records.get(i));
        }
        builder.close();
        buffer.flip();
        MemoryRecords recordsToConvert = MemoryRecords.readableRecords((ByteBuffer)buffer);
        int numBytesToConvert = recordsToConvert.sizeInBytes();
        if (testConversionOverflow) {
            numBytesToConvert *= 2;
        }
        MemoryRecords convertedRecords = LazyDownConversionRecordsTest.convertRecords(recordsToConvert, toMagic, numBytesToConvert);
        LazyDownConversionRecordsTest.verifyDownConvertedRecords(records, offsets, convertedRecords, compressionType, toMagic);
    }

    private static MemoryRecords convertRecords(MemoryRecords recordsToConvert, byte toMagic, int bytesToConvert) throws IOException {
        try (FileRecords inputRecords = FileRecords.open((File)TestUtils.tempFile());){
            ByteBuffer convertedRecordsBuffer;
            inputRecords.append(recordsToConvert);
            inputRecords.flush();
            LazyDownConversionRecords lazyRecords = new LazyDownConversionRecords(new TopicPartition("test", 1), (Records)inputRecords, toMagic, 0L, Time.SYSTEM);
            LazyDownConversionRecordsSend lazySend = lazyRecords.toSend();
            File outputFile = TestUtils.tempFile();
            try (TransferableChannel channel = LazyDownConversionRecordsTest.toTransferableChannel(FileChannel.open(outputFile.toPath(), StandardOpenOption.READ, StandardOpenOption.WRITE));){
                int written = 0;
                while (written < bytesToConvert) {
                    written = (int)((long)written + lazySend.writeTo(channel, (long)written, bytesToConvert - written));
                }
                try (FileRecords convertedRecords = FileRecords.open((File)outputFile, (boolean)true, (int)written, (boolean)false);){
                    convertedRecordsBuffer = ByteBuffer.allocate(convertedRecords.sizeInBytes());
                    convertedRecords.readInto(convertedRecordsBuffer, 0);
                }
            }
            MemoryRecords memoryRecords = MemoryRecords.readableRecords((ByteBuffer)convertedRecordsBuffer);
            return memoryRecords;
        }
    }

    private static TransferableChannel toTransferableChannel(final FileChannel channel) {
        return new TransferableChannel(){

            public boolean hasPendingWrites() {
                return false;
            }

            public long transferFrom(FileChannel fileChannel, long position, long count) throws IOException {
                return fileChannel.transferTo(position, count, channel);
            }

            public boolean isOpen() {
                return channel.isOpen();
            }

            public void close() throws IOException {
                channel.close();
            }

            public int write(ByteBuffer src) throws IOException {
                return channel.write(src);
            }

            public long write(ByteBuffer[] srcs, int offset, int length) throws IOException {
                return channel.write(srcs, offset, length);
            }

            public long write(ByteBuffer[] srcs) throws IOException {
                return channel.write(srcs);
            }
        };
    }

    private static void verifyDownConvertedRecords(List<SimpleRecord> initialRecords, List<Long> initialOffsets, MemoryRecords downConvertedRecords, CompressionType compressionType, byte toMagic) {
        int i = 0;
        for (RecordBatch batch : downConvertedRecords.batches()) {
            Assertions.assertTrue((batch.magic() <= toMagic ? 1 : 0) != 0, (String)("Magic byte should be lower than or equal to " + toMagic));
            if (batch.magic() == 0) {
                Assertions.assertEquals((Object)TimestampType.NO_TIMESTAMP_TYPE, (Object)batch.timestampType());
            } else {
                Assertions.assertEquals((Object)TimestampType.CREATE_TIME, (Object)batch.timestampType());
            }
            Assertions.assertEquals((Object)compressionType, (Object)batch.compressionType(), (String)"Compression type should not be affected by conversion");
            for (Record record : batch) {
                Assertions.assertTrue((boolean)record.hasMagic(batch.magic()), (String)("Inner record should have magic " + toMagic));
                Assertions.assertEquals((long)initialOffsets.get(i), (long)record.offset(), (String)"Offset should not change");
                Assertions.assertEquals((Object)Utils.utf8((ByteBuffer)initialRecords.get(i).key()), (Object)Utils.utf8((ByteBuffer)record.key()), (String)"Key should not change");
                Assertions.assertEquals((Object)Utils.utf8((ByteBuffer)initialRecords.get(i).value()), (Object)Utils.utf8((ByteBuffer)record.value()), (String)"Value should not change");
                Assertions.assertFalse((boolean)record.hasTimestampType(TimestampType.LOG_APPEND_TIME));
                if (batch.magic() == 0) {
                    Assertions.assertEquals((long)-1L, (long)record.timestamp());
                    Assertions.assertFalse((boolean)record.hasTimestampType(TimestampType.CREATE_TIME));
                    Assertions.assertTrue((boolean)record.hasTimestampType(TimestampType.NO_TIMESTAMP_TYPE));
                } else if (batch.magic() == 1) {
                    Assertions.assertEquals((long)initialRecords.get(i).timestamp(), (long)record.timestamp(), (String)"Timestamp should not change");
                    Assertions.assertTrue((boolean)record.hasTimestampType(TimestampType.CREATE_TIME));
                    Assertions.assertFalse((boolean)record.hasTimestampType(TimestampType.NO_TIMESTAMP_TYPE));
                } else {
                    Assertions.assertEquals((long)initialRecords.get(i).timestamp(), (long)record.timestamp(), (String)"Timestamp should not change");
                    Assertions.assertFalse((boolean)record.hasTimestampType(TimestampType.CREATE_TIME));
                    Assertions.assertFalse((boolean)record.hasTimestampType(TimestampType.NO_TIMESTAMP_TYPE));
                    Assertions.assertArrayEquals((Object[])initialRecords.get(i).headers(), (Object[])record.headers(), (String)"Headers should not change");
                }
                ++i;
            }
        }
        Assertions.assertEquals((int)initialOffsets.size(), (int)i);
    }
}

