/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.metrics;

import java.lang.management.ManagementFactory;
import java.util.List;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.RuntimeMBeanException;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.metrics.JmxReporter;
import org.apache.kafka.common.metrics.MeasurableStat;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.MetricsReporter;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.metrics.stats.WindowedCount;
import org.apache.kafka.common.metrics.stats.WindowedSum;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class KafkaMbeanTest {
    private final MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
    private Sensor sensor;
    private MetricName countMetricName;
    private MetricName sumMetricName;
    private Metrics metrics;

    @BeforeEach
    public void setup() throws Exception {
        this.metrics = new Metrics();
        this.metrics.addReporter((MetricsReporter)new JmxReporter());
        this.sensor = this.metrics.sensor("kafka.requests");
        this.countMetricName = this.metrics.metricName("pack.bean1.count", "grp1");
        this.sensor.add(this.countMetricName, (MeasurableStat)new WindowedCount());
        this.sumMetricName = this.metrics.metricName("pack.bean1.sum", "grp1");
        this.sensor.add(this.sumMetricName, (MeasurableStat)new WindowedSum());
    }

    @AfterEach
    public void tearDown() {
        this.metrics.close();
    }

    @Test
    public void testGetAttribute() throws Exception {
        this.sensor.record(2.5);
        Object counterAttribute = this.getAttribute(this.countMetricName);
        Assertions.assertEquals((Object)1.0, (Object)counterAttribute);
        Object sumAttribute = this.getAttribute(this.sumMetricName);
        Assertions.assertEquals((Object)2.5, (Object)sumAttribute);
    }

    @Test
    public void testGetAttributeUnknown() throws Exception {
        this.sensor.record(2.5);
        try {
            this.getAttribute(this.sumMetricName, "name");
            Assertions.fail((String)"Should have gotten attribute not found");
        }
        catch (AttributeNotFoundException attributeNotFoundException) {
            // empty catch block
        }
    }

    @Test
    public void testGetAttributes() throws Exception {
        this.sensor.record(3.5);
        this.sensor.record(4.0);
        AttributeList attributeList = this.getAttributes(this.countMetricName, this.countMetricName.name(), this.sumMetricName.name());
        List<Attribute> attributes = attributeList.asList();
        Assertions.assertEquals((int)2, (int)attributes.size());
        for (Attribute attribute : attributes) {
            if (this.countMetricName.name().equals(attribute.getName())) {
                Assertions.assertEquals((Object)2.0, (Object)attribute.getValue());
                continue;
            }
            if (this.sumMetricName.name().equals(attribute.getName())) {
                Assertions.assertEquals((Object)7.5, (Object)attribute.getValue());
                continue;
            }
            Assertions.fail((String)("Unexpected attribute returned: " + attribute.getName()));
        }
    }

    @Test
    public void testGetAttributesWithUnknown() throws Exception {
        this.sensor.record(3.5);
        this.sensor.record(4.0);
        AttributeList attributeList = this.getAttributes(this.countMetricName, this.countMetricName.name(), this.sumMetricName.name(), "name");
        List<Attribute> attributes = attributeList.asList();
        Assertions.assertEquals((int)2, (int)attributes.size());
        for (Attribute attribute : attributes) {
            if (this.countMetricName.name().equals(attribute.getName())) {
                Assertions.assertEquals((Object)2.0, (Object)attribute.getValue());
                continue;
            }
            if (this.sumMetricName.name().equals(attribute.getName())) {
                Assertions.assertEquals((Object)7.5, (Object)attribute.getValue());
                continue;
            }
            Assertions.fail((String)("Unexpected attribute returned: " + attribute.getName()));
        }
    }

    @Test
    public void testInvoke() throws Exception {
        RuntimeMBeanException e = (RuntimeMBeanException)Assertions.assertThrows(RuntimeMBeanException.class, () -> this.mBeanServer.invoke(this.objectName(this.countMetricName), "something", null, null));
        Assertions.assertEquals(UnsupportedOperationException.class, e.getCause().getClass());
    }

    @Test
    public void testSetAttribute() throws Exception {
        RuntimeMBeanException e = (RuntimeMBeanException)Assertions.assertThrows(RuntimeMBeanException.class, () -> this.mBeanServer.setAttribute(this.objectName(this.countMetricName), new Attribute("anything", 1)));
        Assertions.assertEquals(UnsupportedOperationException.class, e.getCause().getClass());
    }

    @Test
    public void testSetAttributes() throws Exception {
        RuntimeMBeanException e = (RuntimeMBeanException)Assertions.assertThrows(RuntimeMBeanException.class, () -> this.mBeanServer.setAttributes(this.objectName(this.countMetricName), new AttributeList(1)));
        Assertions.assertEquals(UnsupportedOperationException.class, e.getCause().getClass());
    }

    private ObjectName objectName(MetricName metricName) throws Exception {
        return new ObjectName(JmxReporter.getMBeanName((String)"", (MetricName)metricName));
    }

    private Object getAttribute(MetricName metricName, String attribute) throws Exception {
        return this.mBeanServer.getAttribute(this.objectName(metricName), attribute);
    }

    private Object getAttribute(MetricName metricName) throws Exception {
        return this.getAttribute(metricName, metricName.name());
    }

    private AttributeList getAttributes(MetricName metricName, String ... attributes) throws Exception {
        return this.mBeanServer.getAttributes(this.objectName(metricName), attributes);
    }
}

