/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.message;

import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.Message;
import org.apache.kafka.common.protocol.MessageSizeAccumulator;
import org.apache.kafka.common.protocol.MessageUtil;
import org.apache.kafka.common.protocol.ObjectSerializationCache;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.protocol.Writable;
import org.apache.kafka.common.protocol.types.CompactArrayOf;
import org.apache.kafka.common.protocol.types.Field;
import org.apache.kafka.common.protocol.types.RawTaggedField;
import org.apache.kafka.common.protocol.types.RawTaggedFieldWriter;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Type;
import org.apache.kafka.common.utils.ByteUtils;
import org.apache.kafka.common.utils.Bytes;

public class SimpleExampleMessageData
implements ApiMessage {
    Uuid processId;
    List<Integer> myTaggedIntArray;
    String myNullableString;
    short myInt16;
    double myFloat64;
    String myString;
    byte[] myBytes;
    Uuid taggedUuid;
    long taggedLong;
    ByteBuffer zeroCopyByteBuffer;
    ByteBuffer nullableZeroCopyByteBuffer;
    MyStruct myStruct;
    TaggedStruct myTaggedStruct;
    TestCommonStruct myCommonStruct;
    TestCommonStruct myOtherCommonStruct;
    int myUint16;
    private List<RawTaggedField> _unknownTaggedFields;
    public static final Schema SCHEMA_0 = new Schema(new Field[]{new Field("my_common_struct", (Type)TestCommonStruct.SCHEMA_0, ""), new Field("my_other_common_struct", (Type)TestCommonStruct.SCHEMA_0, "")});
    public static final Schema SCHEMA_1 = new Schema(new Field[]{new Field("process_id", (Type)Type.UUID, ""), new Field("zero_copy_byte_buffer", (Type)Type.COMPACT_BYTES, ""), new Field("nullable_zero_copy_byte_buffer", (Type)Type.COMPACT_NULLABLE_BYTES, ""), new Field("my_common_struct", (Type)TestCommonStruct.SCHEMA_1, ""), new Field("my_other_common_struct", (Type)TestCommonStruct.SCHEMA_1, ""), new Field("my_uint16", (Type)Type.UINT16, ""), Field.TaggedFieldsSection.of((Object[])new Object[]{0, new Field("my_tagged_int_array", (Type)new CompactArrayOf((Type)Type.INT32), ""), 1, new Field("my_nullable_string", (Type)Type.COMPACT_NULLABLE_STRING, ""), 2, new Field("my_int16", (Type)Type.INT16, ""), 3, new Field("my_float64", (Type)Type.FLOAT64, ""), 4, new Field("my_string", (Type)Type.COMPACT_STRING, ""), 5, new Field("my_bytes", (Type)Type.COMPACT_NULLABLE_BYTES, ""), 6, new Field("tagged_uuid", (Type)Type.UUID, ""), 7, new Field("tagged_long", (Type)Type.INT64, "")})});
    public static final Schema SCHEMA_2 = new Schema(new Field[]{new Field("process_id", (Type)Type.UUID, ""), new Field("my_struct", (Type)MyStruct.SCHEMA_2, "Test Struct field"), new Field("my_common_struct", (Type)TestCommonStruct.SCHEMA_1, ""), new Field("my_other_common_struct", (Type)TestCommonStruct.SCHEMA_1, ""), new Field("my_uint16", (Type)Type.UINT16, ""), Field.TaggedFieldsSection.of((Object[])new Object[]{0, new Field("my_tagged_int_array", (Type)new CompactArrayOf((Type)Type.INT32), ""), 1, new Field("my_nullable_string", (Type)Type.COMPACT_NULLABLE_STRING, ""), 2, new Field("my_int16", (Type)Type.INT16, ""), 3, new Field("my_float64", (Type)Type.FLOAT64, ""), 4, new Field("my_string", (Type)Type.COMPACT_STRING, ""), 5, new Field("my_bytes", (Type)Type.COMPACT_NULLABLE_BYTES, ""), 6, new Field("tagged_uuid", (Type)Type.UUID, ""), 7, new Field("tagged_long", (Type)Type.INT64, ""), 8, new Field("my_tagged_struct", (Type)TaggedStruct.SCHEMA_2, "Test Tagged Struct field")})});
    public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1, SCHEMA_2};
    public static final short LOWEST_SUPPORTED_VERSION = 0;
    public static final short HIGHEST_SUPPORTED_VERSION = 2;

    public SimpleExampleMessageData(Readable _readable, short _version) {
        this.read(_readable, _version);
    }

    public SimpleExampleMessageData() {
        this.processId = Uuid.ZERO_UUID;
        this.myTaggedIntArray = new ArrayList<Integer>(0);
        this.myNullableString = null;
        this.myInt16 = (short)123;
        this.myFloat64 = Double.parseDouble("12.34");
        this.myString = "";
        this.myBytes = Bytes.EMPTY;
        this.taggedUuid = Uuid.fromString((String)"H3KKO4NTRPaCWtEmm3vW7A");
        this.taggedLong = 0xCAFCACAFCACAFCAL;
        this.zeroCopyByteBuffer = ByteUtils.EMPTY_BUF;
        this.nullableZeroCopyByteBuffer = ByteUtils.EMPTY_BUF;
        this.myStruct = new MyStruct();
        this.myTaggedStruct = new TaggedStruct();
        this.myCommonStruct = new TestCommonStruct();
        this.myOtherCommonStruct = new TestCommonStruct();
        this.myUint16 = 33000;
    }

    public short apiKey() {
        return -1;
    }

    public short lowestSupportedVersion() {
        return 0;
    }

    public short highestSupportedVersion() {
        return 2;
    }

    public void read(Readable _readable, short _version) {
        int length;
        this.processId = _version >= 1 ? _readable.readUuid() : Uuid.ZERO_UUID;
        this.myTaggedIntArray = new ArrayList<Integer>(0);
        this.myNullableString = null;
        this.myInt16 = (short)123;
        this.myFloat64 = Double.parseDouble("12.34");
        this.myString = "";
        this.myBytes = Bytes.EMPTY;
        this.taggedUuid = Uuid.fromString((String)"H3KKO4NTRPaCWtEmm3vW7A");
        this.taggedLong = 0xCAFCACAFCACAFCAL;
        if (_version >= 1 && _version <= 1) {
            length = _readable.readUnsignedVarint() - 1;
            if (length < 0) {
                throw new RuntimeException("non-nullable field zeroCopyByteBuffer was serialized as null");
            }
            this.zeroCopyByteBuffer = _readable.readByteBuffer(length);
        } else {
            this.zeroCopyByteBuffer = ByteUtils.EMPTY_BUF;
        }
        this.nullableZeroCopyByteBuffer = _version >= 1 && _version <= 1 ? ((length = _readable.readUnsignedVarint() - 1) < 0 ? null : _readable.readByteBuffer(length)) : ByteUtils.EMPTY_BUF;
        this.myStruct = _version >= 2 ? new MyStruct(_readable, _version) : new MyStruct();
        this.myTaggedStruct = new TaggedStruct();
        this.myCommonStruct = new TestCommonStruct(_readable, _version);
        this.myOtherCommonStruct = new TestCommonStruct(_readable, _version);
        this.myUint16 = _version >= 1 ? _readable.readUnsignedShort() : 33000;
        this._unknownTaggedFields = null;
        if (_version >= 1) {
            int _numTaggedFields = _readable.readUnsignedVarint();
            block11: for (int _i = 0; _i < _numTaggedFields; ++_i) {
                int _tag = _readable.readUnsignedVarint();
                int _size = _readable.readUnsignedVarint();
                switch (_tag) {
                    case 0: {
                        int arrayLength = _readable.readUnsignedVarint() - 1;
                        if (arrayLength < 0) {
                            throw new RuntimeException("non-nullable field myTaggedIntArray was serialized as null");
                        }
                        if (arrayLength > _readable.remaining()) {
                            throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
                        }
                        ArrayList<Integer> newCollection = new ArrayList<Integer>(arrayLength);
                        for (int i = 0; i < arrayLength; ++i) {
                            newCollection.add(_readable.readInt());
                        }
                        this.myTaggedIntArray = newCollection;
                        continue block11;
                    }
                    case 1: {
                        int length2 = _readable.readUnsignedVarint() - 1;
                        if (length2 < 0) {
                            this.myNullableString = null;
                            continue block11;
                        }
                        if (length2 > Short.MAX_VALUE) {
                            throw new RuntimeException("string field myNullableString had invalid length " + length2);
                        }
                        this.myNullableString = _readable.readString(length2);
                        continue block11;
                    }
                    case 2: {
                        this.myInt16 = _readable.readShort();
                        continue block11;
                    }
                    case 3: {
                        this.myFloat64 = _readable.readDouble();
                        continue block11;
                    }
                    case 4: {
                        int length2 = _readable.readUnsignedVarint() - 1;
                        if (length2 < 0) {
                            throw new RuntimeException("non-nullable field myString was serialized as null");
                        }
                        if (length2 > Short.MAX_VALUE) {
                            throw new RuntimeException("string field myString had invalid length " + length2);
                        }
                        this.myString = _readable.readString(length2);
                        continue block11;
                    }
                    case 5: {
                        int length2 = _readable.readUnsignedVarint() - 1;
                        if (length2 < 0) {
                            this.myBytes = null;
                            continue block11;
                        }
                        byte[] newBytes = _readable.readArray(length2);
                        this.myBytes = newBytes;
                        continue block11;
                    }
                    case 6: {
                        this.taggedUuid = _readable.readUuid();
                        continue block11;
                    }
                    case 7: {
                        this.taggedLong = _readable.readLong();
                        continue block11;
                    }
                    case 8: {
                        if (_version >= 2) {
                            this.myTaggedStruct = new TaggedStruct(_readable, _version);
                            continue block11;
                        }
                        throw new RuntimeException("Tag 8 is not valid for version " + _version);
                    }
                    default: {
                        this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
                    }
                }
            }
        }
    }

    public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
        int _numTaggedFields = 0;
        if (_version >= 1) {
            _writable.writeUuid(this.processId);
        } else if (!this.processId.equals((Object)Uuid.ZERO_UUID)) {
            throw new UnsupportedVersionException("Attempted to write a non-default processId at version " + _version);
        }
        if (_version >= 1) {
            if (!this.myTaggedIntArray.isEmpty()) {
                ++_numTaggedFields;
            }
        } else if (!this.myTaggedIntArray.isEmpty()) {
            throw new UnsupportedVersionException("Attempted to write a non-default myTaggedIntArray at version " + _version);
        }
        if (_version >= 1) {
            if (this.myNullableString != null) {
                ++_numTaggedFields;
            }
        } else if (this.myNullableString != null) {
            throw new UnsupportedVersionException("Attempted to write a non-default myNullableString at version " + _version);
        }
        if (_version >= 1) {
            if (this.myInt16 != 123) {
                ++_numTaggedFields;
            }
        } else if (this.myInt16 != 123) {
            throw new UnsupportedVersionException("Attempted to write a non-default myInt16 at version " + _version);
        }
        if (_version >= 1) {
            if (this.myFloat64 != Double.parseDouble("12.34")) {
                ++_numTaggedFields;
            }
        } else if (this.myFloat64 != Double.parseDouble("12.34")) {
            throw new UnsupportedVersionException("Attempted to write a non-default myFloat64 at version " + _version);
        }
        if (_version >= 1) {
            if (!this.myString.equals("")) {
                ++_numTaggedFields;
            }
        } else if (!this.myString.equals("")) {
            throw new UnsupportedVersionException("Attempted to write a non-default myString at version " + _version);
        }
        if (_version >= 1) {
            if (this.myBytes == null || this.myBytes.length != 0) {
                ++_numTaggedFields;
            }
        } else if (this.myBytes == null || this.myBytes.length != 0) {
            throw new UnsupportedVersionException("Attempted to write a non-default myBytes at version " + _version);
        }
        if (_version >= 1) {
            if (!this.taggedUuid.equals((Object)Uuid.fromString((String)"H3KKO4NTRPaCWtEmm3vW7A"))) {
                ++_numTaggedFields;
            }
        } else if (!this.taggedUuid.equals((Object)Uuid.fromString((String)"H3KKO4NTRPaCWtEmm3vW7A"))) {
            throw new UnsupportedVersionException("Attempted to write a non-default taggedUuid at version " + _version);
        }
        if (_version >= 1) {
            if (this.taggedLong != 0xCAFCACAFCACAFCAL) {
                ++_numTaggedFields;
            }
        } else if (this.taggedLong != 0xCAFCACAFCACAFCAL) {
            throw new UnsupportedVersionException("Attempted to write a non-default taggedLong at version " + _version);
        }
        if (_version >= 1 && _version <= 1) {
            _writable.writeUnsignedVarint(this.zeroCopyByteBuffer.remaining() + 1);
            _writable.writeByteBuffer(this.zeroCopyByteBuffer);
        } else if (this.zeroCopyByteBuffer.hasRemaining()) {
            throw new UnsupportedVersionException("Attempted to write a non-default zeroCopyByteBuffer at version " + _version);
        }
        if (_version >= 1 && _version <= 1) {
            if (this.nullableZeroCopyByteBuffer == null) {
                _writable.writeUnsignedVarint(0);
            } else {
                _writable.writeUnsignedVarint(this.nullableZeroCopyByteBuffer.remaining() + 1);
                _writable.writeByteBuffer(this.nullableZeroCopyByteBuffer);
            }
        } else if (this.nullableZeroCopyByteBuffer == null || this.nullableZeroCopyByteBuffer.remaining() > 0) {
            throw new UnsupportedVersionException("Attempted to write a non-default nullableZeroCopyByteBuffer at version " + _version);
        }
        if (_version >= 2) {
            this.myStruct.write(_writable, _cache, _version);
        } else if (!this.myStruct.equals(new MyStruct())) {
            throw new UnsupportedVersionException("Attempted to write a non-default myStruct at version " + _version);
        }
        if (_version >= 2) {
            if (!this.myTaggedStruct.equals(new TaggedStruct())) {
                ++_numTaggedFields;
            }
        } else if (!this.myTaggedStruct.equals(new TaggedStruct())) {
            throw new UnsupportedVersionException("Attempted to write a non-default myTaggedStruct at version " + _version);
        }
        this.myCommonStruct.write(_writable, _cache, _version);
        this.myOtherCommonStruct.write(_writable, _cache, _version);
        if (_version >= 1) {
            _writable.writeUnsignedShort(this.myUint16);
        } else if (this.myUint16 != 33000) {
            throw new UnsupportedVersionException("Attempted to write a non-default myUint16 at version " + _version);
        }
        RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
        _numTaggedFields += _rawWriter.numFields();
        if (_version >= 1) {
            byte[] _stringBytes;
            _writable.writeUnsignedVarint(_numTaggedFields);
            if (!this.myTaggedIntArray.isEmpty()) {
                _writable.writeUnsignedVarint(0);
                _writable.writeUnsignedVarint(_cache.getArraySizeInBytes(this.myTaggedIntArray).intValue());
                _writable.writeUnsignedVarint(this.myTaggedIntArray.size() + 1);
                for (Integer myTaggedIntArrayElement : this.myTaggedIntArray) {
                    _writable.writeInt(myTaggedIntArrayElement.intValue());
                }
            }
            if (this.myNullableString != null) {
                _writable.writeUnsignedVarint(1);
                _stringBytes = _cache.getSerializedValue((Object)this.myNullableString);
                _writable.writeUnsignedVarint(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint((int)(_stringBytes.length + 1)));
                _writable.writeUnsignedVarint(_stringBytes.length + 1);
                _writable.writeByteArray(_stringBytes);
            }
            if (this.myInt16 != 123) {
                _writable.writeUnsignedVarint(2);
                _writable.writeUnsignedVarint(2);
                _writable.writeShort(this.myInt16);
            }
            if (this.myFloat64 != Double.parseDouble("12.34")) {
                _writable.writeUnsignedVarint(3);
                _writable.writeUnsignedVarint(8);
                _writable.writeDouble(this.myFloat64);
            }
            if (!this.myString.equals("")) {
                _writable.writeUnsignedVarint(4);
                _stringBytes = _cache.getSerializedValue((Object)this.myString);
                _writable.writeUnsignedVarint(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint((int)(_stringBytes.length + 1)));
                _writable.writeUnsignedVarint(_stringBytes.length + 1);
                _writable.writeByteArray(_stringBytes);
            }
            if (this.myBytes == null) {
                _writable.writeUnsignedVarint(5);
                _writable.writeUnsignedVarint(1);
                _writable.writeUnsignedVarint(0);
            } else if (this.myBytes.length != 0) {
                _writable.writeUnsignedVarint(5);
                _writable.writeUnsignedVarint(this.myBytes.length + ByteUtils.sizeOfUnsignedVarint((int)(this.myBytes.length + 1)));
                _writable.writeUnsignedVarint(this.myBytes.length + 1);
                _writable.writeByteArray(this.myBytes);
            }
            if (!this.taggedUuid.equals((Object)Uuid.fromString((String)"H3KKO4NTRPaCWtEmm3vW7A"))) {
                _writable.writeUnsignedVarint(6);
                _writable.writeUnsignedVarint(16);
                _writable.writeUuid(this.taggedUuid);
            }
            if (this.taggedLong != 0xCAFCACAFCACAFCAL) {
                _writable.writeUnsignedVarint(7);
                _writable.writeUnsignedVarint(8);
                _writable.writeLong(this.taggedLong);
            }
            if (!this.myTaggedStruct.equals(new TaggedStruct())) {
                _writable.writeUnsignedVarint(8);
                _writable.writeUnsignedVarint(this.myTaggedStruct.size(_cache, _version));
                this.myTaggedStruct.write(_writable, _cache, _version);
            }
            _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
        } else if (_numTaggedFields > 0) {
            throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
        }
    }

    public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version) {
        int _structSize;
        int _sizeBeforeStruct;
        int _bytesSize;
        int _stringPrefixSize;
        int _numTaggedFields = 0;
        if (_version >= 1) {
            _size.addBytes(16);
        }
        if (_version >= 1 && !this.myTaggedIntArray.isEmpty()) {
            ++_numTaggedFields;
            _size.addBytes(1);
            int _sizeBeforeArray = _size.totalSize();
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)(this.myTaggedIntArray.size() + 1)));
            _size.addBytes(this.myTaggedIntArray.size() * 4);
            int _arraySize = _size.totalSize() - _sizeBeforeArray;
            _cache.setArraySizeInBytes(this.myTaggedIntArray, Integer.valueOf(_arraySize));
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_arraySize));
        }
        if (_version >= 1 && this.myNullableString != null) {
            ++_numTaggedFields;
            _size.addBytes(1);
            byte[] _stringBytes = this.myNullableString.getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'myNullableString' field is too long to be serialized");
            }
            _cache.cacheSerializedValue((Object)this.myNullableString, _stringBytes);
            _stringPrefixSize = ByteUtils.sizeOfUnsignedVarint((int)(_stringBytes.length + 1));
            _size.addBytes(_stringBytes.length + _stringPrefixSize + ByteUtils.sizeOfUnsignedVarint((int)(_stringPrefixSize + _stringBytes.length)));
        }
        if (_version >= 1 && this.myInt16 != 123) {
            ++_numTaggedFields;
            _size.addBytes(1);
            _size.addBytes(1);
            _size.addBytes(2);
        }
        if (_version >= 1 && this.myFloat64 != Double.parseDouble("12.34")) {
            ++_numTaggedFields;
            _size.addBytes(1);
            _size.addBytes(1);
            _size.addBytes(8);
        }
        if (_version >= 1 && !this.myString.equals("")) {
            ++_numTaggedFields;
            _size.addBytes(1);
            byte[] _stringBytes = this.myString.getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'myString' field is too long to be serialized");
            }
            _cache.cacheSerializedValue((Object)this.myString, _stringBytes);
            _stringPrefixSize = ByteUtils.sizeOfUnsignedVarint((int)(_stringBytes.length + 1));
            _size.addBytes(_stringBytes.length + _stringPrefixSize + ByteUtils.sizeOfUnsignedVarint((int)(_stringPrefixSize + _stringBytes.length)));
        }
        if (_version >= 1) {
            if (this.myBytes == null) {
                ++_numTaggedFields;
                _size.addBytes(1);
                _size.addBytes(1);
                _size.addBytes(1);
            } else if (this.myBytes.length != 0) {
                ++_numTaggedFields;
                _size.addBytes(1);
                int _sizeBeforeBytes = _size.totalSize();
                _size.addBytes(this.myBytes.length);
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)(this.myBytes.length + 1)));
                _bytesSize = _size.totalSize() - _sizeBeforeBytes;
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_bytesSize));
            }
        }
        if (_version >= 1 && !this.taggedUuid.equals((Object)Uuid.fromString((String)"H3KKO4NTRPaCWtEmm3vW7A"))) {
            ++_numTaggedFields;
            _size.addBytes(1);
            _size.addBytes(1);
            _size.addBytes(16);
        }
        if (_version >= 1 && this.taggedLong != 0xCAFCACAFCACAFCAL) {
            ++_numTaggedFields;
            _size.addBytes(1);
            _size.addBytes(1);
            _size.addBytes(8);
        }
        if (_version >= 1 && _version <= 1) {
            _size.addZeroCopyBytes(this.zeroCopyByteBuffer.remaining());
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)(this.zeroCopyByteBuffer.remaining() + 1)));
        }
        if (_version >= 1 && _version <= 1) {
            if (this.nullableZeroCopyByteBuffer == null) {
                _size.addBytes(1);
            } else {
                _size.addZeroCopyBytes(this.nullableZeroCopyByteBuffer.remaining());
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)(this.nullableZeroCopyByteBuffer.remaining() + 1)));
            }
        }
        if (_version >= 2) {
            _sizeBeforeStruct = _size.totalSize();
            this.myStruct.addSize(_size, _cache, _version);
            _bytesSize = _size.totalSize() - _sizeBeforeStruct;
        }
        if (_version >= 2 && !this.myTaggedStruct.equals(new TaggedStruct())) {
            ++_numTaggedFields;
            _size.addBytes(1);
            _sizeBeforeStruct = _size.totalSize();
            this.myTaggedStruct.addSize(_size, _cache, _version);
            _structSize = _size.totalSize() - _sizeBeforeStruct;
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_structSize));
        }
        _sizeBeforeStruct = _size.totalSize();
        this.myCommonStruct.addSize(_size, _cache, _version);
        _structSize = _size.totalSize() - _sizeBeforeStruct;
        _sizeBeforeStruct = _size.totalSize();
        this.myOtherCommonStruct.addSize(_size, _cache, _version);
        _structSize = _size.totalSize() - _sizeBeforeStruct;
        if (_version >= 1) {
            _size.addBytes(2);
        }
        if (this._unknownTaggedFields != null) {
            _numTaggedFields += this._unknownTaggedFields.size();
            for (RawTaggedField _field : this._unknownTaggedFields) {
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_field.tag()));
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_field.size()));
                _size.addBytes(_field.size());
            }
        }
        if (_version >= 1) {
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_numTaggedFields));
        } else if (_numTaggedFields > 0) {
            throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
        }
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof SimpleExampleMessageData)) {
            return false;
        }
        SimpleExampleMessageData other = (SimpleExampleMessageData)obj;
        if (!this.processId.equals((Object)other.processId)) {
            return false;
        }
        if (this.myTaggedIntArray == null ? other.myTaggedIntArray != null : !this.myTaggedIntArray.equals(other.myTaggedIntArray)) {
            return false;
        }
        if (this.myNullableString == null ? other.myNullableString != null : !this.myNullableString.equals(other.myNullableString)) {
            return false;
        }
        if (this.myInt16 != other.myInt16) {
            return false;
        }
        if (this.myFloat64 != other.myFloat64) {
            return false;
        }
        if (this.myString == null ? other.myString != null : !this.myString.equals(other.myString)) {
            return false;
        }
        if (!Arrays.equals(this.myBytes, other.myBytes)) {
            return false;
        }
        if (!this.taggedUuid.equals((Object)other.taggedUuid)) {
            return false;
        }
        if (this.taggedLong != other.taggedLong) {
            return false;
        }
        if (!Objects.equals(this.zeroCopyByteBuffer, other.zeroCopyByteBuffer)) {
            return false;
        }
        if (!Objects.equals(this.nullableZeroCopyByteBuffer, other.nullableZeroCopyByteBuffer)) {
            return false;
        }
        if (this.myStruct == null ? other.myStruct != null : !this.myStruct.equals(other.myStruct)) {
            return false;
        }
        if (this.myTaggedStruct == null ? other.myTaggedStruct != null : !this.myTaggedStruct.equals(other.myTaggedStruct)) {
            return false;
        }
        if (this.myCommonStruct == null ? other.myCommonStruct != null : !this.myCommonStruct.equals(other.myCommonStruct)) {
            return false;
        }
        if (this.myOtherCommonStruct == null ? other.myOtherCommonStruct != null : !this.myOtherCommonStruct.equals(other.myOtherCommonStruct)) {
            return false;
        }
        if (this.myUint16 != other.myUint16) {
            return false;
        }
        return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = 31 * hashCode + this.processId.hashCode();
        hashCode = 31 * hashCode + (this.myTaggedIntArray == null ? 0 : this.myTaggedIntArray.hashCode());
        hashCode = 31 * hashCode + (this.myNullableString == null ? 0 : this.myNullableString.hashCode());
        hashCode = 31 * hashCode + this.myInt16;
        hashCode = 31 * hashCode + Double.hashCode(this.myFloat64);
        hashCode = 31 * hashCode + (this.myString == null ? 0 : this.myString.hashCode());
        hashCode = 31 * hashCode + Arrays.hashCode(this.myBytes);
        hashCode = 31 * hashCode + this.taggedUuid.hashCode();
        hashCode = 31 * hashCode + ((int)(this.taggedLong >> 32) ^ (int)this.taggedLong);
        hashCode = 31 * hashCode + Objects.hashCode(this.zeroCopyByteBuffer);
        hashCode = 31 * hashCode + Objects.hashCode(this.nullableZeroCopyByteBuffer);
        hashCode = 31 * hashCode + (this.myStruct == null ? 0 : this.myStruct.hashCode());
        hashCode = 31 * hashCode + (this.myTaggedStruct == null ? 0 : this.myTaggedStruct.hashCode());
        hashCode = 31 * hashCode + (this.myCommonStruct == null ? 0 : this.myCommonStruct.hashCode());
        hashCode = 31 * hashCode + (this.myOtherCommonStruct == null ? 0 : this.myOtherCommonStruct.hashCode());
        hashCode = 31 * hashCode + this.myUint16;
        return hashCode;
    }

    public SimpleExampleMessageData duplicate() {
        SimpleExampleMessageData _duplicate = new SimpleExampleMessageData();
        _duplicate.processId = this.processId;
        ArrayList<Integer> newMyTaggedIntArray = new ArrayList<Integer>(this.myTaggedIntArray.size());
        for (Integer _element : this.myTaggedIntArray) {
            newMyTaggedIntArray.add(_element);
        }
        _duplicate.myTaggedIntArray = newMyTaggedIntArray;
        _duplicate.myNullableString = this.myNullableString == null ? null : this.myNullableString;
        _duplicate.myInt16 = this.myInt16;
        _duplicate.myFloat64 = this.myFloat64;
        _duplicate.myString = this.myString;
        _duplicate.myBytes = (byte[])(this.myBytes == null ? null : MessageUtil.duplicate((byte[])this.myBytes));
        _duplicate.taggedUuid = this.taggedUuid;
        _duplicate.taggedLong = this.taggedLong;
        _duplicate.zeroCopyByteBuffer = this.zeroCopyByteBuffer.duplicate();
        _duplicate.nullableZeroCopyByteBuffer = this.nullableZeroCopyByteBuffer == null ? null : this.nullableZeroCopyByteBuffer.duplicate();
        _duplicate.myStruct = this.myStruct.duplicate();
        _duplicate.myTaggedStruct = this.myTaggedStruct.duplicate();
        _duplicate.myCommonStruct = this.myCommonStruct.duplicate();
        _duplicate.myOtherCommonStruct = this.myOtherCommonStruct.duplicate();
        _duplicate.myUint16 = this.myUint16;
        return _duplicate;
    }

    public String toString() {
        return "SimpleExampleMessageData(processId=" + this.processId.toString() + ", myTaggedIntArray=" + MessageUtil.deepToString(this.myTaggedIntArray.iterator()) + ", myNullableString=" + (this.myNullableString == null ? "null" : "'" + this.myNullableString.toString() + "'") + ", myInt16=" + this.myInt16 + ", myFloat64=" + this.myFloat64 + ", myString=" + (this.myString == null ? "null" : "'" + this.myString.toString() + "'") + ", myBytes=" + Arrays.toString(this.myBytes) + ", taggedUuid=" + this.taggedUuid.toString() + ", taggedLong=" + this.taggedLong + ", zeroCopyByteBuffer=" + this.zeroCopyByteBuffer + ", nullableZeroCopyByteBuffer=" + this.nullableZeroCopyByteBuffer + ", myStruct=" + this.myStruct.toString() + ", myTaggedStruct=" + this.myTaggedStruct.toString() + ", myCommonStruct=" + this.myCommonStruct.toString() + ", myOtherCommonStruct=" + this.myOtherCommonStruct.toString() + ", myUint16=" + this.myUint16 + ")";
    }

    public Uuid processId() {
        return this.processId;
    }

    public List<Integer> myTaggedIntArray() {
        return this.myTaggedIntArray;
    }

    public String myNullableString() {
        return this.myNullableString;
    }

    public short myInt16() {
        return this.myInt16;
    }

    public double myFloat64() {
        return this.myFloat64;
    }

    public String myString() {
        return this.myString;
    }

    public byte[] myBytes() {
        return this.myBytes;
    }

    public Uuid taggedUuid() {
        return this.taggedUuid;
    }

    public long taggedLong() {
        return this.taggedLong;
    }

    public ByteBuffer zeroCopyByteBuffer() {
        return this.zeroCopyByteBuffer;
    }

    public ByteBuffer nullableZeroCopyByteBuffer() {
        return this.nullableZeroCopyByteBuffer;
    }

    public MyStruct myStruct() {
        return this.myStruct;
    }

    public TaggedStruct myTaggedStruct() {
        return this.myTaggedStruct;
    }

    public TestCommonStruct myCommonStruct() {
        return this.myCommonStruct;
    }

    public TestCommonStruct myOtherCommonStruct() {
        return this.myOtherCommonStruct;
    }

    public int myUint16() {
        return this.myUint16;
    }

    public List<RawTaggedField> unknownTaggedFields() {
        if (this._unknownTaggedFields == null) {
            this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
        }
        return this._unknownTaggedFields;
    }

    public SimpleExampleMessageData setProcessId(Uuid v) {
        this.processId = v;
        return this;
    }

    public SimpleExampleMessageData setMyTaggedIntArray(List<Integer> v) {
        this.myTaggedIntArray = v;
        return this;
    }

    public SimpleExampleMessageData setMyNullableString(String v) {
        this.myNullableString = v;
        return this;
    }

    public SimpleExampleMessageData setMyInt16(short v) {
        this.myInt16 = v;
        return this;
    }

    public SimpleExampleMessageData setMyFloat64(double v) {
        this.myFloat64 = v;
        return this;
    }

    public SimpleExampleMessageData setMyString(String v) {
        this.myString = v;
        return this;
    }

    public SimpleExampleMessageData setMyBytes(byte[] v) {
        this.myBytes = v;
        return this;
    }

    public SimpleExampleMessageData setTaggedUuid(Uuid v) {
        this.taggedUuid = v;
        return this;
    }

    public SimpleExampleMessageData setTaggedLong(long v) {
        this.taggedLong = v;
        return this;
    }

    public SimpleExampleMessageData setZeroCopyByteBuffer(ByteBuffer v) {
        this.zeroCopyByteBuffer = v;
        return this;
    }

    public SimpleExampleMessageData setNullableZeroCopyByteBuffer(ByteBuffer v) {
        this.nullableZeroCopyByteBuffer = v;
        return this;
    }

    public SimpleExampleMessageData setMyStruct(MyStruct v) {
        this.myStruct = v;
        return this;
    }

    public SimpleExampleMessageData setMyTaggedStruct(TaggedStruct v) {
        this.myTaggedStruct = v;
        return this;
    }

    public SimpleExampleMessageData setMyCommonStruct(TestCommonStruct v) {
        this.myCommonStruct = v;
        return this;
    }

    public SimpleExampleMessageData setMyOtherCommonStruct(TestCommonStruct v) {
        this.myOtherCommonStruct = v;
        return this;
    }

    public SimpleExampleMessageData setMyUint16(int v) {
        if (v < 0 || v > 65535) {
            throw new RuntimeException("Invalid value " + v + " for unsigned short field.");
        }
        this.myUint16 = v;
        return this;
    }

    public static class TestCommonStruct
    implements Message {
        int foo;
        int bar;
        private List<RawTaggedField> _unknownTaggedFields;
        public static final Schema SCHEMA_0 = new Schema(new Field[]{new Field("foo", (Type)Type.INT32, ""), new Field("bar", (Type)Type.INT32, "")});
        public static final Schema SCHEMA_1;
        public static final Schema SCHEMA_2;
        public static final Schema[] SCHEMAS;
        public static final short LOWEST_SUPPORTED_VERSION = 0;
        public static final short HIGHEST_SUPPORTED_VERSION = 2;

        public TestCommonStruct(Readable _readable, short _version) {
            this.read(_readable, _version);
        }

        public TestCommonStruct() {
            this.foo = 123;
            this.bar = 123;
        }

        public short lowestSupportedVersion() {
            return 0;
        }

        public short highestSupportedVersion() {
            return Short.MAX_VALUE;
        }

        public void read(Readable _readable, short _version) {
            this.foo = _readable.readInt();
            this.bar = _readable.readInt();
            this._unknownTaggedFields = null;
            if (_version >= 1) {
                int _numTaggedFields = _readable.readUnsignedVarint();
                for (int _i = 0; _i < _numTaggedFields; ++_i) {
                    int _tag = _readable.readUnsignedVarint();
                    int _size = _readable.readUnsignedVarint();
                    switch (_tag) {
                        default: 
                    }
                    this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
                }
            }
        }

        public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
            int _numTaggedFields = 0;
            _writable.writeInt(this.foo);
            _writable.writeInt(this.bar);
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            _numTaggedFields += _rawWriter.numFields();
            if (_version >= 1) {
                _writable.writeUnsignedVarint(_numTaggedFields);
                _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
            } else if (_numTaggedFields > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
        }

        public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version) {
            int _numTaggedFields = 0;
            _size.addBytes(4);
            _size.addBytes(4);
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_field.tag()));
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_field.size()));
                    _size.addBytes(_field.size());
                }
            }
            if (_version >= 1) {
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_numTaggedFields));
            } else if (_numTaggedFields > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof TestCommonStruct)) {
                return false;
            }
            TestCommonStruct other = (TestCommonStruct)obj;
            if (this.foo != other.foo) {
                return false;
            }
            if (this.bar != other.bar) {
                return false;
            }
            return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + this.foo;
            hashCode = 31 * hashCode + this.bar;
            return hashCode;
        }

        public TestCommonStruct duplicate() {
            TestCommonStruct _duplicate = new TestCommonStruct();
            _duplicate.foo = this.foo;
            _duplicate.bar = this.bar;
            return _duplicate;
        }

        public String toString() {
            return "TestCommonStruct(foo=" + this.foo + ", bar=" + this.bar + ")";
        }

        public int foo() {
            return this.foo;
        }

        public int bar() {
            return this.bar;
        }

        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public TestCommonStruct setFoo(int v) {
            this.foo = v;
            return this;
        }

        public TestCommonStruct setBar(int v) {
            this.bar = v;
            return this;
        }

        static {
            SCHEMA_2 = SCHEMA_1 = new Schema(new Field[]{new Field("foo", (Type)Type.INT32, ""), new Field("bar", (Type)Type.INT32, ""), Field.TaggedFieldsSection.of((Object[])new Object[0])});
            SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1, SCHEMA_2};
        }
    }

    public static class TaggedStruct
    implements Message {
        String structId;
        private List<RawTaggedField> _unknownTaggedFields;
        public static final Schema SCHEMA_2 = new Schema(new Field[]{new Field("struct_id", (Type)Type.COMPACT_STRING, "String field in struct"), Field.TaggedFieldsSection.of((Object[])new Object[0])});
        public static final Schema[] SCHEMAS = new Schema[]{null, null, SCHEMA_2};
        public static final short LOWEST_SUPPORTED_VERSION = 2;
        public static final short HIGHEST_SUPPORTED_VERSION = 2;

        public TaggedStruct(Readable _readable, short _version) {
            this.read(_readable, _version);
        }

        public TaggedStruct() {
            this.structId = "";
        }

        public short lowestSupportedVersion() {
            return 0;
        }

        public short highestSupportedVersion() {
            return 2;
        }

        public void read(Readable _readable, short _version) {
            if (_version > 2) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of TaggedStruct");
            }
            int length = _readable.readUnsignedVarint() - 1;
            if (length < 0) {
                throw new RuntimeException("non-nullable field structId was serialized as null");
            }
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field structId had invalid length " + length);
            }
            this.structId = _readable.readString(length);
            this._unknownTaggedFields = null;
            int _numTaggedFields = _readable.readUnsignedVarint();
            for (int _i = 0; _i < _numTaggedFields; ++_i) {
                int _tag = _readable.readUnsignedVarint();
                int _size = _readable.readUnsignedVarint();
                switch (_tag) {
                    default: 
                }
                this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
            }
        }

        public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
            if (_version < 2) {
                throw new UnsupportedVersionException("Can't write version " + _version + " of TaggedStruct");
            }
            int _numTaggedFields = 0;
            byte[] _stringBytes = _cache.getSerializedValue((Object)this.structId);
            _writable.writeUnsignedVarint(_stringBytes.length + 1);
            _writable.writeByteArray(_stringBytes);
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            _writable.writeUnsignedVarint(_numTaggedFields += _rawWriter.numFields());
            _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
        }

        public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version) {
            int _numTaggedFields = 0;
            if (_version > 2) {
                throw new UnsupportedVersionException("Can't size version " + _version + " of TaggedStruct");
            }
            byte[] _stringBytes = this.structId.getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'structId' field is too long to be serialized");
            }
            _cache.cacheSerializedValue((Object)this.structId, _stringBytes);
            _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint((int)(_stringBytes.length + 1)));
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_field.tag()));
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_field.size()));
                    _size.addBytes(_field.size());
                }
            }
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_numTaggedFields));
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof TaggedStruct)) {
                return false;
            }
            TaggedStruct other = (TaggedStruct)obj;
            if (this.structId == null ? other.structId != null : !this.structId.equals(other.structId)) {
                return false;
            }
            return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + (this.structId == null ? 0 : this.structId.hashCode());
            return hashCode;
        }

        public TaggedStruct duplicate() {
            TaggedStruct _duplicate = new TaggedStruct();
            _duplicate.structId = this.structId;
            return _duplicate;
        }

        public String toString() {
            return "TaggedStruct(structId=" + (this.structId == null ? "null" : "'" + this.structId.toString() + "'") + ")";
        }

        public String structId() {
            return this.structId;
        }

        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public TaggedStruct setStructId(String v) {
            this.structId = v;
            return this;
        }
    }

    public static class StructArray
    implements Message {
        int arrayFieldId;
        private List<RawTaggedField> _unknownTaggedFields;
        public static final Schema SCHEMA_2 = new Schema(new Field[]{new Field("array_field_id", (Type)Type.INT32, ""), Field.TaggedFieldsSection.of((Object[])new Object[0])});
        public static final Schema[] SCHEMAS = new Schema[]{null, null, SCHEMA_2};
        public static final short LOWEST_SUPPORTED_VERSION = 2;
        public static final short HIGHEST_SUPPORTED_VERSION = 2;

        public StructArray(Readable _readable, short _version) {
            this.read(_readable, _version);
        }

        public StructArray() {
            this.arrayFieldId = 0;
        }

        public short lowestSupportedVersion() {
            return 2;
        }

        public short highestSupportedVersion() {
            return 2;
        }

        public void read(Readable _readable, short _version) {
            if (_version > 2) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of StructArray");
            }
            this.arrayFieldId = _readable.readInt();
            this._unknownTaggedFields = null;
            int _numTaggedFields = _readable.readUnsignedVarint();
            for (int _i = 0; _i < _numTaggedFields; ++_i) {
                int _tag = _readable.readUnsignedVarint();
                int _size = _readable.readUnsignedVarint();
                switch (_tag) {
                    default: 
                }
                this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
            }
        }

        public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
            int _numTaggedFields = 0;
            _writable.writeInt(this.arrayFieldId);
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            _writable.writeUnsignedVarint(_numTaggedFields += _rawWriter.numFields());
            _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
        }

        public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version) {
            int _numTaggedFields = 0;
            if (_version > 2) {
                throw new UnsupportedVersionException("Can't size version " + _version + " of StructArray");
            }
            _size.addBytes(4);
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_field.tag()));
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_field.size()));
                    _size.addBytes(_field.size());
                }
            }
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_numTaggedFields));
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof StructArray)) {
                return false;
            }
            StructArray other = (StructArray)obj;
            if (this.arrayFieldId != other.arrayFieldId) {
                return false;
            }
            return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + this.arrayFieldId;
            return hashCode;
        }

        public StructArray duplicate() {
            StructArray _duplicate = new StructArray();
            _duplicate.arrayFieldId = this.arrayFieldId;
            return _duplicate;
        }

        public String toString() {
            return "StructArray(arrayFieldId=" + this.arrayFieldId + ")";
        }

        public int arrayFieldId() {
            return this.arrayFieldId;
        }

        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public StructArray setArrayFieldId(int v) {
            this.arrayFieldId = v;
            return this;
        }
    }

    public static class MyStruct
    implements Message {
        int structId;
        List<StructArray> arrayInStruct;
        private List<RawTaggedField> _unknownTaggedFields;
        public static final Schema SCHEMA_2 = new Schema(new Field[]{new Field("struct_id", (Type)Type.INT32, "Int field in struct"), new Field("array_in_struct", (Type)new CompactArrayOf((Type)StructArray.SCHEMA_2), ""), Field.TaggedFieldsSection.of((Object[])new Object[0])});
        public static final Schema[] SCHEMAS = new Schema[]{null, null, SCHEMA_2};
        public static final short LOWEST_SUPPORTED_VERSION = 2;
        public static final short HIGHEST_SUPPORTED_VERSION = 2;

        public MyStruct(Readable _readable, short _version) {
            this.read(_readable, _version);
        }

        public MyStruct() {
            this.structId = 0;
            this.arrayInStruct = new ArrayList<StructArray>(0);
        }

        public short lowestSupportedVersion() {
            return 0;
        }

        public short highestSupportedVersion() {
            return 2;
        }

        public void read(Readable _readable, short _version) {
            if (_version > 2) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of MyStruct");
            }
            this.structId = _readable.readInt();
            int arrayLength = _readable.readUnsignedVarint() - 1;
            if (arrayLength < 0) {
                throw new RuntimeException("non-nullable field arrayInStruct was serialized as null");
            }
            if (arrayLength > _readable.remaining()) {
                throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
            }
            ArrayList<StructArray> newCollection = new ArrayList<StructArray>(arrayLength);
            for (int i = 0; i < arrayLength; ++i) {
                newCollection.add(new StructArray(_readable, _version));
            }
            this.arrayInStruct = newCollection;
            this._unknownTaggedFields = null;
            int _numTaggedFields = _readable.readUnsignedVarint();
            for (int _i = 0; _i < _numTaggedFields; ++_i) {
                int _tag = _readable.readUnsignedVarint();
                int _size = _readable.readUnsignedVarint();
                switch (_tag) {
                    default: 
                }
                this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
            }
        }

        public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
            if (_version < 2) {
                throw new UnsupportedVersionException("Can't write version " + _version + " of MyStruct");
            }
            int _numTaggedFields = 0;
            _writable.writeInt(this.structId);
            _writable.writeUnsignedVarint(this.arrayInStruct.size() + 1);
            for (StructArray arrayInStructElement : this.arrayInStruct) {
                arrayInStructElement.write(_writable, _cache, _version);
            }
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            _writable.writeUnsignedVarint(_numTaggedFields += _rawWriter.numFields());
            _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
        }

        public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version) {
            int _numTaggedFields = 0;
            if (_version > 2) {
                throw new UnsupportedVersionException("Can't size version " + _version + " of MyStruct");
            }
            _size.addBytes(4);
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)(this.arrayInStruct.size() + 1)));
            for (StructArray arrayInStructElement : this.arrayInStruct) {
                arrayInStructElement.addSize(_size, _cache, _version);
            }
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_field.tag()));
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_field.size()));
                    _size.addBytes(_field.size());
                }
            }
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_numTaggedFields));
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof MyStruct)) {
                return false;
            }
            MyStruct other = (MyStruct)obj;
            if (this.structId != other.structId) {
                return false;
            }
            if (this.arrayInStruct == null ? other.arrayInStruct != null : !this.arrayInStruct.equals(other.arrayInStruct)) {
                return false;
            }
            return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + this.structId;
            hashCode = 31 * hashCode + (this.arrayInStruct == null ? 0 : this.arrayInStruct.hashCode());
            return hashCode;
        }

        public MyStruct duplicate() {
            MyStruct _duplicate = new MyStruct();
            _duplicate.structId = this.structId;
            ArrayList<StructArray> newArrayInStruct = new ArrayList<StructArray>(this.arrayInStruct.size());
            for (StructArray _element : this.arrayInStruct) {
                newArrayInStruct.add(_element.duplicate());
            }
            _duplicate.arrayInStruct = newArrayInStruct;
            return _duplicate;
        }

        public String toString() {
            return "MyStruct(structId=" + this.structId + ", arrayInStruct=" + MessageUtil.deepToString(this.arrayInStruct.iterator()) + ")";
        }

        public int structId() {
            return this.structId;
        }

        public List<StructArray> arrayInStruct() {
            return this.arrayInStruct;
        }

        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public MyStruct setStructId(int v) {
            this.structId = v;
            return this;
        }

        public MyStruct setArrayInStruct(List<StructArray> v) {
            this.arrayInStruct = v;
            return this;
        }
    }
}

