/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.security.authenticator;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.kafka.common.config.types.Password;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.security.JaasContext;
import org.apache.kafka.common.security.authenticator.DefaultLogin;
import org.apache.kafka.common.security.authenticator.LoginManager;
import org.apache.kafka.common.security.authenticator.TestDigestLoginModule;
import org.apache.kafka.common.security.authenticator.TestJaasConfig;
import org.apache.kafka.common.security.plain.PlainLoginModule;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class LoginManagerTest {
    private Password dynamicPlainContext;
    private Password dynamicDigestContext;

    @BeforeEach
    public void setUp() {
        this.dynamicPlainContext = new Password(PlainLoginModule.class.getName() + " required user=\"plainuser\" password=\"plain-secret\";");
        this.dynamicDigestContext = new Password(TestDigestLoginModule.class.getName() + " required user=\"digestuser\" password=\"digest-secret\";");
        TestJaasConfig.createConfiguration("SCRAM-SHA-256", Collections.singletonList("SCRAM-SHA-256"));
    }

    @AfterEach
    public void tearDown() {
        LoginManager.closeAll();
    }

    @Test
    public void testClientLoginManager() throws Exception {
        Map<String, Password> configs = Collections.singletonMap("sasl.jaas.config", this.dynamicPlainContext);
        JaasContext dynamicContext = JaasContext.loadClientContext(configs);
        JaasContext staticContext = JaasContext.loadClientContext(Collections.emptyMap());
        LoginManager dynamicLogin = LoginManager.acquireLoginManager((JaasContext)dynamicContext, (String)"PLAIN", DefaultLogin.class, configs);
        Assertions.assertEquals((Object)this.dynamicPlainContext, (Object)dynamicLogin.cacheKey());
        LoginManager staticLogin = LoginManager.acquireLoginManager((JaasContext)staticContext, (String)"SCRAM-SHA-256", DefaultLogin.class, configs);
        Assertions.assertNotSame((Object)dynamicLogin, (Object)staticLogin);
        Assertions.assertEquals((Object)"KafkaClient", (Object)staticLogin.cacheKey());
        Assertions.assertSame((Object)dynamicLogin, (Object)LoginManager.acquireLoginManager((JaasContext)dynamicContext, (String)"PLAIN", DefaultLogin.class, configs));
        Assertions.assertSame((Object)staticLogin, (Object)LoginManager.acquireLoginManager((JaasContext)staticContext, (String)"SCRAM-SHA-256", DefaultLogin.class, configs));
        this.verifyLoginManagerRelease(dynamicLogin, 2, dynamicContext, configs);
        this.verifyLoginManagerRelease(staticLogin, 2, staticContext, configs);
    }

    @Test
    public void testServerLoginManager() throws Exception {
        HashMap<String, Password> configs = new HashMap<String, Password>();
        configs.put("plain.sasl.jaas.config", this.dynamicPlainContext);
        configs.put("digest-md5.sasl.jaas.config", this.dynamicDigestContext);
        ListenerName listenerName = new ListenerName("listener1");
        JaasContext plainJaasContext = JaasContext.loadServerContext((ListenerName)listenerName, (String)"PLAIN", configs);
        JaasContext digestJaasContext = JaasContext.loadServerContext((ListenerName)listenerName, (String)"DIGEST-MD5", configs);
        JaasContext scramJaasContext = JaasContext.loadServerContext((ListenerName)listenerName, (String)"SCRAM-SHA-256", configs);
        LoginManager dynamicPlainLogin = LoginManager.acquireLoginManager((JaasContext)plainJaasContext, (String)"PLAIN", DefaultLogin.class, configs);
        Assertions.assertEquals((Object)this.dynamicPlainContext, (Object)dynamicPlainLogin.cacheKey());
        LoginManager dynamicDigestLogin = LoginManager.acquireLoginManager((JaasContext)digestJaasContext, (String)"DIGEST-MD5", DefaultLogin.class, configs);
        Assertions.assertNotSame((Object)dynamicPlainLogin, (Object)dynamicDigestLogin);
        Assertions.assertEquals((Object)this.dynamicDigestContext, (Object)dynamicDigestLogin.cacheKey());
        LoginManager staticScramLogin = LoginManager.acquireLoginManager((JaasContext)scramJaasContext, (String)"SCRAM-SHA-256", DefaultLogin.class, configs);
        Assertions.assertNotSame((Object)dynamicPlainLogin, (Object)staticScramLogin);
        Assertions.assertEquals((Object)"KafkaServer", (Object)staticScramLogin.cacheKey());
        Assertions.assertSame((Object)dynamicPlainLogin, (Object)LoginManager.acquireLoginManager((JaasContext)plainJaasContext, (String)"PLAIN", DefaultLogin.class, configs));
        Assertions.assertSame((Object)dynamicDigestLogin, (Object)LoginManager.acquireLoginManager((JaasContext)digestJaasContext, (String)"DIGEST-MD5", DefaultLogin.class, configs));
        Assertions.assertSame((Object)staticScramLogin, (Object)LoginManager.acquireLoginManager((JaasContext)scramJaasContext, (String)"SCRAM-SHA-256", DefaultLogin.class, configs));
        this.verifyLoginManagerRelease(dynamicPlainLogin, 2, plainJaasContext, configs);
        this.verifyLoginManagerRelease(dynamicDigestLogin, 2, digestJaasContext, configs);
        this.verifyLoginManagerRelease(staticScramLogin, 2, scramJaasContext, configs);
    }

    private void verifyLoginManagerRelease(LoginManager loginManager, int acquireCount, JaasContext jaasContext, Map<String, ?> configs) throws Exception {
        int i;
        for (i = 0; i < acquireCount - 1; ++i) {
            loginManager.release();
        }
        Assertions.assertSame((Object)loginManager, (Object)LoginManager.acquireLoginManager((JaasContext)jaasContext, (String)"PLAIN", DefaultLogin.class, configs));
        for (i = 0; i < 2; ++i) {
            loginManager.release();
        }
        LoginManager newLoginManager = LoginManager.acquireLoginManager((JaasContext)jaasContext, (String)"PLAIN", DefaultLogin.class, configs);
        Assertions.assertNotSame((Object)loginManager, (Object)newLoginManager);
        newLoginManager.release();
    }
}

