/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.feature;

import java.util.HashMap;
import java.util.Map;
import org.apache.kafka.common.feature.Features;
import org.apache.kafka.common.feature.FinalizedVersionRange;
import org.apache.kafka.common.feature.SupportedVersionRange;
import org.apache.kafka.common.utils.Utils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class FeaturesTest {
    @Test
    public void testEmptyFeatures() {
        HashMap emptyMap = new HashMap();
        Features emptyFinalizedFeatures = Features.emptyFinalizedFeatures();
        Assertions.assertTrue((boolean)emptyFinalizedFeatures.features().isEmpty());
        Assertions.assertTrue((boolean)emptyFinalizedFeatures.toMap().isEmpty());
        Assertions.assertEquals((Object)emptyFinalizedFeatures, (Object)Features.fromFinalizedFeaturesMap(emptyMap));
        Features emptySupportedFeatures = Features.emptySupportedFeatures();
        Assertions.assertTrue((boolean)emptySupportedFeatures.features().isEmpty());
        Assertions.assertTrue((boolean)emptySupportedFeatures.toMap().isEmpty());
        Assertions.assertEquals((Object)emptySupportedFeatures, (Object)Features.fromSupportedFeaturesMap(emptyMap));
    }

    @Test
    public void testNullFeatures() {
        Assertions.assertThrows(NullPointerException.class, () -> Features.finalizedFeatures(null));
        Assertions.assertThrows(NullPointerException.class, () -> Features.supportedFeatures(null));
    }

    @Test
    public void testGetAllFeaturesAPI() {
        SupportedVersionRange v1 = new SupportedVersionRange(1, 2);
        SupportedVersionRange v2 = new SupportedVersionRange(3, 4);
        Map allFeatures = Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)"feature_1", (Object)v1), Utils.mkEntry((Object)"feature_2", (Object)v2)});
        Features features = Features.supportedFeatures((Map)allFeatures);
        Assertions.assertEquals((Object)allFeatures, (Object)features.features());
    }

    @Test
    public void testGetAPI() {
        SupportedVersionRange v1 = new SupportedVersionRange(1, 2);
        SupportedVersionRange v2 = new SupportedVersionRange(3, 4);
        Map allFeatures = Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)"feature_1", (Object)v1), Utils.mkEntry((Object)"feature_2", (Object)v2)});
        Features features = Features.supportedFeatures((Map)allFeatures);
        Assertions.assertEquals((Object)v1, (Object)features.get("feature_1"));
        Assertions.assertEquals((Object)v2, (Object)features.get("feature_2"));
        Assertions.assertNull((Object)features.get("nonexistent_feature"));
    }

    @Test
    public void testFromFeaturesMapToFeaturesMap() {
        SupportedVersionRange v1 = new SupportedVersionRange(1, 2);
        SupportedVersionRange v2 = new SupportedVersionRange(3, 4);
        Map allFeatures = Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)"feature_1", (Object)v1), Utils.mkEntry((Object)"feature_2", (Object)v2)});
        Features features = Features.supportedFeatures((Map)allFeatures);
        Map expected = Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)"feature_1", (Object)Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)"min_version", (Object)1), Utils.mkEntry((Object)"max_version", (Object)2)})), Utils.mkEntry((Object)"feature_2", (Object)Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)"min_version", (Object)3), Utils.mkEntry((Object)"max_version", (Object)4)}))});
        Assertions.assertEquals((Object)expected, (Object)features.toMap());
        Assertions.assertEquals((Object)features, (Object)Features.fromSupportedFeaturesMap((Map)expected));
    }

    @Test
    public void testFromToFinalizedFeaturesMap() {
        FinalizedVersionRange v1 = new FinalizedVersionRange(1, 2);
        FinalizedVersionRange v2 = new FinalizedVersionRange(3, 4);
        Map allFeatures = Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)"feature_1", (Object)v1), Utils.mkEntry((Object)"feature_2", (Object)v2)});
        Features features = Features.finalizedFeatures((Map)allFeatures);
        Map expected = Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)"feature_1", (Object)Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)"min_version_level", (Object)1), Utils.mkEntry((Object)"max_version_level", (Object)2)})), Utils.mkEntry((Object)"feature_2", (Object)Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)"min_version_level", (Object)3), Utils.mkEntry((Object)"max_version_level", (Object)4)}))});
        Assertions.assertEquals((Object)expected, (Object)features.toMap());
        Assertions.assertEquals((Object)features, (Object)Features.fromFinalizedFeaturesMap((Map)expected));
    }

    @Test
    public void testToStringFinalizedFeatures() {
        FinalizedVersionRange v1 = new FinalizedVersionRange(1, 2);
        FinalizedVersionRange v2 = new FinalizedVersionRange(3, 4);
        Map allFeatures = Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)"feature_1", (Object)v1), Utils.mkEntry((Object)"feature_2", (Object)v2)});
        Features features = Features.finalizedFeatures((Map)allFeatures);
        Assertions.assertEquals((Object)"Features{(feature_1 -> FinalizedVersionRange[min_version_level:1, max_version_level:2]), (feature_2 -> FinalizedVersionRange[min_version_level:3, max_version_level:4])}", (Object)features.toString());
    }

    @Test
    public void testToStringSupportedFeatures() {
        SupportedVersionRange v1 = new SupportedVersionRange(1, 2);
        SupportedVersionRange v2 = new SupportedVersionRange(3, 4);
        Map allFeatures = Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)"feature_1", (Object)v1), Utils.mkEntry((Object)"feature_2", (Object)v2)});
        Features features = Features.supportedFeatures((Map)allFeatures);
        Assertions.assertEquals((Object)"Features{(feature_1 -> SupportedVersionRange[min_version:1, max_version:2]), (feature_2 -> SupportedVersionRange[min_version:3, max_version:4])}", (Object)features.toString());
    }

    @Test
    public void testSuppportedFeaturesFromMapFailureWithInvalidMissingMaxVersion() {
        Map invalidFeatures = Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)"feature_1", (Object)Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)"min_version", (Object)1)}))});
        Assertions.assertThrows(IllegalArgumentException.class, () -> Features.fromSupportedFeaturesMap((Map)invalidFeatures));
    }

    @Test
    public void testFinalizedFeaturesFromMapFailureWithInvalidMissingMaxVersionLevel() {
        Map invalidFeatures = Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)"feature_1", (Object)Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)"min_version_level", (Object)1)}))});
        Assertions.assertThrows(IllegalArgumentException.class, () -> Features.fromFinalizedFeaturesMap((Map)invalidFeatures));
    }

    @Test
    public void testEquals() {
        SupportedVersionRange v1 = new SupportedVersionRange(1, 2);
        Map allFeatures = Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)"feature_1", (Object)v1)});
        Features features = Features.supportedFeatures((Map)allFeatures);
        Features featuresClone = Features.supportedFeatures((Map)allFeatures);
        Assertions.assertTrue((boolean)features.equals((Object)featuresClone));
        SupportedVersionRange v2 = new SupportedVersionRange(1, 3);
        Map allFeaturesDifferent = Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)"feature_1", (Object)v2)});
        Features featuresDifferent = Features.supportedFeatures((Map)allFeaturesDifferent);
        Assertions.assertFalse((boolean)features.equals((Object)featuresDifferent));
        Assertions.assertFalse((boolean)features.equals(null));
    }
}

