/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.util.Collections;
import org.apache.kafka.common.errors.UnknownServerException;
import org.apache.kafka.common.message.UpdateFeaturesRequestData;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.UpdateFeaturesRequest;
import org.apache.kafka.common.requests.UpdateFeaturesResponse;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class UpdateFeaturesRequestTest {
    @Test
    public void testGetErrorResponse() {
        UpdateFeaturesRequestData.FeatureUpdateKeyCollection features = new UpdateFeaturesRequestData.FeatureUpdateKeyCollection();
        features.add(new UpdateFeaturesRequestData.FeatureUpdateKey().setFeature("foo").setMaxVersionLevel((short)2));
        features.add(new UpdateFeaturesRequestData.FeatureUpdateKey().setFeature("bar").setMaxVersionLevel((short)3));
        UpdateFeaturesRequest request = new UpdateFeaturesRequest(new UpdateFeaturesRequestData().setFeatureUpdates(features), 0);
        UpdateFeaturesResponse response = request.getErrorResponse(0, (Throwable)new UnknownServerException());
        Assertions.assertEquals((Object)Errors.UNKNOWN_SERVER_ERROR, (Object)response.topLevelError().error());
        Assertions.assertEquals((int)0, (int)response.data().results().size());
        Assertions.assertEquals(Collections.singletonMap(Errors.UNKNOWN_SERVER_ERROR, 1), (Object)response.errorCounts());
    }
}

