/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.utils;

import java.nio.ByteBuffer;
import java.util.zip.Checksum;
import org.apache.kafka.common.utils.Checksums;
import org.apache.kafka.common.utils.Crc32;
import org.apache.kafka.common.utils.Crc32C;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ChecksumsTest {
    @Test
    public void testUpdateByteBuffer() {
        byte[] bytes = new byte[]{0, 1, 2, 3, 4, 5};
        this.doTestUpdateByteBuffer(bytes, ByteBuffer.allocate(bytes.length));
        this.doTestUpdateByteBuffer(bytes, ByteBuffer.allocateDirect(bytes.length));
    }

    private void doTestUpdateByteBuffer(byte[] bytes, ByteBuffer buffer) {
        buffer.put(bytes);
        buffer.flip();
        Crc32 bufferCrc = new Crc32();
        Checksums.update((Checksum)bufferCrc, (ByteBuffer)buffer, (int)buffer.remaining());
        Assertions.assertEquals((long)Crc32.crc32((byte[])bytes), (long)bufferCrc.getValue());
        Assertions.assertEquals((int)0, (int)buffer.position());
    }

    @Test
    public void testUpdateByteBufferWithOffsetPosition() {
        byte[] bytes = new byte[]{-2, -1, 0, 1, 2, 3, 4, 5};
        this.doTestUpdateByteBufferWithOffsetPosition(bytes, ByteBuffer.allocate(bytes.length), 2);
        this.doTestUpdateByteBufferWithOffsetPosition(bytes, ByteBuffer.allocateDirect(bytes.length), 2);
    }

    @Test
    public void testUpdateInt() {
        int value = 1000;
        ByteBuffer buffer = ByteBuffer.allocate(4);
        buffer.putInt(1000);
        Checksum crc1 = Crc32C.create();
        Checksum crc2 = Crc32C.create();
        Checksums.updateInt((Checksum)crc1, (int)1000);
        crc2.update(buffer.array(), buffer.arrayOffset(), 4);
        Assertions.assertEquals((long)crc1.getValue(), (long)crc2.getValue(), (String)"Crc values should be the same");
    }

    @Test
    public void testUpdateLong() {
        long value = Integer.MIN_VALUE;
        ByteBuffer buffer = ByteBuffer.allocate(8);
        buffer.putLong(Integer.MIN_VALUE);
        Crc32 crc1 = new Crc32();
        Crc32 crc2 = new Crc32();
        Checksums.updateLong((Checksum)crc1, (long)Integer.MIN_VALUE);
        crc2.update(buffer.array(), buffer.arrayOffset(), 8);
        Assertions.assertEquals((long)crc1.getValue(), (long)crc2.getValue(), (String)"Crc values should be the same");
    }

    private void doTestUpdateByteBufferWithOffsetPosition(byte[] bytes, ByteBuffer buffer, int offset) {
        buffer.put(bytes);
        buffer.flip();
        buffer.position(offset);
        Checksum bufferCrc = Crc32C.create();
        Checksums.update((Checksum)bufferCrc, (ByteBuffer)buffer, (int)buffer.remaining());
        Assertions.assertEquals((long)Crc32C.compute((byte[])bytes, (int)offset, (int)buffer.remaining()), (long)bufferCrc.getValue());
        Assertions.assertEquals((int)offset, (int)buffer.position());
    }
}

