/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.OffsetFetchRequest;
import org.apache.kafka.common.requests.OffsetFetchResponse;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class OffsetFetchRequestTest {
    private final String topicOne = "topic1";
    private final int partitionOne = 1;
    private final String topicTwo = "topic2";
    private final int partitionTwo = 2;
    private final String groupId = "groupId";
    private OffsetFetchRequest.Builder builder;
    private List<TopicPartition> partitions;

    @BeforeEach
    public void setUp() {
        this.partitions = Arrays.asList(new TopicPartition("topic1", 1), new TopicPartition("topic2", 2));
        this.builder = new OffsetFetchRequest.Builder("groupId", false, this.partitions, false);
    }

    @Test
    public void testConstructor() {
        Assertions.assertFalse((boolean)this.builder.isAllTopicPartitions());
        int throttleTimeMs = 10;
        HashMap<TopicPartition, OffsetFetchResponse.PartitionData> expectedData = new HashMap<TopicPartition, OffsetFetchResponse.PartitionData>();
        for (TopicPartition partition : this.partitions) {
            expectedData.put(partition, new OffsetFetchResponse.PartitionData(-1L, Optional.empty(), "", Errors.NONE));
        }
        for (short version = 0; version <= ApiKeys.OFFSET_FETCH.latestVersion(); version = (short)(version + 1)) {
            OffsetFetchRequest request = this.builder.build(version);
            Assertions.assertFalse((boolean)request.isAllPartitions());
            Assertions.assertEquals((Object)"groupId", (Object)request.groupId());
            Assertions.assertEquals(this.partitions, (Object)request.partitions());
            OffsetFetchResponse response = request.getErrorResponse(throttleTimeMs, Errors.NONE);
            Assertions.assertEquals((Object)Errors.NONE, (Object)response.error());
            Assertions.assertFalse((boolean)response.hasError());
            Assertions.assertEquals(Collections.singletonMap(Errors.NONE, version <= 1 ? 3 : 1), (Object)response.errorCounts(), (String)("Incorrect error count for version " + version));
            if (version <= 1) {
                Assertions.assertEquals(expectedData, (Object)response.responseData());
            }
            if (version >= 3) {
                Assertions.assertEquals((int)throttleTimeMs, (int)response.throttleTimeMs());
                continue;
            }
            Assertions.assertEquals((int)0, (int)response.throttleTimeMs());
        }
    }

    @Test
    public void testConstructorFailForUnsupportedRequireStable() {
        for (short version = 0; version <= ApiKeys.OFFSET_FETCH.latestVersion(); version = (short)(version + 1)) {
            this.builder = new OffsetFetchRequest.Builder("groupId", true, null, false);
            short finalVersion = version;
            if (version < 2) {
                Assertions.assertThrows(UnsupportedVersionException.class, () -> this.builder.build(finalVersion));
                continue;
            }
            OffsetFetchRequest request = this.builder.build(finalVersion);
            Assertions.assertEquals((Object)"groupId", (Object)request.groupId());
            Assertions.assertNull((Object)request.partitions());
            Assertions.assertTrue((boolean)request.isAllPartitions());
            if (version < 7) {
                Assertions.assertFalse((boolean)request.requireStable());
                continue;
            }
            Assertions.assertTrue((boolean)request.requireStable());
        }
    }

    @Test
    public void testBuildThrowForUnsupportedRequireStable() {
        for (short version = 0; version <= ApiKeys.OFFSET_FETCH.latestVersion(); version = (short)(version + 1)) {
            this.builder = new OffsetFetchRequest.Builder("groupId", true, null, true);
            if (version < 7) {
                short finalVersion = version;
                Assertions.assertThrows(UnsupportedVersionException.class, () -> this.builder.build(finalVersion));
                continue;
            }
            OffsetFetchRequest request = this.builder.build(version);
            Assertions.assertTrue((boolean)request.requireStable());
        }
    }
}

