/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.util.ArrayList;
import java.util.Collections;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AddPartitionsToTxnRequest;
import org.apache.kafka.common.requests.AddPartitionsToTxnResponse;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class AddPartitionsToTxnRequestTest {
    private static String transactionalId = "transactionalId";
    private static int producerId = 10;
    private static short producerEpoch = 1;
    private static int throttleTimeMs = 10;

    @Test
    public void testConstructor() {
        ArrayList<TopicPartition> partitions = new ArrayList<TopicPartition>();
        partitions.add(new TopicPartition("topic", 0));
        partitions.add(new TopicPartition("topic", 1));
        AddPartitionsToTxnRequest.Builder builder = new AddPartitionsToTxnRequest.Builder(transactionalId, (long)producerId, producerEpoch, partitions);
        for (short version = 0; version <= ApiKeys.ADD_PARTITIONS_TO_TXN.latestVersion(); version = (short)(version + 1)) {
            AddPartitionsToTxnRequest request = builder.build(version);
            Assertions.assertEquals((Object)transactionalId, (Object)request.data().transactionalId());
            Assertions.assertEquals((long)producerId, (long)request.data().producerId());
            Assertions.assertEquals((short)producerEpoch, (short)request.data().producerEpoch());
            Assertions.assertEquals(partitions, (Object)request.partitions());
            AddPartitionsToTxnResponse response = request.getErrorResponse(throttleTimeMs, (Throwable)Errors.UNKNOWN_TOPIC_OR_PARTITION.exception());
            Assertions.assertEquals(Collections.singletonMap(Errors.UNKNOWN_TOPIC_OR_PARTITION, 2), (Object)response.errorCounts());
            Assertions.assertEquals((int)throttleTimeMs, (int)response.throttleTimeMs());
        }
    }
}

