/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.internals;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.internals.PartitionStates;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class PartitionStatesTest {
    @Test
    public void testSet() {
        PartitionStates states = new PartitionStates();
        LinkedHashMap<TopicPartition, String> map = this.createMap();
        states.set(map);
        LinkedHashMap<TopicPartition, String> expected = new LinkedHashMap<TopicPartition, String>();
        expected.put(new TopicPartition("foo", 2), "foo 2");
        expected.put(new TopicPartition("foo", 0), "foo 0");
        expected.put(new TopicPartition("blah", 2), "blah 2");
        expected.put(new TopicPartition("blah", 1), "blah 1");
        expected.put(new TopicPartition("baz", 2), "baz 2");
        expected.put(new TopicPartition("baz", 3), "baz 3");
        this.checkState((PartitionStates<String>)states, expected);
        states.set(new LinkedHashMap());
        this.checkState((PartitionStates<String>)states, new LinkedHashMap<TopicPartition, String>());
    }

    private LinkedHashMap<TopicPartition, String> createMap() {
        LinkedHashMap<TopicPartition, String> map = new LinkedHashMap<TopicPartition, String>();
        map.put(new TopicPartition("foo", 2), "foo 2");
        map.put(new TopicPartition("blah", 2), "blah 2");
        map.put(new TopicPartition("blah", 1), "blah 1");
        map.put(new TopicPartition("baz", 2), "baz 2");
        map.put(new TopicPartition("foo", 0), "foo 0");
        map.put(new TopicPartition("baz", 3), "baz 3");
        return map;
    }

    private void checkState(PartitionStates<String> states, LinkedHashMap<TopicPartition, String> expected) {
        Assertions.assertEquals(expected.keySet(), (Object)states.partitionSet());
        Assertions.assertEquals((int)expected.size(), (int)states.size());
        Assertions.assertEquals(expected, (Object)states.partitionStateMap());
    }

    @Test
    public void testMoveToEnd() {
        PartitionStates states = new PartitionStates();
        LinkedHashMap<TopicPartition, String> map = this.createMap();
        states.set(map);
        states.moveToEnd(new TopicPartition("baz", 2));
        LinkedHashMap<Object, String> expected = new LinkedHashMap<TopicPartition, String>();
        expected.put(new TopicPartition("foo", 2), "foo 2");
        expected.put(new TopicPartition("foo", 0), "foo 0");
        expected.put(new TopicPartition("blah", 2), "blah 2");
        expected.put(new TopicPartition("blah", 1), "blah 1");
        expected.put(new TopicPartition("baz", 3), "baz 3");
        expected.put(new TopicPartition("baz", 2), "baz 2");
        this.checkState((PartitionStates<String>)states, expected);
        states.moveToEnd(new TopicPartition("foo", 2));
        expected = new LinkedHashMap();
        expected.put(new TopicPartition("foo", 0), "foo 0");
        expected.put(new TopicPartition("blah", 2), "blah 2");
        expected.put(new TopicPartition("blah", 1), "blah 1");
        expected.put(new TopicPartition("baz", 3), "baz 3");
        expected.put(new TopicPartition("baz", 2), "baz 2");
        expected.put(new TopicPartition("foo", 2), "foo 2");
        this.checkState((PartitionStates<String>)states, expected);
        states.moveToEnd(new TopicPartition("foo", 2));
        this.checkState((PartitionStates<String>)states, expected);
        states.moveToEnd(new TopicPartition("baz", 5));
        this.checkState((PartitionStates<String>)states, expected);
        states.moveToEnd(new TopicPartition("aaa", 2));
        this.checkState((PartitionStates<String>)states, expected);
    }

    @Test
    public void testUpdateAndMoveToEnd() {
        PartitionStates states = new PartitionStates();
        LinkedHashMap<TopicPartition, String> map = this.createMap();
        states.set(map);
        states.updateAndMoveToEnd(new TopicPartition("foo", 0), (Object)"foo 0 updated");
        LinkedHashMap<Object, String> expected = new LinkedHashMap<TopicPartition, String>();
        expected.put(new TopicPartition("foo", 2), "foo 2");
        expected.put(new TopicPartition("blah", 2), "blah 2");
        expected.put(new TopicPartition("blah", 1), "blah 1");
        expected.put(new TopicPartition("baz", 2), "baz 2");
        expected.put(new TopicPartition("baz", 3), "baz 3");
        expected.put(new TopicPartition("foo", 0), "foo 0 updated");
        this.checkState((PartitionStates<String>)states, expected);
        states.updateAndMoveToEnd(new TopicPartition("baz", 2), (Object)"baz 2 updated");
        expected = new LinkedHashMap();
        expected.put(new TopicPartition("foo", 2), "foo 2");
        expected.put(new TopicPartition("blah", 2), "blah 2");
        expected.put(new TopicPartition("blah", 1), "blah 1");
        expected.put(new TopicPartition("baz", 3), "baz 3");
        expected.put(new TopicPartition("foo", 0), "foo 0 updated");
        expected.put(new TopicPartition("baz", 2), "baz 2 updated");
        this.checkState((PartitionStates<String>)states, expected);
        states.updateAndMoveToEnd(new TopicPartition("baz", 5), (Object)"baz 5 new");
        expected = new LinkedHashMap();
        expected.put(new TopicPartition("foo", 2), "foo 2");
        expected.put(new TopicPartition("blah", 2), "blah 2");
        expected.put(new TopicPartition("blah", 1), "blah 1");
        expected.put(new TopicPartition("baz", 3), "baz 3");
        expected.put(new TopicPartition("foo", 0), "foo 0 updated");
        expected.put(new TopicPartition("baz", 2), "baz 2 updated");
        expected.put(new TopicPartition("baz", 5), "baz 5 new");
        this.checkState((PartitionStates<String>)states, expected);
        states.updateAndMoveToEnd(new TopicPartition("aaa", 2), (Object)"aaa 2 new");
        expected = new LinkedHashMap();
        expected.put(new TopicPartition("foo", 2), "foo 2");
        expected.put(new TopicPartition("blah", 2), "blah 2");
        expected.put(new TopicPartition("blah", 1), "blah 1");
        expected.put(new TopicPartition("baz", 3), "baz 3");
        expected.put(new TopicPartition("foo", 0), "foo 0 updated");
        expected.put(new TopicPartition("baz", 2), "baz 2 updated");
        expected.put(new TopicPartition("baz", 5), "baz 5 new");
        expected.put(new TopicPartition("aaa", 2), "aaa 2 new");
        this.checkState((PartitionStates<String>)states, expected);
    }

    @Test
    public void testPartitionValues() {
        PartitionStates states = new PartitionStates();
        LinkedHashMap<TopicPartition, String> map = this.createMap();
        states.set(map);
        ArrayList<String> expected = new ArrayList<String>();
        expected.add("foo 2");
        expected.add("foo 0");
        expected.add("blah 2");
        expected.add("blah 1");
        expected.add("baz 2");
        expected.add("baz 3");
        Assertions.assertEquals(expected, (Object)states.partitionStateValues());
    }

    @Test
    public void testClear() {
        PartitionStates states = new PartitionStates();
        LinkedHashMap<TopicPartition, String> map = this.createMap();
        states.set(map);
        states.clear();
        this.checkState((PartitionStates<String>)states, new LinkedHashMap<TopicPartition, String>());
    }

    @Test
    public void testRemove() {
        PartitionStates states = new PartitionStates();
        LinkedHashMap<TopicPartition, String> map = this.createMap();
        states.set(map);
        states.remove(new TopicPartition("foo", 2));
        LinkedHashMap<Object, String> expected = new LinkedHashMap<TopicPartition, String>();
        expected.put(new TopicPartition("foo", 0), "foo 0");
        expected.put(new TopicPartition("blah", 2), "blah 2");
        expected.put(new TopicPartition("blah", 1), "blah 1");
        expected.put(new TopicPartition("baz", 2), "baz 2");
        expected.put(new TopicPartition("baz", 3), "baz 3");
        this.checkState((PartitionStates<String>)states, expected);
        states.remove(new TopicPartition("blah", 1));
        expected = new LinkedHashMap();
        expected.put(new TopicPartition("foo", 0), "foo 0");
        expected.put(new TopicPartition("blah", 2), "blah 2");
        expected.put(new TopicPartition("baz", 2), "baz 2");
        expected.put(new TopicPartition("baz", 3), "baz 3");
        this.checkState((PartitionStates<String>)states, expected);
        states.remove(new TopicPartition("baz", 3));
        expected = new LinkedHashMap();
        expected.put(new TopicPartition("foo", 0), "foo 0");
        expected.put(new TopicPartition("blah", 2), "blah 2");
        expected.put(new TopicPartition("baz", 2), "baz 2");
        this.checkState((PartitionStates<String>)states, expected);
    }
}

