/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.consumer;

import java.time.Duration;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import org.apache.kafka.clients.consumer.ConsumerGroupMetadata;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.consumer.MockConsumer;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.clients.consumer.OffsetResetStrategy;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.record.TimestampType;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class MockConsumerTest {
    private final MockConsumer<String, String> consumer = new MockConsumer(OffsetResetStrategy.EARLIEST);

    @Test
    public void testSimpleMock() {
        this.consumer.subscribe(Collections.singleton("test"));
        Assertions.assertEquals((int)0, (int)this.consumer.poll(Duration.ZERO).count());
        this.consumer.rebalance(Arrays.asList(new TopicPartition("test", 0), new TopicPartition("test", 1)));
        HashMap<TopicPartition, Long> beginningOffsets = new HashMap<TopicPartition, Long>();
        beginningOffsets.put(new TopicPartition("test", 0), 0L);
        beginningOffsets.put(new TopicPartition("test", 1), 0L);
        this.consumer.updateBeginningOffsets(beginningOffsets);
        this.consumer.seek(new TopicPartition("test", 0), 0L);
        ConsumerRecord rec1 = new ConsumerRecord("test", 0, 0L, 0L, TimestampType.CREATE_TIME, 0L, 0, 0, (Object)"key1", (Object)"value1");
        ConsumerRecord rec2 = new ConsumerRecord("test", 0, 1L, 0L, TimestampType.CREATE_TIME, 0L, 0, 0, (Object)"key2", (Object)"value2");
        this.consumer.addRecord(rec1);
        this.consumer.addRecord(rec2);
        ConsumerRecords recs = this.consumer.poll(Duration.ofMillis(1L));
        Iterator iter = recs.iterator();
        Assertions.assertEquals((Object)rec1, iter.next());
        Assertions.assertEquals((Object)rec2, iter.next());
        Assertions.assertFalse((boolean)iter.hasNext());
        TopicPartition tp = new TopicPartition("test", 0);
        Assertions.assertEquals((long)2L, (long)this.consumer.position(tp));
        this.consumer.commitSync();
        Assertions.assertEquals((long)2L, (long)((OffsetAndMetadata)this.consumer.committed(Collections.singleton(tp)).get(tp)).offset());
    }

    @Test
    public void testSimpleMockDeprecated() {
        this.consumer.subscribe(Collections.singleton("test"));
        Assertions.assertEquals((int)0, (int)this.consumer.poll(1000L).count());
        this.consumer.rebalance(Arrays.asList(new TopicPartition("test", 0), new TopicPartition("test", 1)));
        HashMap<TopicPartition, Long> beginningOffsets = new HashMap<TopicPartition, Long>();
        beginningOffsets.put(new TopicPartition("test", 0), 0L);
        beginningOffsets.put(new TopicPartition("test", 1), 0L);
        this.consumer.updateBeginningOffsets(beginningOffsets);
        this.consumer.seek(new TopicPartition("test", 0), 0L);
        ConsumerRecord rec1 = new ConsumerRecord("test", 0, 0L, 0L, TimestampType.CREATE_TIME, 0L, 0, 0, (Object)"key1", (Object)"value1");
        ConsumerRecord rec2 = new ConsumerRecord("test", 0, 1L, 0L, TimestampType.CREATE_TIME, 0L, 0, 0, (Object)"key2", (Object)"value2");
        this.consumer.addRecord(rec1);
        this.consumer.addRecord(rec2);
        ConsumerRecords recs = this.consumer.poll(1L);
        Iterator iter = recs.iterator();
        Assertions.assertEquals((Object)rec1, iter.next());
        Assertions.assertEquals((Object)rec2, iter.next());
        Assertions.assertFalse((boolean)iter.hasNext());
        TopicPartition tp = new TopicPartition("test", 0);
        Assertions.assertEquals((long)2L, (long)this.consumer.position(tp));
        this.consumer.commitSync();
        Assertions.assertEquals((long)2L, (long)((OffsetAndMetadata)this.consumer.committed(Collections.singleton(tp)).get(tp)).offset());
        Assertions.assertEquals((Object)new ConsumerGroupMetadata("dummy.group.id", 1, "1", Optional.empty()), (Object)this.consumer.groupMetadata());
    }

    @Test
    public void testConsumerRecordsIsEmptyWhenReturningNoRecords() {
        TopicPartition partition = new TopicPartition("test", 0);
        this.consumer.assign(Collections.singleton(partition));
        this.consumer.addRecord(new ConsumerRecord("test", 0, 0L, null, null));
        this.consumer.updateEndOffsets(Collections.singletonMap(partition, 1L));
        this.consumer.seekToEnd(Collections.singleton(partition));
        ConsumerRecords records = this.consumer.poll(Duration.ofMillis(1L));
        Assertions.assertEquals((int)0, (int)records.count());
        Assertions.assertTrue((boolean)records.isEmpty());
    }

    @Test
    public void shouldNotClearRecordsForPausedPartitions() {
        TopicPartition partition0 = new TopicPartition("test", 0);
        List<TopicPartition> testPartitionList = Collections.singletonList(partition0);
        this.consumer.assign(testPartitionList);
        this.consumer.addRecord(new ConsumerRecord("test", 0, 0L, null, null));
        this.consumer.updateBeginningOffsets(Collections.singletonMap(partition0, 0L));
        this.consumer.seekToBeginning(testPartitionList);
        this.consumer.pause(testPartitionList);
        this.consumer.poll(Duration.ofMillis(1L));
        this.consumer.resume(testPartitionList);
        ConsumerRecords recordsSecondPoll = this.consumer.poll(Duration.ofMillis(1L));
        Assertions.assertEquals((int)1, (int)recordsSecondPoll.count());
    }

    @Test
    public void endOffsetsShouldBeIdempotent() {
        TopicPartition partition = new TopicPartition("test", 0);
        this.consumer.updateEndOffsets(Collections.singletonMap(partition, 10L));
        Assertions.assertEquals((long)10L, (long)((Long)this.consumer.endOffsets(Collections.singleton(partition)).get(partition)));
        Assertions.assertEquals((long)10L, (long)((Long)this.consumer.endOffsets(Collections.singleton(partition)).get(partition)));
        Assertions.assertEquals((long)10L, (long)((Long)this.consumer.endOffsets(Collections.singleton(partition)).get(partition)));
        this.consumer.updateEndOffsets(Collections.singletonMap(partition, 11L));
        Assertions.assertEquals((long)11L, (long)((Long)this.consumer.endOffsets(Collections.singleton(partition)).get(partition)));
        Assertions.assertEquals((long)11L, (long)((Long)this.consumer.endOffsets(Collections.singleton(partition)).get(partition)));
        Assertions.assertEquals((long)11L, (long)((Long)this.consumer.endOffsets(Collections.singleton(partition)).get(partition)));
    }
}

