/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.consumer;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.record.TimestampType;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ConsumerRecordsTest {
    @Test
    public void iterator() throws Exception {
        LinkedHashMap<TopicPartition, List<Object>> records = new LinkedHashMap<TopicPartition, List<Object>>();
        String topic = "topic";
        records.put(new TopicPartition(topic, 0), new ArrayList());
        ConsumerRecord record1 = new ConsumerRecord(topic, 1, 0L, 0L, TimestampType.CREATE_TIME, 0L, 0, 0, (Object)1, (Object)"value1");
        ConsumerRecord record2 = new ConsumerRecord(topic, 1, 1L, 0L, TimestampType.CREATE_TIME, 0L, 0, 0, (Object)2, (Object)"value2");
        records.put(new TopicPartition(topic, 1), Arrays.asList(record1, record2));
        records.put(new TopicPartition(topic, 2), new ArrayList());
        ConsumerRecords consumerRecords = new ConsumerRecords(records);
        Iterator iter = consumerRecords.iterator();
        int c = 0;
        while (iter.hasNext()) {
            ConsumerRecord record = (ConsumerRecord)iter.next();
            Assertions.assertEquals((int)1, (int)record.partition());
            Assertions.assertEquals((Object)topic, (Object)record.topic());
            Assertions.assertEquals((long)c, (long)record.offset());
            ++c;
        }
        Assertions.assertEquals((int)2, (int)c);
    }
}

