/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.utils;

import java.io.IOException;
import org.apache.kafka.common.utils.OperatingSystem;
import org.apache.kafka.common.utils.Shell;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.Timeout;

public class ShellTest {
    @Rule
    public final Timeout globalTimeout = Timeout.seconds((long)180L);
    private static final String NONEXISTENT_PATH = "/dev/a/path/that/does/not/exist/in/the/filesystem";

    @Test
    public void testEchoHello() throws Exception {
        Assume.assumeTrue((!OperatingSystem.IS_WINDOWS ? 1 : 0) != 0);
        String output = Shell.execCommand((String[])new String[]{"echo", "hello"});
        Assert.assertEquals((Object)"hello\n", (Object)output);
    }

    @Test
    public void testHeadDevZero() throws Exception {
        Assume.assumeTrue((!OperatingSystem.IS_WINDOWS ? 1 : 0) != 0);
        int length = 100000;
        String output = Shell.execCommand((String[])new String[]{"head", "-c", Integer.toString(100000), "/dev/zero"});
        Assert.assertEquals((long)100000L, (long)output.length());
    }

    @Test
    public void testAttemptToRunNonExistentProgram() {
        Assume.assumeTrue((!OperatingSystem.IS_WINDOWS ? 1 : 0) != 0);
        try {
            Shell.execCommand((String[])new String[]{NONEXISTENT_PATH});
            Assert.fail((String)"Expected to get an exception when trying to run a program that does not exist");
        }
        catch (IOException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("No such file"));
        }
    }

    @Test
    public void testRunProgramWithErrorReturn() throws Exception {
        Assume.assumeTrue((!OperatingSystem.IS_WINDOWS ? 1 : 0) != 0);
        try {
            Shell.execCommand((String[])new String[]{"head", "-c", "0", NONEXISTENT_PATH});
            Assert.fail((String)"Expected to get an exception when trying to head a nonexistent file");
        }
        catch (Shell.ExitCodeException e) {
            String message = e.getMessage();
            Assert.assertTrue((String)("Unexpected error message '" + message + "'"), (message.contains("No such file") || message.contains("illegal byte count") ? 1 : 0) != 0);
        }
    }
}

