/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Random;
import java.util.Set;
import org.apache.kafka.common.utils.ImplicitLinkedHashCollection;
import org.apache.kafka.common.utils.ImplicitLinkedHashMultiCollection;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.Timeout;

public class ImplicitLinkedHashCollectionTest {
    @Rule
    public final Timeout globalTimeout = Timeout.millis((long)120000L);

    @Test
    public void testNullForbidden() {
        ImplicitLinkedHashMultiCollection multiColl = new ImplicitLinkedHashMultiCollection();
        Assert.assertFalse((boolean)multiColl.add(null));
    }

    @Test
    public void testInsertDelete() {
        ImplicitLinkedHashCollection coll = new ImplicitLinkedHashCollection(100);
        Assert.assertTrue((boolean)coll.add((ImplicitLinkedHashCollection.Element)new TestElement(1)));
        TestElement second = new TestElement(2);
        Assert.assertTrue((boolean)coll.add((ImplicitLinkedHashCollection.Element)second));
        Assert.assertTrue((boolean)coll.add((ImplicitLinkedHashCollection.Element)new TestElement(3)));
        Assert.assertFalse((boolean)coll.add((ImplicitLinkedHashCollection.Element)new TestElement(3)));
        Assert.assertEquals((long)3L, (long)coll.size());
        Assert.assertTrue((boolean)coll.contains((Object)new TestElement(1)));
        Assert.assertFalse((boolean)coll.contains((Object)new TestElement(4)));
        TestElement secondAgain = (TestElement)coll.find((ImplicitLinkedHashCollection.Element)new TestElement(2));
        Assert.assertTrue((second == secondAgain ? 1 : 0) != 0);
        Assert.assertTrue((boolean)coll.remove((Object)new TestElement(1)));
        Assert.assertFalse((boolean)coll.remove((Object)new TestElement(1)));
        Assert.assertEquals((long)2L, (long)coll.size());
        coll.clear();
        Assert.assertEquals((long)0L, (long)coll.size());
    }

    static void expectTraversal(Iterator<TestElement> iterator, Integer ... sequence) {
        int i = 0;
        while (iterator.hasNext()) {
            TestElement element = iterator.next();
            Assert.assertTrue((String)("Iterator yieled " + (i + 1) + " elements, but only " + sequence.length + " were expected."), (i < sequence.length ? 1 : 0) != 0);
            Assert.assertEquals((String)("Iterator value number " + (i + 1) + " was incorrect."), (long)sequence[i].intValue(), (long)element.key);
            ++i;
        }
        Assert.assertTrue((String)("Iterator yieled " + (i + 1) + " elements, but " + sequence.length + " were expected."), (i == sequence.length ? 1 : 0) != 0);
    }

    static void expectTraversal(Iterator<TestElement> iter, Iterator<Integer> expectedIter) {
        int i = 0;
        while (iter.hasNext()) {
            TestElement element = iter.next();
            Assert.assertTrue((String)("Iterator yieled " + (i + 1) + " elements, but only " + i + " were expected."), (boolean)expectedIter.hasNext());
            Integer expected = expectedIter.next();
            Assert.assertEquals((String)("Iterator value number " + (i + 1) + " was incorrect."), (long)expected.intValue(), (long)element.key);
            ++i;
        }
        Assert.assertFalse((String)("Iterator yieled " + i + " elements, but at least " + (i + 1) + " were expected."), (boolean)expectedIter.hasNext());
    }

    @Test
    public void testTraversal() {
        ImplicitLinkedHashCollection coll = new ImplicitLinkedHashCollection();
        ImplicitLinkedHashCollectionTest.expectTraversal((Iterator<TestElement>)coll.iterator(), new Integer[0]);
        Assert.assertTrue((boolean)coll.add((ImplicitLinkedHashCollection.Element)new TestElement(2)));
        ImplicitLinkedHashCollectionTest.expectTraversal((Iterator<TestElement>)coll.iterator(), 2);
        Assert.assertTrue((boolean)coll.add((ImplicitLinkedHashCollection.Element)new TestElement(1)));
        ImplicitLinkedHashCollectionTest.expectTraversal((Iterator<TestElement>)coll.iterator(), 2, 1);
        Assert.assertTrue((boolean)coll.add((ImplicitLinkedHashCollection.Element)new TestElement(100)));
        ImplicitLinkedHashCollectionTest.expectTraversal((Iterator<TestElement>)coll.iterator(), 2, 1, 100);
        Assert.assertTrue((boolean)coll.remove((Object)new TestElement(1)));
        ImplicitLinkedHashCollectionTest.expectTraversal((Iterator<TestElement>)coll.iterator(), 2, 100);
        Assert.assertTrue((boolean)coll.add((ImplicitLinkedHashCollection.Element)new TestElement(1)));
        ImplicitLinkedHashCollectionTest.expectTraversal((Iterator<TestElement>)coll.iterator(), 2, 100, 1);
        Iterator iter = coll.iterator();
        iter.next();
        iter.next();
        iter.remove();
        iter.next();
        Assert.assertFalse((boolean)iter.hasNext());
        ImplicitLinkedHashCollectionTest.expectTraversal((Iterator<TestElement>)coll.iterator(), 2, 1);
        ArrayList<TestElement> list = new ArrayList<TestElement>();
        list.add(new TestElement(1));
        list.add(new TestElement(2));
        Assert.assertTrue((boolean)coll.removeAll(list));
        Assert.assertFalse((boolean)coll.removeAll(list));
        ImplicitLinkedHashCollectionTest.expectTraversal((Iterator<TestElement>)coll.iterator(), new Integer[0]);
        Assert.assertEquals((long)0L, (long)coll.size());
        Assert.assertTrue((boolean)coll.isEmpty());
    }

    @Test
    public void testSetViewGet() {
        ImplicitLinkedHashCollection coll = new ImplicitLinkedHashCollection();
        coll.add((ImplicitLinkedHashCollection.Element)new TestElement(1));
        coll.add((ImplicitLinkedHashCollection.Element)new TestElement(2));
        coll.add((ImplicitLinkedHashCollection.Element)new TestElement(3));
        Set set = coll.valuesSet();
        Assert.assertTrue((boolean)set.contains(new TestElement(1)));
        Assert.assertTrue((boolean)set.contains(new TestElement(2)));
        Assert.assertTrue((boolean)set.contains(new TestElement(3)));
        Assert.assertEquals((long)3L, (long)set.size());
    }

    @Test
    public void testSetViewModification() {
        ImplicitLinkedHashCollection coll = new ImplicitLinkedHashCollection();
        coll.add((ImplicitLinkedHashCollection.Element)new TestElement(1));
        coll.add((ImplicitLinkedHashCollection.Element)new TestElement(2));
        coll.add((ImplicitLinkedHashCollection.Element)new TestElement(3));
        Set set = coll.valuesSet();
        set.remove(new TestElement(1));
        Assert.assertFalse((boolean)coll.contains((Object)new TestElement(1)));
        Assert.assertEquals((long)2L, (long)coll.size());
        set.add(new TestElement(4));
        Assert.assertTrue((boolean)coll.contains((Object)new TestElement(4)));
        Assert.assertEquals((long)3L, (long)coll.size());
        coll.remove((Object)new TestElement(2));
        Assert.assertFalse((boolean)set.contains(new TestElement(2)));
        Assert.assertEquals((long)2L, (long)set.size());
        coll.add((ImplicitLinkedHashCollection.Element)new TestElement(5));
        Assert.assertTrue((boolean)set.contains(new TestElement(5)));
        Assert.assertEquals((long)3L, (long)set.size());
        int key = 3;
        for (TestElement e : coll) {
            Assert.assertEquals((long)key, (long)e.key);
            ++key;
        }
    }

    @Test
    public void testListViewGet() {
        ImplicitLinkedHashCollection coll = new ImplicitLinkedHashCollection();
        coll.add((ImplicitLinkedHashCollection.Element)new TestElement(1));
        coll.add((ImplicitLinkedHashCollection.Element)new TestElement(2));
        coll.add((ImplicitLinkedHashCollection.Element)new TestElement(3));
        List list = coll.valuesList();
        Assert.assertEquals((long)1L, (long)((TestElement)list.get(0)).key);
        Assert.assertEquals((long)2L, (long)((TestElement)list.get(1)).key);
        Assert.assertEquals((long)3L, (long)((TestElement)list.get(2)).key);
        Assert.assertEquals((long)3L, (long)list.size());
    }

    @Test
    public void testListViewModification() {
        ImplicitLinkedHashCollection coll = new ImplicitLinkedHashCollection();
        coll.add((ImplicitLinkedHashCollection.Element)new TestElement(1));
        coll.add((ImplicitLinkedHashCollection.Element)new TestElement(2));
        coll.add((ImplicitLinkedHashCollection.Element)new TestElement(3));
        List list = coll.valuesList();
        list.remove(1);
        Assert.assertTrue((boolean)coll.contains((Object)new TestElement(1)));
        Assert.assertFalse((boolean)coll.contains((Object)new TestElement(2)));
        Assert.assertTrue((boolean)coll.contains((Object)new TestElement(3)));
        Assert.assertEquals((long)2L, (long)coll.size());
        coll.remove((Object)new TestElement(1));
        Assert.assertEquals((long)3L, (long)((TestElement)list.get(0)).key);
        Assert.assertEquals((long)1L, (long)list.size());
        coll.add((ImplicitLinkedHashCollection.Element)new TestElement(4));
        Assert.assertEquals((long)3L, (long)((TestElement)list.get(0)).key);
        Assert.assertEquals((long)4L, (long)((TestElement)list.get(1)).key);
        Assert.assertEquals((long)2L, (long)list.size());
    }

    @Test
    public void testEmptyListIterator() {
        ImplicitLinkedHashCollection coll = new ImplicitLinkedHashCollection();
        ListIterator iter = coll.valuesList().listIterator();
        Assert.assertFalse((boolean)iter.hasNext());
        Assert.assertFalse((boolean)iter.hasPrevious());
        Assert.assertEquals((long)0L, (long)iter.nextIndex());
        Assert.assertEquals((long)-1L, (long)iter.previousIndex());
    }

    @Test
    public void testListIteratorCreation() {
        ImplicitLinkedHashCollection coll = new ImplicitLinkedHashCollection();
        coll.add((ImplicitLinkedHashCollection.Element)new TestElement(1));
        coll.add((ImplicitLinkedHashCollection.Element)new TestElement(2));
        coll.add((ImplicitLinkedHashCollection.Element)new TestElement(3));
        ListIterator iter = coll.valuesList().listIterator();
        Assert.assertTrue((boolean)iter.hasNext());
        Assert.assertFalse((boolean)iter.hasPrevious());
        Assert.assertEquals((long)0L, (long)iter.nextIndex());
        Assert.assertEquals((long)-1L, (long)iter.previousIndex());
        iter = coll.valuesList().listIterator(2);
        Assert.assertTrue((boolean)iter.hasNext());
        Assert.assertTrue((boolean)iter.hasPrevious());
        Assert.assertEquals((long)2L, (long)iter.nextIndex());
        Assert.assertEquals((long)1L, (long)iter.previousIndex());
        iter = coll.valuesList().listIterator(3);
        Assert.assertFalse((boolean)iter.hasNext());
        Assert.assertTrue((boolean)iter.hasPrevious());
        Assert.assertEquals((long)3L, (long)iter.nextIndex());
        Assert.assertEquals((long)2L, (long)iter.previousIndex());
    }

    @Test
    public void testListIteratorTraversal() {
        ImplicitLinkedHashCollection coll = new ImplicitLinkedHashCollection();
        coll.add((ImplicitLinkedHashCollection.Element)new TestElement(1));
        coll.add((ImplicitLinkedHashCollection.Element)new TestElement(2));
        coll.add((ImplicitLinkedHashCollection.Element)new TestElement(3));
        ListIterator iter = coll.valuesList().listIterator();
        Assert.assertTrue((boolean)iter.hasNext());
        Assert.assertFalse((boolean)iter.hasPrevious());
        Assert.assertEquals((long)0L, (long)iter.nextIndex());
        Assert.assertEquals((long)-1L, (long)iter.previousIndex());
        Assert.assertEquals((long)1L, (long)((TestElement)iter.next()).key);
        Assert.assertTrue((boolean)iter.hasNext());
        Assert.assertTrue((boolean)iter.hasPrevious());
        Assert.assertEquals((long)1L, (long)iter.nextIndex());
        Assert.assertEquals((long)0L, (long)iter.previousIndex());
        Assert.assertEquals((long)2L, (long)((TestElement)iter.next()).key);
        Assert.assertTrue((boolean)iter.hasNext());
        Assert.assertTrue((boolean)iter.hasPrevious());
        Assert.assertEquals((long)2L, (long)iter.nextIndex());
        Assert.assertEquals((long)1L, (long)iter.previousIndex());
        Assert.assertEquals((long)3L, (long)((TestElement)iter.next()).key);
        Assert.assertFalse((boolean)iter.hasNext());
        Assert.assertTrue((boolean)iter.hasPrevious());
        Assert.assertEquals((long)3L, (long)iter.nextIndex());
        Assert.assertEquals((long)2L, (long)iter.previousIndex());
        Assert.assertEquals((long)3L, (long)((TestElement)iter.previous()).key);
        Assert.assertTrue((boolean)iter.hasNext());
        Assert.assertTrue((boolean)iter.hasPrevious());
        Assert.assertEquals((long)2L, (long)iter.nextIndex());
        Assert.assertEquals((long)1L, (long)iter.previousIndex());
        Assert.assertEquals((long)2L, (long)((TestElement)iter.previous()).key);
        Assert.assertTrue((boolean)iter.hasNext());
        Assert.assertTrue((boolean)iter.hasPrevious());
        Assert.assertEquals((long)1L, (long)iter.nextIndex());
        Assert.assertEquals((long)0L, (long)iter.previousIndex());
        Assert.assertEquals((long)2L, (long)((TestElement)iter.next()).key);
        Assert.assertTrue((boolean)iter.hasNext());
        Assert.assertTrue((boolean)iter.hasPrevious());
        Assert.assertEquals((long)2L, (long)iter.nextIndex());
        Assert.assertEquals((long)1L, (long)iter.previousIndex());
        Assert.assertEquals((long)2L, (long)((TestElement)iter.previous()).key);
        Assert.assertTrue((boolean)iter.hasNext());
        Assert.assertTrue((boolean)iter.hasPrevious());
        Assert.assertEquals((long)1L, (long)iter.nextIndex());
        Assert.assertEquals((long)0L, (long)iter.previousIndex());
        Assert.assertEquals((long)1L, (long)((TestElement)iter.previous()).key);
        Assert.assertTrue((boolean)iter.hasNext());
        Assert.assertFalse((boolean)iter.hasPrevious());
        Assert.assertEquals((long)0L, (long)iter.nextIndex());
        Assert.assertEquals((long)-1L, (long)iter.previousIndex());
    }

    @Test
    public void testListIteratorRemove() {
        ImplicitLinkedHashCollection coll = new ImplicitLinkedHashCollection();
        coll.add((ImplicitLinkedHashCollection.Element)new TestElement(1));
        coll.add((ImplicitLinkedHashCollection.Element)new TestElement(2));
        coll.add((ImplicitLinkedHashCollection.Element)new TestElement(3));
        coll.add((ImplicitLinkedHashCollection.Element)new TestElement(4));
        coll.add((ImplicitLinkedHashCollection.Element)new TestElement(5));
        ListIterator iter = coll.valuesList().listIterator();
        try {
            iter.remove();
            Assert.fail((String)"Calling remove() without calling next() or previous() should raise an exception");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        iter.next();
        iter.next();
        iter.next();
        iter.remove();
        Assert.assertTrue((boolean)iter.hasNext());
        Assert.assertTrue((boolean)iter.hasPrevious());
        Assert.assertEquals((long)2L, (long)iter.nextIndex());
        Assert.assertEquals((long)1L, (long)iter.previousIndex());
        try {
            iter.remove();
            Assert.fail((String)"Calling remove() twice without calling next() or previous() in between should raise an exception");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        Assert.assertEquals((long)2L, (long)((TestElement)iter.previous()).key);
        iter.remove();
        Assert.assertTrue((boolean)iter.hasNext());
        Assert.assertTrue((boolean)iter.hasPrevious());
        Assert.assertEquals((long)1L, (long)iter.nextIndex());
        Assert.assertEquals((long)0L, (long)iter.previousIndex());
        Assert.assertEquals((long)1L, (long)((TestElement)iter.previous()).key);
        iter.remove();
        Assert.assertTrue((boolean)iter.hasNext());
        Assert.assertFalse((boolean)iter.hasPrevious());
        Assert.assertEquals((long)0L, (long)iter.nextIndex());
        Assert.assertEquals((long)-1L, (long)iter.previousIndex());
        Assert.assertEquals((long)4L, (long)((TestElement)iter.next()).key);
        Assert.assertEquals((long)5L, (long)((TestElement)iter.next()).key);
        iter.remove();
        Assert.assertFalse((boolean)iter.hasNext());
        Assert.assertTrue((boolean)iter.hasPrevious());
        Assert.assertEquals((long)1L, (long)iter.nextIndex());
        Assert.assertEquals((long)0L, (long)iter.previousIndex());
        Assert.assertEquals((long)4L, (long)((TestElement)iter.previous()).key);
        iter.remove();
        Assert.assertFalse((boolean)iter.hasNext());
        Assert.assertFalse((boolean)iter.hasPrevious());
        Assert.assertEquals((long)0L, (long)iter.nextIndex());
        Assert.assertEquals((long)-1L, (long)iter.previousIndex());
    }

    @Test
    public void testCollisions() {
        ImplicitLinkedHashCollection coll = new ImplicitLinkedHashCollection(5);
        Assert.assertEquals((long)11L, (long)coll.numSlots());
        Assert.assertTrue((boolean)coll.add((ImplicitLinkedHashCollection.Element)new TestElement(11)));
        Assert.assertTrue((boolean)coll.add((ImplicitLinkedHashCollection.Element)new TestElement(0)));
        Assert.assertTrue((boolean)coll.add((ImplicitLinkedHashCollection.Element)new TestElement(22)));
        Assert.assertTrue((boolean)coll.add((ImplicitLinkedHashCollection.Element)new TestElement(33)));
        Assert.assertEquals((long)11L, (long)coll.numSlots());
        ImplicitLinkedHashCollectionTest.expectTraversal((Iterator<TestElement>)coll.iterator(), 11, 0, 22, 33);
        Assert.assertTrue((boolean)coll.remove((Object)new TestElement(22)));
        ImplicitLinkedHashCollectionTest.expectTraversal((Iterator<TestElement>)coll.iterator(), 11, 0, 33);
        Assert.assertEquals((long)3L, (long)coll.size());
        Assert.assertFalse((boolean)coll.isEmpty());
    }

    @Test
    public void testEnlargement() {
        int i;
        ImplicitLinkedHashCollection coll = new ImplicitLinkedHashCollection(5);
        Assert.assertEquals((long)11L, (long)coll.numSlots());
        for (i = 0; i < 6; ++i) {
            Assert.assertTrue((boolean)coll.add((ImplicitLinkedHashCollection.Element)new TestElement(i)));
        }
        Assert.assertEquals((long)23L, (long)coll.numSlots());
        Assert.assertEquals((long)6L, (long)coll.size());
        ImplicitLinkedHashCollectionTest.expectTraversal((Iterator<TestElement>)coll.iterator(), 0, 1, 2, 3, 4, 5);
        for (i = 0; i < 6; ++i) {
            Assert.assertTrue((String)("Failed to find element " + i), (boolean)coll.contains((Object)new TestElement(i)));
        }
        coll.remove((Object)new TestElement(3));
        Assert.assertEquals((long)23L, (long)coll.numSlots());
        Assert.assertEquals((long)5L, (long)coll.size());
        ImplicitLinkedHashCollectionTest.expectTraversal((Iterator<TestElement>)coll.iterator(), 0, 1, 2, 4, 5);
    }

    @Test
    public void testManyInsertsAndDeletes() {
        Random random = new Random(123L);
        LinkedHashSet<Integer> existing = new LinkedHashSet<Integer>();
        ImplicitLinkedHashCollection coll = new ImplicitLinkedHashCollection();
        for (int i = 0; i < 100; ++i) {
            this.addRandomElement(random, existing, (ImplicitLinkedHashCollection<TestElement>)coll);
            this.addRandomElement(random, existing, (ImplicitLinkedHashCollection<TestElement>)coll);
            this.addRandomElement(random, existing, (ImplicitLinkedHashCollection<TestElement>)coll);
            this.removeRandomElement(random, existing, (ImplicitLinkedHashCollection<TestElement>)coll);
            ImplicitLinkedHashCollectionTest.expectTraversal((Iterator<TestElement>)coll.iterator(), existing.iterator());
        }
    }

    @Test
    public void testInsertingTheSameObjectMultipleTimes() {
        ImplicitLinkedHashCollection coll = new ImplicitLinkedHashCollection();
        TestElement element = new TestElement(123);
        Assert.assertTrue((boolean)coll.add((ImplicitLinkedHashCollection.Element)element));
        Assert.assertFalse((boolean)coll.add((ImplicitLinkedHashCollection.Element)element));
        Assert.assertFalse((boolean)coll.add((ImplicitLinkedHashCollection.Element)element));
        Assert.assertTrue((boolean)coll.remove((Object)element));
        Assert.assertFalse((boolean)coll.remove((Object)element));
        Assert.assertTrue((boolean)coll.add((ImplicitLinkedHashCollection.Element)element));
        Assert.assertFalse((boolean)coll.add((ImplicitLinkedHashCollection.Element)element));
    }

    @Test
    public void testEquals() {
        ImplicitLinkedHashCollection coll1 = new ImplicitLinkedHashCollection();
        coll1.add((ImplicitLinkedHashCollection.Element)new TestElement(1));
        coll1.add((ImplicitLinkedHashCollection.Element)new TestElement(2));
        coll1.add((ImplicitLinkedHashCollection.Element)new TestElement(3));
        ImplicitLinkedHashCollection coll2 = new ImplicitLinkedHashCollection();
        coll2.add((ImplicitLinkedHashCollection.Element)new TestElement(1));
        coll2.add((ImplicitLinkedHashCollection.Element)new TestElement(2));
        coll2.add((ImplicitLinkedHashCollection.Element)new TestElement(3));
        ImplicitLinkedHashCollection coll3 = new ImplicitLinkedHashCollection();
        coll3.add((ImplicitLinkedHashCollection.Element)new TestElement(1));
        coll3.add((ImplicitLinkedHashCollection.Element)new TestElement(3));
        coll3.add((ImplicitLinkedHashCollection.Element)new TestElement(2));
        Assert.assertEquals((Object)coll1, (Object)coll2);
        Assert.assertNotEquals((Object)coll1, (Object)coll3);
        Assert.assertNotEquals((Object)coll2, (Object)coll3);
    }

    @Test
    public void testFindContainsRemoveOnEmptyCollection() {
        ImplicitLinkedHashCollection coll = new ImplicitLinkedHashCollection();
        Assert.assertNull((Object)coll.find((ImplicitLinkedHashCollection.Element)new TestElement(2)));
        Assert.assertFalse((boolean)coll.contains((Object)new TestElement(2)));
        Assert.assertFalse((boolean)coll.remove((Object)new TestElement(2)));
    }

    private void addRandomElement(Random random, LinkedHashSet<Integer> existing, ImplicitLinkedHashCollection<TestElement> set) {
        int next;
        while (existing.contains(next = random.nextInt())) {
        }
        existing.add(next);
        set.add((ImplicitLinkedHashCollection.Element)new TestElement(next));
    }

    private void removeRandomElement(Random random, Collection<Integer> existing, ImplicitLinkedHashCollection<TestElement> coll) {
        int removeIdx = random.nextInt(existing.size());
        Iterator<Integer> iter = existing.iterator();
        Integer element = null;
        for (int i = 0; i <= removeIdx; ++i) {
            element = iter.next();
        }
        existing.remove(new TestElement(element));
    }

    @Test
    public void testSameKeysDifferentValues() {
        ImplicitLinkedHashCollection coll = new ImplicitLinkedHashCollection();
        Assert.assertTrue((boolean)coll.add((ImplicitLinkedHashCollection.Element)new TestElement(1, 1)));
        Assert.assertFalse((boolean)coll.add((ImplicitLinkedHashCollection.Element)new TestElement(1, 2)));
        TestElement element2 = new TestElement(1, 2);
        TestElement element1 = (TestElement)coll.find((ImplicitLinkedHashCollection.Element)element2);
        Assert.assertFalse((boolean)element2.equals(element1));
        Assert.assertTrue((boolean)element2.elementKeysAreEqual(element1));
    }

    static final class TestElement
    implements ImplicitLinkedHashCollection.Element {
        private int prev = -2;
        private int next = -2;
        private final int key;
        private final int val;

        TestElement(int key) {
            this.key = key;
            this.val = 0;
        }

        TestElement(int key, int val) {
            this.key = key;
            this.val = val;
        }

        public int prev() {
            return this.prev;
        }

        public void setPrev(int prev) {
            this.prev = prev;
        }

        public int next() {
            return this.next;
        }

        public void setNext(int next) {
            this.next = next;
        }

        public boolean elementKeysAreEqual(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || o.getClass() != TestElement.class) {
                return false;
            }
            TestElement that = (TestElement)o;
            return this.key == that.key;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || o.getClass() != TestElement.class) {
                return false;
            }
            TestElement that = (TestElement)o;
            return this.key == that.key && this.val == that.val;
        }

        public String toString() {
            return "TestElement(key=" + this.key + ", val=" + this.val + ")";
        }

        public int hashCode() {
            return this.key;
        }
    }
}

