/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.security.ssl;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.Security;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.config.types.Password;
import org.apache.kafka.common.network.Mode;
import org.apache.kafka.common.security.auth.SslEngineFactory;
import org.apache.kafka.common.security.ssl.DefaultSslEngineFactory;
import org.apache.kafka.common.security.ssl.SslFactory;
import org.apache.kafka.common.security.ssl.mock.TestProviderCreator;
import org.apache.kafka.common.utils.Java;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.test.TestSslUtils;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class SslFactoryTest {
    private final String tlsProtocol;

    @Parameterized.Parameters(name="tlsProtocol={0}")
    public static Collection<Object[]> data() {
        ArrayList<Object[]> values = new ArrayList<Object[]>();
        values.add(new Object[]{"TLSv1.2"});
        if (Java.IS_JAVA11_COMPATIBLE) {
            values.add(new Object[]{"TLSv1.3"});
        }
        return values;
    }

    public SslFactoryTest(String tlsProtocol) {
        this.tlsProtocol = tlsProtocol;
    }

    @Test
    public void testSslFactoryConfiguration() throws Exception {
        File trustStoreFile = File.createTempFile("truststore", ".jks");
        Map<String, Object> serverSslConfig = this.sslConfigsBuilder(Mode.SERVER).createNewTrustStore(trustStoreFile).build();
        SslFactory sslFactory = new SslFactory(Mode.SERVER);
        sslFactory.configure(serverSslConfig);
        SSLEngine engine = sslFactory.createSslEngine("localhost", 0);
        Assert.assertNotNull((Object)engine);
        Assert.assertEquals((Object)Utils.mkSet((Object[])new String[]{this.tlsProtocol}), (Object)Utils.mkSet((Object[])engine.getEnabledProtocols()));
        Assert.assertEquals((Object)false, (Object)engine.getUseClientMode());
    }

    @Test
    public void testSslFactoryWithCustomKeyManagerConfiguration() {
        TestProviderCreator testProviderCreator = new TestProviderCreator();
        Map<String, Object> serverSslConfig = TestSslUtils.createSslConfig("TestAlgorithm", "TestAlgorithm", this.tlsProtocol);
        serverSslConfig.put("security.providers", testProviderCreator.getClass().getName());
        SslFactory sslFactory = new SslFactory(Mode.SERVER);
        sslFactory.configure(serverSslConfig);
        Assert.assertNotNull((String)"SslEngineFactory not created", (Object)sslFactory.sslEngineFactory());
        Security.removeProvider(testProviderCreator.getProvider().getName());
    }

    @Test(expected=KafkaException.class)
    public void testSslFactoryWithoutProviderClassConfiguration() {
        Map<String, Object> serverSslConfig = TestSslUtils.createSslConfig("TestAlgorithm", "TestAlgorithm", this.tlsProtocol);
        SslFactory sslFactory = new SslFactory(Mode.SERVER);
        sslFactory.configure(serverSslConfig);
    }

    @Test(expected=KafkaException.class)
    public void testSslFactoryWithIncorrectProviderClassConfiguration() {
        Map<String, Object> serverSslConfig = TestSslUtils.createSslConfig("TestAlgorithm", "TestAlgorithm", this.tlsProtocol);
        serverSslConfig.put("security.providers", "com.fake.ProviderClass1,com.fake.ProviderClass2");
        SslFactory sslFactory = new SslFactory(Mode.SERVER);
        sslFactory.configure(serverSslConfig);
    }

    @Test
    public void testSslFactoryWithoutPasswordConfiguration() throws Exception {
        File trustStoreFile = File.createTempFile("truststore", ".jks");
        Map<String, Object> serverSslConfig = this.sslConfigsBuilder(Mode.SERVER).createNewTrustStore(trustStoreFile).build();
        serverSslConfig.remove("ssl.truststore.password");
        SslFactory sslFactory = new SslFactory(Mode.SERVER);
        try {
            sslFactory.configure(serverSslConfig);
        }
        catch (Exception e) {
            Assert.fail((String)("An exception was thrown when configuring the truststore without a password: " + e));
        }
    }

    @Test
    public void testClientMode() throws Exception {
        File trustStoreFile = File.createTempFile("truststore", ".jks");
        Map<String, Object> clientSslConfig = this.sslConfigsBuilder(Mode.CLIENT).createNewTrustStore(trustStoreFile).useClientCert(false).build();
        SslFactory sslFactory = new SslFactory(Mode.CLIENT);
        sslFactory.configure(clientSslConfig);
        SSLEngine engine = sslFactory.createSslEngine("localhost", 0);
        Assert.assertTrue((boolean)engine.getUseClientMode());
    }

    @Test
    public void staleSslEngineFactoryShouldBeClosed() throws IOException, GeneralSecurityException {
        File trustStoreFile = File.createTempFile("truststore", ".jks");
        Map<String, Object> clientSslConfig = this.sslConfigsBuilder(Mode.SERVER).createNewTrustStore(trustStoreFile).useClientCert(false).build();
        clientSslConfig.put("ssl.engine.factory.class", TestSslUtils.TestSslEngineFactory.class);
        SslFactory sslFactory = new SslFactory(Mode.SERVER);
        sslFactory.configure(clientSslConfig);
        TestSslUtils.TestSslEngineFactory sslEngineFactory = (TestSslUtils.TestSslEngineFactory)sslFactory.sslEngineFactory();
        Assert.assertNotNull((Object)sslEngineFactory);
        Assert.assertFalse((boolean)sslEngineFactory.closed);
        trustStoreFile = File.createTempFile("truststore", ".jks");
        clientSslConfig = this.sslConfigsBuilder(Mode.SERVER).createNewTrustStore(trustStoreFile).build();
        clientSslConfig.put("ssl.engine.factory.class", TestSslUtils.TestSslEngineFactory.class);
        sslFactory.reconfigure(clientSslConfig);
        TestSslUtils.TestSslEngineFactory newSslEngineFactory = (TestSslUtils.TestSslEngineFactory)sslFactory.sslEngineFactory();
        Assert.assertNotEquals((Object)sslEngineFactory, (Object)newSslEngineFactory);
        Assert.assertTrue((boolean)sslEngineFactory.closed);
    }

    @Test
    public void testReconfiguration() throws Exception {
        File trustStoreFile = File.createTempFile("truststore", ".jks");
        Map<String, Object> sslConfig = this.sslConfigsBuilder(Mode.SERVER).createNewTrustStore(trustStoreFile).build();
        SslFactory sslFactory = new SslFactory(Mode.SERVER);
        sslFactory.configure(sslConfig);
        SslEngineFactory sslEngineFactory = sslFactory.sslEngineFactory();
        Assert.assertNotNull((String)"SslEngineFactory not created", (Object)sslEngineFactory);
        sslFactory.reconfigure(sslConfig);
        Assert.assertSame((String)"SslEngineFactory recreated unnecessarily", (Object)sslEngineFactory, (Object)sslFactory.sslEngineFactory());
        trustStoreFile = File.createTempFile("truststore", ".jks");
        sslConfig = this.sslConfigsBuilder(Mode.SERVER).createNewTrustStore(trustStoreFile).build();
        sslFactory.reconfigure(sslConfig);
        Assert.assertNotSame((String)"SslEngineFactory not recreated", (Object)sslEngineFactory, (Object)sslFactory.sslEngineFactory());
        sslEngineFactory = sslFactory.sslEngineFactory();
        trustStoreFile.setLastModified(System.currentTimeMillis() + 10000L);
        sslFactory.reconfigure(sslConfig);
        Assert.assertNotSame((String)"SslEngineFactory not recreated", (Object)sslEngineFactory, (Object)sslFactory.sslEngineFactory());
        sslEngineFactory = sslFactory.sslEngineFactory();
        File keyStoreFile = new File((String)sslConfig.get("ssl.keystore.location"));
        keyStoreFile.setLastModified(System.currentTimeMillis() + 10000L);
        sslFactory.reconfigure(sslConfig);
        Assert.assertNotSame((String)"SslEngineFactory not recreated", (Object)sslEngineFactory, (Object)sslFactory.sslEngineFactory());
        sslEngineFactory = sslFactory.sslEngineFactory();
        keyStoreFile.setLastModified(System.currentTimeMillis() + 15000L);
        sslFactory.validateReconfiguration(sslConfig);
        sslFactory.reconfigure(sslConfig);
        Assert.assertNotSame((String)"SslEngineFactory not recreated", (Object)sslEngineFactory, (Object)sslFactory.sslEngineFactory());
        sslEngineFactory = sslFactory.sslEngineFactory();
        keyStoreFile.setLastModified(System.currentTimeMillis() + 20000L);
        Files.delete(keyStoreFile.toPath());
        sslFactory.reconfigure(sslConfig);
        Assert.assertSame((String)"SslEngineFactory recreated unnecessarily", (Object)sslEngineFactory, (Object)sslFactory.sslEngineFactory());
    }

    @Test
    public void testReconfigurationWithoutTruststore() throws Exception {
        File trustStoreFile = File.createTempFile("truststore", ".jks");
        Map<String, Object> sslConfig = this.sslConfigsBuilder(Mode.SERVER).createNewTrustStore(trustStoreFile).build();
        sslConfig.remove("ssl.truststore.location");
        sslConfig.remove("ssl.truststore.password");
        sslConfig.remove("ssl.truststore.type");
        SslFactory sslFactory = new SslFactory(Mode.SERVER);
        sslFactory.configure(sslConfig);
        SSLContext sslContext = ((DefaultSslEngineFactory)sslFactory.sslEngineFactory()).sslContext();
        Assert.assertNotNull((String)"SSL context not created", (Object)sslContext);
        Assert.assertSame((String)"SSL context recreated unnecessarily", (Object)sslContext, (Object)((DefaultSslEngineFactory)sslFactory.sslEngineFactory()).sslContext());
        Assert.assertFalse((boolean)sslFactory.createSslEngine("localhost", 0).getUseClientMode());
        Map<String, Object> sslConfig2 = this.sslConfigsBuilder(Mode.SERVER).createNewTrustStore(trustStoreFile).build();
        try {
            sslFactory.validateReconfiguration(sslConfig2);
            Assert.fail((String)"Truststore configured dynamically for listener without previous truststore");
        }
        catch (ConfigException configException) {
            // empty catch block
        }
    }

    @Test
    public void testReconfigurationWithoutKeystore() throws Exception {
        File trustStoreFile = File.createTempFile("truststore", ".jks");
        Map<String, Object> sslConfig = this.sslConfigsBuilder(Mode.SERVER).createNewTrustStore(trustStoreFile).build();
        sslConfig.remove("ssl.keystore.location");
        sslConfig.remove("ssl.keystore.password");
        sslConfig.remove("ssl.keystore.type");
        SslFactory sslFactory = new SslFactory(Mode.SERVER);
        sslFactory.configure(sslConfig);
        SSLContext sslContext = ((DefaultSslEngineFactory)sslFactory.sslEngineFactory()).sslContext();
        Assert.assertNotNull((String)"SSL context not created", (Object)sslContext);
        Assert.assertSame((String)"SSL context recreated unnecessarily", (Object)sslContext, (Object)((DefaultSslEngineFactory)sslFactory.sslEngineFactory()).sslContext());
        Assert.assertFalse((boolean)sslFactory.createSslEngine("localhost", 0).getUseClientMode());
        File newTrustStoreFile = File.createTempFile("truststore", ".jks");
        sslConfig = this.sslConfigsBuilder(Mode.SERVER).createNewTrustStore(newTrustStoreFile).build();
        sslConfig.remove("ssl.keystore.location");
        sslConfig.remove("ssl.keystore.password");
        sslConfig.remove("ssl.keystore.type");
        sslFactory.reconfigure(sslConfig);
        Assert.assertNotSame((String)"SSL context not recreated", (Object)sslContext, (Object)((DefaultSslEngineFactory)sslFactory.sslEngineFactory()).sslContext());
        sslConfig = this.sslConfigsBuilder(Mode.SERVER).createNewTrustStore(newTrustStoreFile).build();
        try {
            sslFactory.validateReconfiguration(sslConfig);
            Assert.fail((String)"Keystore configured dynamically for listener without previous keystore");
        }
        catch (ConfigException configException) {
            // empty catch block
        }
    }

    @Test
    public void testKeyStoreTrustStoreValidation() throws Exception {
        File trustStoreFile = File.createTempFile("truststore", ".jks");
        Map<String, Object> serverSslConfig = this.sslConfigsBuilder(Mode.SERVER).createNewTrustStore(trustStoreFile).build();
        SslFactory sslFactory = new SslFactory(Mode.SERVER);
        sslFactory.configure(serverSslConfig);
        Assert.assertNotNull((String)"SslEngineFactory not created", (Object)sslFactory.sslEngineFactory());
    }

    @Test
    public void testUntrustedKeyStoreValidationFails() throws Exception {
        File trustStoreFile1 = File.createTempFile("truststore1", ".jks");
        File trustStoreFile2 = File.createTempFile("truststore2", ".jks");
        Map<String, Object> sslConfig1 = this.sslConfigsBuilder(Mode.SERVER).createNewTrustStore(trustStoreFile1).build();
        Map<String, Object> sslConfig2 = this.sslConfigsBuilder(Mode.SERVER).createNewTrustStore(trustStoreFile2).build();
        SslFactory sslFactory = new SslFactory(Mode.SERVER, null, true);
        for (String key : Arrays.asList("ssl.truststore.location", "ssl.truststore.password", "ssl.truststore.type", "ssl.trustmanager.algorithm")) {
            sslConfig1.put(key, sslConfig2.get(key));
        }
        try {
            sslFactory.configure(sslConfig1);
            Assert.fail((String)"Validation did not fail with untrusted truststore");
        }
        catch (ConfigException configException) {
            // empty catch block
        }
    }

    @Test
    public void testKeystoreVerifiableUsingTruststore() throws Exception {
        File trustStoreFile1 = File.createTempFile("truststore1", ".jks");
        Map<String, Object> sslConfig1 = this.sslConfigsBuilder(Mode.SERVER).createNewTrustStore(trustStoreFile1).build();
        SslFactory sslFactory = new SslFactory(Mode.SERVER, null, true);
        sslFactory.configure(sslConfig1);
        File trustStoreFile2 = File.createTempFile("truststore2", ".jks");
        Map<String, Object> sslConfig2 = this.sslConfigsBuilder(Mode.SERVER).createNewTrustStore(trustStoreFile2).build();
        try {
            sslFactory.validateReconfiguration(sslConfig2);
            Assert.fail((String)"ValidateReconfiguration did not fail as expected");
        }
        catch (ConfigException configException) {
            // empty catch block
        }
    }

    @Test
    public void testCertificateEntriesValidation() throws Exception {
        File trustStoreFile = File.createTempFile("truststore", ".jks");
        Map<String, Object> serverSslConfig = this.sslConfigsBuilder(Mode.SERVER).createNewTrustStore(trustStoreFile).build();
        Map<String, Object> newCnConfig = this.sslConfigsBuilder(Mode.SERVER).createNewTrustStore(File.createTempFile("truststore", ".jks")).cn("Another CN").build();
        KeyStore ks1 = this.sslKeyStore(serverSslConfig).get();
        KeyStore ks2 = this.sslKeyStore(serverSslConfig).get();
        Assert.assertEquals((Object)SslFactory.CertificateEntries.create((KeyStore)ks1), (Object)SslFactory.CertificateEntries.create((KeyStore)ks2));
        ks2.setCertificateEntry("another", ks1.getCertificate("localhost"));
        Assert.assertEquals((Object)SslFactory.CertificateEntries.create((KeyStore)ks1), (Object)SslFactory.CertificateEntries.create((KeyStore)ks2));
        KeyStore ks3 = this.sslKeyStore(newCnConfig).get();
        Assert.assertNotEquals((Object)SslFactory.CertificateEntries.create((KeyStore)ks1), (Object)SslFactory.CertificateEntries.create((KeyStore)ks3));
    }

    @Test
    public void testClientSpecifiedSslEngineFactoryUsed() throws Exception {
        File trustStoreFile = File.createTempFile("truststore", ".jks");
        Map<String, Object> clientSslConfig = this.sslConfigsBuilder(Mode.CLIENT).createNewTrustStore(trustStoreFile).useClientCert(false).build();
        clientSslConfig.put("ssl.engine.factory.class", TestSslUtils.TestSslEngineFactory.class);
        SslFactory sslFactory = new SslFactory(Mode.CLIENT);
        sslFactory.configure(clientSslConfig);
        Assert.assertTrue((String)"SslEngineFactory must be of expected type", (boolean)(sslFactory.sslEngineFactory() instanceof TestSslUtils.TestSslEngineFactory));
    }

    @Test
    public void testEngineFactoryClosed() throws Exception {
        File trustStoreFile = File.createTempFile("truststore", ".jks");
        Map<String, Object> clientSslConfig = this.sslConfigsBuilder(Mode.CLIENT).createNewTrustStore(trustStoreFile).useClientCert(false).build();
        clientSslConfig.put("ssl.engine.factory.class", TestSslUtils.TestSslEngineFactory.class);
        SslFactory sslFactory = new SslFactory(Mode.CLIENT);
        sslFactory.configure(clientSslConfig);
        TestSslUtils.TestSslEngineFactory engine = (TestSslUtils.TestSslEngineFactory)sslFactory.sslEngineFactory();
        Assert.assertFalse((boolean)engine.closed);
        sslFactory.close();
        Assert.assertTrue((boolean)engine.closed);
    }

    @Test
    public void testServerSpecifiedSslEngineFactoryUsed() throws Exception {
        File trustStoreFile = File.createTempFile("truststore", ".jks");
        Map<String, Object> serverSslConfig = this.sslConfigsBuilder(Mode.SERVER).createNewTrustStore(trustStoreFile).useClientCert(false).build();
        serverSslConfig.put("ssl.engine.factory.class", TestSslUtils.TestSslEngineFactory.class);
        SslFactory sslFactory = new SslFactory(Mode.SERVER);
        sslFactory.configure(serverSslConfig);
        Assert.assertTrue((String)"SslEngineFactory must be of expected type", (boolean)(sslFactory.sslEngineFactory() instanceof TestSslUtils.TestSslEngineFactory));
    }

    @Test(expected=ClassCastException.class)
    public void testInvalidSslEngineFactory() throws Exception {
        File trustStoreFile = File.createTempFile("truststore", ".jks");
        Map<String, Object> clientSslConfig = this.sslConfigsBuilder(Mode.CLIENT).createNewTrustStore(trustStoreFile).useClientCert(false).build();
        clientSslConfig.put("ssl.engine.factory.class", String.class);
        SslFactory sslFactory = new SslFactory(Mode.CLIENT);
        sslFactory.configure(clientSslConfig);
    }

    private DefaultSslEngineFactory.SecurityStore sslKeyStore(Map<String, Object> sslConfig) {
        return new DefaultSslEngineFactory.SecurityStore((String)sslConfig.get("ssl.keystore.type"), (String)sslConfig.get("ssl.keystore.location"), (Password)sslConfig.get("ssl.keystore.password"), (Password)sslConfig.get("ssl.key.password"));
    }

    private TestSslUtils.SslConfigsBuilder sslConfigsBuilder(Mode mode) {
        return new TestSslUtils.SslConfigsBuilder(mode).tlsProtocol(this.tlsProtocol);
    }
}

