/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import org.apache.kafka.common.message.StopReplicaRequestData;
import org.apache.kafka.common.message.StopReplicaResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.StopReplicaRequest;
import org.apache.kafka.common.requests.StopReplicaResponse;
import org.junit.Assert;
import org.junit.Test;

public class StopReplicaResponseTest {
    @Test
    public void testErrorCountsFromGetErrorResponse() {
        ArrayList<StopReplicaRequestData.StopReplicaTopicState> topicStates = new ArrayList<StopReplicaRequestData.StopReplicaTopicState>();
        topicStates.add(new StopReplicaRequestData.StopReplicaTopicState().setTopicName("foo").setPartitionStates(Arrays.asList(new StopReplicaRequestData.StopReplicaPartitionState().setPartitionIndex(0), new StopReplicaRequestData.StopReplicaPartitionState().setPartitionIndex(1))));
        for (short version = ApiKeys.STOP_REPLICA.oldestVersion(); version < ApiKeys.STOP_REPLICA.latestVersion(); version = (short)(version + 1)) {
            StopReplicaRequest request = new StopReplicaRequest.Builder(version, 15, 20, 0L, false, topicStates).build(version);
            StopReplicaResponse response = request.getErrorResponse(0, (Throwable)Errors.CLUSTER_AUTHORIZATION_FAILED.exception());
            Assert.assertEquals(Collections.singletonMap(Errors.CLUSTER_AUTHORIZATION_FAILED, 2), (Object)response.errorCounts());
        }
    }

    @Test
    public void testErrorCountsWithTopLevelError() {
        ArrayList<StopReplicaResponseData.StopReplicaPartitionError> errors = new ArrayList<StopReplicaResponseData.StopReplicaPartitionError>();
        errors.add(new StopReplicaResponseData.StopReplicaPartitionError().setTopicName("foo").setPartitionIndex(0));
        errors.add(new StopReplicaResponseData.StopReplicaPartitionError().setTopicName("foo").setPartitionIndex(1).setErrorCode(Errors.NOT_LEADER_OR_FOLLOWER.code()));
        StopReplicaResponse response = new StopReplicaResponse(new StopReplicaResponseData().setErrorCode(Errors.UNKNOWN_SERVER_ERROR.code()).setPartitionErrors(errors));
        Assert.assertEquals(Collections.singletonMap(Errors.UNKNOWN_SERVER_ERROR, 2), (Object)response.errorCounts());
    }

    @Test
    public void testErrorCountsNoTopLevelError() {
        ArrayList<StopReplicaResponseData.StopReplicaPartitionError> errors = new ArrayList<StopReplicaResponseData.StopReplicaPartitionError>();
        errors.add(new StopReplicaResponseData.StopReplicaPartitionError().setTopicName("foo").setPartitionIndex(0));
        errors.add(new StopReplicaResponseData.StopReplicaPartitionError().setTopicName("foo").setPartitionIndex(1).setErrorCode(Errors.CLUSTER_AUTHORIZATION_FAILED.code()));
        StopReplicaResponse response = new StopReplicaResponse(new StopReplicaResponseData().setErrorCode(Errors.NONE.code()).setPartitionErrors(errors));
        Map errorCounts = response.errorCounts();
        Assert.assertEquals((long)2L, (long)errorCounts.size());
        Assert.assertEquals((long)1L, (long)((Integer)errorCounts.get(Errors.NONE)).intValue());
        Assert.assertEquals((long)1L, (long)((Integer)errorCounts.get(Errors.CLUSTER_AUTHORIZATION_FAILED)).intValue());
    }

    @Test
    public void testToString() {
        ArrayList<StopReplicaResponseData.StopReplicaPartitionError> errors = new ArrayList<StopReplicaResponseData.StopReplicaPartitionError>();
        errors.add(new StopReplicaResponseData.StopReplicaPartitionError().setTopicName("foo").setPartitionIndex(0));
        errors.add(new StopReplicaResponseData.StopReplicaPartitionError().setTopicName("foo").setPartitionIndex(1).setErrorCode(Errors.CLUSTER_AUTHORIZATION_FAILED.code()));
        StopReplicaResponse response = new StopReplicaResponse(new StopReplicaResponseData().setPartitionErrors(errors));
        String responseStr = response.toString();
        Assert.assertTrue((boolean)responseStr.contains(StopReplicaResponse.class.getSimpleName()));
        Assert.assertTrue((boolean)responseStr.contains(((Object)errors).toString()));
        Assert.assertTrue((boolean)responseStr.contains("errorCode=" + Errors.NONE.code()));
    }
}

