/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.message;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.Message;
import org.apache.kafka.common.protocol.MessageUtil;
import org.apache.kafka.common.protocol.ObjectSerializationCache;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.protocol.Writable;
import org.apache.kafka.common.protocol.types.ArrayOf;
import org.apache.kafka.common.protocol.types.CompactArrayOf;
import org.apache.kafka.common.protocol.types.Field;
import org.apache.kafka.common.protocol.types.RawTaggedField;
import org.apache.kafka.common.protocol.types.RawTaggedFieldWriter;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Struct;
import org.apache.kafka.common.protocol.types.Type;
import org.apache.kafka.common.utils.ByteUtils;
import org.apache.kafka.common.utils.ImplicitLinkedHashCollection;
import org.apache.kafka.common.utils.ImplicitLinkedHashMultiCollection;

public class CreateTopicsResponseData
implements ApiMessage {
    private int throttleTimeMs;
    private CreatableTopicResultCollection topics;
    private List<RawTaggedField> _unknownTaggedFields;
    public static final Schema SCHEMA_0 = new Schema(new Field[]{new Field("topics", (Type)new ArrayOf((Type)CreatableTopicResult.SCHEMA_0), "Results for each topic we tried to create.")});
    public static final Schema SCHEMA_1 = new Schema(new Field[]{new Field("topics", (Type)new ArrayOf((Type)CreatableTopicResult.SCHEMA_1), "Results for each topic we tried to create.")});
    public static final Schema SCHEMA_2;
    public static final Schema SCHEMA_3;
    public static final Schema SCHEMA_4;
    public static final Schema SCHEMA_5;
    public static final Schema[] SCHEMAS;

    public CreateTopicsResponseData(Readable _readable, short _version) {
        this.read(_readable, _version);
    }

    public CreateTopicsResponseData(Struct _struct, short _version) {
        this.fromStruct(_struct, _version);
    }

    public CreateTopicsResponseData() {
        this.throttleTimeMs = 0;
        this.topics = new CreatableTopicResultCollection(0);
    }

    public short apiKey() {
        return 19;
    }

    public short lowestSupportedVersion() {
        return 0;
    }

    public short highestSupportedVersion() {
        return 5;
    }

    public void read(Readable _readable, short _version) {
        int i;
        CreatableTopicResultCollection newCollection;
        int arrayLength;
        this.throttleTimeMs = _version >= 2 ? _readable.readInt() : 0;
        if (_version >= 5) {
            arrayLength = _readable.readUnsignedVarint() - 1;
            if (arrayLength < 0) {
                throw new RuntimeException("non-nullable field topics was serialized as null");
            }
            newCollection = new CreatableTopicResultCollection(arrayLength);
            for (i = 0; i < arrayLength; ++i) {
                newCollection.add(new CreatableTopicResult(_readable, _version));
            }
            this.topics = newCollection;
        } else {
            arrayLength = _readable.readInt();
            if (arrayLength < 0) {
                throw new RuntimeException("non-nullable field topics was serialized as null");
            }
            newCollection = new CreatableTopicResultCollection(arrayLength);
            for (i = 0; i < arrayLength; ++i) {
                newCollection.add(new CreatableTopicResult(_readable, _version));
            }
            this.topics = newCollection;
        }
        this._unknownTaggedFields = null;
        if (_version >= 5) {
            int _numTaggedFields = _readable.readUnsignedVarint();
            for (int _i = 0; _i < _numTaggedFields; ++_i) {
                int _tag = _readable.readUnsignedVarint();
                int _size = _readable.readUnsignedVarint();
                switch (_tag) {
                    default: 
                }
                this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
            }
        }
    }

    public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
        Iterator iterator;
        int _numTaggedFields = 0;
        if (_version >= 2) {
            _writable.writeInt(this.throttleTimeMs);
        }
        if (_version >= 5) {
            _writable.writeUnsignedVarint(this.topics.size() + 1);
            iterator = this.topics.iterator();
            while (iterator.hasNext()) {
                CreatableTopicResult topicsElement = (CreatableTopicResult)iterator.next();
                topicsElement.write(_writable, _cache, _version);
            }
        } else {
            _writable.writeInt(this.topics.size());
            iterator = this.topics.iterator();
            while (iterator.hasNext()) {
                CreatableTopicResult topicsElement = (CreatableTopicResult)iterator.next();
                topicsElement.write(_writable, _cache, _version);
            }
        }
        RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
        _numTaggedFields += _rawWriter.numFields();
        if (_version >= 5) {
            _writable.writeUnsignedVarint(_numTaggedFields);
            _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
        } else if (_numTaggedFields > 0) {
            throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
        }
    }

    public void fromStruct(Struct struct, short _version) {
        NavigableMap _taggedFields = null;
        this._unknownTaggedFields = null;
        if (_version >= 5) {
            _taggedFields = (NavigableMap)struct.get("_tagged_fields");
        }
        this.throttleTimeMs = _version >= 2 ? struct.getInt("throttle_time_ms") : 0;
        Object[] _nestedObjects = struct.getArray("topics");
        this.topics = new CreatableTopicResultCollection(_nestedObjects.length);
        for (Object nestedObject : _nestedObjects) {
            this.topics.add(new CreatableTopicResult((Struct)nestedObject, _version));
        }
        if (_version >= 5 && !_taggedFields.isEmpty()) {
            this._unknownTaggedFields = new ArrayList<RawTaggedField>(_taggedFields.size());
            for (Map.Entry entry : _taggedFields.entrySet()) {
                this._unknownTaggedFields.add((RawTaggedField)entry.getValue());
            }
        }
    }

    public Struct toStruct(short _version) {
        TreeMap _taggedFields = null;
        if (_version >= 5) {
            _taggedFields = new TreeMap();
        }
        Struct struct = new Struct(SCHEMAS[_version]);
        if (_version >= 2) {
            struct.set("throttle_time_ms", (Object)this.throttleTimeMs);
        }
        Struct[] _nestedObjects = new Struct[this.topics.size()];
        int i = 0;
        Iterator iterator = this.topics.iterator();
        while (iterator.hasNext()) {
            CreatableTopicResult element = (CreatableTopicResult)iterator.next();
            _nestedObjects[i++] = element.toStruct(_version);
        }
        struct.set("topics", (Object)_nestedObjects);
        if (_version >= 5) {
            struct.set("_tagged_fields", _taggedFields);
        }
        return struct;
    }

    public int size(ObjectSerializationCache _cache, short _version) {
        int _size = 0;
        int _numTaggedFields = 0;
        if (_version >= 2) {
            _size += 4;
        }
        int _arraySize = 0;
        _arraySize = _version >= 5 ? (_arraySize += ByteUtils.sizeOfUnsignedVarint((int)(this.topics.size() + 1))) : (_arraySize += 4);
        Iterator iterator = this.topics.iterator();
        while (iterator.hasNext()) {
            CreatableTopicResult topicsElement = (CreatableTopicResult)iterator.next();
            _arraySize += topicsElement.size(_cache, _version);
        }
        _size += _arraySize;
        if (this._unknownTaggedFields != null) {
            _numTaggedFields += this._unknownTaggedFields.size();
            for (RawTaggedField _field : this._unknownTaggedFields) {
                _size += ByteUtils.sizeOfUnsignedVarint((int)_field.tag());
                _size += ByteUtils.sizeOfUnsignedVarint((int)_field.size());
                _size += _field.size();
            }
        }
        if (_version >= 5) {
            _size += ByteUtils.sizeOfUnsignedVarint((int)_numTaggedFields);
        } else if (_numTaggedFields > 0) {
            throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
        }
        return _size;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof CreateTopicsResponseData)) {
            return false;
        }
        CreateTopicsResponseData other = (CreateTopicsResponseData)obj;
        if (this.throttleTimeMs != other.throttleTimeMs) {
            return false;
        }
        return !(this.topics == null ? other.topics != null : !this.topics.equals((Object)other.topics));
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = 31 * hashCode + this.throttleTimeMs;
        hashCode = 31 * hashCode + (this.topics == null ? 0 : this.topics.hashCode());
        return hashCode;
    }

    public CreateTopicsResponseData duplicate() {
        CreateTopicsResponseData _duplicate = new CreateTopicsResponseData();
        _duplicate.throttleTimeMs = this.throttleTimeMs;
        CreatableTopicResultCollection newTopics = new CreatableTopicResultCollection(this.topics.size());
        Iterator iterator = this.topics.iterator();
        while (iterator.hasNext()) {
            CreatableTopicResult _element = (CreatableTopicResult)iterator.next();
            newTopics.add(_element.duplicate());
        }
        _duplicate.topics = newTopics;
        return _duplicate;
    }

    public String toString() {
        return "CreateTopicsResponseData(throttleTimeMs=" + this.throttleTimeMs + ", topics=" + MessageUtil.deepToString((Iterator)this.topics.iterator()) + ")";
    }

    public int throttleTimeMs() {
        return this.throttleTimeMs;
    }

    public CreatableTopicResultCollection topics() {
        return this.topics;
    }

    public List<RawTaggedField> unknownTaggedFields() {
        if (this._unknownTaggedFields == null) {
            this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
        }
        return this._unknownTaggedFields;
    }

    public CreateTopicsResponseData setThrottleTimeMs(int v) {
        this.throttleTimeMs = v;
        return this;
    }

    public CreateTopicsResponseData setTopics(CreatableTopicResultCollection v) {
        this.topics = v;
        return this;
    }

    static {
        SCHEMA_4 = SCHEMA_3 = (SCHEMA_2 = new Schema(new Field[]{new Field("throttle_time_ms", (Type)Type.INT32, "The duration in milliseconds for which the request was throttled due to a quota violation, or zero if the request did not violate any quota."), new Field("topics", (Type)new ArrayOf((Type)CreatableTopicResult.SCHEMA_1), "Results for each topic we tried to create.")}));
        SCHEMA_5 = new Schema(new Field[]{new Field("throttle_time_ms", (Type)Type.INT32, "The duration in milliseconds for which the request was throttled due to a quota violation, or zero if the request did not violate any quota."), new Field("topics", (Type)new CompactArrayOf((Type)CreatableTopicResult.SCHEMA_5), "Results for each topic we tried to create."), Field.TaggedFieldsSection.of((Object[])new Object[0])});
        SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1, SCHEMA_2, SCHEMA_3, SCHEMA_4, SCHEMA_5};
    }

    public static class CreatableTopicResultCollection
    extends ImplicitLinkedHashMultiCollection<CreatableTopicResult> {
        public CreatableTopicResultCollection() {
        }

        public CreatableTopicResultCollection(int expectedNumElements) {
            super(expectedNumElements);
        }

        public CreatableTopicResultCollection(Iterator<CreatableTopicResult> iterator) {
            super(iterator);
        }

        public CreatableTopicResult find(String name) {
            CreatableTopicResult _key = new CreatableTopicResult();
            _key.setName(name);
            return (CreatableTopicResult)this.find(_key);
        }

        public List<CreatableTopicResult> findAll(String name) {
            CreatableTopicResult _key = new CreatableTopicResult();
            _key.setName(name);
            return this.findAll(_key);
        }

        public CreatableTopicResultCollection duplicate() {
            CreatableTopicResultCollection _duplicate = new CreatableTopicResultCollection(this.size());
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                CreatableTopicResult _element = (CreatableTopicResult)iterator.next();
                _duplicate.add(_element.duplicate());
            }
            return _duplicate;
        }
    }

    public static class CreatableTopicConfigs
    implements Message {
        private String name;
        private String value;
        private boolean readOnly;
        private byte configSource;
        private boolean isSensitive;
        private List<RawTaggedField> _unknownTaggedFields;
        public static final Schema SCHEMA_5 = new Schema(new Field[]{new Field("name", (Type)Type.COMPACT_STRING, "The configuration name."), new Field("value", (Type)Type.COMPACT_NULLABLE_STRING, "The configuration value."), new Field("read_only", (Type)Type.BOOLEAN, "True if the configuration is read-only."), new Field("config_source", (Type)Type.INT8, "The configuration source."), new Field("is_sensitive", (Type)Type.BOOLEAN, "True if this configuration is sensitive."), Field.TaggedFieldsSection.of((Object[])new Object[0])});
        public static final Schema[] SCHEMAS = new Schema[]{null, null, null, null, null, SCHEMA_5};

        public CreatableTopicConfigs(Readable _readable, short _version) {
            this.read(_readable, _version);
        }

        public CreatableTopicConfigs(Struct _struct, short _version) {
            this.fromStruct(_struct, _version);
        }

        public CreatableTopicConfigs() {
            this.name = "";
            this.value = "";
            this.readOnly = false;
            this.configSource = (byte)-1;
            this.isSensitive = false;
        }

        public short lowestSupportedVersion() {
            return 0;
        }

        public short highestSupportedVersion() {
            return 5;
        }

        public void read(Readable _readable, short _version) {
            if (_version > 5) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of CreatableTopicConfigs");
            }
            int length = _readable.readUnsignedVarint() - 1;
            if (length < 0) {
                throw new RuntimeException("non-nullable field name was serialized as null");
            }
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field name had invalid length " + length);
            }
            this.name = _readable.readString(length);
            length = _readable.readUnsignedVarint() - 1;
            if (length < 0) {
                this.value = null;
            } else {
                if (length > Short.MAX_VALUE) {
                    throw new RuntimeException("string field value had invalid length " + length);
                }
                this.value = _readable.readString(length);
            }
            this.readOnly = _readable.readByte() != 0;
            this.configSource = _readable.readByte();
            this.isSensitive = _readable.readByte() != 0;
            this._unknownTaggedFields = null;
            int _numTaggedFields = _readable.readUnsignedVarint();
            for (int _i = 0; _i < _numTaggedFields; ++_i) {
                int _tag = _readable.readUnsignedVarint();
                int _size = _readable.readUnsignedVarint();
                switch (_tag) {
                    default: 
                }
                this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
            }
        }

        public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
            if (_version < 5) {
                throw new UnsupportedVersionException("Can't write version " + _version + " of CreatableTopicConfigs");
            }
            int _numTaggedFields = 0;
            byte[] _stringBytes = _cache.getSerializedValue((Object)this.name);
            _writable.writeUnsignedVarint(_stringBytes.length + 1);
            _writable.writeByteArray(_stringBytes);
            if (this.value == null) {
                _writable.writeUnsignedVarint(0);
            } else {
                _stringBytes = _cache.getSerializedValue((Object)this.value);
                _writable.writeUnsignedVarint(_stringBytes.length + 1);
                _writable.writeByteArray(_stringBytes);
            }
            _writable.writeByte(this.readOnly ? (byte)1 : 0);
            _writable.writeByte(this.configSource);
            _writable.writeByte(this.isSensitive ? (byte)1 : 0);
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            _writable.writeUnsignedVarint(_numTaggedFields += _rawWriter.numFields());
            _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
        }

        public void fromStruct(Struct struct, short _version) {
            if (_version > 5) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of CreatableTopicConfigs");
            }
            NavigableMap _taggedFields = null;
            this._unknownTaggedFields = null;
            _taggedFields = (NavigableMap)struct.get("_tagged_fields");
            this.name = struct.getString("name");
            this.value = struct.getString("value");
            this.readOnly = struct.getBoolean("read_only");
            this.configSource = struct.getByte("config_source");
            this.isSensitive = struct.getBoolean("is_sensitive");
            if (!_taggedFields.isEmpty()) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(_taggedFields.size());
                for (Map.Entry entry : _taggedFields.entrySet()) {
                    this._unknownTaggedFields.add((RawTaggedField)entry.getValue());
                }
            }
        }

        public Struct toStruct(short _version) {
            if (_version > 5) {
                throw new UnsupportedVersionException("Can't write version " + _version + " of CreatableTopicConfigs");
            }
            TreeMap _taggedFields = null;
            _taggedFields = new TreeMap();
            Struct struct = new Struct(SCHEMAS[_version]);
            struct.set("name", (Object)this.name);
            struct.set("value", (Object)this.value);
            struct.set("read_only", (Object)this.readOnly);
            struct.set("config_source", (Object)this.configSource);
            struct.set("is_sensitive", (Object)this.isSensitive);
            struct.set("_tagged_fields", _taggedFields);
            return struct;
        }

        public int size(ObjectSerializationCache _cache, short _version) {
            int _size = 0;
            int _numTaggedFields = 0;
            if (_version > 5) {
                throw new UnsupportedVersionException("Can't size version " + _version + " of CreatableTopicConfigs");
            }
            byte[] _stringBytes = this.name.getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'name' field is too long to be serialized");
            }
            _cache.cacheSerializedValue((Object)this.name, _stringBytes);
            _size += _stringBytes.length + ByteUtils.sizeOfUnsignedVarint((int)(_stringBytes.length + 1));
            if (this.value == null) {
                ++_size;
            } else {
                _stringBytes = this.value.getBytes(StandardCharsets.UTF_8);
                if (_stringBytes.length > Short.MAX_VALUE) {
                    throw new RuntimeException("'value' field is too long to be serialized");
                }
                _cache.cacheSerializedValue((Object)this.value, _stringBytes);
                _size += _stringBytes.length + ByteUtils.sizeOfUnsignedVarint((int)(_stringBytes.length + 1));
            }
            ++_size;
            ++_size;
            ++_size;
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size += ByteUtils.sizeOfUnsignedVarint((int)_field.tag());
                    _size += ByteUtils.sizeOfUnsignedVarint((int)_field.size());
                    _size += _field.size();
                }
            }
            return _size += ByteUtils.sizeOfUnsignedVarint((int)_numTaggedFields);
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof CreatableTopicConfigs)) {
                return false;
            }
            CreatableTopicConfigs other = (CreatableTopicConfigs)obj;
            if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
                return false;
            }
            if (this.value == null ? other.value != null : !this.value.equals(other.value)) {
                return false;
            }
            if (this.readOnly != other.readOnly) {
                return false;
            }
            if (this.configSource != other.configSource) {
                return false;
            }
            return this.isSensitive == other.isSensitive;
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + (this.name == null ? 0 : this.name.hashCode());
            hashCode = 31 * hashCode + (this.value == null ? 0 : this.value.hashCode());
            hashCode = 31 * hashCode + (this.readOnly ? 1231 : 1237);
            hashCode = 31 * hashCode + this.configSource;
            hashCode = 31 * hashCode + (this.isSensitive ? 1231 : 1237);
            return hashCode;
        }

        public CreatableTopicConfigs duplicate() {
            CreatableTopicConfigs _duplicate = new CreatableTopicConfigs();
            _duplicate.name = this.name;
            _duplicate.value = this.value == null ? null : this.value;
            _duplicate.readOnly = this.readOnly;
            _duplicate.configSource = this.configSource;
            _duplicate.isSensitive = this.isSensitive;
            return _duplicate;
        }

        public String toString() {
            return "CreatableTopicConfigs(name=" + (this.name == null ? "null" : "'" + this.name.toString() + "'") + ", value=" + (this.value == null ? "null" : "'" + this.value.toString() + "'") + ", readOnly=" + (this.readOnly ? "true" : "false") + ", configSource=" + this.configSource + ", isSensitive=" + (this.isSensitive ? "true" : "false") + ")";
        }

        public String name() {
            return this.name;
        }

        public String value() {
            return this.value;
        }

        public boolean readOnly() {
            return this.readOnly;
        }

        public byte configSource() {
            return this.configSource;
        }

        public boolean isSensitive() {
            return this.isSensitive;
        }

        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public CreatableTopicConfigs setName(String v) {
            this.name = v;
            return this;
        }

        public CreatableTopicConfigs setValue(String v) {
            this.value = v;
            return this;
        }

        public CreatableTopicConfigs setReadOnly(boolean v) {
            this.readOnly = v;
            return this;
        }

        public CreatableTopicConfigs setConfigSource(byte v) {
            this.configSource = v;
            return this;
        }

        public CreatableTopicConfigs setIsSensitive(boolean v) {
            this.isSensitive = v;
            return this;
        }
    }

    public static class CreatableTopicResult
    implements Message,
    ImplicitLinkedHashCollection.Element {
        private String name;
        private short errorCode;
        private String errorMessage;
        private short topicConfigErrorCode;
        private int numPartitions;
        private short replicationFactor;
        private List<CreatableTopicConfigs> configs;
        private List<RawTaggedField> _unknownTaggedFields;
        private int next;
        private int prev;
        public static final Schema SCHEMA_0 = new Schema(new Field[]{new Field("name", (Type)Type.STRING, "The topic name."), new Field("error_code", (Type)Type.INT16, "The error code, or 0 if there was no error.")});
        public static final Schema SCHEMA_1;
        public static final Schema SCHEMA_2;
        public static final Schema SCHEMA_3;
        public static final Schema SCHEMA_4;
        public static final Schema SCHEMA_5;
        public static final Schema[] SCHEMAS;

        public CreatableTopicResult(Readable _readable, short _version) {
            this.read(_readable, _version);
            this.prev = -2;
            this.next = -2;
        }

        public CreatableTopicResult(Struct _struct, short _version) {
            this.fromStruct(_struct, _version);
            this.prev = -2;
            this.next = -2;
        }

        public CreatableTopicResult() {
            this.name = "";
            this.errorCode = 0;
            this.errorMessage = "";
            this.topicConfigErrorCode = 0;
            this.numPartitions = -1;
            this.replicationFactor = (short)-1;
            this.configs = new ArrayList<CreatableTopicConfigs>(0);
            this.prev = -2;
            this.next = -2;
        }

        public short lowestSupportedVersion() {
            return 0;
        }

        public short highestSupportedVersion() {
            return 5;
        }

        public void read(Readable _readable, short _version) {
            if (_version > 5) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of CreatableTopicResult");
            }
            int length = _version >= 5 ? _readable.readUnsignedVarint() - 1 : _readable.readShort();
            if (length < 0) {
                throw new RuntimeException("non-nullable field name was serialized as null");
            }
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field name had invalid length " + length);
            }
            this.name = _readable.readString(length);
            this.errorCode = _readable.readShort();
            if (_version >= 1) {
                length = _version >= 5 ? _readable.readUnsignedVarint() - 1 : (int)_readable.readShort();
                if (length < 0) {
                    this.errorMessage = null;
                } else {
                    if (length > Short.MAX_VALUE) {
                        throw new RuntimeException("string field errorMessage had invalid length " + length);
                    }
                    this.errorMessage = _readable.readString(length);
                }
            } else {
                this.errorMessage = "";
            }
            this.topicConfigErrorCode = 0;
            this.numPartitions = _version >= 5 ? _readable.readInt() : -1;
            this.replicationFactor = _version >= 5 ? _readable.readShort() : (short)-1;
            if (_version >= 5) {
                int arrayLength = _readable.readUnsignedVarint() - 1;
                if (arrayLength < 0) {
                    this.configs = null;
                } else {
                    ArrayList<CreatableTopicConfigs> newCollection = new ArrayList<CreatableTopicConfigs>(arrayLength);
                    for (int i = 0; i < arrayLength; ++i) {
                        newCollection.add(new CreatableTopicConfigs(_readable, _version));
                    }
                    this.configs = newCollection;
                }
            } else {
                this.configs = new ArrayList<CreatableTopicConfigs>(0);
            }
            this._unknownTaggedFields = null;
            if (_version >= 5) {
                int _numTaggedFields = _readable.readUnsignedVarint();
                block4: for (int _i = 0; _i < _numTaggedFields; ++_i) {
                    int _tag = _readable.readUnsignedVarint();
                    int _size = _readable.readUnsignedVarint();
                    switch (_tag) {
                        case 0: {
                            this.topicConfigErrorCode = _readable.readShort();
                            continue block4;
                        }
                        default: {
                            this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
                        }
                    }
                }
            }
        }

        public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
            int _numTaggedFields = 0;
            Object _stringBytes = _cache.getSerializedValue((Object)this.name);
            if (_version >= 5) {
                _writable.writeUnsignedVarint(((byte[])_stringBytes).length + 1);
            } else {
                _writable.writeShort((short)((byte[])_stringBytes).length);
            }
            _writable.writeByteArray((byte[])_stringBytes);
            _writable.writeShort(this.errorCode);
            if (_version >= 1) {
                if (this.errorMessage == null) {
                    if (_version >= 5) {
                        _writable.writeUnsignedVarint(0);
                    } else {
                        _writable.writeShort((short)-1);
                    }
                } else {
                    _stringBytes = _cache.getSerializedValue((Object)this.errorMessage);
                    if (_version >= 5) {
                        _writable.writeUnsignedVarint(((byte[])_stringBytes).length + 1);
                    } else {
                        _writable.writeShort((short)((byte[])_stringBytes).length);
                    }
                    _writable.writeByteArray((byte[])_stringBytes);
                }
            }
            if (_version >= 5 && this.topicConfigErrorCode != 0) {
                ++_numTaggedFields;
            }
            if (_version >= 5) {
                _writable.writeInt(this.numPartitions);
            }
            if (_version >= 5) {
                _writable.writeShort(this.replicationFactor);
            }
            if (_version >= 5) {
                if (this.configs == null) {
                    _writable.writeUnsignedVarint(0);
                } else {
                    _writable.writeUnsignedVarint(this.configs.size() + 1);
                    _stringBytes = this.configs.iterator();
                    while (_stringBytes.hasNext()) {
                        CreatableTopicConfigs configsElement = (CreatableTopicConfigs)_stringBytes.next();
                        configsElement.write(_writable, _cache, _version);
                    }
                }
            }
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            _numTaggedFields += _rawWriter.numFields();
            if (_version >= 5) {
                _writable.writeUnsignedVarint(_numTaggedFields);
                if (this.topicConfigErrorCode != 0) {
                    _writable.writeUnsignedVarint(0);
                    _writable.writeUnsignedVarint(2);
                    _writable.writeShort(this.topicConfigErrorCode);
                }
                _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
            } else if (_numTaggedFields > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
        }

        public void fromStruct(Struct struct, short _version) {
            if (_version > 5) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of CreatableTopicResult");
            }
            NavigableMap _taggedFields = null;
            this._unknownTaggedFields = null;
            if (_version >= 5) {
                _taggedFields = (NavigableMap)struct.get("_tagged_fields");
            }
            this.name = struct.getString("name");
            this.errorCode = struct.getShort("error_code");
            this.errorMessage = _version >= 1 ? struct.getString("error_message") : "";
            this.topicConfigErrorCode = _version >= 5 ? (_taggedFields.containsKey(0) ? (Short)_taggedFields.remove(0) : (short)0) : (short)0;
            this.numPartitions = _version >= 5 ? struct.getInt("num_partitions") : -1;
            this.replicationFactor = _version >= 5 ? struct.getShort("replication_factor") : (short)-1;
            if (_version >= 5) {
                Object[] _nestedObjects = struct.getArray("configs");
                if (_nestedObjects == null) {
                    this.configs = null;
                } else {
                    this.configs = new ArrayList<CreatableTopicConfigs>(_nestedObjects.length);
                    for (Object nestedObject : _nestedObjects) {
                        this.configs.add(new CreatableTopicConfigs((Struct)nestedObject, _version));
                    }
                }
            } else {
                this.configs = new ArrayList<CreatableTopicConfigs>(0);
            }
            if (_version >= 5 && !_taggedFields.isEmpty()) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(_taggedFields.size());
                for (Map.Entry entry : _taggedFields.entrySet()) {
                    this._unknownTaggedFields.add((RawTaggedField)entry.getValue());
                }
            }
        }

        public Struct toStruct(short _version) {
            if (_version > 5) {
                throw new UnsupportedVersionException("Can't write version " + _version + " of CreatableTopicResult");
            }
            TreeMap<Integer, Short> _taggedFields = null;
            if (_version >= 5) {
                _taggedFields = new TreeMap<Integer, Short>();
            }
            Struct struct = new Struct(SCHEMAS[_version]);
            struct.set("name", (Object)this.name);
            struct.set("error_code", (Object)this.errorCode);
            if (_version >= 1) {
                struct.set("error_message", (Object)this.errorMessage);
            }
            if (_version >= 5 && this.topicConfigErrorCode != 0) {
                _taggedFields.put(0, this.topicConfigErrorCode);
            }
            if (_version >= 5) {
                struct.set("num_partitions", (Object)this.numPartitions);
            }
            if (_version >= 5) {
                struct.set("replication_factor", (Object)this.replicationFactor);
            }
            if (_version >= 5) {
                if (this.configs == null) {
                    struct.set("configs", null);
                } else {
                    Struct[] _nestedObjects = new Struct[this.configs.size()];
                    int i = 0;
                    for (CreatableTopicConfigs element : this.configs) {
                        _nestedObjects[i++] = element.toStruct(_version);
                    }
                    struct.set("configs", (Object)_nestedObjects);
                }
            }
            if (_version >= 5) {
                struct.set("_tagged_fields", _taggedFields);
            }
            return struct;
        }

        public int size(ObjectSerializationCache _cache, short _version) {
            int _size = 0;
            int _numTaggedFields = 0;
            if (_version > 5) {
                throw new UnsupportedVersionException("Can't size version " + _version + " of CreatableTopicResult");
            }
            byte[] _stringBytes = this.name.getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'name' field is too long to be serialized");
            }
            _cache.cacheSerializedValue((Object)this.name, _stringBytes);
            _size = _version >= 5 ? (_size += _stringBytes.length + ByteUtils.sizeOfUnsignedVarint((int)(_stringBytes.length + 1))) : (_size += _stringBytes.length + 2);
            _size += 2;
            if (_version >= 1) {
                if (this.errorMessage == null) {
                    _size = _version >= 5 ? ++_size : (_size += 2);
                } else {
                    _stringBytes = this.errorMessage.getBytes(StandardCharsets.UTF_8);
                    if (_stringBytes.length > Short.MAX_VALUE) {
                        throw new RuntimeException("'errorMessage' field is too long to be serialized");
                    }
                    _cache.cacheSerializedValue((Object)this.errorMessage, _stringBytes);
                    _size = _version >= 5 ? (_size += _stringBytes.length + ByteUtils.sizeOfUnsignedVarint((int)(_stringBytes.length + 1))) : (_size += _stringBytes.length + 2);
                }
            }
            if (_version >= 5 && this.topicConfigErrorCode != 0) {
                ++_numTaggedFields;
                ++_size;
                ++_size;
                _size += 2;
            }
            if (_version >= 5) {
                _size += 4;
            }
            if (_version >= 5) {
                _size += 2;
            }
            if (_version >= 5) {
                if (this.configs == null) {
                    ++_size;
                } else {
                    int _arraySize = 0;
                    _arraySize += ByteUtils.sizeOfUnsignedVarint((int)(this.configs.size() + 1));
                    for (CreatableTopicConfigs configsElement : this.configs) {
                        _arraySize += configsElement.size(_cache, _version);
                    }
                    _size += _arraySize;
                }
            }
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size += ByteUtils.sizeOfUnsignedVarint((int)_field.tag());
                    _size += ByteUtils.sizeOfUnsignedVarint((int)_field.size());
                    _size += _field.size();
                }
            }
            if (_version >= 5) {
                _size += ByteUtils.sizeOfUnsignedVarint((int)_numTaggedFields);
            } else if (_numTaggedFields > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
            return _size;
        }

        public boolean elementKeysAreEqual(Object obj) {
            if (!(obj instanceof CreatableTopicResult)) {
                return false;
            }
            CreatableTopicResult other = (CreatableTopicResult)obj;
            return !(this.name == null ? other.name != null : !this.name.equals(other.name));
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof CreatableTopicResult)) {
                return false;
            }
            CreatableTopicResult other = (CreatableTopicResult)obj;
            if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
                return false;
            }
            if (this.errorCode != other.errorCode) {
                return false;
            }
            if (this.errorMessage == null ? other.errorMessage != null : !this.errorMessage.equals(other.errorMessage)) {
                return false;
            }
            if (this.topicConfigErrorCode != other.topicConfigErrorCode) {
                return false;
            }
            if (this.numPartitions != other.numPartitions) {
                return false;
            }
            if (this.replicationFactor != other.replicationFactor) {
                return false;
            }
            return !(this.configs == null ? other.configs != null : !this.configs.equals(other.configs));
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + (this.name == null ? 0 : this.name.hashCode());
            return hashCode;
        }

        public CreatableTopicResult duplicate() {
            CreatableTopicResult _duplicate = new CreatableTopicResult();
            _duplicate.name = this.name;
            _duplicate.errorCode = this.errorCode;
            _duplicate.errorMessage = this.errorMessage == null ? null : this.errorMessage;
            _duplicate.topicConfigErrorCode = this.topicConfigErrorCode;
            _duplicate.numPartitions = this.numPartitions;
            _duplicate.replicationFactor = this.replicationFactor;
            if (this.configs == null) {
                _duplicate.configs = null;
            } else {
                ArrayList<CreatableTopicConfigs> newConfigs = new ArrayList<CreatableTopicConfigs>(this.configs.size());
                for (CreatableTopicConfigs _element : this.configs) {
                    newConfigs.add(_element.duplicate());
                }
                _duplicate.configs = newConfigs;
            }
            return _duplicate;
        }

        public String toString() {
            return "CreatableTopicResult(name=" + (this.name == null ? "null" : "'" + this.name.toString() + "'") + ", errorCode=" + this.errorCode + ", errorMessage=" + (this.errorMessage == null ? "null" : "'" + this.errorMessage.toString() + "'") + ", topicConfigErrorCode=" + this.topicConfigErrorCode + ", numPartitions=" + this.numPartitions + ", replicationFactor=" + this.replicationFactor + ", configs=" + (this.configs == null ? "null" : MessageUtil.deepToString(this.configs.iterator())) + ")";
        }

        public String name() {
            return this.name;
        }

        public short errorCode() {
            return this.errorCode;
        }

        public String errorMessage() {
            return this.errorMessage;
        }

        public short topicConfigErrorCode() {
            return this.topicConfigErrorCode;
        }

        public int numPartitions() {
            return this.numPartitions;
        }

        public short replicationFactor() {
            return this.replicationFactor;
        }

        public List<CreatableTopicConfigs> configs() {
            return this.configs;
        }

        public int next() {
            return this.next;
        }

        public int prev() {
            return this.prev;
        }

        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public CreatableTopicResult setName(String v) {
            this.name = v;
            return this;
        }

        public CreatableTopicResult setErrorCode(short v) {
            this.errorCode = v;
            return this;
        }

        public CreatableTopicResult setErrorMessage(String v) {
            this.errorMessage = v;
            return this;
        }

        public CreatableTopicResult setTopicConfigErrorCode(short v) {
            this.topicConfigErrorCode = v;
            return this;
        }

        public CreatableTopicResult setNumPartitions(int v) {
            this.numPartitions = v;
            return this;
        }

        public CreatableTopicResult setReplicationFactor(short v) {
            this.replicationFactor = v;
            return this;
        }

        public CreatableTopicResult setConfigs(List<CreatableTopicConfigs> v) {
            this.configs = v;
            return this;
        }

        public void setNext(int v) {
            this.next = v;
        }

        public void setPrev(int v) {
            this.prev = v;
        }

        static {
            SCHEMA_4 = SCHEMA_3 = (SCHEMA_2 = (SCHEMA_1 = new Schema(new Field[]{new Field("name", (Type)Type.STRING, "The topic name."), new Field("error_code", (Type)Type.INT16, "The error code, or 0 if there was no error."), new Field("error_message", (Type)Type.NULLABLE_STRING, "The error message, or null if there was no error.")})));
            SCHEMA_5 = new Schema(new Field[]{new Field("name", (Type)Type.COMPACT_STRING, "The topic name."), new Field("error_code", (Type)Type.INT16, "The error code, or 0 if there was no error."), new Field("error_message", (Type)Type.COMPACT_NULLABLE_STRING, "The error message, or null if there was no error."), new Field("num_partitions", (Type)Type.INT32, "Number of partitions of the topic."), new Field("replication_factor", (Type)Type.INT16, "Replication factor of the topic."), new Field("configs", (Type)CompactArrayOf.nullable((Type)CreatableTopicConfigs.SCHEMA_5), "Configuration of the topic."), Field.TaggedFieldsSection.of((Object[])new Object[]{0, new Field("topic_config_error_code", (Type)Type.INT16, "Optional topic config error returned if configs are not returned in the response.")})});
            SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1, SCHEMA_2, SCHEMA_3, SCHEMA_4, SCHEMA_5};
        }
    }
}

