/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.protocol.types;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.List;
import org.apache.kafka.common.protocol.ByteBufferAccessor;
import org.apache.kafka.common.protocol.Writable;
import org.apache.kafka.common.protocol.types.RawTaggedField;
import org.apache.kafka.common.protocol.types.RawTaggedFieldWriter;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.Timeout;

public class RawTaggedFieldWriterTest {
    @Rule
    public final Timeout globalTimeout = Timeout.millis((long)120000L);

    @Test
    public void testWritingZeroRawTaggedFields() {
        RawTaggedFieldWriter writer = RawTaggedFieldWriter.forFields(null);
        Assert.assertEquals((long)0L, (long)writer.numFields());
        ByteBufferAccessor accessor = new ByteBufferAccessor(ByteBuffer.allocate(0));
        writer.writeRawTags((Writable)accessor, Integer.MAX_VALUE);
    }

    @Test
    public void testWritingSeveralRawTaggedFields() {
        List<RawTaggedField> tags = Arrays.asList(new RawTaggedField(2, new byte[]{1, 2, 3}), new RawTaggedField(5, new byte[]{4, 5}));
        RawTaggedFieldWriter writer = RawTaggedFieldWriter.forFields(tags);
        Assert.assertEquals((long)2L, (long)writer.numFields());
        byte[] arr = new byte[9];
        ByteBufferAccessor accessor = new ByteBufferAccessor(ByteBuffer.wrap(arr));
        writer.writeRawTags((Writable)accessor, 1);
        Assert.assertArrayEquals((byte[])new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0}, (byte[])arr);
        writer.writeRawTags((Writable)accessor, 3);
        Assert.assertArrayEquals((byte[])new byte[]{2, 3, 1, 2, 3, 0, 0, 0, 0}, (byte[])arr);
        writer.writeRawTags((Writable)accessor, 7);
        Assert.assertArrayEquals((byte[])new byte[]{2, 3, 1, 2, 3, 5, 2, 4, 5}, (byte[])arr);
        writer.writeRawTags((Writable)accessor, Integer.MAX_VALUE);
        Assert.assertArrayEquals((byte[])new byte[]{2, 3, 1, 2, 3, 5, 2, 4, 5}, (byte[])arr);
    }

    @Test
    public void testInvalidNextDefinedTag() {
        List<RawTaggedField> tags = Arrays.asList(new RawTaggedField(2, new byte[]{1, 2, 3}), new RawTaggedField(5, new byte[]{4, 5, 6}), new RawTaggedField(7, new byte[]{0}));
        RawTaggedFieldWriter writer = RawTaggedFieldWriter.forFields(tags);
        Assert.assertEquals((long)3L, (long)writer.numFields());
        try {
            writer.writeRawTags((Writable)new ByteBufferAccessor(ByteBuffer.allocate(1024)), 2);
            Assert.fail((String)"expected to get RuntimeException");
        }
        catch (RuntimeException e) {
            Assert.assertEquals((Object)"Attempted to use tag 2 as an undefined tag.", (Object)e.getMessage());
        }
    }

    @Test
    public void testOutOfOrderTags() {
        List<RawTaggedField> tags = Arrays.asList(new RawTaggedField(5, new byte[]{4, 5, 6}), new RawTaggedField(2, new byte[]{1, 2, 3}), new RawTaggedField(7, new byte[]{0}));
        RawTaggedFieldWriter writer = RawTaggedFieldWriter.forFields(tags);
        Assert.assertEquals((long)3L, (long)writer.numFields());
        try {
            writer.writeRawTags((Writable)new ByteBufferAccessor(ByteBuffer.allocate(1024)), 8);
            Assert.fail((String)"expected to get RuntimeException");
        }
        catch (RuntimeException e) {
            Assert.assertEquals((Object)"Invalid raw tag field list: tag 2 comes after tag 5, but is not higher than it.", (Object)e.getMessage());
        }
    }
}

