/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.message;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.IntNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.LongNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.ShortNode;
import com.fasterxml.jackson.databind.node.TextNode;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.Message;
import org.apache.kafka.common.protocol.MessageUtil;
import org.apache.kafka.common.protocol.ObjectSerializationCache;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.protocol.Writable;
import org.apache.kafka.common.protocol.types.ArrayOf;
import org.apache.kafka.common.protocol.types.Field;
import org.apache.kafka.common.protocol.types.RawTaggedField;
import org.apache.kafka.common.protocol.types.RawTaggedFieldWriter;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Struct;
import org.apache.kafka.common.protocol.types.Type;
import org.apache.kafka.common.utils.ByteUtils;

public class ListOffsetResponseData
implements ApiMessage {
    private int throttleTimeMs;
    private List<ListOffsetTopicResponse> topics;
    private List<RawTaggedField> _unknownTaggedFields;
    public static final Schema SCHEMA_0 = new Schema(new Field[]{new Field("topics", (Type)new ArrayOf((Type)ListOffsetTopicResponse.SCHEMA_0), "Each topic in the response.")});
    public static final Schema SCHEMA_1 = new Schema(new Field[]{new Field("topics", (Type)new ArrayOf((Type)ListOffsetTopicResponse.SCHEMA_1), "Each topic in the response.")});
    public static final Schema SCHEMA_2;
    public static final Schema SCHEMA_3;
    public static final Schema SCHEMA_4;
    public static final Schema SCHEMA_5;
    public static final Schema[] SCHEMAS;

    public ListOffsetResponseData(Readable _readable, short _version) {
        this.read(_readable, _version);
    }

    public ListOffsetResponseData(Struct _struct, short _version) {
        this.fromStruct(_struct, _version);
    }

    public ListOffsetResponseData(JsonNode _node, short _version) {
        this.fromJson(_node, _version);
    }

    public ListOffsetResponseData() {
        this.throttleTimeMs = 0;
        this.topics = new ArrayList<ListOffsetTopicResponse>(0);
    }

    public short apiKey() {
        return 2;
    }

    public short lowestSupportedVersion() {
        return 0;
    }

    public short highestSupportedVersion() {
        return 5;
    }

    public void read(Readable _readable, short _version) {
        this.throttleTimeMs = _version >= 2 ? _readable.readInt() : 0;
        int arrayLength = _readable.readInt();
        if (arrayLength < 0) {
            throw new RuntimeException("non-nullable field topics was serialized as null");
        }
        ArrayList<ListOffsetTopicResponse> newCollection = new ArrayList<ListOffsetTopicResponse>(arrayLength);
        for (int i = 0; i < arrayLength; ++i) {
            newCollection.add(new ListOffsetTopicResponse(_readable, _version));
        }
        this.topics = newCollection;
        this._unknownTaggedFields = null;
    }

    public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
        int _numTaggedFields = 0;
        if (_version >= 2) {
            _writable.writeInt(this.throttleTimeMs);
        }
        _writable.writeInt(this.topics.size());
        for (ListOffsetTopicResponse topicsElement : this.topics) {
            topicsElement.write(_writable, _cache, _version);
        }
        RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
        if ((_numTaggedFields += _rawWriter.numFields()) > 0) {
            throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
        }
    }

    public void fromStruct(Struct struct, short _version) {
        this._unknownTaggedFields = null;
        this.throttleTimeMs = _version >= 2 ? struct.getInt("throttle_time_ms") : 0;
        Object[] _nestedObjects = struct.getArray("topics");
        this.topics = new ArrayList<ListOffsetTopicResponse>(_nestedObjects.length);
        for (Object nestedObject : _nestedObjects) {
            this.topics.add(new ListOffsetTopicResponse((Struct)nestedObject, _version));
        }
    }

    public Struct toStruct(short _version) {
        Object _taggedFields = null;
        Struct struct = new Struct(SCHEMAS[_version]);
        if (_version >= 2) {
            struct.set("throttle_time_ms", (Object)this.throttleTimeMs);
        }
        Struct[] _nestedObjects = new Struct[this.topics.size()];
        int i = 0;
        for (ListOffsetTopicResponse element : this.topics) {
            _nestedObjects[i++] = element.toStruct(_version);
        }
        struct.set("topics", (Object)_nestedObjects);
        return struct;
    }

    public void fromJson(JsonNode _node, short _version) {
        JsonNode _throttleTimeMsNode = _node.get("throttleTimeMs");
        if (_throttleTimeMsNode == null) {
            if (_version >= 2) {
                throw new RuntimeException("ListOffsetResponseData: unable to locate field 'throttleTimeMs', which is mandatory in version " + _version);
            }
            this.throttleTimeMs = 0;
        } else {
            this.throttleTimeMs = MessageUtil.jsonNodeToInt((JsonNode)_throttleTimeMsNode, (String)"ListOffsetResponseData");
        }
        JsonNode _topicsNode = _node.get("topics");
        if (_topicsNode == null) {
            throw new RuntimeException("ListOffsetResponseData: unable to locate field 'topics', which is mandatory in version " + _version);
        }
        if (!_topicsNode.isArray()) {
            throw new RuntimeException("ListOffsetResponseData expected a JSON array, but got " + _node.getNodeType());
        }
        this.topics = new ArrayList<ListOffsetTopicResponse>();
        for (JsonNode _element : _topicsNode) {
            this.topics.add(new ListOffsetTopicResponse(_element, _version));
        }
    }

    public JsonNode toJson(short _version) {
        ObjectNode _node = new ObjectNode(JsonNodeFactory.instance);
        if (_version >= 2) {
            _node.set("throttleTimeMs", (JsonNode)new IntNode(this.throttleTimeMs));
        }
        ArrayNode _topicsArray = new ArrayNode(JsonNodeFactory.instance);
        for (ListOffsetTopicResponse _element : this.topics) {
            _topicsArray.add(_element.toJson(_version));
        }
        _node.set("topics", (JsonNode)_topicsArray);
        return _node;
    }

    public int size(ObjectSerializationCache _cache, short _version) {
        int _size = 0;
        int _numTaggedFields = 0;
        if (_version >= 2) {
            _size += 4;
        }
        int _arraySize = 0;
        _arraySize += 4;
        for (ListOffsetTopicResponse topicsElement : this.topics) {
            _arraySize += topicsElement.size(_cache, _version);
        }
        _size += _arraySize;
        if (this._unknownTaggedFields != null) {
            _numTaggedFields += this._unknownTaggedFields.size();
            for (RawTaggedField _field : this._unknownTaggedFields) {
                _size += ByteUtils.sizeOfUnsignedVarint((int)_field.tag());
                _size += ByteUtils.sizeOfUnsignedVarint((int)_field.size());
                _size += _field.size();
            }
        }
        if (_numTaggedFields > 0) {
            throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
        }
        return _size;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ListOffsetResponseData)) {
            return false;
        }
        ListOffsetResponseData other = (ListOffsetResponseData)obj;
        if (this.throttleTimeMs != other.throttleTimeMs) {
            return false;
        }
        return !(this.topics == null ? other.topics != null : !this.topics.equals(other.topics));
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = 31 * hashCode + this.throttleTimeMs;
        hashCode = 31 * hashCode + (this.topics == null ? 0 : this.topics.hashCode());
        return hashCode;
    }

    public ListOffsetResponseData duplicate() {
        ListOffsetResponseData _duplicate = new ListOffsetResponseData();
        _duplicate.throttleTimeMs = this.throttleTimeMs;
        ArrayList<ListOffsetTopicResponse> newTopics = new ArrayList<ListOffsetTopicResponse>(this.topics.size());
        for (ListOffsetTopicResponse _element : this.topics) {
            newTopics.add(_element.duplicate());
        }
        _duplicate.topics = newTopics;
        return _duplicate;
    }

    public String toString() {
        return "ListOffsetResponseData(throttleTimeMs=" + this.throttleTimeMs + ", topics=" + MessageUtil.deepToString(this.topics.iterator()) + ")";
    }

    public int throttleTimeMs() {
        return this.throttleTimeMs;
    }

    public List<ListOffsetTopicResponse> topics() {
        return this.topics;
    }

    public List<RawTaggedField> unknownTaggedFields() {
        if (this._unknownTaggedFields == null) {
            this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
        }
        return this._unknownTaggedFields;
    }

    public ListOffsetResponseData setThrottleTimeMs(int v) {
        this.throttleTimeMs = v;
        return this;
    }

    public ListOffsetResponseData setTopics(List<ListOffsetTopicResponse> v) {
        this.topics = v;
        return this;
    }

    static {
        SCHEMA_3 = SCHEMA_2 = new Schema(new Field[]{new Field("throttle_time_ms", (Type)Type.INT32, "The duration in milliseconds for which the request was throttled due to a quota violation, or zero if the request did not violate any quota."), new Field("topics", (Type)new ArrayOf((Type)ListOffsetTopicResponse.SCHEMA_1), "Each topic in the response.")});
        SCHEMA_5 = SCHEMA_4 = new Schema(new Field[]{new Field("throttle_time_ms", (Type)Type.INT32, "The duration in milliseconds for which the request was throttled due to a quota violation, or zero if the request did not violate any quota."), new Field("topics", (Type)new ArrayOf((Type)ListOffsetTopicResponse.SCHEMA_4), "Each topic in the response.")});
        SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1, SCHEMA_2, SCHEMA_3, SCHEMA_4, SCHEMA_5};
    }

    public static class ListOffsetPartitionResponse
    implements Message {
        private int partitionIndex;
        private short errorCode;
        private List<Long> oldStyleOffsets;
        private long timestamp;
        private long offset;
        private int leaderEpoch;
        private List<RawTaggedField> _unknownTaggedFields;
        public static final Schema SCHEMA_0 = new Schema(new Field[]{new Field("partition_index", (Type)Type.INT32, "The partition index."), new Field("error_code", (Type)Type.INT16, "The partition error code, or 0 if there was no error."), new Field("old_style_offsets", (Type)new ArrayOf((Type)Type.INT64), "The result offsets.")});
        public static final Schema SCHEMA_1;
        public static final Schema SCHEMA_2;
        public static final Schema SCHEMA_3;
        public static final Schema SCHEMA_4;
        public static final Schema SCHEMA_5;
        public static final Schema[] SCHEMAS;

        public ListOffsetPartitionResponse(Readable _readable, short _version) {
            this.read(_readable, _version);
        }

        public ListOffsetPartitionResponse(Struct _struct, short _version) {
            this.fromStruct(_struct, _version);
        }

        public ListOffsetPartitionResponse(JsonNode _node, short _version) {
            this.fromJson(_node, _version);
        }

        public ListOffsetPartitionResponse() {
            this.partitionIndex = 0;
            this.errorCode = 0;
            this.oldStyleOffsets = new ArrayList<Long>(0);
            this.timestamp = -1L;
            this.offset = -1L;
            this.leaderEpoch = 0;
        }

        public short lowestSupportedVersion() {
            return 0;
        }

        public short highestSupportedVersion() {
            return 5;
        }

        public void read(Readable _readable, short _version) {
            if (_version > 5) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of ListOffsetPartitionResponse");
            }
            this.partitionIndex = _readable.readInt();
            this.errorCode = _readable.readShort();
            if (_version <= 0) {
                int arrayLength = _readable.readInt();
                if (arrayLength < 0) {
                    throw new RuntimeException("non-nullable field oldStyleOffsets was serialized as null");
                }
                ArrayList<Long> newCollection = new ArrayList<Long>(arrayLength);
                for (int i = 0; i < arrayLength; ++i) {
                    newCollection.add(_readable.readLong());
                }
                this.oldStyleOffsets = newCollection;
            } else {
                this.oldStyleOffsets = new ArrayList<Long>(0);
            }
            this.timestamp = _version >= 1 ? _readable.readLong() : -1L;
            this.offset = _version >= 1 ? _readable.readLong() : -1L;
            this.leaderEpoch = _version >= 4 ? _readable.readInt() : 0;
            this._unknownTaggedFields = null;
        }

        public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
            int _numTaggedFields = 0;
            _writable.writeInt(this.partitionIndex);
            _writable.writeShort(this.errorCode);
            if (_version <= 0) {
                _writable.writeInt(this.oldStyleOffsets.size());
                for (Long oldStyleOffsetsElement : this.oldStyleOffsets) {
                    _writable.writeLong(oldStyleOffsetsElement.longValue());
                }
            } else if (!this.oldStyleOffsets.isEmpty()) {
                throw new UnsupportedVersionException("Attempted to write a non-default oldStyleOffsets at version " + _version);
            }
            if (_version >= 1) {
                _writable.writeLong(this.timestamp);
            } else if (this.timestamp != -1L) {
                throw new UnsupportedVersionException("Attempted to write a non-default timestamp at version " + _version);
            }
            if (_version >= 1) {
                _writable.writeLong(this.offset);
            } else if (this.offset != -1L) {
                throw new UnsupportedVersionException("Attempted to write a non-default offset at version " + _version);
            }
            if (_version >= 4) {
                _writable.writeInt(this.leaderEpoch);
            } else if (this.leaderEpoch != 0) {
                throw new UnsupportedVersionException("Attempted to write a non-default leaderEpoch at version " + _version);
            }
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            if ((_numTaggedFields += _rawWriter.numFields()) > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
        }

        public void fromStruct(Struct struct, short _version) {
            if (_version > 5) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of ListOffsetPartitionResponse");
            }
            this._unknownTaggedFields = null;
            this.partitionIndex = struct.getInt("partition_index");
            this.errorCode = struct.getShort("error_code");
            if (_version <= 0) {
                Object[] _nestedObjects = struct.getArray("old_style_offsets");
                this.oldStyleOffsets = new ArrayList<Long>(_nestedObjects.length);
                for (Object nestedObject : _nestedObjects) {
                    this.oldStyleOffsets.add((Long)nestedObject);
                }
            } else {
                this.oldStyleOffsets = new ArrayList<Long>(0);
            }
            this.timestamp = _version >= 1 ? struct.getLong("timestamp") : -1L;
            this.offset = _version >= 1 ? struct.getLong("offset") : -1L;
            this.leaderEpoch = _version >= 4 ? struct.getInt("leader_epoch") : 0;
        }

        public Struct toStruct(short _version) {
            if (_version > 5) {
                throw new UnsupportedVersionException("Can't write version " + _version + " of ListOffsetPartitionResponse");
            }
            Object _taggedFields = null;
            Struct struct = new Struct(SCHEMAS[_version]);
            struct.set("partition_index", (Object)this.partitionIndex);
            struct.set("error_code", (Object)this.errorCode);
            if (_version <= 0) {
                Long[] _nestedObjects = new Long[this.oldStyleOffsets.size()];
                int i = 0;
                for (Long element : this.oldStyleOffsets) {
                    _nestedObjects[i++] = element;
                }
                struct.set("old_style_offsets", (Object)_nestedObjects);
            } else if (!this.oldStyleOffsets.isEmpty()) {
                throw new UnsupportedVersionException("Attempted to write a non-default oldStyleOffsets at version " + _version);
            }
            if (_version >= 1) {
                struct.set("timestamp", (Object)this.timestamp);
            } else if (this.timestamp != -1L) {
                throw new UnsupportedVersionException("Attempted to write a non-default timestamp at version " + _version);
            }
            if (_version >= 1) {
                struct.set("offset", (Object)this.offset);
            } else if (this.offset != -1L) {
                throw new UnsupportedVersionException("Attempted to write a non-default offset at version " + _version);
            }
            if (_version >= 4) {
                struct.set("leader_epoch", (Object)this.leaderEpoch);
            } else if (this.leaderEpoch != 0) {
                throw new UnsupportedVersionException("Attempted to write a non-default leaderEpoch at version " + _version);
            }
            return struct;
        }

        public void fromJson(JsonNode _node, short _version) {
            JsonNode _partitionIndexNode = _node.get("partitionIndex");
            if (_partitionIndexNode == null) {
                throw new RuntimeException("ListOffsetPartitionResponse: unable to locate field 'partitionIndex', which is mandatory in version " + _version);
            }
            this.partitionIndex = MessageUtil.jsonNodeToInt((JsonNode)_partitionIndexNode, (String)"ListOffsetPartitionResponse");
            JsonNode _errorCodeNode = _node.get("errorCode");
            if (_errorCodeNode == null) {
                throw new RuntimeException("ListOffsetPartitionResponse: unable to locate field 'errorCode', which is mandatory in version " + _version);
            }
            this.errorCode = MessageUtil.jsonNodeToShort((JsonNode)_errorCodeNode, (String)"ListOffsetPartitionResponse");
            JsonNode _oldStyleOffsetsNode = _node.get("oldStyleOffsets");
            if (_oldStyleOffsetsNode == null) {
                if (_version <= 0) {
                    throw new RuntimeException("ListOffsetPartitionResponse: unable to locate field 'oldStyleOffsets', which is mandatory in version " + _version);
                }
                this.oldStyleOffsets = new ArrayList<Long>(0);
            } else {
                if (!_oldStyleOffsetsNode.isArray()) {
                    throw new RuntimeException("ListOffsetPartitionResponse expected a JSON array, but got " + _node.getNodeType());
                }
                this.oldStyleOffsets = new ArrayList<Long>();
                for (JsonNode _element : _oldStyleOffsetsNode) {
                    this.oldStyleOffsets.add(MessageUtil.jsonNodeToLong((JsonNode)_element, (String)"ListOffsetPartitionResponse element"));
                }
            }
            JsonNode _timestampNode = _node.get("timestamp");
            if (_timestampNode == null) {
                if (_version >= 1) {
                    throw new RuntimeException("ListOffsetPartitionResponse: unable to locate field 'timestamp', which is mandatory in version " + _version);
                }
                this.timestamp = -1L;
            } else {
                this.timestamp = MessageUtil.jsonNodeToLong((JsonNode)_timestampNode, (String)"ListOffsetPartitionResponse");
            }
            JsonNode _offsetNode = _node.get("offset");
            if (_offsetNode == null) {
                if (_version >= 1) {
                    throw new RuntimeException("ListOffsetPartitionResponse: unable to locate field 'offset', which is mandatory in version " + _version);
                }
                this.offset = -1L;
            } else {
                this.offset = MessageUtil.jsonNodeToLong((JsonNode)_offsetNode, (String)"ListOffsetPartitionResponse");
            }
            JsonNode _leaderEpochNode = _node.get("leaderEpoch");
            if (_leaderEpochNode == null) {
                if (_version >= 4) {
                    throw new RuntimeException("ListOffsetPartitionResponse: unable to locate field 'leaderEpoch', which is mandatory in version " + _version);
                }
                this.leaderEpoch = 0;
            } else {
                this.leaderEpoch = MessageUtil.jsonNodeToInt((JsonNode)_leaderEpochNode, (String)"ListOffsetPartitionResponse");
            }
        }

        public JsonNode toJson(short _version) {
            ObjectNode _node = new ObjectNode(JsonNodeFactory.instance);
            _node.set("partitionIndex", (JsonNode)new IntNode(this.partitionIndex));
            _node.set("errorCode", (JsonNode)new ShortNode(this.errorCode));
            if (_version <= 0) {
                ArrayNode _oldStyleOffsetsArray = new ArrayNode(JsonNodeFactory.instance);
                for (Long _element : this.oldStyleOffsets) {
                    _oldStyleOffsetsArray.add((JsonNode)new LongNode(_element.longValue()));
                }
                _node.set("oldStyleOffsets", (JsonNode)_oldStyleOffsetsArray);
            } else if (!this.oldStyleOffsets.isEmpty()) {
                throw new UnsupportedVersionException("Attempted to write a non-default oldStyleOffsets at version " + _version);
            }
            if (_version >= 1) {
                _node.set("timestamp", (JsonNode)new LongNode(this.timestamp));
            } else if (this.timestamp != -1L) {
                throw new UnsupportedVersionException("Attempted to write a non-default timestamp at version " + _version);
            }
            if (_version >= 1) {
                _node.set("offset", (JsonNode)new LongNode(this.offset));
            } else if (this.offset != -1L) {
                throw new UnsupportedVersionException("Attempted to write a non-default offset at version " + _version);
            }
            if (_version >= 4) {
                _node.set("leaderEpoch", (JsonNode)new IntNode(this.leaderEpoch));
            } else if (this.leaderEpoch != 0) {
                throw new UnsupportedVersionException("Attempted to write a non-default leaderEpoch at version " + _version);
            }
            return _node;
        }

        public int size(ObjectSerializationCache _cache, short _version) {
            int _size = 0;
            int _numTaggedFields = 0;
            if (_version > 5) {
                throw new UnsupportedVersionException("Can't size version " + _version + " of ListOffsetPartitionResponse");
            }
            _size += 4;
            _size += 2;
            if (_version <= 0) {
                int _arraySize = 0;
                _arraySize += 4;
                _size += (_arraySize += this.oldStyleOffsets.size() * 8);
            }
            if (_version >= 1) {
                _size += 8;
            }
            if (_version >= 1) {
                _size += 8;
            }
            if (_version >= 4) {
                _size += 4;
            }
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size += ByteUtils.sizeOfUnsignedVarint((int)_field.tag());
                    _size += ByteUtils.sizeOfUnsignedVarint((int)_field.size());
                    _size += _field.size();
                }
            }
            if (_numTaggedFields > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
            return _size;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof ListOffsetPartitionResponse)) {
                return false;
            }
            ListOffsetPartitionResponse other = (ListOffsetPartitionResponse)obj;
            if (this.partitionIndex != other.partitionIndex) {
                return false;
            }
            if (this.errorCode != other.errorCode) {
                return false;
            }
            if (this.oldStyleOffsets == null ? other.oldStyleOffsets != null : !this.oldStyleOffsets.equals(other.oldStyleOffsets)) {
                return false;
            }
            if (this.timestamp != other.timestamp) {
                return false;
            }
            if (this.offset != other.offset) {
                return false;
            }
            return this.leaderEpoch == other.leaderEpoch;
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + this.partitionIndex;
            hashCode = 31 * hashCode + this.errorCode;
            hashCode = 31 * hashCode + (this.oldStyleOffsets == null ? 0 : this.oldStyleOffsets.hashCode());
            hashCode = 31 * hashCode + ((int)(this.timestamp >> 32) ^ (int)this.timestamp);
            hashCode = 31 * hashCode + ((int)(this.offset >> 32) ^ (int)this.offset);
            hashCode = 31 * hashCode + this.leaderEpoch;
            return hashCode;
        }

        public ListOffsetPartitionResponse duplicate() {
            ListOffsetPartitionResponse _duplicate = new ListOffsetPartitionResponse();
            _duplicate.partitionIndex = this.partitionIndex;
            _duplicate.errorCode = this.errorCode;
            ArrayList<Long> newOldStyleOffsets = new ArrayList<Long>(this.oldStyleOffsets.size());
            for (Long _element : this.oldStyleOffsets) {
                newOldStyleOffsets.add(_element);
            }
            _duplicate.oldStyleOffsets = newOldStyleOffsets;
            _duplicate.timestamp = this.timestamp;
            _duplicate.offset = this.offset;
            _duplicate.leaderEpoch = this.leaderEpoch;
            return _duplicate;
        }

        public String toString() {
            return "ListOffsetPartitionResponse(partitionIndex=" + this.partitionIndex + ", errorCode=" + this.errorCode + ", oldStyleOffsets=" + MessageUtil.deepToString(this.oldStyleOffsets.iterator()) + ", timestamp=" + this.timestamp + ", offset=" + this.offset + ", leaderEpoch=" + this.leaderEpoch + ")";
        }

        public int partitionIndex() {
            return this.partitionIndex;
        }

        public short errorCode() {
            return this.errorCode;
        }

        public List<Long> oldStyleOffsets() {
            return this.oldStyleOffsets;
        }

        public long timestamp() {
            return this.timestamp;
        }

        public long offset() {
            return this.offset;
        }

        public int leaderEpoch() {
            return this.leaderEpoch;
        }

        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public ListOffsetPartitionResponse setPartitionIndex(int v) {
            this.partitionIndex = v;
            return this;
        }

        public ListOffsetPartitionResponse setErrorCode(short v) {
            this.errorCode = v;
            return this;
        }

        public ListOffsetPartitionResponse setOldStyleOffsets(List<Long> v) {
            this.oldStyleOffsets = v;
            return this;
        }

        public ListOffsetPartitionResponse setTimestamp(long v) {
            this.timestamp = v;
            return this;
        }

        public ListOffsetPartitionResponse setOffset(long v) {
            this.offset = v;
            return this;
        }

        public ListOffsetPartitionResponse setLeaderEpoch(int v) {
            this.leaderEpoch = v;
            return this;
        }

        static {
            SCHEMA_3 = SCHEMA_2 = (SCHEMA_1 = new Schema(new Field[]{new Field("partition_index", (Type)Type.INT32, "The partition index."), new Field("error_code", (Type)Type.INT16, "The partition error code, or 0 if there was no error."), new Field("timestamp", (Type)Type.INT64, "The timestamp associated with the returned offset."), new Field("offset", (Type)Type.INT64, "The returned offset.")}));
            SCHEMA_5 = SCHEMA_4 = new Schema(new Field[]{new Field("partition_index", (Type)Type.INT32, "The partition index."), new Field("error_code", (Type)Type.INT16, "The partition error code, or 0 if there was no error."), new Field("timestamp", (Type)Type.INT64, "The timestamp associated with the returned offset."), new Field("offset", (Type)Type.INT64, "The returned offset."), new Field("leader_epoch", (Type)Type.INT32, "")});
            SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1, SCHEMA_2, SCHEMA_3, SCHEMA_4, SCHEMA_5};
        }
    }

    public static class ListOffsetTopicResponse
    implements Message {
        private String name;
        private List<ListOffsetPartitionResponse> partitions;
        private List<RawTaggedField> _unknownTaggedFields;
        public static final Schema SCHEMA_0 = new Schema(new Field[]{new Field("name", (Type)Type.STRING, "The topic name"), new Field("partitions", (Type)new ArrayOf((Type)ListOffsetPartitionResponse.SCHEMA_0), "Each partition in the response.")});
        public static final Schema SCHEMA_1;
        public static final Schema SCHEMA_2;
        public static final Schema SCHEMA_3;
        public static final Schema SCHEMA_4;
        public static final Schema SCHEMA_5;
        public static final Schema[] SCHEMAS;

        public ListOffsetTopicResponse(Readable _readable, short _version) {
            this.read(_readable, _version);
        }

        public ListOffsetTopicResponse(Struct _struct, short _version) {
            this.fromStruct(_struct, _version);
        }

        public ListOffsetTopicResponse(JsonNode _node, short _version) {
            this.fromJson(_node, _version);
        }

        public ListOffsetTopicResponse() {
            this.name = "";
            this.partitions = new ArrayList<ListOffsetPartitionResponse>(0);
        }

        public short lowestSupportedVersion() {
            return 0;
        }

        public short highestSupportedVersion() {
            return 5;
        }

        public void read(Readable _readable, short _version) {
            if (_version > 5) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of ListOffsetTopicResponse");
            }
            short length = _readable.readShort();
            if (length < 0) {
                throw new RuntimeException("non-nullable field name was serialized as null");
            }
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field name had invalid length " + length);
            }
            this.name = _readable.readString((int)length);
            int arrayLength = _readable.readInt();
            if (arrayLength < 0) {
                throw new RuntimeException("non-nullable field partitions was serialized as null");
            }
            ArrayList<ListOffsetPartitionResponse> newCollection = new ArrayList<ListOffsetPartitionResponse>(arrayLength);
            for (int i = 0; i < arrayLength; ++i) {
                newCollection.add(new ListOffsetPartitionResponse(_readable, _version));
            }
            this.partitions = newCollection;
            this._unknownTaggedFields = null;
        }

        public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
            int _numTaggedFields = 0;
            Object _stringBytes = _cache.getSerializedValue((Object)this.name);
            _writable.writeShort((short)((byte[])_stringBytes).length);
            _writable.writeByteArray((byte[])_stringBytes);
            _writable.writeInt(this.partitions.size());
            _stringBytes = this.partitions.iterator();
            while (_stringBytes.hasNext()) {
                ListOffsetPartitionResponse partitionsElement = (ListOffsetPartitionResponse)_stringBytes.next();
                partitionsElement.write(_writable, _cache, _version);
            }
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            if ((_numTaggedFields += _rawWriter.numFields()) > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
        }

        public void fromStruct(Struct struct, short _version) {
            if (_version > 5) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of ListOffsetTopicResponse");
            }
            this._unknownTaggedFields = null;
            this.name = struct.getString("name");
            Object[] _nestedObjects = struct.getArray("partitions");
            this.partitions = new ArrayList<ListOffsetPartitionResponse>(_nestedObjects.length);
            for (Object nestedObject : _nestedObjects) {
                this.partitions.add(new ListOffsetPartitionResponse((Struct)nestedObject, _version));
            }
        }

        public Struct toStruct(short _version) {
            if (_version > 5) {
                throw new UnsupportedVersionException("Can't write version " + _version + " of ListOffsetTopicResponse");
            }
            Object _taggedFields = null;
            Struct struct = new Struct(SCHEMAS[_version]);
            struct.set("name", (Object)this.name);
            Struct[] _nestedObjects = new Struct[this.partitions.size()];
            int i = 0;
            for (ListOffsetPartitionResponse element : this.partitions) {
                _nestedObjects[i++] = element.toStruct(_version);
            }
            struct.set("partitions", (Object)_nestedObjects);
            return struct;
        }

        public void fromJson(JsonNode _node, short _version) {
            JsonNode _nameNode = _node.get("name");
            if (_nameNode == null) {
                throw new RuntimeException("ListOffsetTopicResponse: unable to locate field 'name', which is mandatory in version " + _version);
            }
            if (!_nameNode.isTextual()) {
                throw new RuntimeException("ListOffsetTopicResponse expected a string type, but got " + _node.getNodeType());
            }
            this.name = _nameNode.asText();
            JsonNode _partitionsNode = _node.get("partitions");
            if (_partitionsNode == null) {
                throw new RuntimeException("ListOffsetTopicResponse: unable to locate field 'partitions', which is mandatory in version " + _version);
            }
            if (!_partitionsNode.isArray()) {
                throw new RuntimeException("ListOffsetTopicResponse expected a JSON array, but got " + _node.getNodeType());
            }
            this.partitions = new ArrayList<ListOffsetPartitionResponse>();
            for (JsonNode _element : _partitionsNode) {
                this.partitions.add(new ListOffsetPartitionResponse(_element, _version));
            }
        }

        public JsonNode toJson(short _version) {
            ObjectNode _node = new ObjectNode(JsonNodeFactory.instance);
            _node.set("name", (JsonNode)new TextNode(this.name));
            ArrayNode _partitionsArray = new ArrayNode(JsonNodeFactory.instance);
            for (ListOffsetPartitionResponse _element : this.partitions) {
                _partitionsArray.add(_element.toJson(_version));
            }
            _node.set("partitions", (JsonNode)_partitionsArray);
            return _node;
        }

        public int size(ObjectSerializationCache _cache, short _version) {
            int _size = 0;
            int _numTaggedFields = 0;
            if (_version > 5) {
                throw new UnsupportedVersionException("Can't size version " + _version + " of ListOffsetTopicResponse");
            }
            byte[] _stringBytes = this.name.getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'name' field is too long to be serialized");
            }
            _cache.cacheSerializedValue((Object)this.name, _stringBytes);
            _size += _stringBytes.length + 2;
            int _arraySize = 0;
            _arraySize += 4;
            for (ListOffsetPartitionResponse partitionsElement : this.partitions) {
                _arraySize += partitionsElement.size(_cache, _version);
            }
            _size += _arraySize;
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size += ByteUtils.sizeOfUnsignedVarint((int)_field.tag());
                    _size += ByteUtils.sizeOfUnsignedVarint((int)_field.size());
                    _size += _field.size();
                }
            }
            if (_numTaggedFields > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
            return _size;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof ListOffsetTopicResponse)) {
                return false;
            }
            ListOffsetTopicResponse other = (ListOffsetTopicResponse)obj;
            if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
                return false;
            }
            return !(this.partitions == null ? other.partitions != null : !this.partitions.equals(other.partitions));
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + (this.name == null ? 0 : this.name.hashCode());
            hashCode = 31 * hashCode + (this.partitions == null ? 0 : this.partitions.hashCode());
            return hashCode;
        }

        public ListOffsetTopicResponse duplicate() {
            ListOffsetTopicResponse _duplicate = new ListOffsetTopicResponse();
            _duplicate.name = this.name;
            ArrayList<ListOffsetPartitionResponse> newPartitions = new ArrayList<ListOffsetPartitionResponse>(this.partitions.size());
            for (ListOffsetPartitionResponse _element : this.partitions) {
                newPartitions.add(_element.duplicate());
            }
            _duplicate.partitions = newPartitions;
            return _duplicate;
        }

        public String toString() {
            return "ListOffsetTopicResponse(name=" + (this.name == null ? "null" : "'" + this.name.toString() + "'") + ", partitions=" + MessageUtil.deepToString(this.partitions.iterator()) + ")";
        }

        public String name() {
            return this.name;
        }

        public List<ListOffsetPartitionResponse> partitions() {
            return this.partitions;
        }

        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public ListOffsetTopicResponse setName(String v) {
            this.name = v;
            return this;
        }

        public ListOffsetTopicResponse setPartitions(List<ListOffsetPartitionResponse> v) {
            this.partitions = v;
            return this;
        }

        static {
            SCHEMA_3 = SCHEMA_2 = (SCHEMA_1 = new Schema(new Field[]{new Field("name", (Type)Type.STRING, "The topic name"), new Field("partitions", (Type)new ArrayOf((Type)ListOffsetPartitionResponse.SCHEMA_1), "Each partition in the response.")}));
            SCHEMA_5 = SCHEMA_4 = new Schema(new Field[]{new Field("name", (Type)Type.STRING, "The topic name"), new Field("partitions", (Type)new ArrayOf((Type)ListOffsetPartitionResponse.SCHEMA_4), "Each partition in the response.")});
            SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1, SCHEMA_2, SCHEMA_3, SCHEMA_4, SCHEMA_5};
        }
    }
}

