/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.message;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.IntNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.LongNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.ShortNode;
import com.fasterxml.jackson.databind.node.TextNode;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.Message;
import org.apache.kafka.common.protocol.MessageUtil;
import org.apache.kafka.common.protocol.ObjectSerializationCache;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.protocol.Writable;
import org.apache.kafka.common.protocol.types.ArrayOf;
import org.apache.kafka.common.protocol.types.Field;
import org.apache.kafka.common.protocol.types.RawTaggedField;
import org.apache.kafka.common.protocol.types.RawTaggedFieldWriter;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Struct;
import org.apache.kafka.common.protocol.types.Type;
import org.apache.kafka.common.utils.ByteUtils;

public class ListOffsetRequestData
implements ApiMessage {
    private int replicaId;
    private byte isolationLevel;
    private List<ListOffsetTopic> topics;
    private List<RawTaggedField> _unknownTaggedFields;
    public static final Schema SCHEMA_0 = new Schema(new Field[]{new Field("replica_id", (Type)Type.INT32, "The broker ID of the requestor, or -1 if this request is being made by a normal consumer."), new Field("topics", (Type)new ArrayOf((Type)ListOffsetTopic.SCHEMA_0), "Each topic in the request.")});
    public static final Schema SCHEMA_1 = new Schema(new Field[]{new Field("replica_id", (Type)Type.INT32, "The broker ID of the requestor, or -1 if this request is being made by a normal consumer."), new Field("topics", (Type)new ArrayOf((Type)ListOffsetTopic.SCHEMA_1), "Each topic in the request.")});
    public static final Schema SCHEMA_2;
    public static final Schema SCHEMA_3;
    public static final Schema SCHEMA_4;
    public static final Schema SCHEMA_5;
    public static final Schema[] SCHEMAS;

    public ListOffsetRequestData(Readable _readable, short _version) {
        this.read(_readable, _version);
    }

    public ListOffsetRequestData(Struct _struct, short _version) {
        this.fromStruct(_struct, _version);
    }

    public ListOffsetRequestData(JsonNode _node, short _version) {
        this.fromJson(_node, _version);
    }

    public ListOffsetRequestData() {
        this.replicaId = 0;
        this.isolationLevel = 0;
        this.topics = new ArrayList<ListOffsetTopic>(0);
    }

    public short apiKey() {
        return 2;
    }

    public short lowestSupportedVersion() {
        return 0;
    }

    public short highestSupportedVersion() {
        return 5;
    }

    public void read(Readable _readable, short _version) {
        this.replicaId = _readable.readInt();
        this.isolationLevel = _version >= 2 ? _readable.readByte() : (byte)0;
        int arrayLength = _readable.readInt();
        if (arrayLength < 0) {
            throw new RuntimeException("non-nullable field topics was serialized as null");
        }
        ArrayList<ListOffsetTopic> newCollection = new ArrayList<ListOffsetTopic>(arrayLength);
        for (int i = 0; i < arrayLength; ++i) {
            newCollection.add(new ListOffsetTopic(_readable, _version));
        }
        this.topics = newCollection;
        this._unknownTaggedFields = null;
    }

    public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
        int _numTaggedFields = 0;
        _writable.writeInt(this.replicaId);
        if (_version >= 2) {
            _writable.writeByte(this.isolationLevel);
        } else if (this.isolationLevel != 0) {
            throw new UnsupportedVersionException("Attempted to write a non-default isolationLevel at version " + _version);
        }
        _writable.writeInt(this.topics.size());
        for (ListOffsetTopic topicsElement : this.topics) {
            topicsElement.write(_writable, _cache, _version);
        }
        RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
        if ((_numTaggedFields += _rawWriter.numFields()) > 0) {
            throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
        }
    }

    public void fromStruct(Struct struct, short _version) {
        this._unknownTaggedFields = null;
        this.replicaId = struct.getInt("replica_id");
        this.isolationLevel = _version >= 2 ? struct.getByte("isolation_level") : (byte)0;
        Object[] _nestedObjects = struct.getArray("topics");
        this.topics = new ArrayList<ListOffsetTopic>(_nestedObjects.length);
        for (Object nestedObject : _nestedObjects) {
            this.topics.add(new ListOffsetTopic((Struct)nestedObject, _version));
        }
    }

    public Struct toStruct(short _version) {
        Object _taggedFields = null;
        Struct struct = new Struct(SCHEMAS[_version]);
        struct.set("replica_id", (Object)this.replicaId);
        if (_version >= 2) {
            struct.set("isolation_level", (Object)this.isolationLevel);
        } else if (this.isolationLevel != 0) {
            throw new UnsupportedVersionException("Attempted to write a non-default isolationLevel at version " + _version);
        }
        Struct[] _nestedObjects = new Struct[this.topics.size()];
        int i = 0;
        for (ListOffsetTopic element : this.topics) {
            _nestedObjects[i++] = element.toStruct(_version);
        }
        struct.set("topics", (Object)_nestedObjects);
        return struct;
    }

    public void fromJson(JsonNode _node, short _version) {
        JsonNode _replicaIdNode = _node.get("replicaId");
        if (_replicaIdNode == null) {
            throw new RuntimeException("ListOffsetRequestData: unable to locate field 'replicaId', which is mandatory in version " + _version);
        }
        this.replicaId = MessageUtil.jsonNodeToInt((JsonNode)_replicaIdNode, (String)"ListOffsetRequestData");
        JsonNode _isolationLevelNode = _node.get("isolationLevel");
        if (_isolationLevelNode == null) {
            if (_version >= 2) {
                throw new RuntimeException("ListOffsetRequestData: unable to locate field 'isolationLevel', which is mandatory in version " + _version);
            }
            this.isolationLevel = 0;
        } else {
            this.isolationLevel = MessageUtil.jsonNodeToByte((JsonNode)_isolationLevelNode, (String)"ListOffsetRequestData");
        }
        JsonNode _topicsNode = _node.get("topics");
        if (_topicsNode == null) {
            throw new RuntimeException("ListOffsetRequestData: unable to locate field 'topics', which is mandatory in version " + _version);
        }
        if (!_topicsNode.isArray()) {
            throw new RuntimeException("ListOffsetRequestData expected a JSON array, but got " + _node.getNodeType());
        }
        this.topics = new ArrayList<ListOffsetTopic>();
        for (JsonNode _element : _topicsNode) {
            this.topics.add(new ListOffsetTopic(_element, _version));
        }
    }

    public JsonNode toJson(short _version) {
        ObjectNode _node = new ObjectNode(JsonNodeFactory.instance);
        _node.set("replicaId", (JsonNode)new IntNode(this.replicaId));
        if (_version >= 2) {
            _node.set("isolationLevel", (JsonNode)new ShortNode((short)this.isolationLevel));
        } else if (this.isolationLevel != 0) {
            throw new UnsupportedVersionException("Attempted to write a non-default isolationLevel at version " + _version);
        }
        ArrayNode _topicsArray = new ArrayNode(JsonNodeFactory.instance);
        for (ListOffsetTopic _element : this.topics) {
            _topicsArray.add(_element.toJson(_version));
        }
        _node.set("topics", (JsonNode)_topicsArray);
        return _node;
    }

    public int size(ObjectSerializationCache _cache, short _version) {
        int _size = 0;
        int _numTaggedFields = 0;
        _size += 4;
        if (_version >= 2) {
            ++_size;
        }
        int _arraySize = 0;
        _arraySize += 4;
        for (ListOffsetTopic topicsElement : this.topics) {
            _arraySize += topicsElement.size(_cache, _version);
        }
        _size += _arraySize;
        if (this._unknownTaggedFields != null) {
            _numTaggedFields += this._unknownTaggedFields.size();
            for (RawTaggedField _field : this._unknownTaggedFields) {
                _size += ByteUtils.sizeOfUnsignedVarint((int)_field.tag());
                _size += ByteUtils.sizeOfUnsignedVarint((int)_field.size());
                _size += _field.size();
            }
        }
        if (_numTaggedFields > 0) {
            throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
        }
        return _size;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ListOffsetRequestData)) {
            return false;
        }
        ListOffsetRequestData other = (ListOffsetRequestData)obj;
        if (this.replicaId != other.replicaId) {
            return false;
        }
        if (this.isolationLevel != other.isolationLevel) {
            return false;
        }
        return !(this.topics == null ? other.topics != null : !this.topics.equals(other.topics));
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = 31 * hashCode + this.replicaId;
        hashCode = 31 * hashCode + this.isolationLevel;
        hashCode = 31 * hashCode + (this.topics == null ? 0 : this.topics.hashCode());
        return hashCode;
    }

    public ListOffsetRequestData duplicate() {
        ListOffsetRequestData _duplicate = new ListOffsetRequestData();
        _duplicate.replicaId = this.replicaId;
        _duplicate.isolationLevel = this.isolationLevel;
        ArrayList<ListOffsetTopic> newTopics = new ArrayList<ListOffsetTopic>(this.topics.size());
        for (ListOffsetTopic _element : this.topics) {
            newTopics.add(_element.duplicate());
        }
        _duplicate.topics = newTopics;
        return _duplicate;
    }

    public String toString() {
        return "ListOffsetRequestData(replicaId=" + this.replicaId + ", isolationLevel=" + this.isolationLevel + ", topics=" + MessageUtil.deepToString(this.topics.iterator()) + ")";
    }

    public int replicaId() {
        return this.replicaId;
    }

    public byte isolationLevel() {
        return this.isolationLevel;
    }

    public List<ListOffsetTopic> topics() {
        return this.topics;
    }

    public List<RawTaggedField> unknownTaggedFields() {
        if (this._unknownTaggedFields == null) {
            this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
        }
        return this._unknownTaggedFields;
    }

    public ListOffsetRequestData setReplicaId(int v) {
        this.replicaId = v;
        return this;
    }

    public ListOffsetRequestData setIsolationLevel(byte v) {
        this.isolationLevel = v;
        return this;
    }

    public ListOffsetRequestData setTopics(List<ListOffsetTopic> v) {
        this.topics = v;
        return this;
    }

    static {
        SCHEMA_3 = SCHEMA_2 = new Schema(new Field[]{new Field("replica_id", (Type)Type.INT32, "The broker ID of the requestor, or -1 if this request is being made by a normal consumer."), new Field("isolation_level", (Type)Type.INT8, "This setting controls the visibility of transactional records. Using READ_UNCOMMITTED (isolation_level = 0) makes all records visible. With READ_COMMITTED (isolation_level = 1), non-transactional and COMMITTED transactional records are visible. To be more concrete, READ_COMMITTED returns all data from offsets smaller than the current LSO (last stable offset), and enables the inclusion of the list of aborted transactions in the result, which allows consumers to discard ABORTED transactional records"), new Field("topics", (Type)new ArrayOf((Type)ListOffsetTopic.SCHEMA_1), "Each topic in the request.")});
        SCHEMA_5 = SCHEMA_4 = new Schema(new Field[]{new Field("replica_id", (Type)Type.INT32, "The broker ID of the requestor, or -1 if this request is being made by a normal consumer."), new Field("isolation_level", (Type)Type.INT8, "This setting controls the visibility of transactional records. Using READ_UNCOMMITTED (isolation_level = 0) makes all records visible. With READ_COMMITTED (isolation_level = 1), non-transactional and COMMITTED transactional records are visible. To be more concrete, READ_COMMITTED returns all data from offsets smaller than the current LSO (last stable offset), and enables the inclusion of the list of aborted transactions in the result, which allows consumers to discard ABORTED transactional records"), new Field("topics", (Type)new ArrayOf((Type)ListOffsetTopic.SCHEMA_4), "Each topic in the request.")});
        SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1, SCHEMA_2, SCHEMA_3, SCHEMA_4, SCHEMA_5};
    }

    public static class ListOffsetPartition
    implements Message {
        private int partitionIndex;
        private int currentLeaderEpoch;
        private long timestamp;
        private int maxNumOffsets;
        private List<RawTaggedField> _unknownTaggedFields;
        public static final Schema SCHEMA_0 = new Schema(new Field[]{new Field("partition_index", (Type)Type.INT32, "The partition index."), new Field("timestamp", (Type)Type.INT64, "The current timestamp."), new Field("max_num_offsets", (Type)Type.INT32, "The maximum number of offsets to report.")});
        public static final Schema SCHEMA_1;
        public static final Schema SCHEMA_2;
        public static final Schema SCHEMA_3;
        public static final Schema SCHEMA_4;
        public static final Schema SCHEMA_5;
        public static final Schema[] SCHEMAS;

        public ListOffsetPartition(Readable _readable, short _version) {
            this.read(_readable, _version);
        }

        public ListOffsetPartition(Struct _struct, short _version) {
            this.fromStruct(_struct, _version);
        }

        public ListOffsetPartition(JsonNode _node, short _version) {
            this.fromJson(_node, _version);
        }

        public ListOffsetPartition() {
            this.partitionIndex = 0;
            this.currentLeaderEpoch = 0;
            this.timestamp = 0L;
            this.maxNumOffsets = 0;
        }

        public short lowestSupportedVersion() {
            return 0;
        }

        public short highestSupportedVersion() {
            return 5;
        }

        public void read(Readable _readable, short _version) {
            if (_version > 5) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of ListOffsetPartition");
            }
            this.partitionIndex = _readable.readInt();
            this.currentLeaderEpoch = _version >= 4 ? _readable.readInt() : 0;
            this.timestamp = _readable.readLong();
            this.maxNumOffsets = _version <= 0 ? _readable.readInt() : 0;
            this._unknownTaggedFields = null;
        }

        public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
            int _numTaggedFields = 0;
            _writable.writeInt(this.partitionIndex);
            if (_version >= 4) {
                _writable.writeInt(this.currentLeaderEpoch);
            } else if (this.currentLeaderEpoch != 0) {
                throw new UnsupportedVersionException("Attempted to write a non-default currentLeaderEpoch at version " + _version);
            }
            _writable.writeLong(this.timestamp);
            if (_version <= 0) {
                _writable.writeInt(this.maxNumOffsets);
            } else if (this.maxNumOffsets != 0) {
                throw new UnsupportedVersionException("Attempted to write a non-default maxNumOffsets at version " + _version);
            }
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            if ((_numTaggedFields += _rawWriter.numFields()) > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
        }

        public void fromStruct(Struct struct, short _version) {
            if (_version > 5) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of ListOffsetPartition");
            }
            this._unknownTaggedFields = null;
            this.partitionIndex = struct.getInt("partition_index");
            this.currentLeaderEpoch = _version >= 4 ? struct.getInt("current_leader_epoch") : 0;
            this.timestamp = struct.getLong("timestamp");
            this.maxNumOffsets = _version <= 0 ? struct.getInt("max_num_offsets") : 0;
        }

        public Struct toStruct(short _version) {
            if (_version > 5) {
                throw new UnsupportedVersionException("Can't write version " + _version + " of ListOffsetPartition");
            }
            Object _taggedFields = null;
            Struct struct = new Struct(SCHEMAS[_version]);
            struct.set("partition_index", (Object)this.partitionIndex);
            if (_version >= 4) {
                struct.set("current_leader_epoch", (Object)this.currentLeaderEpoch);
            } else if (this.currentLeaderEpoch != 0) {
                throw new UnsupportedVersionException("Attempted to write a non-default currentLeaderEpoch at version " + _version);
            }
            struct.set("timestamp", (Object)this.timestamp);
            if (_version <= 0) {
                struct.set("max_num_offsets", (Object)this.maxNumOffsets);
            } else if (this.maxNumOffsets != 0) {
                throw new UnsupportedVersionException("Attempted to write a non-default maxNumOffsets at version " + _version);
            }
            return struct;
        }

        public void fromJson(JsonNode _node, short _version) {
            JsonNode _partitionIndexNode = _node.get("partitionIndex");
            if (_partitionIndexNode == null) {
                throw new RuntimeException("ListOffsetPartition: unable to locate field 'partitionIndex', which is mandatory in version " + _version);
            }
            this.partitionIndex = MessageUtil.jsonNodeToInt((JsonNode)_partitionIndexNode, (String)"ListOffsetPartition");
            JsonNode _currentLeaderEpochNode = _node.get("currentLeaderEpoch");
            if (_currentLeaderEpochNode == null) {
                if (_version >= 4) {
                    throw new RuntimeException("ListOffsetPartition: unable to locate field 'currentLeaderEpoch', which is mandatory in version " + _version);
                }
                this.currentLeaderEpoch = 0;
            } else {
                this.currentLeaderEpoch = MessageUtil.jsonNodeToInt((JsonNode)_currentLeaderEpochNode, (String)"ListOffsetPartition");
            }
            JsonNode _timestampNode = _node.get("timestamp");
            if (_timestampNode == null) {
                throw new RuntimeException("ListOffsetPartition: unable to locate field 'timestamp', which is mandatory in version " + _version);
            }
            this.timestamp = MessageUtil.jsonNodeToLong((JsonNode)_timestampNode, (String)"ListOffsetPartition");
            JsonNode _maxNumOffsetsNode = _node.get("maxNumOffsets");
            if (_maxNumOffsetsNode == null) {
                if (_version <= 0) {
                    throw new RuntimeException("ListOffsetPartition: unable to locate field 'maxNumOffsets', which is mandatory in version " + _version);
                }
                this.maxNumOffsets = 0;
            } else {
                this.maxNumOffsets = MessageUtil.jsonNodeToInt((JsonNode)_maxNumOffsetsNode, (String)"ListOffsetPartition");
            }
        }

        public JsonNode toJson(short _version) {
            ObjectNode _node = new ObjectNode(JsonNodeFactory.instance);
            _node.set("partitionIndex", (JsonNode)new IntNode(this.partitionIndex));
            if (_version >= 4) {
                _node.set("currentLeaderEpoch", (JsonNode)new IntNode(this.currentLeaderEpoch));
            } else if (this.currentLeaderEpoch != 0) {
                throw new UnsupportedVersionException("Attempted to write a non-default currentLeaderEpoch at version " + _version);
            }
            _node.set("timestamp", (JsonNode)new LongNode(this.timestamp));
            if (_version <= 0) {
                _node.set("maxNumOffsets", (JsonNode)new IntNode(this.maxNumOffsets));
            } else if (this.maxNumOffsets != 0) {
                throw new UnsupportedVersionException("Attempted to write a non-default maxNumOffsets at version " + _version);
            }
            return _node;
        }

        public int size(ObjectSerializationCache _cache, short _version) {
            int _size = 0;
            int _numTaggedFields = 0;
            if (_version > 5) {
                throw new UnsupportedVersionException("Can't size version " + _version + " of ListOffsetPartition");
            }
            _size += 4;
            if (_version >= 4) {
                _size += 4;
            }
            _size += 8;
            if (_version <= 0) {
                _size += 4;
            }
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size += ByteUtils.sizeOfUnsignedVarint((int)_field.tag());
                    _size += ByteUtils.sizeOfUnsignedVarint((int)_field.size());
                    _size += _field.size();
                }
            }
            if (_numTaggedFields > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
            return _size;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof ListOffsetPartition)) {
                return false;
            }
            ListOffsetPartition other = (ListOffsetPartition)obj;
            if (this.partitionIndex != other.partitionIndex) {
                return false;
            }
            if (this.currentLeaderEpoch != other.currentLeaderEpoch) {
                return false;
            }
            if (this.timestamp != other.timestamp) {
                return false;
            }
            return this.maxNumOffsets == other.maxNumOffsets;
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + this.partitionIndex;
            hashCode = 31 * hashCode + this.currentLeaderEpoch;
            hashCode = 31 * hashCode + ((int)(this.timestamp >> 32) ^ (int)this.timestamp);
            hashCode = 31 * hashCode + this.maxNumOffsets;
            return hashCode;
        }

        public ListOffsetPartition duplicate() {
            ListOffsetPartition _duplicate = new ListOffsetPartition();
            _duplicate.partitionIndex = this.partitionIndex;
            _duplicate.currentLeaderEpoch = this.currentLeaderEpoch;
            _duplicate.timestamp = this.timestamp;
            _duplicate.maxNumOffsets = this.maxNumOffsets;
            return _duplicate;
        }

        public String toString() {
            return "ListOffsetPartition(partitionIndex=" + this.partitionIndex + ", currentLeaderEpoch=" + this.currentLeaderEpoch + ", timestamp=" + this.timestamp + ", maxNumOffsets=" + this.maxNumOffsets + ")";
        }

        public int partitionIndex() {
            return this.partitionIndex;
        }

        public int currentLeaderEpoch() {
            return this.currentLeaderEpoch;
        }

        public long timestamp() {
            return this.timestamp;
        }

        public int maxNumOffsets() {
            return this.maxNumOffsets;
        }

        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public ListOffsetPartition setPartitionIndex(int v) {
            this.partitionIndex = v;
            return this;
        }

        public ListOffsetPartition setCurrentLeaderEpoch(int v) {
            this.currentLeaderEpoch = v;
            return this;
        }

        public ListOffsetPartition setTimestamp(long v) {
            this.timestamp = v;
            return this;
        }

        public ListOffsetPartition setMaxNumOffsets(int v) {
            this.maxNumOffsets = v;
            return this;
        }

        static {
            SCHEMA_3 = SCHEMA_2 = (SCHEMA_1 = new Schema(new Field[]{new Field("partition_index", (Type)Type.INT32, "The partition index."), new Field("timestamp", (Type)Type.INT64, "The current timestamp.")}));
            SCHEMA_5 = SCHEMA_4 = new Schema(new Field[]{new Field("partition_index", (Type)Type.INT32, "The partition index."), new Field("current_leader_epoch", (Type)Type.INT32, "The current leader epoch."), new Field("timestamp", (Type)Type.INT64, "The current timestamp.")});
            SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1, SCHEMA_2, SCHEMA_3, SCHEMA_4, SCHEMA_5};
        }
    }

    public static class ListOffsetTopic
    implements Message {
        private String name;
        private List<ListOffsetPartition> partitions;
        private List<RawTaggedField> _unknownTaggedFields;
        public static final Schema SCHEMA_0 = new Schema(new Field[]{new Field("name", (Type)Type.STRING, "The topic name."), new Field("partitions", (Type)new ArrayOf((Type)ListOffsetPartition.SCHEMA_0), "Each partition in the request.")});
        public static final Schema SCHEMA_1;
        public static final Schema SCHEMA_2;
        public static final Schema SCHEMA_3;
        public static final Schema SCHEMA_4;
        public static final Schema SCHEMA_5;
        public static final Schema[] SCHEMAS;

        public ListOffsetTopic(Readable _readable, short _version) {
            this.read(_readable, _version);
        }

        public ListOffsetTopic(Struct _struct, short _version) {
            this.fromStruct(_struct, _version);
        }

        public ListOffsetTopic(JsonNode _node, short _version) {
            this.fromJson(_node, _version);
        }

        public ListOffsetTopic() {
            this.name = "";
            this.partitions = new ArrayList<ListOffsetPartition>(0);
        }

        public short lowestSupportedVersion() {
            return 0;
        }

        public short highestSupportedVersion() {
            return 5;
        }

        public void read(Readable _readable, short _version) {
            if (_version > 5) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of ListOffsetTopic");
            }
            short length = _readable.readShort();
            if (length < 0) {
                throw new RuntimeException("non-nullable field name was serialized as null");
            }
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field name had invalid length " + length);
            }
            this.name = _readable.readString((int)length);
            int arrayLength = _readable.readInt();
            if (arrayLength < 0) {
                throw new RuntimeException("non-nullable field partitions was serialized as null");
            }
            ArrayList<ListOffsetPartition> newCollection = new ArrayList<ListOffsetPartition>(arrayLength);
            for (int i = 0; i < arrayLength; ++i) {
                newCollection.add(new ListOffsetPartition(_readable, _version));
            }
            this.partitions = newCollection;
            this._unknownTaggedFields = null;
        }

        public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
            int _numTaggedFields = 0;
            Object _stringBytes = _cache.getSerializedValue((Object)this.name);
            _writable.writeShort((short)((byte[])_stringBytes).length);
            _writable.writeByteArray((byte[])_stringBytes);
            _writable.writeInt(this.partitions.size());
            _stringBytes = this.partitions.iterator();
            while (_stringBytes.hasNext()) {
                ListOffsetPartition partitionsElement = (ListOffsetPartition)_stringBytes.next();
                partitionsElement.write(_writable, _cache, _version);
            }
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            if ((_numTaggedFields += _rawWriter.numFields()) > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
        }

        public void fromStruct(Struct struct, short _version) {
            if (_version > 5) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of ListOffsetTopic");
            }
            this._unknownTaggedFields = null;
            this.name = struct.getString("name");
            Object[] _nestedObjects = struct.getArray("partitions");
            this.partitions = new ArrayList<ListOffsetPartition>(_nestedObjects.length);
            for (Object nestedObject : _nestedObjects) {
                this.partitions.add(new ListOffsetPartition((Struct)nestedObject, _version));
            }
        }

        public Struct toStruct(short _version) {
            if (_version > 5) {
                throw new UnsupportedVersionException("Can't write version " + _version + " of ListOffsetTopic");
            }
            Object _taggedFields = null;
            Struct struct = new Struct(SCHEMAS[_version]);
            struct.set("name", (Object)this.name);
            Struct[] _nestedObjects = new Struct[this.partitions.size()];
            int i = 0;
            for (ListOffsetPartition element : this.partitions) {
                _nestedObjects[i++] = element.toStruct(_version);
            }
            struct.set("partitions", (Object)_nestedObjects);
            return struct;
        }

        public void fromJson(JsonNode _node, short _version) {
            JsonNode _nameNode = _node.get("name");
            if (_nameNode == null) {
                throw new RuntimeException("ListOffsetTopic: unable to locate field 'name', which is mandatory in version " + _version);
            }
            if (!_nameNode.isTextual()) {
                throw new RuntimeException("ListOffsetTopic expected a string type, but got " + _node.getNodeType());
            }
            this.name = _nameNode.asText();
            JsonNode _partitionsNode = _node.get("partitions");
            if (_partitionsNode == null) {
                throw new RuntimeException("ListOffsetTopic: unable to locate field 'partitions', which is mandatory in version " + _version);
            }
            if (!_partitionsNode.isArray()) {
                throw new RuntimeException("ListOffsetTopic expected a JSON array, but got " + _node.getNodeType());
            }
            this.partitions = new ArrayList<ListOffsetPartition>();
            for (JsonNode _element : _partitionsNode) {
                this.partitions.add(new ListOffsetPartition(_element, _version));
            }
        }

        public JsonNode toJson(short _version) {
            ObjectNode _node = new ObjectNode(JsonNodeFactory.instance);
            _node.set("name", (JsonNode)new TextNode(this.name));
            ArrayNode _partitionsArray = new ArrayNode(JsonNodeFactory.instance);
            for (ListOffsetPartition _element : this.partitions) {
                _partitionsArray.add(_element.toJson(_version));
            }
            _node.set("partitions", (JsonNode)_partitionsArray);
            return _node;
        }

        public int size(ObjectSerializationCache _cache, short _version) {
            int _size = 0;
            int _numTaggedFields = 0;
            if (_version > 5) {
                throw new UnsupportedVersionException("Can't size version " + _version + " of ListOffsetTopic");
            }
            byte[] _stringBytes = this.name.getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'name' field is too long to be serialized");
            }
            _cache.cacheSerializedValue((Object)this.name, _stringBytes);
            _size += _stringBytes.length + 2;
            int _arraySize = 0;
            _arraySize += 4;
            for (ListOffsetPartition partitionsElement : this.partitions) {
                _arraySize += partitionsElement.size(_cache, _version);
            }
            _size += _arraySize;
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size += ByteUtils.sizeOfUnsignedVarint((int)_field.tag());
                    _size += ByteUtils.sizeOfUnsignedVarint((int)_field.size());
                    _size += _field.size();
                }
            }
            if (_numTaggedFields > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
            return _size;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof ListOffsetTopic)) {
                return false;
            }
            ListOffsetTopic other = (ListOffsetTopic)obj;
            if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
                return false;
            }
            return !(this.partitions == null ? other.partitions != null : !this.partitions.equals(other.partitions));
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + (this.name == null ? 0 : this.name.hashCode());
            hashCode = 31 * hashCode + (this.partitions == null ? 0 : this.partitions.hashCode());
            return hashCode;
        }

        public ListOffsetTopic duplicate() {
            ListOffsetTopic _duplicate = new ListOffsetTopic();
            _duplicate.name = this.name;
            ArrayList<ListOffsetPartition> newPartitions = new ArrayList<ListOffsetPartition>(this.partitions.size());
            for (ListOffsetPartition _element : this.partitions) {
                newPartitions.add(_element.duplicate());
            }
            _duplicate.partitions = newPartitions;
            return _duplicate;
        }

        public String toString() {
            return "ListOffsetTopic(name=" + (this.name == null ? "null" : "'" + this.name.toString() + "'") + ", partitions=" + MessageUtil.deepToString(this.partitions.iterator()) + ")";
        }

        public String name() {
            return this.name;
        }

        public List<ListOffsetPartition> partitions() {
            return this.partitions;
        }

        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public ListOffsetTopic setName(String v) {
            this.name = v;
            return this;
        }

        public ListOffsetTopic setPartitions(List<ListOffsetPartition> v) {
            this.partitions = v;
            return this;
        }

        static {
            SCHEMA_3 = SCHEMA_2 = (SCHEMA_1 = new Schema(new Field[]{new Field("name", (Type)Type.STRING, "The topic name."), new Field("partitions", (Type)new ArrayOf((Type)ListOffsetPartition.SCHEMA_1), "Each partition in the request.")}));
            SCHEMA_5 = SCHEMA_4 = new Schema(new Field[]{new Field("name", (Type)Type.STRING, "The topic name."), new Field("partitions", (Type)new ArrayOf((Type)ListOffsetPartition.SCHEMA_4), "Each partition in the request.")});
            SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1, SCHEMA_2, SCHEMA_3, SCHEMA_4, SCHEMA_5};
        }
    }
}

