/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.security.ssl;

import java.io.File;
import java.nio.file.Files;
import java.security.KeyStore;
import java.security.Security;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.config.types.Password;
import org.apache.kafka.common.network.Mode;
import org.apache.kafka.common.security.ssl.SslEngineBuilder;
import org.apache.kafka.common.security.ssl.SslFactory;
import org.apache.kafka.common.security.ssl.mock.TestProviderCreator;
import org.apache.kafka.common.utils.Java;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.test.TestSslUtils;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class SslFactoryTest {
    private final String tlsProtocol;

    @Parameterized.Parameters(name="tlsProtocol={0}")
    public static Collection<Object[]> data() {
        ArrayList<Object[]> values = new ArrayList<Object[]>();
        values.add(new Object[]{"TLSv1.2"});
        if (Java.IS_JAVA11_COMPATIBLE) {
            values.add(new Object[]{"TLSv1.3"});
        }
        return values;
    }

    public SslFactoryTest(String tlsProtocol) {
        this.tlsProtocol = tlsProtocol;
    }

    @Test
    public void testSslFactoryConfiguration() throws Exception {
        File trustStoreFile = File.createTempFile("truststore", ".jks");
        Map<String, Object> serverSslConfig = this.sslConfigsBuilder(Mode.SERVER).createNewTrustStore(trustStoreFile).build();
        SslFactory sslFactory = new SslFactory(Mode.SERVER);
        sslFactory.configure(serverSslConfig);
        SSLEngine engine = sslFactory.createSslEngine("localhost", 0);
        Assert.assertNotNull((Object)engine);
        Assert.assertEquals((Object)Utils.mkSet((Object[])new String[]{this.tlsProtocol}), (Object)Utils.mkSet((Object[])engine.getEnabledProtocols()));
        Assert.assertEquals((Object)false, (Object)engine.getUseClientMode());
    }

    @Test
    public void testSslFactoryWithCustomKeyManagerConfiguration() {
        TestProviderCreator testProviderCreator = new TestProviderCreator();
        Map<String, Object> serverSslConfig = TestSslUtils.createSslConfig("TestAlgorithm", "TestAlgorithm", this.tlsProtocol);
        serverSslConfig.put("security.providers", testProviderCreator.getClass().getName());
        SslFactory sslFactory = new SslFactory(Mode.SERVER);
        sslFactory.configure(serverSslConfig);
        Assert.assertNotNull((String)"SslEngineBuilder not created", (Object)sslFactory.sslEngineBuilder());
        Security.removeProvider(testProviderCreator.getProvider().getName());
    }

    @Test(expected=KafkaException.class)
    public void testSslFactoryWithoutProviderClassConfiguration() {
        Map<String, Object> serverSslConfig = TestSslUtils.createSslConfig("TestAlgorithm", "TestAlgorithm", this.tlsProtocol);
        SslFactory sslFactory = new SslFactory(Mode.SERVER);
        sslFactory.configure(serverSslConfig);
    }

    @Test(expected=KafkaException.class)
    public void testSslFactoryWithIncorrectProviderClassConfiguration() {
        Map<String, Object> serverSslConfig = TestSslUtils.createSslConfig("TestAlgorithm", "TestAlgorithm", this.tlsProtocol);
        serverSslConfig.put("security.providers", "com.fake.ProviderClass1,com.fake.ProviderClass2");
        SslFactory sslFactory = new SslFactory(Mode.SERVER);
        sslFactory.configure(serverSslConfig);
    }

    @Test
    public void testSslFactoryWithoutPasswordConfiguration() throws Exception {
        File trustStoreFile = File.createTempFile("truststore", ".jks");
        Map<String, Object> serverSslConfig = this.sslConfigsBuilder(Mode.SERVER).createNewTrustStore(trustStoreFile).build();
        serverSslConfig.remove("ssl.truststore.password");
        SslFactory sslFactory = new SslFactory(Mode.SERVER);
        try {
            sslFactory.configure(serverSslConfig);
        }
        catch (Exception e) {
            Assert.fail((String)("An exception was thrown when configuring the truststore without a password: " + e));
        }
    }

    @Test
    public void testClientMode() throws Exception {
        File trustStoreFile = File.createTempFile("truststore", ".jks");
        Map<String, Object> clientSslConfig = this.sslConfigsBuilder(Mode.CLIENT).createNewTrustStore(trustStoreFile).useClientCert(false).build();
        SslFactory sslFactory = new SslFactory(Mode.CLIENT);
        sslFactory.configure(clientSslConfig);
        SSLEngine engine = sslFactory.createSslEngine("localhost", 0);
        Assert.assertTrue((boolean)engine.getUseClientMode());
    }

    @Test
    public void testReconfiguration() throws Exception {
        File trustStoreFile = File.createTempFile("truststore", ".jks");
        Map<String, Object> sslConfig = this.sslConfigsBuilder(Mode.SERVER).createNewTrustStore(trustStoreFile).build();
        SslFactory sslFactory = new SslFactory(Mode.SERVER);
        sslFactory.configure(sslConfig);
        SslEngineBuilder sslEngineBuilder = sslFactory.sslEngineBuilder();
        Assert.assertNotNull((String)"SslEngineBuilder not created", (Object)sslEngineBuilder);
        sslFactory.reconfigure(sslConfig);
        Assert.assertSame((String)"SslEngineBuilder recreated unnecessarily", (Object)sslEngineBuilder, (Object)sslFactory.sslEngineBuilder());
        trustStoreFile = File.createTempFile("truststore", ".jks");
        sslConfig = this.sslConfigsBuilder(Mode.SERVER).createNewTrustStore(trustStoreFile).build();
        sslFactory.reconfigure(sslConfig);
        Assert.assertNotSame((String)"SslEngineBuilder not recreated", (Object)sslEngineBuilder, (Object)sslFactory.sslEngineBuilder());
        sslEngineBuilder = sslFactory.sslEngineBuilder();
        trustStoreFile.setLastModified(System.currentTimeMillis() + 10000L);
        sslFactory.reconfigure(sslConfig);
        Assert.assertNotSame((String)"SslEngineBuilder not recreated", (Object)sslEngineBuilder, (Object)sslFactory.sslEngineBuilder());
        sslEngineBuilder = sslFactory.sslEngineBuilder();
        File keyStoreFile = new File((String)sslConfig.get("ssl.keystore.location"));
        keyStoreFile.setLastModified(System.currentTimeMillis() + 10000L);
        sslFactory.reconfigure(sslConfig);
        Assert.assertNotSame((String)"SslEngineBuilder not recreated", (Object)sslEngineBuilder, (Object)sslFactory.sslEngineBuilder());
        sslEngineBuilder = sslFactory.sslEngineBuilder();
        keyStoreFile.setLastModified(System.currentTimeMillis() + 15000L);
        sslFactory.validateReconfiguration(sslConfig);
        sslFactory.reconfigure(sslConfig);
        Assert.assertNotSame((String)"SslEngineBuilder not recreated", (Object)sslEngineBuilder, (Object)sslFactory.sslEngineBuilder());
        sslEngineBuilder = sslFactory.sslEngineBuilder();
        keyStoreFile.setLastModified(System.currentTimeMillis() + 20000L);
        Files.delete(keyStoreFile.toPath());
        sslFactory.reconfigure(sslConfig);
        Assert.assertSame((String)"SslEngineBuilder recreated unnecessarily", (Object)sslEngineBuilder, (Object)sslFactory.sslEngineBuilder());
    }

    @Test
    public void testReconfigurationWithoutTruststore() throws Exception {
        File trustStoreFile = File.createTempFile("truststore", ".jks");
        Map<String, Object> sslConfig = this.sslConfigsBuilder(Mode.SERVER).createNewTrustStore(trustStoreFile).build();
        sslConfig.remove("ssl.truststore.location");
        sslConfig.remove("ssl.truststore.password");
        sslConfig.remove("ssl.truststore.type");
        SslFactory sslFactory = new SslFactory(Mode.SERVER);
        sslFactory.configure(sslConfig);
        SSLContext sslContext = sslFactory.sslEngineBuilder().sslContext();
        Assert.assertNotNull((String)"SSL context not created", (Object)sslContext);
        Assert.assertSame((String)"SSL context recreated unnecessarily", (Object)sslContext, (Object)sslFactory.sslEngineBuilder().sslContext());
        Assert.assertFalse((boolean)sslFactory.createSslEngine("localhost", 0).getUseClientMode());
        Map<String, Object> sslConfig2 = this.sslConfigsBuilder(Mode.SERVER).createNewTrustStore(trustStoreFile).build();
        try {
            sslFactory.validateReconfiguration(sslConfig2);
            Assert.fail((String)"Truststore configured dynamically for listener without previous truststore");
        }
        catch (ConfigException configException) {
            // empty catch block
        }
    }

    @Test
    public void testReconfigurationWithoutKeystore() throws Exception {
        File trustStoreFile = File.createTempFile("truststore", ".jks");
        Map<String, Object> sslConfig = this.sslConfigsBuilder(Mode.SERVER).createNewTrustStore(trustStoreFile).build();
        sslConfig.remove("ssl.keystore.location");
        sslConfig.remove("ssl.keystore.password");
        sslConfig.remove("ssl.keystore.type");
        SslFactory sslFactory = new SslFactory(Mode.SERVER);
        sslFactory.configure(sslConfig);
        SSLContext sslContext = sslFactory.sslEngineBuilder().sslContext();
        Assert.assertNotNull((String)"SSL context not created", (Object)sslContext);
        Assert.assertSame((String)"SSL context recreated unnecessarily", (Object)sslContext, (Object)sslFactory.sslEngineBuilder().sslContext());
        Assert.assertFalse((boolean)sslFactory.createSslEngine("localhost", 0).getUseClientMode());
        File newTrustStoreFile = File.createTempFile("truststore", ".jks");
        sslConfig = this.sslConfigsBuilder(Mode.SERVER).createNewTrustStore(newTrustStoreFile).build();
        sslConfig.remove("ssl.keystore.location");
        sslConfig.remove("ssl.keystore.password");
        sslConfig.remove("ssl.keystore.type");
        sslFactory.reconfigure(sslConfig);
        Assert.assertNotSame((String)"SSL context not recreated", (Object)sslContext, (Object)sslFactory.sslEngineBuilder().sslContext());
        sslConfig = this.sslConfigsBuilder(Mode.SERVER).createNewTrustStore(newTrustStoreFile).build();
        try {
            sslFactory.validateReconfiguration(sslConfig);
            Assert.fail((String)"Keystore configured dynamically for listener without previous keystore");
        }
        catch (ConfigException configException) {
            // empty catch block
        }
    }

    @Test
    public void testKeyStoreTrustStoreValidation() throws Exception {
        File trustStoreFile = File.createTempFile("truststore", ".jks");
        Map<String, Object> serverSslConfig = this.sslConfigsBuilder(Mode.SERVER).createNewTrustStore(trustStoreFile).build();
        SslFactory sslFactory = new SslFactory(Mode.SERVER);
        sslFactory.configure(serverSslConfig);
        Assert.assertNotNull((String)"SslEngineBuilder not created", (Object)sslFactory.sslEngineBuilder());
    }

    @Test
    public void testUntrustedKeyStoreValidationFails() throws Exception {
        File trustStoreFile1 = File.createTempFile("truststore1", ".jks");
        File trustStoreFile2 = File.createTempFile("truststore2", ".jks");
        Map<String, Object> sslConfig1 = this.sslConfigsBuilder(Mode.SERVER).createNewTrustStore(trustStoreFile1).build();
        Map<String, Object> sslConfig2 = this.sslConfigsBuilder(Mode.SERVER).createNewTrustStore(trustStoreFile2).build();
        SslFactory sslFactory = new SslFactory(Mode.SERVER, null, true);
        for (String key : Arrays.asList("ssl.truststore.location", "ssl.truststore.password", "ssl.truststore.type", "ssl.trustmanager.algorithm")) {
            sslConfig1.put(key, sslConfig2.get(key));
        }
        try {
            sslFactory.configure(sslConfig1);
            Assert.fail((String)"Validation did not fail with untrusted truststore");
        }
        catch (ConfigException configException) {
            // empty catch block
        }
    }

    @Test
    public void testKeystoreVerifiableUsingTruststore() throws Exception {
        File trustStoreFile1 = File.createTempFile("truststore1", ".jks");
        Map<String, Object> sslConfig1 = this.sslConfigsBuilder(Mode.SERVER).createNewTrustStore(trustStoreFile1).build();
        SslFactory sslFactory = new SslFactory(Mode.SERVER, null, true);
        sslFactory.configure(sslConfig1);
        File trustStoreFile2 = File.createTempFile("truststore2", ".jks");
        Map<String, Object> sslConfig2 = this.sslConfigsBuilder(Mode.SERVER).createNewTrustStore(trustStoreFile2).build();
        try {
            sslFactory.validateReconfiguration(sslConfig2);
            Assert.fail((String)"ValidateReconfiguration did not fail as expected");
        }
        catch (ConfigException configException) {
            // empty catch block
        }
    }

    @Test
    public void testCertificateEntriesValidation() throws Exception {
        File trustStoreFile = File.createTempFile("truststore", ".jks");
        Map<String, Object> serverSslConfig = this.sslConfigsBuilder(Mode.SERVER).createNewTrustStore(trustStoreFile).build();
        Map<String, Object> newCnConfig = this.sslConfigsBuilder(Mode.SERVER).createNewTrustStore(File.createTempFile("truststore", ".jks")).cn("Another CN").build();
        KeyStore ks1 = this.sslKeyStore(serverSslConfig).load();
        KeyStore ks2 = this.sslKeyStore(serverSslConfig).load();
        Assert.assertEquals((Object)SslFactory.CertificateEntries.create((KeyStore)ks1), (Object)SslFactory.CertificateEntries.create((KeyStore)ks2));
        ks2.setCertificateEntry("another", ks1.getCertificate("localhost"));
        Assert.assertEquals((Object)SslFactory.CertificateEntries.create((KeyStore)ks1), (Object)SslFactory.CertificateEntries.create((KeyStore)ks2));
        KeyStore ks3 = this.sslKeyStore(newCnConfig).load();
        Assert.assertNotEquals((Object)SslFactory.CertificateEntries.create((KeyStore)ks1), (Object)SslFactory.CertificateEntries.create((KeyStore)ks3));
    }

    private SslEngineBuilder.SecurityStore sslKeyStore(Map<String, Object> sslConfig) {
        return new SslEngineBuilder.SecurityStore((String)sslConfig.get("ssl.keystore.type"), (String)sslConfig.get("ssl.keystore.location"), (Password)sslConfig.get("ssl.keystore.password"), (Password)sslConfig.get("ssl.key.password"));
    }

    private SslEngineBuilder.SecurityStore sslTrustStore(Map<String, Object> sslConfig) {
        return new SslEngineBuilder.SecurityStore((String)sslConfig.get("ssl.truststore.type"), (String)sslConfig.get("ssl.truststore.location"), (Password)sslConfig.get("ssl.truststore.password"), null);
    }

    private TestSslUtils.SslConfigsBuilder sslConfigsBuilder(Mode mode) {
        return new TestSslUtils.SslConfigsBuilder(mode).tlsProtocol(this.tlsProtocol);
    }
}

