/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.config;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.config.ConfigValue;
import org.apache.kafka.common.config.SslConfigs;
import org.apache.kafka.common.config.types.Password;
import org.junit.Assert;
import org.junit.Test;

public class ConfigDefTest {
    @Test
    public void testBasicTypes() {
        ConfigDef def = new ConfigDef().define("a", ConfigDef.Type.INT, (Object)5, (ConfigDef.Validator)ConfigDef.Range.between((Number)0, (Number)14), ConfigDef.Importance.HIGH, "docs").define("b", ConfigDef.Type.LONG, ConfigDef.Importance.HIGH, "docs").define("c", ConfigDef.Type.STRING, (Object)"hello", ConfigDef.Importance.HIGH, "docs").define("d", ConfigDef.Type.LIST, ConfigDef.Importance.HIGH, "docs").define("e", ConfigDef.Type.DOUBLE, ConfigDef.Importance.HIGH, "docs").define("f", ConfigDef.Type.CLASS, ConfigDef.Importance.HIGH, "docs").define("g", ConfigDef.Type.BOOLEAN, ConfigDef.Importance.HIGH, "docs").define("h", ConfigDef.Type.BOOLEAN, ConfigDef.Importance.HIGH, "docs").define("i", ConfigDef.Type.BOOLEAN, ConfigDef.Importance.HIGH, "docs").define("j", ConfigDef.Type.PASSWORD, ConfigDef.Importance.HIGH, "docs");
        Properties props = new Properties();
        props.put("a", "1   ");
        props.put("b", (Object)2);
        props.put("d", " a , b, c");
        props.put("e", (Object)42.5);
        props.put("f", String.class.getName());
        props.put("g", "true");
        props.put("h", "FalSE");
        props.put("i", "TRUE");
        props.put("j", "password");
        Map vals = def.parse((Map)props);
        Assert.assertEquals((Object)1, vals.get("a"));
        Assert.assertEquals((Object)2L, vals.get("b"));
        Assert.assertEquals((Object)"hello", vals.get("c"));
        Assert.assertEquals(Arrays.asList("a", "b", "c"), vals.get("d"));
        Assert.assertEquals((Object)42.5, vals.get("e"));
        Assert.assertEquals(String.class, vals.get("f"));
        Assert.assertEquals((Object)true, vals.get("g"));
        Assert.assertEquals((Object)false, vals.get("h"));
        Assert.assertEquals((Object)true, vals.get("i"));
        Assert.assertEquals((Object)new Password("password"), vals.get("j"));
        Assert.assertEquals((Object)"[hidden]", (Object)vals.get("j").toString());
    }

    @Test(expected=ConfigException.class)
    public void testInvalidDefault() {
        new ConfigDef().define("a", ConfigDef.Type.INT, (Object)"hello", ConfigDef.Importance.HIGH, "docs");
    }

    @Test
    public void testNullDefault() {
        ConfigDef def = new ConfigDef().define("a", ConfigDef.Type.INT, null, null, null, "docs");
        Map vals = def.parse((Map)new Properties());
        Assert.assertEquals(null, vals.get("a"));
    }

    @Test(expected=ConfigException.class)
    public void testMissingRequired() {
        new ConfigDef().define("a", ConfigDef.Type.INT, ConfigDef.Importance.HIGH, "docs").parse(new HashMap());
    }

    @Test
    public void testParsingEmptyDefaultValueForStringFieldShouldSucceed() {
        new ConfigDef().define("a", ConfigDef.Type.STRING, (Object)"", ConfigDef.Importance.HIGH, "docs").parse(new HashMap());
    }

    @Test(expected=ConfigException.class)
    public void testDefinedTwice() {
        new ConfigDef().define("a", ConfigDef.Type.STRING, ConfigDef.Importance.HIGH, "docs").define("a", ConfigDef.Type.INT, ConfigDef.Importance.HIGH, "docs");
    }

    @Test
    public void testBadInputs() {
        this.testBadInputs(ConfigDef.Type.INT, "hello", "42.5", 42.5, Long.MAX_VALUE, Long.toString(Long.MAX_VALUE), new Object());
        this.testBadInputs(ConfigDef.Type.LONG, "hello", "42.5", Long.toString(Long.MAX_VALUE) + "00", new Object());
        this.testBadInputs(ConfigDef.Type.DOUBLE, "hello", new Object());
        this.testBadInputs(ConfigDef.Type.STRING, new Object());
        this.testBadInputs(ConfigDef.Type.LIST, 53, new Object());
        this.testBadInputs(ConfigDef.Type.BOOLEAN, "hello", "truee", "fals");
        this.testBadInputs(ConfigDef.Type.CLASS, "ClassDoesNotExist");
    }

    private void testBadInputs(ConfigDef.Type type, Object ... values) {
        for (Object value : values) {
            HashMap<String, Object> m = new HashMap<String, Object>();
            m.put("name", value);
            ConfigDef def = new ConfigDef().define("name", type, ConfigDef.Importance.HIGH, "docs");
            try {
                def.parse(m);
                Assert.fail((String)("Expected a config exception on bad input for value " + value));
            }
            catch (ConfigException configException) {
                // empty catch block
            }
        }
    }

    @Test(expected=ConfigException.class)
    public void testInvalidDefaultRange() {
        new ConfigDef().define("name", ConfigDef.Type.INT, (Object)-1, (ConfigDef.Validator)ConfigDef.Range.between((Number)0, (Number)10), ConfigDef.Importance.HIGH, "docs");
    }

    @Test(expected=ConfigException.class)
    public void testInvalidDefaultString() {
        new ConfigDef().define("name", ConfigDef.Type.STRING, (Object)"bad", (ConfigDef.Validator)ConfigDef.ValidString.in((String[])new String[]{"valid", "values"}), ConfigDef.Importance.HIGH, "docs");
    }

    @Test
    public void testNestedClass() {
        Map<String, String> props = Collections.singletonMap("name", NestedClass.class.getName());
        new ConfigDef().define("name", ConfigDef.Type.CLASS, ConfigDef.Importance.HIGH, "docs").parse(props);
    }

    @Test
    public void testValidators() {
        this.testValidators(ConfigDef.Type.INT, (ConfigDef.Validator)ConfigDef.Range.between((Number)0, (Number)10), 5, new Object[]{1, 5, 9}, new Object[]{-1, 11, null});
        this.testValidators(ConfigDef.Type.STRING, (ConfigDef.Validator)ConfigDef.ValidString.in((String[])new String[]{"good", "values", "default"}), "default", new Object[]{"good", "values", "default"}, new Object[]{"bad", "inputs", "DEFAULT", null});
        this.testValidators(ConfigDef.Type.STRING, (ConfigDef.Validator)ConfigDef.CaseInsensitiveValidString.in((String[])new String[]{"good", "values", "default"}), "default", new Object[]{"gOOd", "VALUES", "default"}, new Object[]{"Bad", "iNPUts", null});
        this.testValidators(ConfigDef.Type.LIST, (ConfigDef.Validator)ConfigDef.ValidList.in((String[])new String[]{"1", "2", "3"}), "1", new Object[]{"1", "2", "3"}, new Object[]{"4", "5", "6"});
        this.testValidators(ConfigDef.Type.STRING, (ConfigDef.Validator)new ConfigDef.NonNullValidator(), "a", new Object[]{"abb"}, new Object[]{null});
        this.testValidators(ConfigDef.Type.STRING, (ConfigDef.Validator)ConfigDef.CompositeValidator.of((ConfigDef.Validator[])new ConfigDef.Validator[]{new ConfigDef.NonNullValidator(), ConfigDef.ValidString.in((String[])new String[]{"a", "b"})}), "a", new Object[]{"a", "b"}, new Object[]{null, -1, "c"});
        this.testValidators(ConfigDef.Type.STRING, (ConfigDef.Validator)new ConfigDef.NonEmptyStringWithoutControlChars(), "defaultname", new Object[]{"test", "name", "test/test", "test\u1234", "\u1324name\\", "/+%>&):??<&()?-", "+1", "\ud83d\ude01", "\uf3b1", "     test   \n\r", "\n  hello \t"}, new Object[]{"nontrailing\nnotallowed", "as\u0001cii control char", "tes\rt", "test\btest", "1\t2", ""});
    }

    @Test
    public void testSslPasswords() {
        ConfigDef def = new ConfigDef();
        SslConfigs.addClientSslSupport((ConfigDef)def);
        Properties props = new Properties();
        props.put("ssl.key.password", "key_password");
        props.put("ssl.keystore.password", "keystore_password");
        props.put("ssl.truststore.password", "truststore_password");
        Map vals = def.parse((Map)props);
        Assert.assertEquals((Object)new Password("key_password"), vals.get("ssl.key.password"));
        Assert.assertEquals((Object)"[hidden]", (Object)vals.get("ssl.key.password").toString());
        Assert.assertEquals((Object)new Password("keystore_password"), vals.get("ssl.keystore.password"));
        Assert.assertEquals((Object)"[hidden]", (Object)vals.get("ssl.keystore.password").toString());
        Assert.assertEquals((Object)new Password("truststore_password"), vals.get("ssl.truststore.password"));
        Assert.assertEquals((Object)"[hidden]", (Object)vals.get("ssl.truststore.password").toString());
    }

    @Test
    public void testNullDefaultWithValidator() {
        String key = "enum_test";
        ConfigDef def = new ConfigDef();
        def.define("enum_test", ConfigDef.Type.STRING, ConfigDef.NO_DEFAULT_VALUE, (ConfigDef.Validator)ConfigDef.ValidString.in((String[])new String[]{"ONE", "TWO", "THREE"}), ConfigDef.Importance.HIGH, "docs");
        Properties props = new Properties();
        props.put("enum_test", "ONE");
        Map vals = def.parse((Map)props);
        Assert.assertEquals((Object)"ONE", vals.get("enum_test"));
    }

    @Test
    public void testGroupInference() {
        List<String> expected1 = Arrays.asList("group1", "group2");
        ConfigDef def1 = new ConfigDef().define("a", ConfigDef.Type.INT, ConfigDef.Importance.HIGH, "docs", "group1", 1, ConfigDef.Width.SHORT, "a").define("b", ConfigDef.Type.INT, ConfigDef.Importance.HIGH, "docs", "group2", 1, ConfigDef.Width.SHORT, "b").define("c", ConfigDef.Type.INT, ConfigDef.Importance.HIGH, "docs", "group1", 2, ConfigDef.Width.SHORT, "c");
        Assert.assertEquals(expected1, (Object)def1.groups());
        List<String> expected2 = Arrays.asList("group2", "group1");
        ConfigDef def2 = new ConfigDef().define("a", ConfigDef.Type.INT, ConfigDef.Importance.HIGH, "docs", "group2", 1, ConfigDef.Width.SHORT, "a").define("b", ConfigDef.Type.INT, ConfigDef.Importance.HIGH, "docs", "group2", 2, ConfigDef.Width.SHORT, "b").define("c", ConfigDef.Type.INT, ConfigDef.Importance.HIGH, "docs", "group1", 2, ConfigDef.Width.SHORT, "c");
        Assert.assertEquals(expected2, (Object)def2.groups());
    }

    @Test
    public void testParseForValidate() {
        HashMap<String, Integer> expectedParsed = new HashMap<String, Integer>();
        expectedParsed.put("a", 1);
        expectedParsed.put("b", null);
        expectedParsed.put("c", null);
        expectedParsed.put("d", 10);
        HashMap<String, ConfigValue> expected = new HashMap<String, ConfigValue>();
        String errorMessageB = "Missing required configuration \"b\" which has no default value.";
        String errorMessageC = "Missing required configuration \"c\" which has no default value.";
        ConfigValue configA = new ConfigValue("a", (Object)1, Collections.emptyList(), Collections.emptyList());
        ConfigValue configB = new ConfigValue("b", null, Collections.emptyList(), Arrays.asList(errorMessageB, errorMessageB));
        ConfigValue configC = new ConfigValue("c", null, Collections.emptyList(), Arrays.asList(errorMessageC));
        ConfigValue configD = new ConfigValue("d", (Object)10, Collections.emptyList(), Collections.emptyList());
        expected.put("a", configA);
        expected.put("b", configB);
        expected.put("c", configC);
        expected.put("d", configD);
        ConfigDef def = new ConfigDef().define("a", ConfigDef.Type.INT, ConfigDef.Importance.HIGH, "docs", "group", 1, ConfigDef.Width.SHORT, "a", Arrays.asList("b", "c"), (ConfigDef.Recommender)new IntegerRecommender(false)).define("b", ConfigDef.Type.INT, ConfigDef.Importance.HIGH, "docs", "group", 2, ConfigDef.Width.SHORT, "b", (ConfigDef.Recommender)new IntegerRecommender(true)).define("c", ConfigDef.Type.INT, ConfigDef.Importance.HIGH, "docs", "group", 3, ConfigDef.Width.SHORT, "c", (ConfigDef.Recommender)new IntegerRecommender(true)).define("d", ConfigDef.Type.INT, ConfigDef.Importance.HIGH, "docs", "group", 4, ConfigDef.Width.SHORT, "d", Arrays.asList("b"), (ConfigDef.Recommender)new IntegerRecommender(false));
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("a", "1");
        props.put("d", "10");
        HashMap<String, ConfigValue> configValues = new HashMap<String, ConfigValue>();
        for (String name : def.configKeys().keySet()) {
            configValues.put(name, new ConfigValue(name));
        }
        Map parsed = def.parseForValidate(props, configValues);
        Assert.assertEquals(expectedParsed, (Object)parsed);
        Assert.assertEquals(expected, configValues);
    }

    @Test
    public void testValidate() {
        HashMap<String, ConfigValue> expected = new HashMap<String, ConfigValue>();
        String errorMessageB = "Missing required configuration \"b\" which has no default value.";
        String errorMessageC = "Missing required configuration \"c\" which has no default value.";
        ConfigValue configA = new ConfigValue("a", (Object)1, Arrays.asList(1, 2, 3), Collections.emptyList());
        ConfigValue configB = new ConfigValue("b", null, Arrays.asList(4, 5), Arrays.asList(errorMessageB, errorMessageB));
        ConfigValue configC = new ConfigValue("c", null, Arrays.asList(4, 5), Arrays.asList(errorMessageC));
        ConfigValue configD = new ConfigValue("d", (Object)10, Arrays.asList(1, 2, 3), Collections.emptyList());
        expected.put("a", configA);
        expected.put("b", configB);
        expected.put("c", configC);
        expected.put("d", configD);
        ConfigDef def = new ConfigDef().define("a", ConfigDef.Type.INT, ConfigDef.Importance.HIGH, "docs", "group", 1, ConfigDef.Width.SHORT, "a", Arrays.asList("b", "c"), (ConfigDef.Recommender)new IntegerRecommender(false)).define("b", ConfigDef.Type.INT, ConfigDef.Importance.HIGH, "docs", "group", 2, ConfigDef.Width.SHORT, "b", (ConfigDef.Recommender)new IntegerRecommender(true)).define("c", ConfigDef.Type.INT, ConfigDef.Importance.HIGH, "docs", "group", 3, ConfigDef.Width.SHORT, "c", (ConfigDef.Recommender)new IntegerRecommender(true)).define("d", ConfigDef.Type.INT, ConfigDef.Importance.HIGH, "docs", "group", 4, ConfigDef.Width.SHORT, "d", Arrays.asList("b"), (ConfigDef.Recommender)new IntegerRecommender(false));
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("a", "1");
        props.put("d", "10");
        List configs = def.validate(props);
        for (ConfigValue config : configs) {
            String name = config.name();
            ConfigValue expectedConfig = (ConfigValue)expected.get(name);
            Assert.assertEquals((Object)expectedConfig, (Object)config);
        }
    }

    @Test
    public void testValidateMissingConfigKey() {
        HashMap<String, ConfigValue> expected = new HashMap<String, ConfigValue>();
        String errorMessageB = "Missing required configuration \"b\" which has no default value.";
        String errorMessageC = "Missing required configuration \"c\" which has no default value.";
        String errorMessageD = "d is referred in the dependents, but not defined.";
        ConfigValue configA = new ConfigValue("a", (Object)1, Arrays.asList(1, 2, 3), Collections.emptyList());
        ConfigValue configB = new ConfigValue("b", null, Arrays.asList(4, 5), Arrays.asList(errorMessageB));
        ConfigValue configC = new ConfigValue("c", null, Arrays.asList(4, 5), Arrays.asList(errorMessageC));
        ConfigValue configD = new ConfigValue("d", null, Collections.emptyList(), Arrays.asList(errorMessageD));
        configD.visible(false);
        expected.put("a", configA);
        expected.put("b", configB);
        expected.put("c", configC);
        expected.put("d", configD);
        ConfigDef def = new ConfigDef().define("a", ConfigDef.Type.INT, ConfigDef.Importance.HIGH, "docs", "group", 1, ConfigDef.Width.SHORT, "a", Arrays.asList("b", "c", "d"), (ConfigDef.Recommender)new IntegerRecommender(false)).define("b", ConfigDef.Type.INT, ConfigDef.Importance.HIGH, "docs", "group", 2, ConfigDef.Width.SHORT, "b", (ConfigDef.Recommender)new IntegerRecommender(true)).define("c", ConfigDef.Type.INT, ConfigDef.Importance.HIGH, "docs", "group", 3, ConfigDef.Width.SHORT, "c", (ConfigDef.Recommender)new IntegerRecommender(true));
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("a", "1");
        List configs = def.validate(props);
        for (ConfigValue config : configs) {
            String name = config.name();
            ConfigValue expectedConfig = (ConfigValue)expected.get(name);
            Assert.assertEquals((Object)expectedConfig, (Object)config);
        }
    }

    @Test
    public void testValidateCannotParse() {
        HashMap<String, ConfigValue> expected = new HashMap<String, ConfigValue>();
        String errorMessageB = "Invalid value non_integer for configuration a: Not a number of type INT";
        ConfigValue configA = new ConfigValue("a", null, Collections.emptyList(), Arrays.asList(errorMessageB));
        expected.put("a", configA);
        ConfigDef def = new ConfigDef().define("a", ConfigDef.Type.INT, ConfigDef.Importance.HIGH, "docs");
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("a", "non_integer");
        List configs = def.validate(props);
        for (ConfigValue config : configs) {
            String name = config.name();
            ConfigValue expectedConfig = (ConfigValue)expected.get(name);
            Assert.assertEquals((Object)expectedConfig, (Object)config);
        }
    }

    @Test
    public void testCanAddInternalConfig() throws Exception {
        String configName = "internal.config";
        ConfigDef configDef = new ConfigDef().defineInternal("internal.config", ConfigDef.Type.STRING, (Object)"", ConfigDef.Importance.LOW);
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("internal.config", "value");
        List results = configDef.validate(properties);
        ConfigValue configValue = (ConfigValue)results.get(0);
        Assert.assertEquals((Object)"value", (Object)configValue.value());
        Assert.assertEquals((Object)"internal.config", (Object)configValue.name());
    }

    @Test
    public void testInternalConfigDoesntShowUpInDocs() throws Exception {
        String name = "my.config";
        ConfigDef configDef = new ConfigDef().defineInternal("my.config", ConfigDef.Type.STRING, (Object)"", ConfigDef.Importance.LOW);
        Assert.assertFalse((boolean)configDef.toHtmlTable().contains("my.config"));
        Assert.assertFalse((boolean)configDef.toEnrichedRst().contains("my.config"));
        Assert.assertFalse((boolean)configDef.toRst().contains("my.config"));
    }

    @Test
    public void testDynamicUpdateModeInDocs() throws Exception {
        ConfigDef configDef = new ConfigDef().define("my.broker.config", ConfigDef.Type.LONG, ConfigDef.Importance.HIGH, "docs").define("my.cluster.config", ConfigDef.Type.LONG, ConfigDef.Importance.HIGH, "docs").define("my.readonly.config", ConfigDef.Type.LONG, ConfigDef.Importance.HIGH, "docs");
        HashMap<String, String> updateModes = new HashMap<String, String>();
        updateModes.put("my.broker.config", "per-broker");
        updateModes.put("my.cluster.config", "cluster-wide");
        String html = configDef.toHtmlTable(updateModes);
        HashSet<String> configsInHtml = new HashSet<String>();
        for (String line : html.split("\n")) {
            if (line.contains("my.broker.config")) {
                Assert.assertTrue((boolean)line.contains("per-broker"));
                configsInHtml.add("my.broker.config");
                continue;
            }
            if (line.contains("my.cluster.config")) {
                Assert.assertTrue((boolean)line.contains("cluster-wide"));
                configsInHtml.add("my.cluster.config");
                continue;
            }
            if (!line.contains("my.readonly.config")) continue;
            Assert.assertTrue((boolean)line.contains("read-only"));
            configsInHtml.add("my.readonly.config");
        }
        Assert.assertEquals((Object)configDef.names(), configsInHtml);
    }

    @Test
    public void testNames() {
        ConfigDef configDef = new ConfigDef().define("a", ConfigDef.Type.STRING, ConfigDef.Importance.LOW, "docs").define("b", ConfigDef.Type.STRING, ConfigDef.Importance.LOW, "docs");
        Set names = configDef.names();
        Assert.assertEquals(new HashSet<String>(Arrays.asList("a", "b")), (Object)names);
        try {
            names.add("new");
            Assert.fail();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    @Test(expected=ConfigException.class)
    public void testMissingDependentConfigs() {
        ConfigDef configDef = new ConfigDef().define("parent", ConfigDef.Type.STRING, ConfigDef.Importance.HIGH, "parent docs", "group", 1, ConfigDef.Width.LONG, "Parent", Collections.singletonList("child"));
        configDef.parse(Collections.emptyMap());
    }

    @Test
    public void testBaseConfigDefDependents() {
        ConfigDef baseConfigDef = new ConfigDef().define("a", ConfigDef.Type.STRING, ConfigDef.Importance.LOW, "docs");
        Assert.assertEquals(new HashSet<String>(Arrays.asList("a")), (Object)baseConfigDef.getConfigsWithNoParent());
        ConfigDef configDef = new ConfigDef(baseConfigDef).define("parent", ConfigDef.Type.STRING, ConfigDef.Importance.HIGH, "parent docs", "group", 1, ConfigDef.Width.LONG, "Parent", Collections.singletonList("child")).define("child", ConfigDef.Type.STRING, ConfigDef.Importance.HIGH, "docs");
        Assert.assertEquals(new HashSet<String>(Arrays.asList("a", "parent")), (Object)configDef.getConfigsWithNoParent());
    }

    private void testValidators(ConfigDef.Type type, ConfigDef.Validator validator, Object defaultVal, Object[] okValues, Object[] badValues) {
        HashMap<String, Object> m;
        ConfigDef def = new ConfigDef().define("name", type, defaultVal, validator, ConfigDef.Importance.HIGH, "docs");
        for (Object value : okValues) {
            m = new HashMap<String, Object>();
            m.put("name", value);
            def.parse(m);
        }
        for (Object value : badValues) {
            m = new HashMap();
            m.put("name", value);
            try {
                def.parse(m);
                Assert.fail((String)("Expected a config exception due to invalid value " + value));
            }
            catch (ConfigException configException) {
                // empty catch block
            }
        }
    }

    @Test
    public void toRst() {
        ConfigDef def = new ConfigDef().define("opt1", ConfigDef.Type.STRING, (Object)"a", (ConfigDef.Validator)ConfigDef.ValidString.in((String[])new String[]{"a", "b", "c"}), ConfigDef.Importance.HIGH, "docs1").define("opt2", ConfigDef.Type.INT, ConfigDef.Importance.MEDIUM, "docs2").define("opt3", ConfigDef.Type.LIST, Arrays.asList("a", "b"), ConfigDef.Importance.LOW, "docs3");
        String expectedRst = "``opt2``\n  docs2\n\n  * Type: int\n  * Importance: medium\n\n``opt1``\n  docs1\n\n  * Type: string\n  * Default: a\n  * Valid Values: [a, b, c]\n  * Importance: high\n\n``opt3``\n  docs3\n\n  * Type: list\n  * Default: a,b\n  * Importance: low\n\n";
        Assert.assertEquals((Object)"``opt2``\n  docs2\n\n  * Type: int\n  * Importance: medium\n\n``opt1``\n  docs1\n\n  * Type: string\n  * Default: a\n  * Valid Values: [a, b, c]\n  * Importance: high\n\n``opt3``\n  docs3\n\n  * Type: list\n  * Default: a,b\n  * Importance: low\n\n", (Object)def.toRst());
    }

    @Test
    public void toEnrichedRst() {
        ConfigDef def = new ConfigDef().define("opt1.of.group1", ConfigDef.Type.STRING, (Object)"a", (ConfigDef.Validator)ConfigDef.ValidString.in((String[])new String[]{"a", "b", "c"}), ConfigDef.Importance.HIGH, "Doc doc.", "Group One", 0, ConfigDef.Width.NONE, "..", Collections.emptyList()).define("opt2.of.group1", ConfigDef.Type.INT, ConfigDef.NO_DEFAULT_VALUE, ConfigDef.Importance.MEDIUM, "Doc doc doc.", "Group One", 1, ConfigDef.Width.NONE, "..", Arrays.asList("some.option1", "some.option2")).define("opt2.of.group2", ConfigDef.Type.BOOLEAN, (Object)false, ConfigDef.Importance.HIGH, "Doc doc doc doc.", "Group Two", 1, ConfigDef.Width.NONE, "..", Collections.emptyList()).define("opt1.of.group2", ConfigDef.Type.BOOLEAN, (Object)false, ConfigDef.Importance.HIGH, "Doc doc doc doc doc.", "Group Two", 0, ConfigDef.Width.NONE, "..", Collections.singletonList("some.option")).define("poor.opt", ConfigDef.Type.STRING, (Object)"foo", ConfigDef.Importance.HIGH, "Doc doc doc doc.");
        String expectedRst = "``poor.opt``\n  Doc doc doc doc.\n\n  * Type: string\n  * Default: foo\n  * Importance: high\n\nGroup One\n^^^^^^^^^\n\n``opt1.of.group1``\n  Doc doc.\n\n  * Type: string\n  * Default: a\n  * Valid Values: [a, b, c]\n  * Importance: high\n\n``opt2.of.group1``\n  Doc doc doc.\n\n  * Type: int\n  * Importance: medium\n  * Dependents: ``some.option1``, ``some.option2``\n\nGroup Two\n^^^^^^^^^\n\n``opt1.of.group2``\n  Doc doc doc doc doc.\n\n  * Type: boolean\n  * Default: false\n  * Importance: high\n  * Dependents: ``some.option``\n\n``opt2.of.group2``\n  Doc doc doc doc.\n\n  * Type: boolean\n  * Default: false\n  * Importance: high\n\n";
        Assert.assertEquals((Object)"``poor.opt``\n  Doc doc doc doc.\n\n  * Type: string\n  * Default: foo\n  * Importance: high\n\nGroup One\n^^^^^^^^^\n\n``opt1.of.group1``\n  Doc doc.\n\n  * Type: string\n  * Default: a\n  * Valid Values: [a, b, c]\n  * Importance: high\n\n``opt2.of.group1``\n  Doc doc doc.\n\n  * Type: int\n  * Importance: medium\n  * Dependents: ``some.option1``, ``some.option2``\n\nGroup Two\n^^^^^^^^^\n\n``opt1.of.group2``\n  Doc doc doc doc doc.\n\n  * Type: boolean\n  * Default: false\n  * Importance: high\n  * Dependents: ``some.option``\n\n``opt2.of.group2``\n  Doc doc doc doc.\n\n  * Type: boolean\n  * Default: false\n  * Importance: high\n\n", (Object)def.toEnrichedRst());
    }

    @Test
    public void testConvertValueToStringBoolean() {
        Assert.assertEquals((Object)"true", (Object)ConfigDef.convertToString((Object)true, (ConfigDef.Type)ConfigDef.Type.BOOLEAN));
        Assert.assertNull((Object)ConfigDef.convertToString(null, (ConfigDef.Type)ConfigDef.Type.BOOLEAN));
    }

    @Test
    public void testConvertValueToStringShort() {
        Assert.assertEquals((Object)"32767", (Object)ConfigDef.convertToString((Object)Short.MAX_VALUE, (ConfigDef.Type)ConfigDef.Type.SHORT));
        Assert.assertNull((Object)ConfigDef.convertToString(null, (ConfigDef.Type)ConfigDef.Type.SHORT));
    }

    @Test
    public void testConvertValueToStringInt() {
        Assert.assertEquals((Object)"2147483647", (Object)ConfigDef.convertToString((Object)Integer.MAX_VALUE, (ConfigDef.Type)ConfigDef.Type.INT));
        Assert.assertNull((Object)ConfigDef.convertToString(null, (ConfigDef.Type)ConfigDef.Type.INT));
    }

    @Test
    public void testConvertValueToStringLong() {
        Assert.assertEquals((Object)"9223372036854775807", (Object)ConfigDef.convertToString((Object)Long.MAX_VALUE, (ConfigDef.Type)ConfigDef.Type.LONG));
        Assert.assertNull((Object)ConfigDef.convertToString(null, (ConfigDef.Type)ConfigDef.Type.LONG));
    }

    @Test
    public void testConvertValueToStringDouble() {
        Assert.assertEquals((Object)"3.125", (Object)ConfigDef.convertToString((Object)3.125, (ConfigDef.Type)ConfigDef.Type.DOUBLE));
        Assert.assertNull((Object)ConfigDef.convertToString(null, (ConfigDef.Type)ConfigDef.Type.DOUBLE));
    }

    @Test
    public void testConvertValueToStringString() {
        Assert.assertEquals((Object)"foobar", (Object)ConfigDef.convertToString((Object)"foobar", (ConfigDef.Type)ConfigDef.Type.STRING));
        Assert.assertNull((Object)ConfigDef.convertToString(null, (ConfigDef.Type)ConfigDef.Type.STRING));
    }

    @Test
    public void testConvertValueToStringPassword() {
        Assert.assertEquals((Object)"[hidden]", (Object)ConfigDef.convertToString((Object)new Password("foobar"), (ConfigDef.Type)ConfigDef.Type.PASSWORD));
        Assert.assertEquals((Object)"foobar", (Object)ConfigDef.convertToString((Object)"foobar", (ConfigDef.Type)ConfigDef.Type.PASSWORD));
        Assert.assertNull((Object)ConfigDef.convertToString(null, (ConfigDef.Type)ConfigDef.Type.PASSWORD));
    }

    @Test
    public void testConvertValueToStringList() {
        Assert.assertEquals((Object)"a,bc,d", (Object)ConfigDef.convertToString(Arrays.asList("a", "bc", "d"), (ConfigDef.Type)ConfigDef.Type.LIST));
        Assert.assertNull((Object)ConfigDef.convertToString(null, (ConfigDef.Type)ConfigDef.Type.LIST));
    }

    @Test
    public void testConvertValueToStringClass() throws ClassNotFoundException {
        String actual = ConfigDef.convertToString(ConfigDefTest.class, (ConfigDef.Type)ConfigDef.Type.CLASS);
        Assert.assertEquals((Object)"org.apache.kafka.common.config.ConfigDefTest", (Object)actual);
        Assert.assertEquals(ConfigDefTest.class, Class.forName(actual));
        Assert.assertNull((Object)ConfigDef.convertToString(null, (ConfigDef.Type)ConfigDef.Type.CLASS));
    }

    @Test
    public void testConvertValueToStringNestedClass() throws ClassNotFoundException {
        String actual = ConfigDef.convertToString(NestedClass.class, (ConfigDef.Type)ConfigDef.Type.CLASS);
        Assert.assertEquals((Object)"org.apache.kafka.common.config.ConfigDefTest$NestedClass", (Object)actual);
        Assert.assertEquals(NestedClass.class, Class.forName(actual));
    }

    @Test
    public void testClassWithAlias() {
        String alias = "PluginAlias";
        ClassLoader originalClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(new ClassLoader(originalClassLoader){

                @Override
                public Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
                    if ("PluginAlias".equals(name)) {
                        return NestedClass.class;
                    }
                    return super.loadClass(name, resolve);
                }
            });
            ConfigDef.parseType((String)"Test config", (Object)"PluginAlias", (ConfigDef.Type)ConfigDef.Type.CLASS);
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalClassLoader);
        }
    }

    private class NestedClass {
        private NestedClass() {
        }
    }

    private static class IntegerRecommender
    implements ConfigDef.Recommender {
        private boolean hasParent;

        public IntegerRecommender(boolean hasParent) {
            this.hasParent = hasParent;
        }

        public List<Object> validValues(String name, Map<String, Object> parsedConfig) {
            LinkedList<Object> values = new LinkedList<Object>();
            if (!this.hasParent) {
                values.addAll(Arrays.asList(1, 2, 3));
            } else {
                values.addAll(Arrays.asList(4, 5));
            }
            return values;
        }

        public boolean visible(String name, Map<String, Object> parsedConfig) {
            return true;
        }
    }
}

