/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.apache.kafka.common.acl.AccessControlEntry;
import org.apache.kafka.common.acl.AclBinding;
import org.apache.kafka.common.acl.AclOperation;
import org.apache.kafka.common.acl.AclPermissionType;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.protocol.types.Struct;
import org.apache.kafka.common.requests.ApiError;
import org.apache.kafka.common.requests.DescribeAclsResponse;
import org.apache.kafka.common.resource.PatternType;
import org.apache.kafka.common.resource.ResourcePattern;
import org.apache.kafka.common.resource.ResourceType;
import org.junit.Assert;
import org.junit.Test;

public class DescribeAclsResponseTest {
    private static final short V0 = 0;
    private static final short V1 = 1;
    private static final AclBinding LITERAL_ACL1 = new AclBinding(new ResourcePattern(ResourceType.TOPIC, "foo", PatternType.LITERAL), new AccessControlEntry("User:ANONYMOUS", "127.0.0.1", AclOperation.READ, AclPermissionType.DENY));
    private static final AclBinding LITERAL_ACL2 = new AclBinding(new ResourcePattern(ResourceType.GROUP, "group", PatternType.LITERAL), new AccessControlEntry("User:*", "127.0.0.1", AclOperation.WRITE, AclPermissionType.ALLOW));
    private static final AclBinding PREFIXED_ACL1 = new AclBinding(new ResourcePattern(ResourceType.GROUP, "prefix", PatternType.PREFIXED), new AccessControlEntry("User:*", "127.0.0.1", AclOperation.CREATE, AclPermissionType.ALLOW));
    private static final AclBinding UNKNOWN_ACL = new AclBinding(new ResourcePattern(ResourceType.UNKNOWN, "foo", PatternType.LITERAL), new AccessControlEntry("User:ANONYMOUS", "127.0.0.1", AclOperation.READ, AclPermissionType.DENY));

    @Test(expected=UnsupportedVersionException.class)
    public void shouldThrowOnV0IfNotLiteral() {
        new DescribeAclsResponse(10, ApiError.NONE, DescribeAclsResponseTest.aclBindings(PREFIXED_ACL1)).toStruct((short)0);
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldThrowIfUnknown() {
        new DescribeAclsResponse(10, ApiError.NONE, DescribeAclsResponseTest.aclBindings(UNKNOWN_ACL)).toStruct((short)0);
    }

    @Test
    public void shouldRoundTripV0() {
        DescribeAclsResponse original = new DescribeAclsResponse(10, ApiError.NONE, DescribeAclsResponseTest.aclBindings(LITERAL_ACL1, LITERAL_ACL2));
        Struct struct = original.toStruct((short)0);
        DescribeAclsResponse result = new DescribeAclsResponse(struct);
        DescribeAclsResponseTest.assertResponseEquals(original, result);
    }

    @Test
    public void shouldRoundTripV1() {
        DescribeAclsResponse original = new DescribeAclsResponse(100, ApiError.NONE, DescribeAclsResponseTest.aclBindings(LITERAL_ACL1, PREFIXED_ACL1));
        Struct struct = original.toStruct((short)1);
        DescribeAclsResponse result = new DescribeAclsResponse(struct);
        DescribeAclsResponseTest.assertResponseEquals(original, result);
    }

    private static void assertResponseEquals(DescribeAclsResponse original, DescribeAclsResponse actual) {
        HashSet originalBindings = new HashSet(original.acls());
        HashSet actualBindings = new HashSet(actual.acls());
        Assert.assertEquals(originalBindings, actualBindings);
    }

    private static List<AclBinding> aclBindings(AclBinding ... bindings) {
        return Arrays.asList(bindings);
    }
}

