/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.message;

import java.util.Iterator;
import java.util.List;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.Message;
import org.apache.kafka.common.protocol.MessageUtil;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.protocol.Writable;
import org.apache.kafka.common.protocol.types.ArrayOf;
import org.apache.kafka.common.protocol.types.Field;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Struct;
import org.apache.kafka.common.protocol.types.Type;
import org.apache.kafka.common.utils.ImplicitLinkedHashCollection;
import org.apache.kafka.common.utils.ImplicitLinkedHashMultiCollection;

public class IncrementalAlterConfigsRequestData
implements ApiMessage {
    private AlterConfigsResourceCollection resources = new AlterConfigsResourceCollection(0);
    private boolean validateOnly;
    public static final Schema SCHEMA_0 = new Schema(new Field[]{new Field("resources", (Type)new ArrayOf((Type)AlterConfigsResource.SCHEMA_0), "The incremental updates for each resource."), new Field("validate_only", (Type)Type.BOOLEAN, "True if we should validate the request, but not change the configurations.")});
    public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0};

    public IncrementalAlterConfigsRequestData(Readable readable, short version) {
        this.read(readable, version);
    }

    public IncrementalAlterConfigsRequestData(Struct struct, short version) {
        this.fromStruct(struct, version);
    }

    public IncrementalAlterConfigsRequestData() {
        this.validateOnly = false;
    }

    public short apiKey() {
        return 44;
    }

    public short lowestSupportedVersion() {
        return 0;
    }

    public short highestSupportedVersion() {
        return 0;
    }

    public void read(Readable readable, short version) {
        int arrayLength = readable.readInt();
        if (arrayLength < 0) {
            this.resources = null;
        } else {
            this.resources.clear(arrayLength);
            for (int i = 0; i < arrayLength; ++i) {
                this.resources.add(new AlterConfigsResource(readable, version));
            }
        }
        this.validateOnly = readable.readByte() != 0;
    }

    public void write(Writable writable, short version) {
        writable.writeInt(this.resources.size());
        Iterator iterator = this.resources.iterator();
        while (iterator.hasNext()) {
            AlterConfigsResource element = (AlterConfigsResource)iterator.next();
            element.write(writable, version);
        }
        writable.writeByte(this.validateOnly ? (byte)1 : 0);
    }

    public void fromStruct(Struct struct, short version) {
        Object[] nestedObjects = struct.getArray("resources");
        this.resources = new AlterConfigsResourceCollection(nestedObjects.length);
        for (Object nestedObject : nestedObjects) {
            this.resources.add(new AlterConfigsResource((Struct)nestedObject, version));
        }
        this.validateOnly = struct.getBoolean("validate_only");
    }

    public Struct toStruct(short version) {
        Struct struct = new Struct(SCHEMAS[version]);
        Struct[] nestedObjects = new Struct[this.resources.size()];
        int i = 0;
        Iterator iterator = this.resources.iterator();
        while (iterator.hasNext()) {
            AlterConfigsResource element = (AlterConfigsResource)iterator.next();
            nestedObjects[i++] = element.toStruct(version);
        }
        struct.set("resources", (Object)nestedObjects);
        struct.set("validate_only", (Object)this.validateOnly);
        return struct;
    }

    public int size(short version) {
        int size = 0;
        size += 4;
        Iterator iterator = this.resources.iterator();
        while (iterator.hasNext()) {
            AlterConfigsResource element = (AlterConfigsResource)iterator.next();
            size += element.size(version);
        }
        return ++size;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof IncrementalAlterConfigsRequestData)) {
            return false;
        }
        IncrementalAlterConfigsRequestData other = (IncrementalAlterConfigsRequestData)obj;
        if (this.resources == null ? other.resources != null : !this.resources.equals((Object)other.resources)) {
            return false;
        }
        return this.validateOnly == other.validateOnly;
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = 31 * hashCode + (this.resources == null ? 0 : this.resources.hashCode());
        hashCode = 31 * hashCode + (this.validateOnly ? 1231 : 1237);
        return hashCode;
    }

    public String toString() {
        return "IncrementalAlterConfigsRequestData(resources=" + MessageUtil.deepToString((Iterator)this.resources.iterator()) + ", validateOnly=" + (this.validateOnly ? "true" : "false") + ")";
    }

    public AlterConfigsResourceCollection resources() {
        return this.resources;
    }

    public boolean validateOnly() {
        return this.validateOnly;
    }

    public IncrementalAlterConfigsRequestData setResources(AlterConfigsResourceCollection v) {
        this.resources = v;
        return this;
    }

    public IncrementalAlterConfigsRequestData setValidateOnly(boolean v) {
        this.validateOnly = v;
        return this;
    }

    public static class AlterConfigsResourceCollection
    extends ImplicitLinkedHashMultiCollection<AlterConfigsResource> {
        public AlterConfigsResourceCollection() {
        }

        public AlterConfigsResourceCollection(int expectedNumElements) {
            super(expectedNumElements);
        }

        public AlterConfigsResourceCollection(Iterator<AlterConfigsResource> iterator) {
            super(iterator);
        }

        public AlterConfigsResource find(byte resourceType, String resourceName) {
            AlterConfigsResource key = new AlterConfigsResource();
            key.setResourceType(resourceType);
            key.setResourceName(resourceName);
            return (AlterConfigsResource)this.find(key);
        }

        public List<AlterConfigsResource> findAll(byte resourceType, String resourceName) {
            AlterConfigsResource key = new AlterConfigsResource();
            key.setResourceType(resourceType);
            key.setResourceName(resourceName);
            return this.findAll(key);
        }
    }

    public static class AlterableConfigCollection
    extends ImplicitLinkedHashMultiCollection<AlterableConfig> {
        public AlterableConfigCollection() {
        }

        public AlterableConfigCollection(int expectedNumElements) {
            super(expectedNumElements);
        }

        public AlterableConfigCollection(Iterator<AlterableConfig> iterator) {
            super(iterator);
        }

        public AlterableConfig find(String name, byte configOperation) {
            AlterableConfig key = new AlterableConfig();
            key.setName(name);
            key.setConfigOperation(configOperation);
            return (AlterableConfig)this.find(key);
        }

        public List<AlterableConfig> findAll(String name, byte configOperation) {
            AlterableConfig key = new AlterableConfig();
            key.setName(name);
            key.setConfigOperation(configOperation);
            return this.findAll(key);
        }
    }

    public static class AlterableConfig
    implements Message,
    ImplicitLinkedHashCollection.Element {
        private String name;
        private byte configOperation;
        private String value;
        private int next;
        private int prev;
        public static final Schema SCHEMA_0 = new Schema(new Field[]{new Field("name", (Type)Type.STRING, "The configuration key name."), new Field("config_operation", (Type)Type.INT8, "The type (Set, Delete, Append, Subtract) of operation."), new Field("value", (Type)Type.NULLABLE_STRING, "The value to set for the configuration key.")});
        public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0};

        public AlterableConfig(Readable readable, short version) {
            this.read(readable, version);
        }

        public AlterableConfig(Struct struct, short version) {
            this.fromStruct(struct, version);
        }

        public AlterableConfig() {
            this.name = "";
            this.configOperation = 0;
            this.value = "";
        }

        public short lowestSupportedVersion() {
            return 0;
        }

        public short highestSupportedVersion() {
            return 0;
        }

        public void read(Readable readable, short version) {
            this.name = readable.readNullableString();
            this.configOperation = readable.readByte();
            this.value = readable.readNullableString();
        }

        public void write(Writable writable, short version) {
            writable.writeString(this.name);
            writable.writeByte(this.configOperation);
            writable.writeNullableString(this.value);
        }

        public void fromStruct(Struct struct, short version) {
            this.name = struct.getString("name");
            this.configOperation = struct.getByte("config_operation");
            this.value = struct.getString("value");
        }

        public Struct toStruct(short version) {
            Struct struct = new Struct(SCHEMAS[version]);
            struct.set("name", (Object)this.name);
            struct.set("config_operation", (Object)this.configOperation);
            struct.set("value", (Object)this.value);
            return struct;
        }

        public int size(short version) {
            int size = 0;
            size += 2;
            size += MessageUtil.serializedUtf8Length((CharSequence)this.name);
            ++size;
            size += 2;
            if (this.value != null) {
                size += MessageUtil.serializedUtf8Length((CharSequence)this.value);
            }
            return size;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof AlterableConfig)) {
                return false;
            }
            AlterableConfig other = (AlterableConfig)obj;
            if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
                return false;
            }
            return this.configOperation == other.configOperation;
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + (this.name == null ? 0 : this.name.hashCode());
            hashCode = 31 * hashCode + this.configOperation;
            return hashCode;
        }

        public String toString() {
            return "AlterableConfig(name='" + this.name + "', configOperation=" + this.configOperation + ", value='" + this.value + "')";
        }

        public String name() {
            return this.name;
        }

        public byte configOperation() {
            return this.configOperation;
        }

        public String value() {
            return this.value;
        }

        public int next() {
            return this.next;
        }

        public int prev() {
            return this.prev;
        }

        public AlterableConfig setName(String v) {
            this.name = v;
            return this;
        }

        public AlterableConfig setConfigOperation(byte v) {
            this.configOperation = v;
            return this;
        }

        public AlterableConfig setValue(String v) {
            this.value = v;
            return this;
        }

        public void setNext(int v) {
            this.next = v;
        }

        public void setPrev(int v) {
            this.prev = v;
        }
    }

    public static class AlterConfigsResource
    implements Message,
    ImplicitLinkedHashCollection.Element {
        private byte resourceType;
        private String resourceName;
        private AlterableConfigCollection configs;
        private int next;
        private int prev;
        public static final Schema SCHEMA_0 = new Schema(new Field[]{new Field("resource_type", (Type)Type.INT8, "The resource type."), new Field("resource_name", (Type)Type.STRING, "The resource name."), new Field("configs", (Type)new ArrayOf((Type)AlterableConfig.SCHEMA_0), "The configurations.")});
        public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0};

        public AlterConfigsResource(Readable readable, short version) {
            this.configs = new AlterableConfigCollection(0);
            this.read(readable, version);
        }

        public AlterConfigsResource(Struct struct, short version) {
            this.configs = new AlterableConfigCollection(0);
            this.fromStruct(struct, version);
        }

        public AlterConfigsResource() {
            this.resourceType = 0;
            this.resourceName = "";
            this.configs = new AlterableConfigCollection(0);
        }

        public short lowestSupportedVersion() {
            return 0;
        }

        public short highestSupportedVersion() {
            return 0;
        }

        public void read(Readable readable, short version) {
            this.resourceType = readable.readByte();
            this.resourceName = readable.readNullableString();
            int arrayLength = readable.readInt();
            if (arrayLength < 0) {
                this.configs = null;
            } else {
                this.configs.clear(arrayLength);
                for (int i = 0; i < arrayLength; ++i) {
                    this.configs.add(new AlterableConfig(readable, version));
                }
            }
        }

        public void write(Writable writable, short version) {
            writable.writeByte(this.resourceType);
            writable.writeString(this.resourceName);
            writable.writeInt(this.configs.size());
            Iterator iterator = this.configs.iterator();
            while (iterator.hasNext()) {
                AlterableConfig element = (AlterableConfig)iterator.next();
                element.write(writable, version);
            }
        }

        public void fromStruct(Struct struct, short version) {
            this.resourceType = struct.getByte("resource_type");
            this.resourceName = struct.getString("resource_name");
            Object[] nestedObjects = struct.getArray("configs");
            this.configs = new AlterableConfigCollection(nestedObjects.length);
            for (Object nestedObject : nestedObjects) {
                this.configs.add(new AlterableConfig((Struct)nestedObject, version));
            }
        }

        public Struct toStruct(short version) {
            Struct struct = new Struct(SCHEMAS[version]);
            struct.set("resource_type", (Object)this.resourceType);
            struct.set("resource_name", (Object)this.resourceName);
            Struct[] nestedObjects = new Struct[this.configs.size()];
            int i = 0;
            Iterator iterator = this.configs.iterator();
            while (iterator.hasNext()) {
                AlterableConfig element = (AlterableConfig)iterator.next();
                nestedObjects[i++] = element.toStruct(version);
            }
            struct.set("configs", (Object)nestedObjects);
            return struct;
        }

        public int size(short version) {
            int size = 0;
            ++size;
            size += 2;
            size += MessageUtil.serializedUtf8Length((CharSequence)this.resourceName);
            size += 4;
            Iterator iterator = this.configs.iterator();
            while (iterator.hasNext()) {
                AlterableConfig element = (AlterableConfig)iterator.next();
                size += element.size(version);
            }
            return size;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof AlterConfigsResource)) {
                return false;
            }
            AlterConfigsResource other = (AlterConfigsResource)obj;
            if (this.resourceType != other.resourceType) {
                return false;
            }
            return !(this.resourceName == null ? other.resourceName != null : !this.resourceName.equals(other.resourceName));
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + this.resourceType;
            hashCode = 31 * hashCode + (this.resourceName == null ? 0 : this.resourceName.hashCode());
            return hashCode;
        }

        public String toString() {
            return "AlterConfigsResource(resourceType=" + this.resourceType + ", resourceName='" + this.resourceName + "', configs=" + MessageUtil.deepToString((Iterator)this.configs.iterator()) + ")";
        }

        public byte resourceType() {
            return this.resourceType;
        }

        public String resourceName() {
            return this.resourceName;
        }

        public AlterableConfigCollection configs() {
            return this.configs;
        }

        public int next() {
            return this.next;
        }

        public int prev() {
            return this.prev;
        }

        public AlterConfigsResource setResourceType(byte v) {
            this.resourceType = v;
            return this;
        }

        public AlterConfigsResource setResourceName(String v) {
            this.resourceName = v;
            return this;
        }

        public AlterConfigsResource setConfigs(AlterableConfigCollection v) {
            this.configs = v;
            return this;
        }

        public void setNext(int v) {
            this.next = v;
        }

        public void setPrev(int v) {
            this.prev = v;
        }
    }
}

