/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.producer.internals;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.kafka.clients.ApiVersions;
import org.apache.kafka.clients.NodeApiVersions;
import org.apache.kafka.clients.producer.Callback;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.clients.producer.internals.BufferPool;
import org.apache.kafka.clients.producer.internals.FutureRecordMetadata;
import org.apache.kafka.clients.producer.internals.ProducerBatch;
import org.apache.kafka.clients.producer.internals.RecordAccumulator;
import org.apache.kafka.clients.producer.internals.TransactionManager;
import org.apache.kafka.common.Cluster;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.PartitionInfo;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.header.Header;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.record.CompressionRatioEstimator;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.DefaultRecord;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.MemoryRecordsBuilder;
import org.apache.kafka.common.record.MutableRecordBatch;
import org.apache.kafka.common.record.Record;
import org.apache.kafka.common.record.TimestampType;
import org.apache.kafka.common.requests.ApiVersionsResponse;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.test.TestUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;

public class RecordAccumulatorTest {
    private String topic = "test";
    private int partition1 = 0;
    private int partition2 = 1;
    private int partition3 = 2;
    private Node node1 = new Node(0, "localhost", 1111);
    private Node node2 = new Node(1, "localhost", 1112);
    private TopicPartition tp1 = new TopicPartition(this.topic, this.partition1);
    private TopicPartition tp2 = new TopicPartition(this.topic, this.partition2);
    private TopicPartition tp3 = new TopicPartition(this.topic, this.partition3);
    private PartitionInfo part1 = new PartitionInfo(this.topic, this.partition1, this.node1, null, null);
    private PartitionInfo part2 = new PartitionInfo(this.topic, this.partition2, this.node1, null, null);
    private PartitionInfo part3 = new PartitionInfo(this.topic, this.partition3, this.node2, null, null);
    private MockTime time = new MockTime();
    private byte[] key = "key".getBytes();
    private byte[] value = "value".getBytes();
    private int msgSize = DefaultRecord.sizeInBytes((int)0, (long)0L, (int)this.key.length, (int)this.value.length, (Header[])Record.EMPTY_HEADERS);
    private Cluster cluster = new Cluster(null, Arrays.asList(this.node1, this.node2), Arrays.asList(this.part1, this.part2, this.part3), Collections.emptySet(), Collections.emptySet());
    private Metrics metrics = new Metrics((Time)this.time);
    private final long maxBlockTimeMs = 1000L;
    private final LogContext logContext = new LogContext();

    @After
    public void teardown() {
        this.metrics.close();
    }

    @Test
    public void testFull() throws Exception {
        long now = this.time.milliseconds();
        int batchSize = 1025;
        RecordAccumulator accum = this.createTestRecordAccumulator(batchSize + 61, 10L * (long)batchSize, CompressionType.NONE, 10);
        int appends = this.expectedNumAppends(batchSize);
        for (int i = 0; i < appends; ++i) {
            accum.append(this.tp1, 0L, this.key, this.value, Record.EMPTY_HEADERS, null, 1000L);
            Deque partitionBatches = (Deque)accum.batches().get(this.tp1);
            Assert.assertEquals((long)1L, (long)partitionBatches.size());
            ProducerBatch batch = (ProducerBatch)partitionBatches.peekFirst();
            Assert.assertTrue((boolean)batch.isWritable());
            Assert.assertEquals((String)"No partitions should be ready.", (long)0L, (long)accum.ready((Cluster)this.cluster, (long)now).readyNodes.size());
        }
        accum.append(this.tp1, 0L, this.key, this.value, Record.EMPTY_HEADERS, null, 1000L);
        Deque partitionBatches = (Deque)accum.batches().get(this.tp1);
        Assert.assertEquals((long)2L, (long)partitionBatches.size());
        Iterator partitionBatchesIterator = partitionBatches.iterator();
        Assert.assertTrue((boolean)((ProducerBatch)partitionBatchesIterator.next()).isWritable());
        Assert.assertEquals((String)"Our partition's leader should be ready", Collections.singleton(this.node1), (Object)accum.ready((Cluster)this.cluster, (long)this.time.milliseconds()).readyNodes);
        List batches = (List)accum.drain(this.cluster, Collections.singleton(this.node1), Integer.MAX_VALUE, 0L).get(this.node1.id());
        Assert.assertEquals((long)1L, (long)batches.size());
        ProducerBatch batch = (ProducerBatch)batches.get(0);
        Iterator iter = batch.records().records().iterator();
        for (int i = 0; i < appends; ++i) {
            Record record = (Record)iter.next();
            Assert.assertEquals((String)"Keys should match", (Object)ByteBuffer.wrap(this.key), (Object)record.key());
            Assert.assertEquals((String)"Values should match", (Object)ByteBuffer.wrap(this.value), (Object)record.value());
        }
        Assert.assertFalse((String)"No more records", (boolean)iter.hasNext());
    }

    @Test
    public void testAppendLargeCompressed() throws Exception {
        this.testAppendLarge(CompressionType.GZIP);
    }

    @Test
    public void testAppendLargeNonCompressed() throws Exception {
        this.testAppendLarge(CompressionType.NONE);
    }

    private void testAppendLarge(CompressionType compressionType) throws Exception {
        int batchSize = 512;
        byte[] value = new byte[2 * batchSize];
        RecordAccumulator accum = this.createTestRecordAccumulator(batchSize + 61, 10240L, compressionType, 0);
        accum.append(this.tp1, 0L, this.key, value, Record.EMPTY_HEADERS, null, 1000L);
        Assert.assertEquals((String)"Our partition's leader should be ready", Collections.singleton(this.node1), (Object)accum.ready((Cluster)this.cluster, (long)this.time.milliseconds()).readyNodes);
        Deque batches = (Deque)accum.batches().get(this.tp1);
        Assert.assertEquals((long)1L, (long)batches.size());
        ProducerBatch producerBatch = (ProducerBatch)batches.peek();
        List recordBatches = TestUtils.toList(producerBatch.records().batches());
        Assert.assertEquals((long)1L, (long)recordBatches.size());
        MutableRecordBatch recordBatch = (MutableRecordBatch)recordBatches.get(0);
        Assert.assertEquals((long)0L, (long)recordBatch.baseOffset());
        List records = TestUtils.toList(recordBatch);
        Assert.assertEquals((long)1L, (long)records.size());
        Record record = (Record)records.get(0);
        Assert.assertEquals((long)0L, (long)record.offset());
        Assert.assertEquals((Object)ByteBuffer.wrap(this.key), (Object)record.key());
        Assert.assertEquals((Object)ByteBuffer.wrap(value), (Object)record.value());
        Assert.assertEquals((long)0L, (long)record.timestamp());
    }

    @Test
    public void testAppendLargeOldMessageFormatCompressed() throws Exception {
        this.testAppendLargeOldMessageFormat(CompressionType.GZIP);
    }

    @Test
    public void testAppendLargeOldMessageFormatNonCompressed() throws Exception {
        this.testAppendLargeOldMessageFormat(CompressionType.NONE);
    }

    private void testAppendLargeOldMessageFormat(CompressionType compressionType) throws Exception {
        int batchSize = 512;
        byte[] value = new byte[2 * batchSize];
        ApiVersions apiVersions = new ApiVersions();
        apiVersions.update(this.node1.idString(), NodeApiVersions.create(Collections.singleton(new ApiVersionsResponse.ApiVersion(ApiKeys.PRODUCE, 0, 2))));
        RecordAccumulator accum = this.createTestRecordAccumulator(batchSize + 61, 10240L, compressionType, 0);
        accum.append(this.tp1, 0L, this.key, value, Record.EMPTY_HEADERS, null, 1000L);
        Assert.assertEquals((String)"Our partition's leader should be ready", Collections.singleton(this.node1), (Object)accum.ready((Cluster)this.cluster, (long)this.time.milliseconds()).readyNodes);
        Deque batches = (Deque)accum.batches().get(this.tp1);
        Assert.assertEquals((long)1L, (long)batches.size());
        ProducerBatch producerBatch = (ProducerBatch)batches.peek();
        List recordBatches = TestUtils.toList(producerBatch.records().batches());
        Assert.assertEquals((long)1L, (long)recordBatches.size());
        MutableRecordBatch recordBatch = (MutableRecordBatch)recordBatches.get(0);
        Assert.assertEquals((long)0L, (long)recordBatch.baseOffset());
        List records = TestUtils.toList(recordBatch);
        Assert.assertEquals((long)1L, (long)records.size());
        Record record = (Record)records.get(0);
        Assert.assertEquals((long)0L, (long)record.offset());
        Assert.assertEquals((Object)ByteBuffer.wrap(this.key), (Object)record.key());
        Assert.assertEquals((Object)ByteBuffer.wrap(value), (Object)record.value());
        Assert.assertEquals((long)0L, (long)record.timestamp());
    }

    @Test
    public void testLinger() throws Exception {
        int lingerMs = 10;
        RecordAccumulator accum = this.createTestRecordAccumulator(1085, 10240L, CompressionType.NONE, lingerMs);
        accum.append(this.tp1, 0L, this.key, this.value, Record.EMPTY_HEADERS, null, 1000L);
        Assert.assertEquals((String)"No partitions should be ready", (long)0L, (long)accum.ready((Cluster)this.cluster, (long)this.time.milliseconds()).readyNodes.size());
        this.time.sleep(10L);
        Assert.assertEquals((String)"Our partition's leader should be ready", Collections.singleton(this.node1), (Object)accum.ready((Cluster)this.cluster, (long)this.time.milliseconds()).readyNodes);
        List batches = (List)accum.drain(this.cluster, Collections.singleton(this.node1), Integer.MAX_VALUE, 0L).get(this.node1.id());
        Assert.assertEquals((long)1L, (long)batches.size());
        ProducerBatch batch = (ProducerBatch)batches.get(0);
        Iterator iter = batch.records().records().iterator();
        Record record = (Record)iter.next();
        Assert.assertEquals((String)"Keys should match", (Object)ByteBuffer.wrap(this.key), (Object)record.key());
        Assert.assertEquals((String)"Values should match", (Object)ByteBuffer.wrap(this.value), (Object)record.value());
        Assert.assertFalse((String)"No more records", (boolean)iter.hasNext());
    }

    @Test
    public void testPartialDrain() throws Exception {
        RecordAccumulator accum = this.createTestRecordAccumulator(1085, 10240L, CompressionType.NONE, 10);
        int appends = 1024 / this.msgSize + 1;
        List<TopicPartition> partitions = Arrays.asList(this.tp1, this.tp2);
        for (TopicPartition tp : partitions) {
            for (int i = 0; i < appends; ++i) {
                accum.append(tp, 0L, this.key, this.value, Record.EMPTY_HEADERS, null, 1000L);
            }
        }
        Assert.assertEquals((String)"Partition's leader should be ready", Collections.singleton(this.node1), (Object)accum.ready((Cluster)this.cluster, (long)this.time.milliseconds()).readyNodes);
        List batches = (List)accum.drain(this.cluster, Collections.singleton(this.node1), 1024, 0L).get(this.node1.id());
        Assert.assertEquals((String)"But due to size bound only one partition should have been retrieved", (long)1L, (long)batches.size());
    }

    @Test
    public void testStressfulSituation() throws Exception {
        int numThreads = 5;
        int msgs = 10000;
        int numParts = 2;
        final RecordAccumulator accum = this.createTestRecordAccumulator(1085, 10240L, CompressionType.NONE, 0);
        ArrayList<1> threads = new ArrayList<1>();
        for (int i = 0; i < 5; ++i) {
            threads.add(new Thread(){

                @Override
                public void run() {
                    for (int i = 0; i < 10000; ++i) {
                        try {
                            accum.append(new TopicPartition(RecordAccumulatorTest.this.topic, i % 2), 0L, RecordAccumulatorTest.this.key, RecordAccumulatorTest.this.value, Record.EMPTY_HEADERS, null, 1000L);
                            continue;
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }
            });
        }
        for (Thread thread : threads) {
            thread.start();
        }
        int read = 0;
        long l = this.time.milliseconds();
        while (read < 50000) {
            Set nodes = accum.ready((Cluster)this.cluster, (long)l).readyNodes;
            List list = (List)accum.drain(this.cluster, nodes, 5120, 0L).get(this.node1.id());
            if (list == null) continue;
            for (ProducerBatch batch : list) {
                for (Record record : batch.records().records()) {
                    ++read;
                }
                accum.deallocate(batch);
            }
        }
        for (Thread thread : threads) {
            thread.join();
        }
    }

    @Test
    public void testNextReadyCheckDelay() throws Exception {
        int i;
        int lingerMs = 10;
        int batchSize = 1025;
        RecordAccumulator accum = this.createTestRecordAccumulator(batchSize + 61, 10 * batchSize, CompressionType.NONE, lingerMs);
        int appends = this.expectedNumAppends(batchSize);
        for (int i2 = 0; i2 < appends; ++i2) {
            accum.append(this.tp1, 0L, this.key, this.value, Record.EMPTY_HEADERS, null, 1000L);
        }
        RecordAccumulator.ReadyCheckResult result = accum.ready(this.cluster, this.time.milliseconds());
        Assert.assertEquals((String)"No nodes should be ready.", (long)0L, (long)result.readyNodes.size());
        Assert.assertEquals((String)"Next check time should be the linger time", (long)lingerMs, (long)result.nextReadyCheckDelayMs);
        this.time.sleep(lingerMs / 2);
        for (i = 0; i < appends; ++i) {
            accum.append(this.tp3, 0L, this.key, this.value, Record.EMPTY_HEADERS, null, 1000L);
        }
        result = accum.ready(this.cluster, this.time.milliseconds());
        Assert.assertEquals((String)"No nodes should be ready.", (long)0L, (long)result.readyNodes.size());
        Assert.assertEquals((String)"Next check time should be defined by node1, half remaining linger time", (long)(lingerMs / 2), (long)result.nextReadyCheckDelayMs);
        for (i = 0; i < appends + 1; ++i) {
            accum.append(this.tp2, 0L, this.key, this.value, Record.EMPTY_HEADERS, null, 1000L);
        }
        result = accum.ready(this.cluster, this.time.milliseconds());
        Assert.assertEquals((String)"Node1 should be ready", Collections.singleton(this.node1), (Object)result.readyNodes);
        Assert.assertTrue((String)"Next check time should be defined by node2, at most linger time", (result.nextReadyCheckDelayMs <= (long)lingerMs ? 1 : 0) != 0);
    }

    @Test
    public void testRetryBackoff() throws Exception {
        int lingerMs = 0x7FFFFFF;
        long retryBackoffMs = 0xFFFFFFFL;
        int deliveryTimeoutMs = Integer.MAX_VALUE;
        long totalSize = 10240L;
        int batchSize = 1085;
        String metricGrpName = "producer-metrics";
        RecordAccumulator accum = new RecordAccumulator(this.logContext, batchSize, CompressionType.NONE, lingerMs, retryBackoffMs, deliveryTimeoutMs, this.metrics, metricGrpName, (Time)this.time, new ApiVersions(), null, new BufferPool(totalSize, batchSize, this.metrics, (Time)this.time, metricGrpName));
        long now = this.time.milliseconds();
        accum.append(this.tp1, 0L, this.key, this.value, Record.EMPTY_HEADERS, null, 1000L);
        RecordAccumulator.ReadyCheckResult result = accum.ready(this.cluster, now + (long)lingerMs + 1L);
        Assert.assertEquals((String)"Node1 should be ready", Collections.singleton(this.node1), (Object)result.readyNodes);
        Map batches = accum.drain(this.cluster, result.readyNodes, Integer.MAX_VALUE, now + (long)lingerMs + 1L);
        Assert.assertEquals((String)"Node1 should be the only ready node.", (long)1L, (long)batches.size());
        Assert.assertEquals((String)"Partition 0 should only have one batch drained.", (long)1L, (long)((List)batches.get(0)).size());
        now = this.time.milliseconds();
        accum.reenqueue((ProducerBatch)((List)batches.get(0)).get(0), now);
        accum.append(this.tp2, 0L, this.key, this.value, Record.EMPTY_HEADERS, null, 1000L);
        result = accum.ready(this.cluster, now + (long)lingerMs + 1L);
        Assert.assertEquals((String)"Node1 should be ready", Collections.singleton(this.node1), (Object)result.readyNodes);
        batches = accum.drain(this.cluster, result.readyNodes, Integer.MAX_VALUE, now + (long)lingerMs + 1L);
        Assert.assertEquals((String)"Node1 should be the only ready node.", (long)1L, (long)batches.size());
        Assert.assertEquals((String)"Node1 should only have one batch drained.", (long)1L, (long)((List)batches.get(0)).size());
        Assert.assertEquals((String)"Node1 should only have one batch for partition 1.", (Object)this.tp2, (Object)((ProducerBatch)((List)batches.get((Object)Integer.valueOf((int)0))).get((int)0)).topicPartition);
        result = accum.ready(this.cluster, now + retryBackoffMs + 1L);
        Assert.assertEquals((String)"Node1 should be ready", Collections.singleton(this.node1), (Object)result.readyNodes);
        batches = accum.drain(this.cluster, result.readyNodes, Integer.MAX_VALUE, now + retryBackoffMs + 1L);
        Assert.assertEquals((String)"Node1 should be the only ready node.", (long)1L, (long)batches.size());
        Assert.assertEquals((String)"Node1 should only have one batch drained.", (long)1L, (long)((List)batches.get(0)).size());
        Assert.assertEquals((String)"Node1 should only have one batch for partition 0.", (Object)this.tp1, (Object)((ProducerBatch)((List)batches.get((Object)Integer.valueOf((int)0))).get((int)0)).topicPartition);
    }

    @Test
    public void testFlush() throws Exception {
        int lingerMs = Integer.MAX_VALUE;
        RecordAccumulator accum = this.createTestRecordAccumulator(4157, 65536L, CompressionType.NONE, lingerMs);
        for (int i = 0; i < 100; ++i) {
            accum.append(new TopicPartition(this.topic, i % 3), 0L, this.key, this.value, Record.EMPTY_HEADERS, null, 1000L);
            Assert.assertTrue((boolean)accum.hasIncomplete());
        }
        RecordAccumulator.ReadyCheckResult result = accum.ready(this.cluster, this.time.milliseconds());
        Assert.assertEquals((String)"No nodes should be ready.", (long)0L, (long)result.readyNodes.size());
        accum.beginFlush();
        result = accum.ready(this.cluster, this.time.milliseconds());
        Map results = accum.drain(this.cluster, result.readyNodes, Integer.MAX_VALUE, this.time.milliseconds());
        Assert.assertTrue((boolean)accum.hasIncomplete());
        for (List batches : results.values()) {
            for (ProducerBatch batch : batches) {
                accum.deallocate(batch);
            }
        }
        accum.awaitFlushCompletion();
        Assert.assertFalse((boolean)accum.hasUndrained());
        Assert.assertFalse((boolean)accum.hasIncomplete());
    }

    private void delayedInterrupt(final Thread thread, final long delayMs) {
        Thread t = new Thread(){

            @Override
            public void run() {
                Time.SYSTEM.sleep(delayMs);
                thread.interrupt();
            }
        };
        t.start();
    }

    @Test
    public void testAwaitFlushComplete() throws Exception {
        RecordAccumulator accum = this.createTestRecordAccumulator(4157, 65536L, CompressionType.NONE, Integer.MAX_VALUE);
        accum.append(new TopicPartition(this.topic, 0), 0L, this.key, this.value, Record.EMPTY_HEADERS, null, 1000L);
        accum.beginFlush();
        Assert.assertTrue((boolean)accum.flushInProgress());
        this.delayedInterrupt(Thread.currentThread(), 1000L);
        try {
            accum.awaitFlushCompletion();
            Assert.fail((String)"awaitFlushCompletion should throw InterruptException");
        }
        catch (InterruptedException e) {
            Assert.assertFalse((String)"flushInProgress count should be decremented even if thread is interrupted", (boolean)accum.flushInProgress());
        }
    }

    @Test
    public void testAbortIncompleteBatches() throws Exception {
        int lingerMs = Integer.MAX_VALUE;
        int numRecords = 100;
        final AtomicInteger numExceptionReceivedInCallback = new AtomicInteger(0);
        RecordAccumulator accum = this.createTestRecordAccumulator(189, 65536L, CompressionType.NONE, lingerMs);
        for (int i = 0; i < numRecords; ++i) {
            class TestCallback
            implements Callback {
                TestCallback() {
                }

                public void onCompletion(RecordMetadata metadata, Exception exception) {
                    Assert.assertTrue((boolean)exception.getMessage().equals("Producer is closed forcefully."));
                    numExceptionReceivedInCallback.incrementAndGet();
                }
            }
            accum.append(new TopicPartition(this.topic, i % 3), 0L, this.key, this.value, null, (Callback)new TestCallback(), 1000L);
        }
        RecordAccumulator.ReadyCheckResult result = accum.ready(this.cluster, this.time.milliseconds());
        Assert.assertFalse((boolean)result.readyNodes.isEmpty());
        Map drained = accum.drain(this.cluster, result.readyNodes, Integer.MAX_VALUE, this.time.milliseconds());
        Assert.assertTrue((boolean)accum.hasUndrained());
        Assert.assertTrue((boolean)accum.hasIncomplete());
        int numDrainedRecords = 0;
        for (Map.Entry drainedEntry : drained.entrySet()) {
            for (ProducerBatch batch : (List)drainedEntry.getValue()) {
                Assert.assertTrue((boolean)batch.isClosed());
                Assert.assertFalse((boolean)batch.produceFuture.completed());
                numDrainedRecords += batch.recordCount;
            }
        }
        Assert.assertTrue((numDrainedRecords > 0 && numDrainedRecords < numRecords ? 1 : 0) != 0);
        accum.abortIncompleteBatches();
        Assert.assertEquals((long)numRecords, (long)numExceptionReceivedInCallback.get());
        Assert.assertFalse((boolean)accum.hasUndrained());
        Assert.assertFalse((boolean)accum.hasIncomplete());
    }

    @Test
    public void testAbortUnsentBatches() throws Exception {
        int lingerMs = Integer.MAX_VALUE;
        int numRecords = 100;
        final AtomicInteger numExceptionReceivedInCallback = new AtomicInteger(0);
        RecordAccumulator accum = this.createTestRecordAccumulator(189, 65536L, CompressionType.NONE, lingerMs);
        final KafkaException cause = new KafkaException();
        for (int i = 0; i < numRecords; ++i) {
            class TestCallback
            implements Callback {
                TestCallback() {
                }

                public void onCompletion(RecordMetadata metadata, Exception exception) {
                    Assert.assertEquals((Object)((Object)cause), (Object)exception);
                    numExceptionReceivedInCallback.incrementAndGet();
                }
            }
            accum.append(new TopicPartition(this.topic, i % 3), 0L, this.key, this.value, null, (Callback)new TestCallback(), 1000L);
        }
        RecordAccumulator.ReadyCheckResult result = accum.ready(this.cluster, this.time.milliseconds());
        Assert.assertFalse((boolean)result.readyNodes.isEmpty());
        Map drained = accum.drain(this.cluster, result.readyNodes, Integer.MAX_VALUE, this.time.milliseconds());
        Assert.assertTrue((boolean)accum.hasUndrained());
        Assert.assertTrue((boolean)accum.hasIncomplete());
        accum.abortUndrainedBatches((RuntimeException)((Object)cause));
        int numDrainedRecords = 0;
        for (Map.Entry drainedEntry : drained.entrySet()) {
            for (ProducerBatch batch : (List)drainedEntry.getValue()) {
                Assert.assertTrue((boolean)batch.isClosed());
                Assert.assertFalse((boolean)batch.produceFuture.completed());
                numDrainedRecords += batch.recordCount;
            }
        }
        Assert.assertTrue((numDrainedRecords > 0 ? 1 : 0) != 0);
        Assert.assertTrue((numExceptionReceivedInCallback.get() > 0 ? 1 : 0) != 0);
        Assert.assertEquals((long)numRecords, (long)(numExceptionReceivedInCallback.get() + numDrainedRecords));
        Assert.assertFalse((boolean)accum.hasUndrained());
        Assert.assertTrue((boolean)accum.hasIncomplete());
    }

    private void doExpireBatchSingle(int deliveryTimeoutMs) throws InterruptedException {
        int lingerMs = 300;
        List<Boolean> muteStates = Arrays.asList(false, true);
        Set readyNodes = null;
        List expiredBatches = new ArrayList();
        int batchSize = 1025;
        RecordAccumulator accum = this.createTestRecordAccumulator(deliveryTimeoutMs, batchSize + 61, 10 * batchSize, CompressionType.NONE, lingerMs);
        for (Boolean mute : muteStates) {
            if (this.time.milliseconds() < System.currentTimeMillis()) {
                this.time.setCurrentTimeMs(System.currentTimeMillis());
            }
            accum.append(this.tp1, 0L, this.key, this.value, Record.EMPTY_HEADERS, null, 1000L);
            Assert.assertEquals((String)"No partition should be ready.", (long)0L, (long)accum.ready((Cluster)this.cluster, (long)this.time.milliseconds()).readyNodes.size());
            this.time.sleep(lingerMs);
            readyNodes = accum.ready((Cluster)this.cluster, (long)this.time.milliseconds()).readyNodes;
            Assert.assertEquals((String)"Our partition's leader should be ready", Collections.singleton(this.node1), (Object)readyNodes);
            expiredBatches = accum.expiredBatches(this.time.milliseconds());
            Assert.assertEquals((String)"The batch should not expire when just linger has passed", (long)0L, (long)expiredBatches.size());
            if (mute.booleanValue()) {
                accum.mutePartition(this.tp1);
            } else {
                accum.unmutePartition(this.tp1, 0L);
            }
            this.time.sleep(deliveryTimeoutMs - lingerMs);
            expiredBatches = accum.expiredBatches(this.time.milliseconds());
            Assert.assertEquals((String)"The batch may expire when the partition is muted", (long)1L, (long)expiredBatches.size());
            Assert.assertEquals((String)"No partitions should be ready.", (long)0L, (long)accum.ready((Cluster)this.cluster, (long)this.time.milliseconds()).readyNodes.size());
        }
    }

    @Test
    public void testExpiredBatchSingle() throws InterruptedException {
        this.doExpireBatchSingle(3200);
    }

    @Test
    public void testExpiredBatchSingleMaxValue() throws InterruptedException {
        this.doExpireBatchSingle(Integer.MAX_VALUE);
    }

    @Test
    public void testExpiredBatches() throws InterruptedException {
        long retryBackoffMs = 100L;
        int lingerMs = 30;
        int requestTimeout = 60;
        int deliveryTimeoutMs = 3200;
        int batchSize = 1025;
        RecordAccumulator accum = this.createTestRecordAccumulator(deliveryTimeoutMs, batchSize + 61, 10 * batchSize, CompressionType.NONE, lingerMs);
        int appends = this.expectedNumAppends(batchSize);
        for (int i = 0; i < appends; ++i) {
            accum.append(this.tp1, 0L, this.key, this.value, Record.EMPTY_HEADERS, null, 1000L);
            Assert.assertEquals((String)"No partitions should be ready.", (long)0L, (long)accum.ready((Cluster)this.cluster, (long)this.time.milliseconds()).readyNodes.size());
        }
        accum.append(this.tp1, 0L, this.key, this.value, Record.EMPTY_HEADERS, null, 0L);
        Set readyNodes = accum.ready((Cluster)this.cluster, (long)this.time.milliseconds()).readyNodes;
        Assert.assertEquals((String)"Our partition's leader should be ready", Collections.singleton(this.node1), (Object)readyNodes);
        this.time.sleep(deliveryTimeoutMs + 1);
        accum.mutePartition(this.tp1);
        List expiredBatches = accum.expiredBatches(this.time.milliseconds());
        Assert.assertEquals((String)"The batches will be muted no matter if the partition is muted or not", (long)2L, (long)expiredBatches.size());
        accum.unmutePartition(this.tp1, 0L);
        expiredBatches = accum.expiredBatches(this.time.milliseconds());
        Assert.assertEquals((String)"All batches should have been expired earlier", (long)0L, (long)expiredBatches.size());
        Assert.assertEquals((String)"No partitions should be ready.", (long)0L, (long)accum.ready((Cluster)this.cluster, (long)this.time.milliseconds()).readyNodes.size());
        this.time.sleep(lingerMs);
        Assert.assertEquals((String)"Our partition's leader should be ready", Collections.singleton(this.node1), (Object)readyNodes);
        this.time.sleep(requestTimeout + 1);
        accum.mutePartition(this.tp1);
        expiredBatches = accum.expiredBatches(this.time.milliseconds());
        Assert.assertEquals((String)"The batch should not be expired when metadata is still available and partition is muted", (long)0L, (long)expiredBatches.size());
        accum.unmutePartition(this.tp1, 0L);
        expiredBatches = accum.expiredBatches(this.time.milliseconds());
        Assert.assertEquals((String)"All batches should have been expired", (long)0L, (long)expiredBatches.size());
        Assert.assertEquals((String)"No partitions should be ready.", (long)0L, (long)accum.ready((Cluster)this.cluster, (long)this.time.milliseconds()).readyNodes.size());
        accum.append(this.tp1, 0L, this.key, this.value, Record.EMPTY_HEADERS, null, 0L);
        this.time.sleep(lingerMs);
        readyNodes = accum.ready((Cluster)this.cluster, (long)this.time.milliseconds()).readyNodes;
        Assert.assertEquals((String)"Our partition's leader should be ready", Collections.singleton(this.node1), (Object)readyNodes);
        Map drained = accum.drain(this.cluster, readyNodes, Integer.MAX_VALUE, this.time.milliseconds());
        Assert.assertEquals((String)"There should be only one batch.", (long)((List)drained.get(this.node1.id())).size(), (long)1L);
        this.time.sleep(1000L);
        accum.reenqueue((ProducerBatch)((List)drained.get(this.node1.id())).get(0), this.time.milliseconds());
        this.time.sleep((long)requestTimeout + retryBackoffMs);
        expiredBatches = accum.expiredBatches(this.time.milliseconds());
        Assert.assertEquals((String)"The batch should not be expired.", (long)0L, (long)expiredBatches.size());
        this.time.sleep(1L);
        accum.mutePartition(this.tp1);
        expiredBatches = accum.expiredBatches(this.time.milliseconds());
        Assert.assertEquals((String)"The batch should not be expired when the partition is muted", (long)0L, (long)expiredBatches.size());
        accum.unmutePartition(this.tp1, 0L);
        expiredBatches = accum.expiredBatches(this.time.milliseconds());
        Assert.assertEquals((String)"All batches should have been expired.", (long)0L, (long)expiredBatches.size());
        accum.append(this.tp1, 0L, this.key, this.value, Record.EMPTY_HEADERS, null, 0L);
        this.time.sleep(lingerMs);
        readyNodes = accum.ready((Cluster)this.cluster, (long)this.time.milliseconds()).readyNodes;
        Assert.assertEquals((String)"Our partition's leader should be ready", Collections.singleton(this.node1), (Object)readyNodes);
        this.time.sleep(requestTimeout + 1);
        accum.mutePartition(this.tp1);
        expiredBatches = accum.expiredBatches(this.time.milliseconds());
        Assert.assertEquals((String)"The batch should not be expired when the partition is muted", (long)0L, (long)expiredBatches.size());
        long throttleTimeMs = 100L;
        accum.unmutePartition(this.tp1, this.time.milliseconds() + throttleTimeMs);
        expiredBatches = accum.expiredBatches(this.time.milliseconds());
        Assert.assertEquals((String)"The batch should not be expired when the partition is muted", (long)0L, (long)expiredBatches.size());
        this.time.sleep(throttleTimeMs);
        expiredBatches = accum.expiredBatches(this.time.milliseconds());
        Assert.assertEquals((String)"All batches should have been expired earlier", (long)0L, (long)expiredBatches.size());
        Assert.assertEquals((String)"No partitions should be ready.", (long)1L, (long)accum.ready((Cluster)this.cluster, (long)this.time.milliseconds()).readyNodes.size());
    }

    @Test
    public void testMutedPartitions() throws InterruptedException {
        long now = this.time.milliseconds();
        int batchSize = 1025;
        RecordAccumulator accum = this.createTestRecordAccumulator(batchSize + 61, 10 * batchSize, CompressionType.NONE, 10);
        int appends = this.expectedNumAppends(batchSize);
        for (int i = 0; i < appends; ++i) {
            accum.append(this.tp1, 0L, this.key, this.value, Record.EMPTY_HEADERS, null, 1000L);
            Assert.assertEquals((String)"No partitions should be ready.", (long)0L, (long)accum.ready((Cluster)this.cluster, (long)now).readyNodes.size());
        }
        this.time.sleep(2000L);
        accum.mutePartition(this.tp1);
        RecordAccumulator.ReadyCheckResult result = accum.ready(this.cluster, this.time.milliseconds());
        Assert.assertEquals((String)"No node should be ready", (long)0L, (long)result.readyNodes.size());
        accum.unmutePartition(this.tp1, 0L);
        result = accum.ready(this.cluster, this.time.milliseconds());
        Assert.assertTrue((String)"The batch should be ready", (result.readyNodes.size() > 0 ? 1 : 0) != 0);
        accum.mutePartition(this.tp1);
        Map drained = accum.drain(this.cluster, result.readyNodes, Integer.MAX_VALUE, this.time.milliseconds());
        Assert.assertEquals((String)"No batch should have been drained", (long)0L, (long)((List)drained.get(this.node1.id())).size());
        accum.unmutePartition(this.tp1, 0L);
        drained = accum.drain(this.cluster, result.readyNodes, Integer.MAX_VALUE, this.time.milliseconds());
        Assert.assertTrue((String)"The batch should have been drained.", (((List)drained.get(this.node1.id())).size() > 0 ? 1 : 0) != 0);
    }

    @Test(expected=UnsupportedVersionException.class)
    public void testIdempotenceWithOldMagic() throws InterruptedException {
        ApiVersions apiVersions = new ApiVersions();
        int batchSize = 1025;
        int deliveryTimeoutMs = 3200;
        int lingerMs = 10;
        long retryBackoffMs = 100L;
        long totalSize = 10 * batchSize;
        String metricGrpName = "producer-metrics";
        apiVersions.update("foobar", NodeApiVersions.create(Arrays.asList(new ApiVersionsResponse.ApiVersion(ApiKeys.PRODUCE, 0, 2))));
        RecordAccumulator accum = new RecordAccumulator(this.logContext, batchSize + 61, CompressionType.NONE, lingerMs, retryBackoffMs, deliveryTimeoutMs, this.metrics, metricGrpName, (Time)this.time, apiVersions, new TransactionManager(), new BufferPool(totalSize, batchSize, this.metrics, (Time)this.time, metricGrpName));
        accum.append(this.tp1, 0L, this.key, this.value, Record.EMPTY_HEADERS, null, 0L);
    }

    @Test
    public void testSplitAndReenqueue() throws ExecutionException, InterruptedException {
        long now = this.time.milliseconds();
        RecordAccumulator accum = this.createTestRecordAccumulator(1024, 10240L, CompressionType.GZIP, 10);
        ByteBuffer buffer = ByteBuffer.allocate(4096);
        MemoryRecordsBuilder builder = MemoryRecords.builder((ByteBuffer)buffer, (CompressionType)CompressionType.NONE, (TimestampType)TimestampType.CREATE_TIME, (long)0L);
        ProducerBatch batch = new ProducerBatch(this.tp1, builder, now, true);
        byte[] value = new byte[1024];
        final AtomicInteger acked = new AtomicInteger(0);
        Callback cb = new Callback(){

            public void onCompletion(RecordMetadata metadata, Exception exception) {
                acked.incrementAndGet();
            }
        };
        FutureRecordMetadata future1 = batch.tryAppend(now, null, value, Record.EMPTY_HEADERS, cb, now);
        FutureRecordMetadata future2 = batch.tryAppend(now, null, value, Record.EMPTY_HEADERS, cb, now);
        Assert.assertNotNull((Object)future1);
        Assert.assertNotNull((Object)future2);
        batch.close();
        accum.reenqueue(batch, now);
        this.time.sleep(101L);
        RecordAccumulator.ReadyCheckResult result = accum.ready(this.cluster, this.time.milliseconds());
        Assert.assertTrue((String)"The batch should be ready", (result.readyNodes.size() > 0 ? 1 : 0) != 0);
        Map drained = accum.drain(this.cluster, result.readyNodes, Integer.MAX_VALUE, this.time.milliseconds());
        Assert.assertEquals((String)"Only node1 should be drained", (long)1L, (long)drained.size());
        Assert.assertEquals((String)"Only one batch should be drained", (long)1L, (long)((List)drained.get(this.node1.id())).size());
        accum.splitAndReenqueue((ProducerBatch)((List)drained.get(this.node1.id())).get(0));
        this.time.sleep(101L);
        drained = accum.drain(this.cluster, result.readyNodes, Integer.MAX_VALUE, this.time.milliseconds());
        Assert.assertFalse((boolean)drained.isEmpty());
        Assert.assertFalse((boolean)((List)drained.get(this.node1.id())).isEmpty());
        ((ProducerBatch)((List)drained.get(this.node1.id())).get(0)).done((long)acked.get(), 100L, null);
        Assert.assertEquals((String)"The first message should have been acked.", (long)1L, (long)acked.get());
        Assert.assertTrue((boolean)future1.isDone());
        Assert.assertEquals((long)0L, (long)((RecordMetadata)future1.get()).offset());
        drained = accum.drain(this.cluster, result.readyNodes, Integer.MAX_VALUE, this.time.milliseconds());
        Assert.assertFalse((boolean)drained.isEmpty());
        Assert.assertFalse((boolean)((List)drained.get(this.node1.id())).isEmpty());
        ((ProducerBatch)((List)drained.get(this.node1.id())).get(0)).done((long)acked.get(), 100L, null);
        Assert.assertEquals((String)"Both message should have been acked.", (long)2L, (long)acked.get());
        Assert.assertTrue((boolean)future2.isDone());
        Assert.assertEquals((long)1L, (long)((RecordMetadata)future2.get()).offset());
    }

    @Test
    public void testSplitBatchOffAccumulator() throws InterruptedException {
        long seed = System.currentTimeMillis();
        int batchSize = 1024;
        int bufferCapacity = 3072;
        CompressionRatioEstimator.setEstimation((String)this.tp1.topic(), (CompressionType)CompressionType.GZIP, (float)0.1f);
        RecordAccumulator accum = this.createTestRecordAccumulator(1024, 3072L, CompressionType.GZIP, 0);
        int numSplitBatches = this.prepareSplitBatches(accum, seed, 100, 20);
        Assert.assertTrue((String)"There should be some split batches", (numSplitBatches > 0 ? 1 : 0) != 0);
        RecordAccumulator.ReadyCheckResult result = accum.ready(this.cluster, this.time.milliseconds());
        for (int i = 0; i < numSplitBatches; ++i) {
            Map drained = accum.drain(this.cluster, result.readyNodes, Integer.MAX_VALUE, this.time.milliseconds());
            Assert.assertFalse((boolean)drained.isEmpty());
            Assert.assertFalse((boolean)((List)drained.get(this.node1.id())).isEmpty());
        }
        Assert.assertTrue((String)"All the batches should have been drained.", (boolean)accum.ready((Cluster)this.cluster, (long)this.time.milliseconds()).readyNodes.isEmpty());
        Assert.assertEquals((String)"The split batches should be allocated off the accumulator", (long)3072L, (long)accum.bufferPoolAvailableMemory());
    }

    @Test
    public void testSplitFrequency() throws InterruptedException {
        long seed = System.currentTimeMillis();
        Random random = new Random();
        random.setSeed(seed);
        int batchSize = 1024;
        int numMessages = 1000;
        RecordAccumulator accum = this.createTestRecordAccumulator(1024, 3072L, CompressionType.GZIP, 10);
        for (int goodCompRatioPercentage = 1; goodCompRatioPercentage < 100; ++goodCompRatioPercentage) {
            int numSplit = 0;
            int numBatches = 0;
            CompressionRatioEstimator.resetEstimation((String)this.topic);
            for (int i = 0; i < 1000; ++i) {
                int dice = random.nextInt(100);
                byte[] value = dice < goodCompRatioPercentage ? this.bytesWithGoodCompression(random) : this.bytesWithPoorCompression(random, 100);
                accum.append(this.tp1, 0L, null, value, Record.EMPTY_HEADERS, null, 0L);
                BatchDrainedResult result = this.completeOrSplitBatches(accum, 1024);
                numSplit += result.numSplit;
                numBatches += result.numBatches;
            }
            this.time.sleep(10L);
            BatchDrainedResult result = this.completeOrSplitBatches(accum, 1024);
            Assert.assertTrue((String)String.format("Total num batches = %d, split batches = %d, more than 10%% of the batch splits. Random seed is " + seed, numBatches += result.numBatches, numSplit += result.numSplit), ((double)numSplit / (double)numBatches < (double)0.1f ? 1 : 0) != 0);
        }
    }

    @Test
    public void testSoonToExpireBatchesArePickedUpForExpiry() throws InterruptedException {
        int lingerMs = 500;
        int batchSize = 1025;
        RecordAccumulator accum = this.createTestRecordAccumulator(batchSize + 61, 10 * batchSize, CompressionType.NONE, lingerMs);
        accum.append(this.tp1, 0L, this.key, this.value, Record.EMPTY_HEADERS, null, 1000L);
        Set readyNodes = accum.ready((Cluster)this.cluster, (long)this.time.milliseconds()).readyNodes;
        Map drained = accum.drain(this.cluster, readyNodes, Integer.MAX_VALUE, this.time.milliseconds());
        Assert.assertTrue((boolean)drained.isEmpty());
        this.time.sleep(lingerMs + 1);
        readyNodes = accum.ready((Cluster)this.cluster, (long)this.time.milliseconds()).readyNodes;
        drained = accum.drain(this.cluster, readyNodes, Integer.MAX_VALUE, this.time.milliseconds());
        Assert.assertEquals((String)"A batch did not drain after linger", (long)1L, (long)drained.size());
        accum.append(this.tp2, 0L, this.key, this.value, Record.EMPTY_HEADERS, null, 1000L);
        this.time.sleep(lingerMs * 4);
        readyNodes = accum.ready((Cluster)this.cluster, (long)this.time.milliseconds()).readyNodes;
        drained = accum.drain(this.cluster, readyNodes, Integer.MAX_VALUE, this.time.milliseconds());
        Assert.assertEquals((String)"A batch did not drain after linger", (long)1L, (long)drained.size());
    }

    @Test
    public void testExpiredBatchesRetry() throws InterruptedException {
        int lingerMs = 3000;
        int rtt = 1000;
        int deliveryTimeoutMs = 3200;
        List<Boolean> muteStates = Arrays.asList(false, true);
        int batchSize = 1025;
        RecordAccumulator accum = this.createTestRecordAccumulator(batchSize + 61, 10 * batchSize, CompressionType.NONE, lingerMs);
        for (Boolean mute : muteStates) {
            accum.append(this.tp1, 0L, this.key, this.value, Record.EMPTY_HEADERS, null, 0L);
            this.time.sleep(lingerMs);
            Set readyNodes = accum.ready((Cluster)this.cluster, (long)this.time.milliseconds()).readyNodes;
            Assert.assertEquals((String)"Our partition's leader should be ready", Collections.singleton(this.node1), (Object)readyNodes);
            Map drained = accum.drain(this.cluster, readyNodes, Integer.MAX_VALUE, this.time.milliseconds());
            Assert.assertEquals((String)"There should be only one batch.", (long)1L, (long)((List)drained.get(this.node1.id())).size());
            this.time.sleep(rtt);
            accum.reenqueue((ProducerBatch)((List)drained.get(this.node1.id())).get(0), this.time.milliseconds());
            if (mute.booleanValue()) {
                accum.mutePartition(this.tp1);
            } else {
                accum.unmutePartition(this.tp1, 0L);
            }
            this.time.sleep(deliveryTimeoutMs - rtt);
            accum.drain(this.cluster, Collections.singleton(this.node1), Integer.MAX_VALUE, this.time.milliseconds());
            List expiredBatches = accum.expiredBatches(this.time.milliseconds());
            Assert.assertEquals((String)"RecordAccumulator has expired batches if the partition is not muted", (long)(mute != false ? 1L : 0L), (long)expiredBatches.size());
        }
    }

    private int prepareSplitBatches(RecordAccumulator accum, long seed, int recordSize, int numRecords) throws InterruptedException {
        Random random = new Random();
        random.setSeed(seed);
        CompressionRatioEstimator.setEstimation((String)this.tp1.topic(), (CompressionType)CompressionType.GZIP, (float)0.1f);
        for (int i = 0; i < numRecords; ++i) {
            accum.append(this.tp1, 0L, null, this.bytesWithPoorCompression(random, recordSize), Record.EMPTY_HEADERS, null, 0L);
        }
        RecordAccumulator.ReadyCheckResult result = accum.ready(this.cluster, this.time.milliseconds());
        Assert.assertFalse((boolean)result.readyNodes.isEmpty());
        Map batches = accum.drain(this.cluster, result.readyNodes, Integer.MAX_VALUE, this.time.milliseconds());
        Assert.assertEquals((long)1L, (long)batches.size());
        Assert.assertEquals((long)1L, (long)((List)batches.values().iterator().next()).size());
        ProducerBatch batch = (ProducerBatch)((List)batches.values().iterator().next()).get(0);
        int numSplitBatches = accum.splitAndReenqueue(batch);
        accum.deallocate(batch);
        return numSplitBatches;
    }

    private BatchDrainedResult completeOrSplitBatches(RecordAccumulator accum, int batchSize) {
        boolean batchDrained;
        int numSplit = 0;
        int numBatches = 0;
        do {
            batchDrained = false;
            RecordAccumulator.ReadyCheckResult result = accum.ready(this.cluster, this.time.milliseconds());
            Map batches = accum.drain(this.cluster, result.readyNodes, Integer.MAX_VALUE, this.time.milliseconds());
            for (List batchList : batches.values()) {
                for (ProducerBatch batch : batchList) {
                    batchDrained = true;
                    ++numBatches;
                    if (batch.estimatedSizeInBytes() > batchSize + 61) {
                        accum.splitAndReenqueue(batch);
                        ++numSplit;
                    } else {
                        batch.done(0L, 0L, null);
                    }
                    accum.deallocate(batch);
                }
            }
        } while (batchDrained);
        return new BatchDrainedResult(numSplit, numBatches);
    }

    private byte[] bytesWithGoodCompression(Random random) {
        byte[] value = new byte[100];
        ByteBuffer buffer = ByteBuffer.wrap(value);
        while (buffer.remaining() > 0) {
            buffer.putInt(random.nextInt(1000));
        }
        return value;
    }

    private byte[] bytesWithPoorCompression(Random random, int size) {
        byte[] value = new byte[size];
        random.nextBytes(value);
        return value;
    }

    private int expectedNumAppends(int batchSize) {
        int size = 0;
        int offsetDelta = 0;
        int recordSize;
        while (size + (recordSize = DefaultRecord.sizeInBytes((int)offsetDelta, (long)0L, (int)this.key.length, (int)this.value.length, (Header[])Record.EMPTY_HEADERS)) <= batchSize) {
            ++offsetDelta;
            size += recordSize;
        }
        return offsetDelta;
    }

    private RecordAccumulator createTestRecordAccumulator(int batchSize, long totalSize, CompressionType type, int lingerMs) {
        int deliveryTimeoutMs = 3200;
        return this.createTestRecordAccumulator(deliveryTimeoutMs, batchSize, totalSize, type, lingerMs);
    }

    private RecordAccumulator createTestRecordAccumulator(int deliveryTimeoutMs, int batchSize, long totalSize, CompressionType type, int lingerMs) {
        long retryBackoffMs = 100L;
        String metricGrpName = "producer-metrics";
        return new RecordAccumulator(this.logContext, batchSize, type, lingerMs, retryBackoffMs, deliveryTimeoutMs, this.metrics, metricGrpName, (Time)this.time, new ApiVersions(), null, new BufferPool(totalSize, batchSize, this.metrics, (Time)this.time, metricGrpName));
    }

    private class BatchDrainedResult {
        final int numSplit;
        final int numBatches;

        BatchDrainedResult(int numSplit, int numBatches) {
            this.numBatches = numBatches;
            this.numSplit = numSplit;
        }
    }
}

