/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.message;

import java.util.ArrayList;
import java.util.List;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.Message;
import org.apache.kafka.common.protocol.MessageUtil;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.protocol.Writable;
import org.apache.kafka.common.protocol.types.ArrayOf;
import org.apache.kafka.common.protocol.types.Field;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Struct;
import org.apache.kafka.common.protocol.types.Type;

public class StopReplicaRequestData
implements ApiMessage {
    private int controllerId;
    private int controllerEpoch;
    private long brokerEpoch;
    private boolean deletePartitions;
    private List<StopReplicaRequestPartitionV0> partitionsV0;
    private List<StopReplicaRequestTopic> topics;
    public static final Schema SCHEMA_0 = new Schema(new Field("controller_id", Type.INT32, "The controller id."), new Field("controller_epoch", Type.INT32, "The controller epoch."), new Field("delete_partitions", Type.BOOLEAN, "Whether these partitions should be deleted."), new Field("partitions_v0", new ArrayOf(StopReplicaRequestPartitionV0.SCHEMA_0), "The partitions to stop."));
    public static final Schema SCHEMA_1 = new Schema(new Field("controller_id", Type.INT32, "The controller id."), new Field("controller_epoch", Type.INT32, "The controller epoch."), new Field("broker_epoch", Type.INT64, "The broker epoch."), new Field("delete_partitions", Type.BOOLEAN, "Whether these partitions should be deleted."), new Field("topics", new ArrayOf(StopReplicaRequestTopic.SCHEMA_1), "The topics to stop."));
    public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1};

    public StopReplicaRequestData(Readable readable, short version) {
        this.partitionsV0 = new ArrayList<StopReplicaRequestPartitionV0>();
        this.topics = new ArrayList<StopReplicaRequestTopic>();
        this.read(readable, version);
    }

    public StopReplicaRequestData(Struct struct, short version) {
        this.partitionsV0 = new ArrayList<StopReplicaRequestPartitionV0>();
        this.topics = new ArrayList<StopReplicaRequestTopic>();
        this.fromStruct(struct, version);
    }

    public StopReplicaRequestData() {
        this.controllerId = 0;
        this.controllerEpoch = 0;
        this.brokerEpoch = -1L;
        this.deletePartitions = false;
        this.partitionsV0 = new ArrayList<StopReplicaRequestPartitionV0>();
        this.topics = new ArrayList<StopReplicaRequestTopic>();
    }

    @Override
    public short apiKey() {
        return 5;
    }

    @Override
    public short lowestSupportedVersion() {
        return 0;
    }

    @Override
    public short highestSupportedVersion() {
        return 1;
    }

    @Override
    public void read(Readable readable, short version) {
        int i;
        int arrayLength;
        this.controllerId = readable.readInt();
        this.controllerEpoch = readable.readInt();
        this.brokerEpoch = version >= 1 ? readable.readLong() : -1L;
        boolean bl = this.deletePartitions = readable.readByte() != 0;
        if (version <= 0) {
            arrayLength = readable.readInt();
            if (arrayLength < 0) {
                this.partitionsV0 = null;
            } else {
                this.partitionsV0.clear();
                for (i = 0; i < arrayLength; ++i) {
                    this.partitionsV0.add(new StopReplicaRequestPartitionV0(readable, version));
                }
            }
        } else {
            this.partitionsV0 = new ArrayList<StopReplicaRequestPartitionV0>();
        }
        if (version >= 1) {
            arrayLength = readable.readInt();
            if (arrayLength < 0) {
                this.topics = null;
            } else {
                this.topics.clear();
                for (i = 0; i < arrayLength; ++i) {
                    this.topics.add(new StopReplicaRequestTopic(readable, version));
                }
            }
        } else {
            this.topics = new ArrayList<StopReplicaRequestTopic>();
        }
    }

    @Override
    public void write(Writable writable, short version) {
        writable.writeInt(this.controllerId);
        writable.writeInt(this.controllerEpoch);
        if (version >= 1) {
            writable.writeLong(this.brokerEpoch);
        }
        writable.writeByte(this.deletePartitions ? (byte)1 : 0);
        if (version <= 0) {
            writable.writeInt(this.partitionsV0.size());
            for (StopReplicaRequestPartitionV0 stopReplicaRequestPartitionV0 : this.partitionsV0) {
                stopReplicaRequestPartitionV0.write(writable, version);
            }
        }
        if (version >= 1) {
            writable.writeInt(this.topics.size());
            for (StopReplicaRequestTopic stopReplicaRequestTopic : this.topics) {
                stopReplicaRequestTopic.write(writable, version);
            }
        }
    }

    @Override
    public void fromStruct(Struct struct, short version) {
        Object[] nestedObjects;
        this.controllerId = struct.getInt("controller_id");
        this.controllerEpoch = struct.getInt("controller_epoch");
        this.brokerEpoch = version >= 1 ? struct.getLong("broker_epoch") : -1L;
        this.deletePartitions = struct.getBoolean("delete_partitions");
        if (version <= 0) {
            nestedObjects = struct.getArray("partitions_v0");
            this.partitionsV0 = new ArrayList<StopReplicaRequestPartitionV0>(nestedObjects.length);
            for (Object nestedObject : nestedObjects) {
                this.partitionsV0.add(new StopReplicaRequestPartitionV0((Struct)nestedObject, version));
            }
        } else {
            this.partitionsV0 = new ArrayList<StopReplicaRequestPartitionV0>();
        }
        if (version >= 1) {
            nestedObjects = struct.getArray("topics");
            this.topics = new ArrayList<StopReplicaRequestTopic>(nestedObjects.length);
            for (Object nestedObject : nestedObjects) {
                this.topics.add(new StopReplicaRequestTopic((Struct)nestedObject, version));
            }
        } else {
            this.topics = new ArrayList<StopReplicaRequestTopic>();
        }
    }

    @Override
    public Struct toStruct(short version) {
        int i;
        Struct[] nestedObjects;
        Struct struct = new Struct(SCHEMAS[version]);
        struct.set("controller_id", (Object)this.controllerId);
        struct.set("controller_epoch", (Object)this.controllerEpoch);
        if (version >= 1) {
            struct.set("broker_epoch", (Object)this.brokerEpoch);
        }
        struct.set("delete_partitions", (Object)this.deletePartitions);
        if (version <= 0) {
            nestedObjects = new Struct[this.partitionsV0.size()];
            i = 0;
            for (StopReplicaRequestPartitionV0 stopReplicaRequestPartitionV0 : this.partitionsV0) {
                nestedObjects[i++] = stopReplicaRequestPartitionV0.toStruct(version);
            }
            struct.set("partitions_v0", (Object)nestedObjects);
        }
        if (version >= 1) {
            nestedObjects = new Struct[this.topics.size()];
            i = 0;
            for (StopReplicaRequestTopic stopReplicaRequestTopic : this.topics) {
                nestedObjects[i++] = stopReplicaRequestTopic.toStruct(version);
            }
            struct.set("topics", (Object)nestedObjects);
        }
        return struct;
    }

    @Override
    public int size(short version) {
        int size = 0;
        size += 4;
        size += 4;
        if (version >= 1) {
            size += 8;
        }
        ++size;
        if (version <= 0) {
            size += 4;
            for (StopReplicaRequestPartitionV0 stopReplicaRequestPartitionV0 : this.partitionsV0) {
                size += stopReplicaRequestPartitionV0.size(version);
            }
        } else if (!this.partitionsV0.isEmpty()) {
            throw new UnsupportedVersionException("Attempted to write a non-default partitionsV0 at version " + version);
        }
        if (version >= 1) {
            size += 4;
            for (StopReplicaRequestTopic stopReplicaRequestTopic : this.topics) {
                size += stopReplicaRequestTopic.size(version);
            }
        } else if (!this.topics.isEmpty()) {
            throw new UnsupportedVersionException("Attempted to write a non-default topics at version " + version);
        }
        return size;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof StopReplicaRequestData)) {
            return false;
        }
        StopReplicaRequestData other = (StopReplicaRequestData)obj;
        if (this.controllerId != other.controllerId) {
            return false;
        }
        if (this.controllerEpoch != other.controllerEpoch) {
            return false;
        }
        if (this.brokerEpoch != other.brokerEpoch) {
            return false;
        }
        if (this.deletePartitions != other.deletePartitions) {
            return false;
        }
        if (this.partitionsV0 == null ? other.partitionsV0 != null : !this.partitionsV0.equals(other.partitionsV0)) {
            return false;
        }
        return !(this.topics == null ? other.topics != null : !this.topics.equals(other.topics));
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = 31 * hashCode + this.controllerId;
        hashCode = 31 * hashCode + this.controllerEpoch;
        hashCode = 31 * hashCode + ((int)(this.brokerEpoch >> 32) ^ (int)this.brokerEpoch);
        hashCode = 31 * hashCode + (this.deletePartitions ? 1231 : 1237);
        hashCode = 31 * hashCode + (this.partitionsV0 == null ? 0 : this.partitionsV0.hashCode());
        hashCode = 31 * hashCode + (this.topics == null ? 0 : this.topics.hashCode());
        return hashCode;
    }

    public String toString() {
        return "StopReplicaRequestData(controllerId=" + this.controllerId + ", controllerEpoch=" + this.controllerEpoch + ", brokerEpoch=" + this.brokerEpoch + ", deletePartitions=" + (this.deletePartitions ? "true" : "false") + ", partitionsV0=" + MessageUtil.deepToString(this.partitionsV0.iterator()) + ", topics=" + MessageUtil.deepToString(this.topics.iterator()) + ")";
    }

    public int controllerId() {
        return this.controllerId;
    }

    public int controllerEpoch() {
        return this.controllerEpoch;
    }

    public long brokerEpoch() {
        return this.brokerEpoch;
    }

    public boolean deletePartitions() {
        return this.deletePartitions;
    }

    public List<StopReplicaRequestPartitionV0> partitionsV0() {
        return this.partitionsV0;
    }

    public List<StopReplicaRequestTopic> topics() {
        return this.topics;
    }

    public StopReplicaRequestData setControllerId(int v) {
        this.controllerId = v;
        return this;
    }

    public StopReplicaRequestData setControllerEpoch(int v) {
        this.controllerEpoch = v;
        return this;
    }

    public StopReplicaRequestData setBrokerEpoch(long v) {
        this.brokerEpoch = v;
        return this;
    }

    public StopReplicaRequestData setDeletePartitions(boolean v) {
        this.deletePartitions = v;
        return this;
    }

    public StopReplicaRequestData setPartitionsV0(List<StopReplicaRequestPartitionV0> v) {
        this.partitionsV0 = v;
        return this;
    }

    public StopReplicaRequestData setTopics(List<StopReplicaRequestTopic> v) {
        this.topics = v;
        return this;
    }

    public static class StopReplicaRequestTopic
    implements Message {
        private String name;
        private List<Integer> partitionIndexes;
        public static final Schema SCHEMA_1 = new Schema(new Field("name", Type.STRING, "The topic name."), new Field("partition_indexes", new ArrayOf(Type.INT32), "The partition indexes."));
        public static final Schema[] SCHEMAS = new Schema[]{null, SCHEMA_1};

        public StopReplicaRequestTopic(Readable readable, short version) {
            this.partitionIndexes = new ArrayList<Integer>();
            this.read(readable, version);
        }

        public StopReplicaRequestTopic(Struct struct, short version) {
            this.partitionIndexes = new ArrayList<Integer>();
            this.fromStruct(struct, version);
        }

        public StopReplicaRequestTopic() {
            this.name = "";
            this.partitionIndexes = new ArrayList<Integer>();
        }

        @Override
        public short lowestSupportedVersion() {
            return 0;
        }

        @Override
        public short highestSupportedVersion() {
            return 1;
        }

        @Override
        public void read(Readable readable, short version) {
            if (version < 1) {
                throw new UnsupportedVersionException("Can't read version " + version + " of StopReplicaRequestTopic");
            }
            this.name = readable.readNullableString();
            int arrayLength = readable.readInt();
            if (arrayLength < 0) {
                this.partitionIndexes = null;
            } else {
                this.partitionIndexes.clear();
                for (int i = 0; i < arrayLength; ++i) {
                    this.partitionIndexes.add(readable.readInt());
                }
            }
        }

        @Override
        public void write(Writable writable, short version) {
            if (version < 1) {
                throw new UnsupportedVersionException("Can't write version " + version + " of StopReplicaRequestTopic");
            }
            writable.writeString(this.name);
            writable.writeInt(this.partitionIndexes.size());
            for (Integer element : this.partitionIndexes) {
                writable.writeInt(element);
            }
        }

        @Override
        public void fromStruct(Struct struct, short version) {
            if (version < 1) {
                throw new UnsupportedVersionException("Can't read version " + version + " of StopReplicaRequestTopic");
            }
            this.name = struct.getString("name");
            Object[] nestedObjects = struct.getArray("partition_indexes");
            this.partitionIndexes = new ArrayList<Integer>(nestedObjects.length);
            for (Object nestedObject : nestedObjects) {
                this.partitionIndexes.add((Integer)nestedObject);
            }
        }

        @Override
        public Struct toStruct(short version) {
            if (version < 1) {
                throw new UnsupportedVersionException("Can't write version " + version + " of StopReplicaRequestTopic");
            }
            Struct struct = new Struct(SCHEMAS[version]);
            struct.set("name", (Object)this.name);
            Integer[] nestedObjects = new Integer[this.partitionIndexes.size()];
            int i = 0;
            for (Integer element : this.partitionIndexes) {
                nestedObjects[i++] = element;
            }
            struct.set("partition_indexes", (Object)nestedObjects);
            return struct;
        }

        @Override
        public int size(short version) {
            int size = 0;
            if (version < 1) {
                throw new UnsupportedVersionException("Can't size version " + version + " of StopReplicaRequestTopic");
            }
            size += 2;
            size += MessageUtil.serializedUtf8Length(this.name);
            size += 4;
            return size += this.partitionIndexes.size() * 4;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof StopReplicaRequestTopic)) {
                return false;
            }
            StopReplicaRequestTopic other = (StopReplicaRequestTopic)obj;
            if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
                return false;
            }
            return !(this.partitionIndexes == null ? other.partitionIndexes != null : !this.partitionIndexes.equals(other.partitionIndexes));
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + (this.name == null ? 0 : this.name.hashCode());
            hashCode = 31 * hashCode + (this.partitionIndexes == null ? 0 : this.partitionIndexes.hashCode());
            return hashCode;
        }

        public String toString() {
            return "StopReplicaRequestTopic(name='" + this.name + "', partitionIndexes=" + MessageUtil.deepToString(this.partitionIndexes.iterator()) + ")";
        }

        public String name() {
            return this.name;
        }

        public List<Integer> partitionIndexes() {
            return this.partitionIndexes;
        }

        public StopReplicaRequestTopic setName(String v) {
            this.name = v;
            return this;
        }

        public StopReplicaRequestTopic setPartitionIndexes(List<Integer> v) {
            this.partitionIndexes = v;
            return this;
        }
    }

    public static class StopReplicaRequestPartitionV0
    implements Message {
        private String topicName;
        private int partitionIndex;
        public static final Schema SCHEMA_0 = new Schema(new Field("topic_name", Type.STRING, "The topic name."), new Field("partition_index", Type.INT32, "The partition index."));
        public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0};

        public StopReplicaRequestPartitionV0(Readable readable, short version) {
            this.read(readable, version);
        }

        public StopReplicaRequestPartitionV0(Struct struct, short version) {
            this.fromStruct(struct, version);
        }

        public StopReplicaRequestPartitionV0() {
            this.topicName = "";
            this.partitionIndex = 0;
        }

        @Override
        public short lowestSupportedVersion() {
            return 0;
        }

        @Override
        public short highestSupportedVersion() {
            return 1;
        }

        @Override
        public void read(Readable readable, short version) {
            if (version > 0) {
                throw new UnsupportedVersionException("Can't read version " + version + " of StopReplicaRequestPartitionV0");
            }
            this.topicName = readable.readNullableString();
            this.partitionIndex = readable.readInt();
        }

        @Override
        public void write(Writable writable, short version) {
            if (version > 0) {
                throw new UnsupportedVersionException("Can't write version " + version + " of StopReplicaRequestPartitionV0");
            }
            writable.writeString(this.topicName);
            writable.writeInt(this.partitionIndex);
        }

        @Override
        public void fromStruct(Struct struct, short version) {
            if (version > 0) {
                throw new UnsupportedVersionException("Can't read version " + version + " of StopReplicaRequestPartitionV0");
            }
            this.topicName = struct.getString("topic_name");
            this.partitionIndex = struct.getInt("partition_index");
        }

        @Override
        public Struct toStruct(short version) {
            if (version > 0) {
                throw new UnsupportedVersionException("Can't write version " + version + " of StopReplicaRequestPartitionV0");
            }
            Struct struct = new Struct(SCHEMAS[version]);
            struct.set("topic_name", (Object)this.topicName);
            struct.set("partition_index", (Object)this.partitionIndex);
            return struct;
        }

        @Override
        public int size(short version) {
            int size = 0;
            if (version > 0) {
                throw new UnsupportedVersionException("Can't size version " + version + " of StopReplicaRequestPartitionV0");
            }
            size += 2;
            size += MessageUtil.serializedUtf8Length(this.topicName);
            return size += 4;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof StopReplicaRequestPartitionV0)) {
                return false;
            }
            StopReplicaRequestPartitionV0 other = (StopReplicaRequestPartitionV0)obj;
            if (this.topicName == null ? other.topicName != null : !this.topicName.equals(other.topicName)) {
                return false;
            }
            return this.partitionIndex == other.partitionIndex;
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + (this.topicName == null ? 0 : this.topicName.hashCode());
            hashCode = 31 * hashCode + this.partitionIndex;
            return hashCode;
        }

        public String toString() {
            return "StopReplicaRequestPartitionV0(topicName='" + this.topicName + "', partitionIndex=" + this.partitionIndex + ")";
        }

        public String topicName() {
            return this.topicName;
        }

        public int partitionIndex() {
            return this.partitionIndex;
        }

        public StopReplicaRequestPartitionV0 setTopicName(String v) {
            this.topicName = v;
            return this;
        }

        public StopReplicaRequestPartitionV0 setPartitionIndex(int v) {
            this.partitionIndex = v;
            return this;
        }
    }
}

