/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients;

import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.kafka.common.Cluster;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.PartitionInfo;
import org.apache.kafka.common.TopicPartition;

class MetadataCache {
    private final String clusterId;
    private final List<Node> nodes;
    private final Set<String> unauthorizedTopics;
    private final Set<String> invalidTopics;
    private final Set<String> internalTopics;
    private final Node controller;
    private final Map<TopicPartition, PartitionInfoAndEpoch> metadataByPartition;
    private Cluster clusterInstance;

    MetadataCache(String clusterId, List<Node> nodes, Collection<PartitionInfoAndEpoch> partitions, Set<String> unauthorizedTopics, Set<String> invalidTopics, Set<String> internalTopics, Node controller) {
        this(clusterId, nodes, partitions, unauthorizedTopics, invalidTopics, internalTopics, controller, null);
    }

    MetadataCache(String clusterId, List<Node> nodes, Collection<PartitionInfoAndEpoch> partitions, Set<String> unauthorizedTopics, Set<String> invalidTopics, Set<String> internalTopics, Node controller, Cluster clusterInstance) {
        this.clusterId = clusterId;
        this.nodes = nodes;
        this.unauthorizedTopics = unauthorizedTopics;
        this.invalidTopics = invalidTopics;
        this.internalTopics = internalTopics;
        this.controller = controller;
        this.metadataByPartition = new HashMap<TopicPartition, PartitionInfoAndEpoch>(partitions.size());
        for (PartitionInfoAndEpoch p : partitions) {
            this.metadataByPartition.put(new TopicPartition(p.partitionInfo().topic(), p.partitionInfo().partition()), p);
        }
        if (clusterInstance == null) {
            this.computeClusterView();
        } else {
            this.clusterInstance = clusterInstance;
        }
    }

    Optional<PartitionInfo> getPartitionInfoHavingEpoch(TopicPartition topicPartition, int epoch) {
        PartitionInfoAndEpoch infoAndEpoch = this.metadataByPartition.get(topicPartition);
        if (infoAndEpoch == null) {
            return Optional.empty();
        }
        if (infoAndEpoch.epoch() == epoch) {
            return Optional.of(infoAndEpoch.partitionInfo());
        }
        return Optional.empty();
    }

    Optional<PartitionInfo> getPartitionInfo(TopicPartition topicPartition) {
        return Optional.ofNullable(this.metadataByPartition.get(topicPartition)).map(PartitionInfoAndEpoch::partitionInfo);
    }

    synchronized void retainTopics(Collection<String> topics) {
        this.metadataByPartition.entrySet().removeIf(entry -> !topics.contains(((TopicPartition)entry.getKey()).topic()));
        this.unauthorizedTopics.retainAll(topics);
        this.invalidTopics.retainAll(topics);
        this.computeClusterView();
    }

    Cluster cluster() {
        if (this.clusterInstance == null) {
            throw new IllegalStateException("Cached Cluster instance should not be null, but was.");
        }
        return this.clusterInstance;
    }

    private void computeClusterView() {
        List<PartitionInfo> partitionInfos = this.metadataByPartition.values().stream().map(PartitionInfoAndEpoch::partitionInfo).collect(Collectors.toList());
        this.clusterInstance = new Cluster(this.clusterId, this.nodes, partitionInfos, this.unauthorizedTopics, this.invalidTopics, this.internalTopics, this.controller);
    }

    static MetadataCache bootstrap(List<InetSocketAddress> addresses) {
        ArrayList<Node> nodes = new ArrayList<Node>();
        int nodeId = -1;
        for (InetSocketAddress address : addresses) {
            nodes.add(new Node(nodeId--, address.getHostString(), address.getPort()));
        }
        return new MetadataCache(null, nodes, Collections.emptyList(), Collections.emptySet(), Collections.emptySet(), Collections.emptySet(), null, Cluster.bootstrap(addresses));
    }

    static MetadataCache empty() {
        return new MetadataCache(null, Collections.emptyList(), Collections.emptyList(), Collections.emptySet(), Collections.emptySet(), Collections.emptySet(), null, Cluster.empty());
    }

    public String toString() {
        return "MetadataCache{cluster=" + this.cluster() + '}';
    }

    static class PartitionInfoAndEpoch {
        private final PartitionInfo partitionInfo;
        private final int epoch;

        PartitionInfoAndEpoch(PartitionInfo partitionInfo, int epoch) {
            this.partitionInfo = partitionInfo;
            this.epoch = epoch;
        }

        public PartitionInfo partitionInfo() {
            return this.partitionInfo;
        }

        public int epoch() {
            return this.epoch;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PartitionInfoAndEpoch that = (PartitionInfoAndEpoch)o;
            return this.epoch == that.epoch && Objects.equals(this.partitionInfo, that.partitionInfo);
        }

        public int hashCode() {
            return Objects.hash(this.partitionInfo, this.epoch);
        }

        public String toString() {
            return "PartitionInfoAndEpoch{partitionInfo=" + this.partitionInfo + ", epoch=" + this.epoch + '}';
        }
    }
}

