/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.HashMap;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.InvalidRecordException;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.MemoryRecordsBuilder;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.record.TimestampType;
import org.apache.kafka.common.requests.ProduceRequest;
import org.junit.Assert;
import org.junit.Test;

public class ProduceRequestTest {
    private final SimpleRecord simpleRecord = new SimpleRecord(System.currentTimeMillis(), "key".getBytes(), "value".getBytes());

    @Test
    public void shouldBeFlaggedAsTransactionalWhenTransactionalRecords() throws Exception {
        MemoryRecords memoryRecords = MemoryRecords.withTransactionalRecords((long)0L, (CompressionType)CompressionType.NONE, (long)1L, (short)1, (int)1, (int)1, (SimpleRecord[])new SimpleRecord[]{this.simpleRecord});
        ProduceRequest request = (ProduceRequest)ProduceRequest.Builder.forCurrentMagic((short)-1, (int)10, Collections.singletonMap(new TopicPartition("topic", 1), memoryRecords)).build();
        Assert.assertTrue((boolean)request.isTransactional());
    }

    @Test
    public void shouldNotBeFlaggedAsTransactionalWhenNoRecords() throws Exception {
        ProduceRequest request = this.createNonIdempotentNonTransactionalRecords();
        Assert.assertFalse((boolean)request.isTransactional());
    }

    @Test
    public void shouldNotBeFlaggedAsIdempotentWhenRecordsNotIdempotent() throws Exception {
        ProduceRequest request = this.createNonIdempotentNonTransactionalRecords();
        Assert.assertFalse((boolean)request.isTransactional());
    }

    @Test
    public void shouldBeFlaggedAsIdempotentWhenIdempotentRecords() throws Exception {
        MemoryRecords memoryRecords = MemoryRecords.withIdempotentRecords((long)1L, (CompressionType)CompressionType.NONE, (long)1L, (short)1, (int)1, (int)1, (SimpleRecord[])new SimpleRecord[]{this.simpleRecord});
        ProduceRequest request = (ProduceRequest)ProduceRequest.Builder.forCurrentMagic((short)-1, (int)10, Collections.singletonMap(new TopicPartition("topic", 1), memoryRecords)).build();
        Assert.assertTrue((boolean)request.isIdempotent());
    }

    @Test
    public void testBuildWithOldMessageFormat() {
        ByteBuffer buffer = ByteBuffer.allocate(256);
        MemoryRecordsBuilder builder = MemoryRecords.builder((ByteBuffer)buffer, (byte)1, (CompressionType)CompressionType.NONE, (TimestampType)TimestampType.CREATE_TIME, (long)0L);
        builder.append(10L, null, "a".getBytes());
        HashMap<TopicPartition, MemoryRecords> produceData = new HashMap<TopicPartition, MemoryRecords>();
        produceData.put(new TopicPartition("test", 0), builder.build());
        ProduceRequest.Builder requestBuilder = ProduceRequest.Builder.forMagic((byte)1, (short)1, (int)5000, produceData, null);
        Assert.assertEquals((long)2L, (long)requestBuilder.oldestAllowedVersion());
        Assert.assertEquals((long)2L, (long)requestBuilder.latestAllowedVersion());
    }

    @Test
    public void testBuildWithCurrentMessageFormat() {
        ByteBuffer buffer = ByteBuffer.allocate(256);
        MemoryRecordsBuilder builder = MemoryRecords.builder((ByteBuffer)buffer, (byte)2, (CompressionType)CompressionType.NONE, (TimestampType)TimestampType.CREATE_TIME, (long)0L);
        builder.append(10L, null, "a".getBytes());
        HashMap<TopicPartition, MemoryRecords> produceData = new HashMap<TopicPartition, MemoryRecords>();
        produceData.put(new TopicPartition("test", 0), builder.build());
        ProduceRequest.Builder requestBuilder = ProduceRequest.Builder.forMagic((byte)2, (short)1, (int)5000, produceData, null);
        Assert.assertEquals((long)3L, (long)requestBuilder.oldestAllowedVersion());
        Assert.assertEquals((long)ApiKeys.PRODUCE.latestVersion(), (long)requestBuilder.latestAllowedVersion());
    }

    @Test
    public void testV3AndAboveShouldContainOnlyOneRecordBatch() {
        ByteBuffer buffer = ByteBuffer.allocate(256);
        MemoryRecordsBuilder builder = MemoryRecords.builder((ByteBuffer)buffer, (CompressionType)CompressionType.NONE, (TimestampType)TimestampType.CREATE_TIME, (long)0L);
        builder.append(10L, null, "a".getBytes());
        builder.close();
        builder = MemoryRecords.builder((ByteBuffer)buffer, (CompressionType)CompressionType.NONE, (TimestampType)TimestampType.CREATE_TIME, (long)1L);
        builder.append(11L, "1".getBytes(), "b".getBytes());
        builder.append(12L, null, "c".getBytes());
        builder.close();
        buffer.flip();
        HashMap<TopicPartition, MemoryRecords> produceData = new HashMap<TopicPartition, MemoryRecords>();
        produceData.put(new TopicPartition("test", 0), MemoryRecords.readableRecords((ByteBuffer)buffer));
        ProduceRequest.Builder requestBuilder = ProduceRequest.Builder.forCurrentMagic((short)1, (int)5000, produceData);
        this.assertThrowsInvalidRecordExceptionForAllVersions(requestBuilder);
    }

    @Test
    public void testV3AndAboveCannotHaveNoRecordBatches() {
        HashMap<TopicPartition, MemoryRecords> produceData = new HashMap<TopicPartition, MemoryRecords>();
        produceData.put(new TopicPartition("test", 0), MemoryRecords.EMPTY);
        ProduceRequest.Builder requestBuilder = ProduceRequest.Builder.forCurrentMagic((short)1, (int)5000, produceData);
        this.assertThrowsInvalidRecordExceptionForAllVersions(requestBuilder);
    }

    @Test
    public void testV3AndAboveCannotUseMagicV0() {
        ByteBuffer buffer = ByteBuffer.allocate(256);
        MemoryRecordsBuilder builder = MemoryRecords.builder((ByteBuffer)buffer, (byte)0, (CompressionType)CompressionType.NONE, (TimestampType)TimestampType.NO_TIMESTAMP_TYPE, (long)0L);
        builder.append(10L, null, "a".getBytes());
        HashMap<TopicPartition, MemoryRecords> produceData = new HashMap<TopicPartition, MemoryRecords>();
        produceData.put(new TopicPartition("test", 0), builder.build());
        ProduceRequest.Builder requestBuilder = ProduceRequest.Builder.forCurrentMagic((short)1, (int)5000, produceData);
        this.assertThrowsInvalidRecordExceptionForAllVersions(requestBuilder);
    }

    @Test
    public void testV3AndAboveCannotUseMagicV1() {
        ByteBuffer buffer = ByteBuffer.allocate(256);
        MemoryRecordsBuilder builder = MemoryRecords.builder((ByteBuffer)buffer, (byte)1, (CompressionType)CompressionType.NONE, (TimestampType)TimestampType.CREATE_TIME, (long)0L);
        builder.append(10L, null, "a".getBytes());
        HashMap<TopicPartition, MemoryRecords> produceData = new HashMap<TopicPartition, MemoryRecords>();
        produceData.put(new TopicPartition("test", 0), builder.build());
        ProduceRequest.Builder requestBuilder = ProduceRequest.Builder.forCurrentMagic((short)1, (int)5000, produceData);
        this.assertThrowsInvalidRecordExceptionForAllVersions(requestBuilder);
    }

    @Test
    public void testV6AndBelowCannotUseZStdCompression() {
        ByteBuffer buffer = ByteBuffer.allocate(256);
        MemoryRecordsBuilder builder = MemoryRecords.builder((ByteBuffer)buffer, (byte)2, (CompressionType)CompressionType.ZSTD, (TimestampType)TimestampType.CREATE_TIME, (long)0L);
        builder.append(10L, null, "a".getBytes());
        HashMap<TopicPartition, MemoryRecords> produceData = new HashMap<TopicPartition, MemoryRecords>();
        produceData.put(new TopicPartition("test", 0), builder.build());
        for (short version = 3; version < 7; version = (short)(version + 1)) {
            ProduceRequest.Builder requestBuilder = new ProduceRequest.Builder(version, version, 1, 5000, produceData, null);
            this.assertThrowsInvalidRecordExceptionForAllVersions(requestBuilder);
        }
        ProduceRequest.Builder.forCurrentMagic((short)1, (int)5000, produceData);
    }

    private void assertThrowsInvalidRecordExceptionForAllVersions(ProduceRequest.Builder builder) {
        for (short version = builder.oldestAllowedVersion(); version < builder.latestAllowedVersion(); version = (short)(version + 1)) {
            this.assertThrowsInvalidRecordException(builder, version);
        }
    }

    private void assertThrowsInvalidRecordException(ProduceRequest.Builder builder, short version) {
        try {
            builder.build(version).toStruct();
            Assert.fail((String)("Builder did not raise " + InvalidRecordException.class.getName() + " as expected"));
        }
        catch (RuntimeException e) {
            Assert.assertTrue((String)("Unexpected exception type " + e.getClass().getName()), (boolean)InvalidRecordException.class.isAssignableFrom(e.getClass()));
        }
    }

    private ProduceRequest createNonIdempotentNonTransactionalRecords() {
        MemoryRecords memoryRecords = MemoryRecords.withRecords((CompressionType)CompressionType.NONE, (SimpleRecord[])new SimpleRecord[]{this.simpleRecord});
        return (ProduceRequest)ProduceRequest.Builder.forCurrentMagic((short)-1, (int)10, Collections.singletonMap(new TopicPartition("topic", 1), memoryRecords)).build();
    }
}

