/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.test;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.channels.GatheringByteChannel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.kafka.common.network.ChannelState;
import org.apache.kafka.common.network.NetworkReceive;
import org.apache.kafka.common.network.NetworkSend;
import org.apache.kafka.common.network.Selectable;
import org.apache.kafka.common.network.Send;
import org.apache.kafka.common.requests.ByteBufferChannel;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.test.DelayedReceive;

public class MockSelector
implements Selectable {
    private final Time time;
    private final List<Send> initiatedSends = new ArrayList<Send>();
    private final List<Send> completedSends = new ArrayList<Send>();
    private final List<NetworkReceive> completedReceives = new ArrayList<NetworkReceive>();
    private final Map<String, ChannelState> disconnected = new HashMap<String, ChannelState>();
    private final List<String> connected = new ArrayList<String>();
    private final List<DelayedReceive> delayedReceives = new ArrayList<DelayedReceive>();

    public MockSelector(Time time) {
        this.time = time;
    }

    public void connect(String id, InetSocketAddress address, int sendBufferSize, int receiveBufferSize) throws IOException {
        this.connected.add(id);
    }

    public void wakeup() {
    }

    public void close() {
    }

    public void close(String id) {
        this.removeSendsForNode(id, this.completedSends);
        this.removeSendsForNode(id, this.initiatedSends);
        for (int i = 0; i < this.connected.size(); ++i) {
            if (!this.connected.get(i).equals(id)) continue;
            this.connected.remove(i);
            break;
        }
    }

    public void serverDisconnect(String id) {
        this.disconnected.put(id, ChannelState.READY);
        this.close(id);
    }

    private void removeSendsForNode(String id, Collection<Send> sends) {
        Iterator<Send> iter = sends.iterator();
        while (iter.hasNext()) {
            Send send = iter.next();
            if (!id.equals(send.destination())) continue;
            iter.remove();
        }
    }

    public void clear() {
        this.completedSends.clear();
        this.completedReceives.clear();
        this.disconnected.clear();
        this.connected.clear();
    }

    public void send(Send send) {
        this.initiatedSends.add(send);
    }

    public void poll(long timeout) throws IOException {
        this.completeInitiatedSends();
        this.completeDelayedReceives();
        this.time.sleep(timeout);
    }

    private void completeInitiatedSends() throws IOException {
        for (Send send : this.initiatedSends) {
            this.completeSend(send);
        }
        this.initiatedSends.clear();
    }

    private void completeSend(Send send) throws IOException {
        try (ByteBufferChannel discardChannel = new ByteBufferChannel(send.size());){
            while (!send.completed()) {
                send.writeTo((GatheringByteChannel)discardChannel);
            }
            this.completedSends.add(send);
        }
    }

    private void completeDelayedReceives() {
        for (Send completedSend : this.completedSends) {
            Iterator<DelayedReceive> delayedReceiveIterator = this.delayedReceives.iterator();
            while (delayedReceiveIterator.hasNext()) {
                DelayedReceive delayedReceive = delayedReceiveIterator.next();
                if (!delayedReceive.source().equals(completedSend.destination())) continue;
                this.completedReceives.add(delayedReceive.receive());
                delayedReceiveIterator.remove();
            }
        }
    }

    public List<Send> completedSends() {
        return this.completedSends;
    }

    public void completeSend(NetworkSend send) {
        this.completedSends.add((Send)send);
    }

    public List<NetworkReceive> completedReceives() {
        return this.completedReceives;
    }

    public void completeReceive(NetworkReceive receive) {
        this.completedReceives.add(receive);
    }

    public void delayedReceive(DelayedReceive receive) {
        this.delayedReceives.add(receive);
    }

    public Map<String, ChannelState> disconnected() {
        return this.disconnected;
    }

    public List<String> connected() {
        ArrayList<String> currentConnected = new ArrayList<String>(this.connected);
        this.connected.clear();
        return currentConnected;
    }

    public void mute(String id) {
    }

    public void unmute(String id) {
    }

    public void muteAll() {
    }

    public void unmuteAll() {
    }

    public boolean isChannelReady(String id) {
        return true;
    }

    public void reset() {
        this.clear();
        this.initiatedSends.clear();
        this.delayedReceives.clear();
    }
}

