/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.security.oauthbearer;

import java.util.Collections;
import java.util.Set;
import org.apache.kafka.common.security.oauthbearer.OAuthBearerToken;
import org.apache.kafka.common.security.oauthbearer.OAuthBearerTokenCallback;
import org.junit.Assert;
import org.junit.Test;

public class OAuthBearerTokenCallbackTest {
    private static final OAuthBearerToken TOKEN = new OAuthBearerToken(){

        public String value() {
            return "value";
        }

        public Long startTimeMs() {
            return null;
        }

        public Set<String> scope() {
            return Collections.emptySet();
        }

        public String principalName() {
            return "principalName";
        }

        public long lifetimeMs() {
            return 0L;
        }
    };

    @Test
    public void testError() {
        String errorCode = "errorCode";
        String errorDescription = "errorDescription";
        String errorUri = "errorUri";
        OAuthBearerTokenCallback callback = new OAuthBearerTokenCallback();
        callback.error(errorCode, errorDescription, errorUri);
        Assert.assertEquals((Object)errorCode, (Object)callback.errorCode());
        Assert.assertEquals((Object)errorDescription, (Object)callback.errorDescription());
        Assert.assertEquals((Object)errorUri, (Object)callback.errorUri());
        Assert.assertNull((Object)callback.token());
    }

    @Test
    public void testToken() {
        OAuthBearerTokenCallback callback = new OAuthBearerTokenCallback();
        callback.token(TOKEN);
        Assert.assertSame((Object)TOKEN, (Object)callback.token());
        Assert.assertNull((Object)callback.errorCode());
        Assert.assertNull((Object)callback.errorDescription());
        Assert.assertNull((Object)callback.errorUri());
    }
}

