/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import org.apache.kafka.common.acl.AccessControlEntry;
import org.apache.kafka.common.acl.AccessControlEntryFilter;
import org.apache.kafka.common.acl.AclOperation;
import org.apache.kafka.common.acl.AclPermissionType;
import org.apache.kafka.common.protocol.CommonFields;
import org.apache.kafka.common.protocol.types.Struct;
import org.apache.kafka.common.resource.Resource;
import org.apache.kafka.common.resource.ResourceFilter;
import org.apache.kafka.common.resource.ResourceType;

final class RequestUtils {
    private RequestUtils() {
    }

    static Resource resourceFromStructFields(Struct struct) {
        byte resourceType = struct.get(CommonFields.RESOURCE_TYPE);
        String name = struct.get(CommonFields.RESOURCE_NAME);
        return new Resource(ResourceType.fromCode(resourceType), name);
    }

    static void resourceSetStructFields(Resource resource, Struct struct) {
        struct.set(CommonFields.RESOURCE_TYPE, resource.resourceType().code());
        struct.set(CommonFields.RESOURCE_NAME, resource.name());
    }

    static ResourceFilter resourceFilterFromStructFields(Struct struct) {
        byte resourceType = struct.get(CommonFields.RESOURCE_TYPE);
        String name = struct.get(CommonFields.RESOURCE_NAME_FILTER);
        return new ResourceFilter(ResourceType.fromCode(resourceType), name);
    }

    static void resourceFilterSetStructFields(ResourceFilter resourceFilter, Struct struct) {
        struct.set(CommonFields.RESOURCE_TYPE, resourceFilter.resourceType().code());
        struct.set(CommonFields.RESOURCE_NAME_FILTER, resourceFilter.name());
    }

    static AccessControlEntry aceFromStructFields(Struct struct) {
        String principal = struct.get(CommonFields.PRINCIPAL);
        String host = struct.get(CommonFields.HOST);
        byte operation = struct.get(CommonFields.OPERATION);
        byte permissionType = struct.get(CommonFields.PERMISSION_TYPE);
        return new AccessControlEntry(principal, host, AclOperation.fromCode(operation), AclPermissionType.fromCode(permissionType));
    }

    static void aceSetStructFields(AccessControlEntry data, Struct struct) {
        struct.set(CommonFields.PRINCIPAL, data.principal());
        struct.set(CommonFields.HOST, data.host());
        struct.set(CommonFields.OPERATION, data.operation().code());
        struct.set(CommonFields.PERMISSION_TYPE, data.permissionType().code());
    }

    static AccessControlEntryFilter aceFilterFromStructFields(Struct struct) {
        String principal = struct.get(CommonFields.PRINCIPAL_FILTER);
        String host = struct.get(CommonFields.HOST_FILTER);
        byte operation = struct.get(CommonFields.OPERATION);
        byte permissionType = struct.get(CommonFields.PERMISSION_TYPE);
        return new AccessControlEntryFilter(principal, host, AclOperation.fromCode(operation), AclPermissionType.fromCode(permissionType));
    }

    static void aceFilterSetStructFields(AccessControlEntryFilter filter, Struct struct) {
        struct.set(CommonFields.PRINCIPAL_FILTER, filter.principal());
        struct.set(CommonFields.HOST_FILTER, filter.host());
        struct.set(CommonFields.OPERATION, filter.operation().code());
        struct.set(CommonFields.PERMISSION_TYPE, filter.permissionType().code());
    }
}

