/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.security.scram;

import java.io.IOException;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import org.apache.kafka.common.network.Mode;
import org.apache.kafka.common.security.authenticator.AuthCallbackHandler;
import org.apache.kafka.common.security.authenticator.CredentialCache;
import org.apache.kafka.common.security.scram.ScramCredential;
import org.apache.kafka.common.security.scram.ScramCredentialCallback;
import org.apache.kafka.common.security.token.delegation.DelegationTokenCache;
import org.apache.kafka.common.security.token.delegation.DelegationTokenCredentialCallback;

public class ScramServerCallbackHandler
implements AuthCallbackHandler {
    private final CredentialCache.Cache<ScramCredential> credentialCache;
    private final DelegationTokenCache tokenCache;
    private String saslMechanism;

    public ScramServerCallbackHandler(CredentialCache.Cache<ScramCredential> credentialCache, DelegationTokenCache tokenCache) {
        this.credentialCache = credentialCache;
        this.tokenCache = tokenCache;
    }

    @Override
    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        String username = null;
        for (Callback callback : callbacks) {
            if (callback instanceof NameCallback) {
                username = ((NameCallback)callback).getDefaultName();
                continue;
            }
            if (callback instanceof DelegationTokenCredentialCallback) {
                DelegationTokenCredentialCallback tokenCallback = (DelegationTokenCredentialCallback)callback;
                tokenCallback.scramCredential(this.tokenCache.credential(this.saslMechanism, username));
                tokenCallback.tokenOwner(this.tokenCache.owner(username));
                continue;
            }
            if (callback instanceof ScramCredentialCallback) {
                ScramCredentialCallback sc = (ScramCredentialCallback)callback;
                sc.scramCredential(this.credentialCache.get(username));
                continue;
            }
            throw new UnsupportedCallbackException(callback);
        }
    }

    @Override
    public void configure(Map<String, ?> configs, Mode mode, Subject subject, String saslMechanism) {
        this.saslMechanism = saslMechanism;
    }

    @Override
    public void close() {
    }
}

