/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.security.authenticator;

import java.io.IOException;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.Configuration;
import javax.security.sasl.AuthorizeCallback;
import javax.security.sasl.RealmCallback;
import org.apache.kafka.common.security.kerberos.KerberosName;
import org.apache.kafka.common.security.kerberos.KerberosShortNamer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SaslServerCallbackHandler
implements CallbackHandler {
    private static final Logger LOG = LoggerFactory.getLogger(SaslServerCallbackHandler.class);
    private final KerberosShortNamer kerberosShortNamer;

    public SaslServerCallbackHandler(Configuration configuration, KerberosShortNamer kerberosNameParser) throws IOException {
        AppConfigurationEntry[] configurationEntries = configuration.getAppConfigurationEntry("KafkaServer");
        if (configurationEntries == null) {
            throw new IOException("Could not find a 'KafkaServer' entry in this configuration: Kafka Server cannot start.");
        }
        this.kerberosShortNamer = kerberosNameParser;
    }

    @Override
    public void handle(Callback[] callbacks) throws UnsupportedCallbackException {
        for (Callback callback : callbacks) {
            if (callback instanceof RealmCallback) {
                this.handleRealmCallback((RealmCallback)callback);
                continue;
            }
            if (!(callback instanceof AuthorizeCallback)) continue;
            this.handleAuthorizeCallback((AuthorizeCallback)callback);
        }
    }

    private void handleRealmCallback(RealmCallback rc) {
        LOG.trace("Client supplied realm: {} ", (Object)rc.getDefaultText());
        rc.setText(rc.getDefaultText());
    }

    private void handleAuthorizeCallback(AuthorizeCallback ac) {
        String authenticationID = ac.getAuthenticationID();
        String authorizationID = ac.getAuthorizationID();
        LOG.info("Successfully authenticated client: authenticationID={}; authorizationID={}.", (Object)authenticationID, (Object)authorizationID);
        ac.setAuthorized(true);
        KerberosName kerberosName = KerberosName.parse(authenticationID);
        try {
            String userName = this.kerberosShortNamer.shortName(kerberosName);
            LOG.info("Setting authorizedID: {}", (Object)userName);
            ac.setAuthorizedID(userName);
        }
        catch (IOException e) {
            LOG.error("Failed to set name based on Kerberos authentication rules.");
        }
    }
}

