/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.utils;

import java.util.concurrent.TimeUnit;
import org.apache.kafka.common.utils.Time;

public class MockTime
implements Time {
    private long nanos = System.nanoTime();
    private long autoTickMs = 0L;

    public MockTime() {
    }

    public MockTime(long autoTickMs) {
        this.autoTickMs = autoTickMs;
    }

    public long milliseconds() {
        this.sleep(this.autoTickMs);
        return TimeUnit.MILLISECONDS.convert(this.nanos, TimeUnit.NANOSECONDS);
    }

    public long nanoseconds() {
        this.sleep(this.autoTickMs);
        return this.nanos;
    }

    public void sleep(long ms) {
        this.nanos += TimeUnit.NANOSECONDS.convert(ms, TimeUnit.MILLISECONDS);
    }
}

