/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.security.kerberos;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.kafka.common.security.kerberos.KerberosName;
import org.apache.kafka.common.security.kerberos.KerberosShortNamer;
import org.junit.Assert;
import org.junit.Test;

public class KerberosNameTest {
    @Test
    public void testParse() throws IOException {
        ArrayList<String> rules = new ArrayList<String>(Arrays.asList("RULE:[1:$1](App\\..*)s/App\\.(.*)/$1/g", "RULE:[2:$1](App\\..*)s/App\\.(.*)/$1/g", "DEFAULT"));
        KerberosShortNamer shortNamer = KerberosShortNamer.fromUnparsedRules((String)"REALM.COM", rules);
        KerberosName name = KerberosName.parse((String)"App.service-name/example.com@REALM.COM");
        Assert.assertEquals((Object)"App.service-name", (Object)name.serviceName());
        Assert.assertEquals((Object)"example.com", (Object)name.hostName());
        Assert.assertEquals((Object)"REALM.COM", (Object)name.realm());
        Assert.assertEquals((Object)"service-name", (Object)shortNamer.shortName(name));
        name = KerberosName.parse((String)"App.service-name@REALM.COM");
        Assert.assertEquals((Object)"App.service-name", (Object)name.serviceName());
        Assert.assertNull((Object)name.hostName());
        Assert.assertEquals((Object)"REALM.COM", (Object)name.realm());
        Assert.assertEquals((Object)"service-name", (Object)shortNamer.shortName(name));
        name = KerberosName.parse((String)"user/host@REALM.COM");
        Assert.assertEquals((Object)"user", (Object)name.serviceName());
        Assert.assertEquals((Object)"host", (Object)name.hostName());
        Assert.assertEquals((Object)"REALM.COM", (Object)name.realm());
        Assert.assertEquals((Object)"user", (Object)shortNamer.shortName(name));
    }
}

