/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.UnknownServerException;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.protocol.ProtoUtils;
import org.apache.kafka.common.protocol.SecurityProtocol;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.AbstractRequestResponse;
import org.apache.kafka.common.requests.ApiVersionsRequest;
import org.apache.kafka.common.requests.ApiVersionsResponse;
import org.apache.kafka.common.requests.ControlledShutdownRequest;
import org.apache.kafka.common.requests.ControlledShutdownResponse;
import org.apache.kafka.common.requests.CreateTopicsRequest;
import org.apache.kafka.common.requests.CreateTopicsResponse;
import org.apache.kafka.common.requests.DeleteTopicsRequest;
import org.apache.kafka.common.requests.DeleteTopicsResponse;
import org.apache.kafka.common.requests.DescribeGroupsRequest;
import org.apache.kafka.common.requests.DescribeGroupsResponse;
import org.apache.kafka.common.requests.FetchRequest;
import org.apache.kafka.common.requests.FetchResponse;
import org.apache.kafka.common.requests.GroupCoordinatorRequest;
import org.apache.kafka.common.requests.GroupCoordinatorResponse;
import org.apache.kafka.common.requests.HeartbeatRequest;
import org.apache.kafka.common.requests.HeartbeatResponse;
import org.apache.kafka.common.requests.JoinGroupRequest;
import org.apache.kafka.common.requests.JoinGroupResponse;
import org.apache.kafka.common.requests.LeaderAndIsrRequest;
import org.apache.kafka.common.requests.LeaderAndIsrResponse;
import org.apache.kafka.common.requests.LeaveGroupRequest;
import org.apache.kafka.common.requests.LeaveGroupResponse;
import org.apache.kafka.common.requests.ListGroupsRequest;
import org.apache.kafka.common.requests.ListGroupsResponse;
import org.apache.kafka.common.requests.ListOffsetRequest;
import org.apache.kafka.common.requests.ListOffsetResponse;
import org.apache.kafka.common.requests.MetadataRequest;
import org.apache.kafka.common.requests.MetadataResponse;
import org.apache.kafka.common.requests.OffsetCommitRequest;
import org.apache.kafka.common.requests.OffsetCommitResponse;
import org.apache.kafka.common.requests.OffsetFetchRequest;
import org.apache.kafka.common.requests.OffsetFetchResponse;
import org.apache.kafka.common.requests.PartitionState;
import org.apache.kafka.common.requests.ProduceRequest;
import org.apache.kafka.common.requests.ProduceResponse;
import org.apache.kafka.common.requests.RequestHeader;
import org.apache.kafka.common.requests.ResponseHeader;
import org.apache.kafka.common.requests.SaslHandshakeRequest;
import org.apache.kafka.common.requests.SaslHandshakeResponse;
import org.apache.kafka.common.requests.StopReplicaRequest;
import org.apache.kafka.common.requests.StopReplicaResponse;
import org.apache.kafka.common.requests.UpdateMetadataRequest;
import org.apache.kafka.common.requests.UpdateMetadataResponse;
import org.junit.Assert;
import org.junit.Test;

public class RequestResponseTest {
    @Test
    public void testSerialization() throws Exception {
        List<AbstractRequestResponse> requestResponseList = Arrays.asList(this.createRequestHeader(), this.createResponseHeader(), this.createGroupCoordinatorRequest(), this.createGroupCoordinatorRequest().getErrorResponse(0, (Throwable)new UnknownServerException()), this.createGroupCoordinatorResponse(), this.createControlledShutdownRequest(), this.createControlledShutdownResponse(), this.createControlledShutdownRequest().getErrorResponse(1, (Throwable)new UnknownServerException()), this.createFetchRequest(3), this.createFetchRequest(3).getErrorResponse(3, (Throwable)new UnknownServerException()), this.createFetchResponse(), this.createHeartBeatRequest(), this.createHeartBeatRequest().getErrorResponse(0, (Throwable)new UnknownServerException()), this.createHeartBeatResponse(), this.createJoinGroupRequest(1), this.createJoinGroupRequest(0).getErrorResponse(0, (Throwable)new UnknownServerException()), this.createJoinGroupRequest(1).getErrorResponse(1, (Throwable)new UnknownServerException()), this.createJoinGroupResponse(), this.createLeaveGroupRequest(), this.createLeaveGroupRequest().getErrorResponse(0, (Throwable)new UnknownServerException()), this.createLeaveGroupResponse(), this.createListGroupsRequest(), this.createListGroupsRequest().getErrorResponse(0, (Throwable)new UnknownServerException()), this.createListGroupsResponse(), this.createDescribeGroupRequest(), this.createDescribeGroupRequest().getErrorResponse(0, (Throwable)new UnknownServerException()), this.createDescribeGroupResponse(), this.createListOffsetRequest(1), this.createListOffsetRequest(1).getErrorResponse(1, (Throwable)new UnknownServerException()), this.createListOffsetResponse(1), MetadataRequest.allTopics(), this.createMetadataRequest(Arrays.asList("topic1")), this.createMetadataRequest(Arrays.asList("topic1")).getErrorResponse(2, (Throwable)new UnknownServerException()), this.createMetadataResponse(2), this.createOffsetCommitRequest(2), this.createOffsetCommitRequest(2).getErrorResponse(2, (Throwable)new UnknownServerException()), this.createOffsetCommitResponse(), this.createOffsetFetchRequest(), this.createOffsetFetchRequest().getErrorResponse(0, (Throwable)new UnknownServerException()), this.createOffsetFetchResponse(), this.createProduceRequest(), this.createProduceRequest().getErrorResponse(2, (Throwable)new UnknownServerException()), this.createProduceResponse(), this.createStopReplicaRequest(true), this.createStopReplicaRequest(false), this.createStopReplicaRequest(true).getErrorResponse(0, (Throwable)new UnknownServerException()), this.createStopReplicaResponse(), this.createUpdateMetadataRequest(2, "rack1"), this.createUpdateMetadataRequest(2, null), this.createUpdateMetadataRequest(2, "rack1").getErrorResponse(2, (Throwable)new UnknownServerException()), this.createUpdateMetadataResponse(), this.createLeaderAndIsrRequest(), this.createLeaderAndIsrRequest().getErrorResponse(0, (Throwable)new UnknownServerException()), this.createLeaderAndIsrResponse(), this.createSaslHandshakeRequest(), this.createSaslHandshakeRequest().getErrorResponse(0, (Throwable)new UnknownServerException()), this.createSaslHandshakeResponse(), this.createApiVersionRequest(), this.createApiVersionRequest().getErrorResponse(0, (Throwable)new UnknownServerException()), this.createApiVersionResponse(), this.createCreateTopicRequest(), this.createCreateTopicRequest().getErrorResponse(0, (Throwable)new UnknownServerException()), this.createCreateTopicResponse(), this.createDeleteTopicsRequest(), this.createDeleteTopicsRequest().getErrorResponse(0, (Throwable)new UnknownServerException()), this.createDeleteTopicsResponse());
        for (AbstractRequestResponse req : requestResponseList) {
            this.checkSerialization(req, null);
        }
        this.checkOlderFetchVersions();
        this.checkSerialization(this.createMetadataResponse(0), 0);
        this.checkSerialization(this.createMetadataResponse(1), 1);
        this.checkSerialization(this.createMetadataRequest(Arrays.asList("topic1")).getErrorResponse(0, (Throwable)new UnknownServerException()), 0);
        this.checkSerialization(this.createMetadataRequest(Arrays.asList("topic1")).getErrorResponse(1, (Throwable)new UnknownServerException()), 1);
        this.checkSerialization((AbstractRequestResponse)this.createOffsetCommitRequest(0), 0);
        this.checkSerialization(this.createOffsetCommitRequest(0).getErrorResponse(0, (Throwable)new UnknownServerException()), 0);
        this.checkSerialization((AbstractRequestResponse)this.createOffsetCommitRequest(1), 1);
        this.checkSerialization(this.createOffsetCommitRequest(1).getErrorResponse(1, (Throwable)new UnknownServerException()), 1);
        this.checkSerialization((AbstractRequestResponse)this.createJoinGroupRequest(0), 0);
        this.checkSerialization((AbstractRequestResponse)this.createUpdateMetadataRequest(0, null), 0);
        this.checkSerialization(this.createUpdateMetadataRequest(0, null).getErrorResponse(0, (Throwable)new UnknownServerException()), 0);
        this.checkSerialization((AbstractRequestResponse)this.createUpdateMetadataRequest(1, null), 1);
        this.checkSerialization((AbstractRequestResponse)this.createUpdateMetadataRequest(1, "rack1"), 1);
        this.checkSerialization(this.createUpdateMetadataRequest(1, null).getErrorResponse(1, (Throwable)new UnknownServerException()), 1);
        this.checkSerialization((AbstractRequestResponse)this.createListOffsetRequest(0), 0);
        this.checkSerialization(this.createListOffsetRequest(0).getErrorResponse(0, (Throwable)new UnknownServerException()), 0);
        this.checkSerialization(this.createListOffsetResponse(0), 0);
    }

    private void checkOlderFetchVersions() throws Exception {
        int latestVersion = ProtoUtils.latestVersion((int)ApiKeys.FETCH.id);
        for (int i = 0; i < latestVersion; ++i) {
            this.checkSerialization(this.createFetchRequest(i).getErrorResponse(i, (Throwable)new UnknownServerException()), i);
            this.checkSerialization((AbstractRequestResponse)this.createFetchRequest(i), i);
        }
    }

    private void checkSerialization(AbstractRequestResponse req, Integer version) throws Exception {
        AbstractRequestResponse deserialized;
        ByteBuffer buffer = ByteBuffer.allocate(req.sizeOf());
        req.writeTo(buffer);
        buffer.rewind();
        if (version == null) {
            Method deserializer = req.getClass().getDeclaredMethod("parse", ByteBuffer.class);
            deserialized = (AbstractRequestResponse)deserializer.invoke(null, buffer);
        } else {
            Method deserializer = req.getClass().getDeclaredMethod("parse", ByteBuffer.class, Integer.TYPE);
            deserialized = (AbstractRequestResponse)deserializer.invoke(null, buffer, version);
        }
        Assert.assertEquals((String)("The original and deserialized of " + req.getClass().getSimpleName() + "(version " + version + ") should be the same."), (Object)req, (Object)deserialized);
        Assert.assertEquals((String)("The original and deserialized of " + req.getClass().getSimpleName() + " should have the same hashcode."), (long)req.hashCode(), (long)deserialized.hashCode());
    }

    @Test
    public void produceResponseVersionTest() {
        HashMap<TopicPartition, ProduceResponse.PartitionResponse> responseData = new HashMap<TopicPartition, ProduceResponse.PartitionResponse>();
        responseData.put(new TopicPartition("test", 0), new ProduceResponse.PartitionResponse(Errors.NONE.code(), 10000L, -1L));
        ProduceResponse v0Response = new ProduceResponse(responseData);
        ProduceResponse v1Response = new ProduceResponse(responseData, 10, 1);
        ProduceResponse v2Response = new ProduceResponse(responseData, 10, 2);
        Assert.assertEquals((String)"Throttle time must be zero", (long)0L, (long)v0Response.getThrottleTime());
        Assert.assertEquals((String)"Throttle time must be 10", (long)10L, (long)v1Response.getThrottleTime());
        Assert.assertEquals((String)"Throttle time must be 10", (long)10L, (long)v2Response.getThrottleTime());
        Assert.assertEquals((String)"Should use schema version 0", (Object)ProtoUtils.responseSchema((int)ApiKeys.PRODUCE.id, (int)0), (Object)v0Response.toStruct().schema());
        Assert.assertEquals((String)"Should use schema version 1", (Object)ProtoUtils.responseSchema((int)ApiKeys.PRODUCE.id, (int)1), (Object)v1Response.toStruct().schema());
        Assert.assertEquals((String)"Should use schema version 2", (Object)ProtoUtils.responseSchema((int)ApiKeys.PRODUCE.id, (int)2), (Object)v2Response.toStruct().schema());
        Assert.assertEquals((String)"Response data does not match", responseData, (Object)v0Response.responses());
        Assert.assertEquals((String)"Response data does not match", responseData, (Object)v1Response.responses());
        Assert.assertEquals((String)"Response data does not match", responseData, (Object)v2Response.responses());
    }

    @Test
    public void fetchResponseVersionTest() {
        HashMap<TopicPartition, FetchResponse.PartitionData> responseData = new HashMap<TopicPartition, FetchResponse.PartitionData>();
        responseData.put(new TopicPartition("test", 0), new FetchResponse.PartitionData(Errors.NONE.code(), 1000000L, ByteBuffer.allocate(10)));
        FetchResponse v0Response = new FetchResponse(responseData);
        FetchResponse v1Response = new FetchResponse(responseData, 10);
        Assert.assertEquals((String)"Throttle time must be zero", (long)0L, (long)v0Response.getThrottleTime());
        Assert.assertEquals((String)"Throttle time must be 10", (long)10L, (long)v1Response.getThrottleTime());
        Assert.assertEquals((String)"Should use schema version 0", (Object)ProtoUtils.responseSchema((int)ApiKeys.FETCH.id, (int)0), (Object)v0Response.toStruct().schema());
        Assert.assertEquals((String)"Should use schema version 1", (Object)ProtoUtils.responseSchema((int)ApiKeys.FETCH.id, (int)1), (Object)v1Response.toStruct().schema());
        Assert.assertEquals((String)"Response data does not match", responseData, (Object)v0Response.responseData());
        Assert.assertEquals((String)"Response data does not match", responseData, (Object)v1Response.responseData());
    }

    @Test
    public void testControlledShutdownResponse() {
        ControlledShutdownResponse response = this.createControlledShutdownResponse();
        ByteBuffer buffer = ByteBuffer.allocate(response.sizeOf());
        response.writeTo(buffer);
        buffer.rewind();
        ControlledShutdownResponse deserialized = ControlledShutdownResponse.parse((ByteBuffer)buffer);
        Assert.assertEquals((long)response.errorCode(), (long)deserialized.errorCode());
        Assert.assertEquals((Object)response.partitionsRemaining(), (Object)deserialized.partitionsRemaining());
    }

    @Test
    public void testRequestHeaderWithNullClientId() {
        RequestHeader header = new RequestHeader(10, 1, null, 10);
        ByteBuffer buffer = ByteBuffer.allocate(header.sizeOf());
        header.writeTo(buffer);
        buffer.rewind();
        RequestHeader deserialized = RequestHeader.parse((ByteBuffer)buffer);
        Assert.assertEquals((long)header.apiKey(), (long)deserialized.apiKey());
        Assert.assertEquals((long)header.apiVersion(), (long)deserialized.apiVersion());
        Assert.assertEquals((long)header.correlationId(), (long)deserialized.correlationId());
        Assert.assertEquals((Object)"", (Object)deserialized.clientId());
    }

    private AbstractRequestResponse createRequestHeader() {
        return new RequestHeader(10, 1, "", 10);
    }

    private AbstractRequestResponse createResponseHeader() {
        return new ResponseHeader(10);
    }

    private AbstractRequest createGroupCoordinatorRequest() {
        return new GroupCoordinatorRequest("test-group");
    }

    private AbstractRequestResponse createGroupCoordinatorResponse() {
        return new GroupCoordinatorResponse(Errors.NONE.code(), new Node(10, "host1", 2014));
    }

    private AbstractRequest createFetchRequest(int version) {
        LinkedHashMap<TopicPartition, FetchRequest.PartitionData> fetchData = new LinkedHashMap<TopicPartition, FetchRequest.PartitionData>();
        fetchData.put(new TopicPartition("test1", 0), new FetchRequest.PartitionData(100L, 1000000));
        fetchData.put(new TopicPartition("test2", 0), new FetchRequest.PartitionData(200L, 1000000));
        if (version < 3) {
            return new FetchRequest(100, 100000, fetchData);
        }
        return new FetchRequest(100, 1000, 1000000, fetchData);
    }

    private AbstractRequestResponse createFetchResponse() {
        HashMap<TopicPartition, FetchResponse.PartitionData> responseData = new HashMap<TopicPartition, FetchResponse.PartitionData>();
        responseData.put(new TopicPartition("test", 0), new FetchResponse.PartitionData(Errors.NONE.code(), 1000000L, ByteBuffer.allocate(10)));
        return new FetchResponse(responseData, 0);
    }

    private AbstractRequest createHeartBeatRequest() {
        return new HeartbeatRequest("group1", 1, "consumer1");
    }

    private AbstractRequestResponse createHeartBeatResponse() {
        return new HeartbeatResponse(Errors.NONE.code());
    }

    private AbstractRequest createJoinGroupRequest(int version) {
        ByteBuffer metadata = ByteBuffer.wrap(new byte[0]);
        ArrayList<JoinGroupRequest.ProtocolMetadata> protocols = new ArrayList<JoinGroupRequest.ProtocolMetadata>();
        protocols.add(new JoinGroupRequest.ProtocolMetadata("consumer-range", metadata));
        if (version == 0) {
            return new JoinGroupRequest("group1", 30000, "consumer1", "consumer", protocols);
        }
        return new JoinGroupRequest("group1", 10000, 60000, "consumer1", "consumer", protocols);
    }

    private AbstractRequestResponse createJoinGroupResponse() {
        HashMap<String, ByteBuffer> members = new HashMap<String, ByteBuffer>();
        members.put("consumer1", ByteBuffer.wrap(new byte[0]));
        members.put("consumer2", ByteBuffer.wrap(new byte[0]));
        return new JoinGroupResponse(Errors.NONE.code(), 1, "range", "consumer1", "leader", members);
    }

    private AbstractRequest createListGroupsRequest() {
        return new ListGroupsRequest();
    }

    private AbstractRequestResponse createListGroupsResponse() {
        List<ListGroupsResponse.Group> groups = Arrays.asList(new ListGroupsResponse.Group("test-group", "consumer"));
        return new ListGroupsResponse(Errors.NONE.code(), groups);
    }

    private AbstractRequest createDescribeGroupRequest() {
        return new DescribeGroupsRequest(Collections.singletonList("test-group"));
    }

    private AbstractRequestResponse createDescribeGroupResponse() {
        String clientId = "consumer-1";
        String clientHost = "localhost";
        ByteBuffer empty = ByteBuffer.allocate(0);
        DescribeGroupsResponse.GroupMember member = new DescribeGroupsResponse.GroupMember("memberId", clientId, clientHost, empty, empty);
        DescribeGroupsResponse.GroupMetadata metadata = new DescribeGroupsResponse.GroupMetadata(Errors.NONE.code(), "STABLE", "consumer", "roundrobin", Arrays.asList(member));
        return new DescribeGroupsResponse(Collections.singletonMap("test-group", metadata));
    }

    private AbstractRequest createLeaveGroupRequest() {
        return new LeaveGroupRequest("group1", "consumer1");
    }

    private AbstractRequestResponse createLeaveGroupResponse() {
        return new LeaveGroupResponse(Errors.NONE.code());
    }

    private AbstractRequest createListOffsetRequest(int version) {
        if (version == 0) {
            HashMap<TopicPartition, ListOffsetRequest.PartitionData> offsetData = new HashMap<TopicPartition, ListOffsetRequest.PartitionData>();
            offsetData.put(new TopicPartition("test", 0), new ListOffsetRequest.PartitionData(1000000L, 10));
            return new ListOffsetRequest(offsetData);
        }
        if (version == 1) {
            HashMap<TopicPartition, Long> offsetData = new HashMap<TopicPartition, Long>();
            offsetData.put(new TopicPartition("test", 0), 1000000L);
            return new ListOffsetRequest(offsetData, -1);
        }
        throw new IllegalArgumentException("Illegal ListOffsetRequest version " + version);
    }

    private AbstractRequestResponse createListOffsetResponse(int version) {
        if (version == 0) {
            HashMap<TopicPartition, ListOffsetResponse.PartitionData> responseData = new HashMap<TopicPartition, ListOffsetResponse.PartitionData>();
            responseData.put(new TopicPartition("test", 0), new ListOffsetResponse.PartitionData(Errors.NONE.code(), Arrays.asList(100L)));
            return new ListOffsetResponse(responseData);
        }
        if (version == 1) {
            HashMap<TopicPartition, ListOffsetResponse.PartitionData> responseData = new HashMap<TopicPartition, ListOffsetResponse.PartitionData>();
            responseData.put(new TopicPartition("test", 0), new ListOffsetResponse.PartitionData(Errors.NONE.code(), 10000L, 100L));
            return new ListOffsetResponse(responseData, 1);
        }
        throw new IllegalArgumentException("Illegal ListOffsetResponse version " + version);
    }

    private AbstractRequest createMetadataRequest(List<String> topics) {
        return new MetadataRequest(topics);
    }

    private AbstractRequestResponse createMetadataResponse(int version) {
        Node node = new Node(1, "host1", 1001);
        List<Node> replicas = Arrays.asList(node);
        List<Node> isr = Arrays.asList(node);
        ArrayList<MetadataResponse.TopicMetadata> allTopicMetadata = new ArrayList<MetadataResponse.TopicMetadata>();
        allTopicMetadata.add(new MetadataResponse.TopicMetadata(Errors.NONE, "__consumer_offsets", true, Arrays.asList(new MetadataResponse.PartitionMetadata(Errors.NONE, 1, node, replicas, isr))));
        allTopicMetadata.add(new MetadataResponse.TopicMetadata(Errors.LEADER_NOT_AVAILABLE, "topic2", false, Collections.emptyList()));
        return new MetadataResponse(Arrays.asList(node), null, -1, allTopicMetadata, version);
    }

    private AbstractRequest createOffsetCommitRequest(int version) {
        HashMap<TopicPartition, OffsetCommitRequest.PartitionData> commitData = new HashMap<TopicPartition, OffsetCommitRequest.PartitionData>();
        commitData.put(new TopicPartition("test", 0), new OffsetCommitRequest.PartitionData(100L, ""));
        commitData.put(new TopicPartition("test", 1), new OffsetCommitRequest.PartitionData(200L, null));
        if (version == 0) {
            return new OffsetCommitRequest("group1", commitData);
        }
        if (version == 1) {
            return new OffsetCommitRequest("group1", 100, "consumer1", commitData);
        }
        if (version == 2) {
            return new OffsetCommitRequest("group1", 100, "consumer1", 1000000L, commitData);
        }
        throw new IllegalArgumentException("Unknown offset commit request version " + version);
    }

    private AbstractRequestResponse createOffsetCommitResponse() {
        HashMap<TopicPartition, Short> responseData = new HashMap<TopicPartition, Short>();
        responseData.put(new TopicPartition("test", 0), Errors.NONE.code());
        return new OffsetCommitResponse(responseData);
    }

    private AbstractRequest createOffsetFetchRequest() {
        return new OffsetFetchRequest("group1", Arrays.asList(new TopicPartition("test11", 1)));
    }

    private AbstractRequestResponse createOffsetFetchResponse() {
        HashMap<TopicPartition, OffsetFetchResponse.PartitionData> responseData = new HashMap<TopicPartition, OffsetFetchResponse.PartitionData>();
        responseData.put(new TopicPartition("test", 0), new OffsetFetchResponse.PartitionData(100L, "", Errors.NONE.code()));
        responseData.put(new TopicPartition("test", 1), new OffsetFetchResponse.PartitionData(100L, null, Errors.NONE.code()));
        return new OffsetFetchResponse(responseData);
    }

    private AbstractRequest createProduceRequest() {
        HashMap<TopicPartition, ByteBuffer> produceData = new HashMap<TopicPartition, ByteBuffer>();
        produceData.put(new TopicPartition("test", 0), ByteBuffer.allocate(10));
        return new ProduceRequest(1, 5000, produceData);
    }

    private AbstractRequestResponse createProduceResponse() {
        HashMap<TopicPartition, ProduceResponse.PartitionResponse> responseData = new HashMap<TopicPartition, ProduceResponse.PartitionResponse>();
        responseData.put(new TopicPartition("test", 0), new ProduceResponse.PartitionResponse(Errors.NONE.code(), 10000L, -1L));
        return new ProduceResponse(responseData, 0);
    }

    private AbstractRequest createStopReplicaRequest(boolean deletePartitions) {
        HashSet<TopicPartition> partitions = new HashSet<TopicPartition>(Arrays.asList(new TopicPartition("test", 0)));
        return new StopReplicaRequest(0, 1, deletePartitions, partitions);
    }

    private AbstractRequestResponse createStopReplicaResponse() {
        HashMap<TopicPartition, Short> responses = new HashMap<TopicPartition, Short>();
        responses.put(new TopicPartition("test", 0), Errors.NONE.code());
        return new StopReplicaResponse(Errors.NONE.code(), responses);
    }

    private AbstractRequest createControlledShutdownRequest() {
        return new ControlledShutdownRequest(10);
    }

    private ControlledShutdownResponse createControlledShutdownResponse() {
        HashSet<TopicPartition> topicPartitions = new HashSet<TopicPartition>(Arrays.asList(new TopicPartition("test2", 5), new TopicPartition("test1", 10)));
        return new ControlledShutdownResponse(Errors.NONE.code(), topicPartitions);
    }

    private AbstractRequest createLeaderAndIsrRequest() {
        HashMap<TopicPartition, PartitionState> partitionStates = new HashMap<TopicPartition, PartitionState>();
        List<Integer> isr = Arrays.asList(1, 2);
        List<Integer> replicas = Arrays.asList(1, 2, 3, 4);
        partitionStates.put(new TopicPartition("topic5", 105), new PartitionState(0, 2, 1, new ArrayList<Integer>(isr), 2, new HashSet<Integer>(replicas)));
        partitionStates.put(new TopicPartition("topic5", 1), new PartitionState(1, 1, 1, new ArrayList<Integer>(isr), 2, new HashSet<Integer>(replicas)));
        partitionStates.put(new TopicPartition("topic20", 1), new PartitionState(1, 0, 1, new ArrayList<Integer>(isr), 2, new HashSet<Integer>(replicas)));
        HashSet<Node> leaders = new HashSet<Node>(Arrays.asList(new Node(0, "test0", 1223), new Node(1, "test1", 1223)));
        return new LeaderAndIsrRequest(1, 10, partitionStates, leaders);
    }

    private AbstractRequestResponse createLeaderAndIsrResponse() {
        HashMap<TopicPartition, Short> responses = new HashMap<TopicPartition, Short>();
        responses.put(new TopicPartition("test", 0), Errors.NONE.code());
        return new LeaderAndIsrResponse(Errors.NONE.code(), responses);
    }

    private AbstractRequest createUpdateMetadataRequest(int version, String rack) {
        HashMap<TopicPartition, PartitionState> partitionStates = new HashMap<TopicPartition, PartitionState>();
        List<Integer> isr = Arrays.asList(1, 2);
        List<Integer> replicas = Arrays.asList(1, 2, 3, 4);
        partitionStates.put(new TopicPartition("topic5", 105), new PartitionState(0, 2, 1, new ArrayList<Integer>(isr), 2, new HashSet<Integer>(replicas)));
        partitionStates.put(new TopicPartition("topic5", 1), new PartitionState(1, 1, 1, new ArrayList<Integer>(isr), 2, new HashSet<Integer>(replicas)));
        partitionStates.put(new TopicPartition("topic20", 1), new PartitionState(1, 0, 1, new ArrayList<Integer>(isr), 2, new HashSet<Integer>(replicas)));
        if (version == 0) {
            HashSet<Node> liveBrokers = new HashSet<Node>(Arrays.asList(new Node(0, "host1", 1223), new Node(1, "host2", 1234)));
            return new UpdateMetadataRequest(1, 10, liveBrokers, partitionStates);
        }
        HashMap<SecurityProtocol, UpdateMetadataRequest.EndPoint> endPoints1 = new HashMap<SecurityProtocol, UpdateMetadataRequest.EndPoint>();
        endPoints1.put(SecurityProtocol.PLAINTEXT, new UpdateMetadataRequest.EndPoint("host1", 1223));
        HashMap<SecurityProtocol, UpdateMetadataRequest.EndPoint> endPoints2 = new HashMap<SecurityProtocol, UpdateMetadataRequest.EndPoint>();
        endPoints2.put(SecurityProtocol.PLAINTEXT, new UpdateMetadataRequest.EndPoint("host1", 1244));
        endPoints2.put(SecurityProtocol.SSL, new UpdateMetadataRequest.EndPoint("host2", 1234));
        HashSet<UpdateMetadataRequest.Broker> liveBrokers = new HashSet<UpdateMetadataRequest.Broker>(Arrays.asList(new UpdateMetadataRequest.Broker(0, endPoints1, rack), new UpdateMetadataRequest.Broker(1, endPoints2, rack)));
        return new UpdateMetadataRequest(version, 1, 10, partitionStates, liveBrokers);
    }

    private AbstractRequestResponse createUpdateMetadataResponse() {
        return new UpdateMetadataResponse(Errors.NONE.code());
    }

    private AbstractRequest createSaslHandshakeRequest() {
        return new SaslHandshakeRequest("PLAIN");
    }

    private AbstractRequestResponse createSaslHandshakeResponse() {
        return new SaslHandshakeResponse(Errors.NONE.code(), Collections.singletonList("GSSAPI"));
    }

    private AbstractRequest createApiVersionRequest() {
        return new ApiVersionsRequest();
    }

    private AbstractRequestResponse createApiVersionResponse() {
        List<ApiVersionsResponse.ApiVersion> apiVersions = Arrays.asList(new ApiVersionsResponse.ApiVersion(0, 0, 2));
        return new ApiVersionsResponse(Errors.NONE.code(), apiVersions);
    }

    private AbstractRequest createCreateTopicRequest() {
        CreateTopicsRequest.TopicDetails request1 = new CreateTopicsRequest.TopicDetails(3, 5);
        HashMap<Integer, List<Integer>> replicaAssignments = new HashMap<Integer, List<Integer>>();
        replicaAssignments.put(1, Arrays.asList(1, 2, 3));
        replicaAssignments.put(2, Arrays.asList(2, 3, 4));
        HashMap<String, String> configs = new HashMap<String, String>();
        configs.put("config1", "value1");
        CreateTopicsRequest.TopicDetails request2 = new CreateTopicsRequest.TopicDetails(replicaAssignments, configs);
        HashMap<String, CreateTopicsRequest.TopicDetails> request = new HashMap<String, CreateTopicsRequest.TopicDetails>();
        request.put("my_t1", request1);
        request.put("my_t2", request2);
        return new CreateTopicsRequest(request, Integer.valueOf(0));
    }

    private AbstractRequestResponse createCreateTopicResponse() {
        HashMap<String, Errors> errors = new HashMap<String, Errors>();
        errors.put("t1", Errors.INVALID_TOPIC_EXCEPTION);
        errors.put("t2", Errors.LEADER_NOT_AVAILABLE);
        return new CreateTopicsResponse(errors);
    }

    private AbstractRequest createDeleteTopicsRequest() {
        return new DeleteTopicsRequest(new HashSet<String>(Arrays.asList("my_t1", "my_t2")), Integer.valueOf(10000));
    }

    private AbstractRequestResponse createDeleteTopicsResponse() {
        HashMap<String, Errors> errors = new HashMap<String, Errors>();
        errors.put("t1", Errors.INVALID_TOPIC_EXCEPTION);
        errors.put("t2", Errors.TOPIC_AUTHORIZATION_FAILED);
        return new DeleteTopicsResponse(errors);
    }
}

