/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.connect.runtime.rest;

import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import org.apache.kafka.connect.runtime.Herder;
import org.apache.kafka.connect.runtime.rest.RestClient;
import org.apache.kafka.connect.runtime.rest.RestServer;
import org.apache.kafka.connect.runtime.rest.RestServerConfig;
import org.apache.kafka.connect.runtime.rest.resources.ConnectResource;
import org.apache.kafka.connect.runtime.rest.resources.ConnectorPluginsResource;
import org.apache.kafka.connect.runtime.rest.resources.ConnectorsResource;
import org.apache.kafka.connect.runtime.rest.resources.InternalConnectResource;
import org.apache.kafka.connect.runtime.rest.resources.LoggingResource;
import org.apache.kafka.connect.runtime.rest.resources.RootResource;
import org.glassfish.jersey.server.ResourceConfig;

public class ConnectRestServer
extends RestServer {
    private final RestClient restClient;
    private Herder herder;

    public ConnectRestServer(Integer rebalanceTimeoutMs, RestClient restClient, Map<?, ?> props) {
        super(RestServerConfig.forPublic(rebalanceTimeoutMs, props));
        this.restClient = restClient;
    }

    public void initializeResources(Herder herder) {
        this.herder = herder;
        super.initializeResources();
    }

    @Override
    protected Collection<ConnectResource> regularResources() {
        return Arrays.asList(new RootResource(this.herder), new ConnectorsResource(this.herder, this.config, this.restClient), new InternalConnectResource(this.herder, this.restClient), new ConnectorPluginsResource(this.herder));
    }

    @Override
    protected Collection<ConnectResource> adminResources() {
        return Arrays.asList(new LoggingResource());
    }

    @Override
    protected void configureRegularResources(ResourceConfig resourceConfig) {
        this.registerRestExtensions(this.herder, resourceConfig);
    }
}

