/*
 * Decompiled with CFR 0.152.
 */
package org.apache.johnzon.mapper.internal;

import java.lang.reflect.Type;

public class AdapterKey {
    private final Type from;
    private final Type to;
    private final int hash;
    private Class valueAsClass;
    private Class<?> keyAsClass;

    public AdapterKey(Type from, Type to) {
        this(from, to, false);
    }

    public AdapterKey(Type from, Type to, boolean lookup) {
        this.from = from;
        this.to = to;
        if (!lookup) {
            this.keyAsClass = Class.class.isInstance(from) ? (Class)Class.class.cast(from) : null;
            this.valueAsClass = Class.class.isInstance(to) ? (Class)Class.class.cast(to) : null;
        }
        int result = from.hashCode();
        this.hash = result = 31 * result + to.hashCode();
    }

    public Type getFrom() {
        return this.from;
    }

    public Type getTo() {
        return this.to;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AdapterKey that = (AdapterKey)AdapterKey.class.cast(o);
        return this.from.equals(that.from) && this.to.equals(that.to);
    }

    public boolean isAssignableFrom(Type type) {
        return this.keyAsClass != null && Class.class.isInstance(type) && this.keyAsClass.isAssignableFrom((Class)Class.class.cast(type));
    }

    public boolean isAssignableTo(Type type) {
        return this.valueAsClass != null && Class.class.isInstance(type) && this.valueAsClass.isAssignableFrom((Class)Class.class.cast(type));
    }

    public int hashCode() {
        return this.hash;
    }

    public String toString() {
        return "AdapterKey{from=" + this.from + ", to=" + this.to + "}";
    }
}

