/*
 * Decompiled with CFR 0.152.
 */
package org.apache.johnzon.mapper.access;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import org.apache.johnzon.mapper.Adapter;
import org.apache.johnzon.mapper.JohnzonIgnore;
import org.apache.johnzon.mapper.JohnzonProperty;
import org.apache.johnzon.mapper.ObjectConverter;
import org.apache.johnzon.mapper.access.AccessMode;
import org.apache.johnzon.mapper.access.BaseAccessMode;
import org.apache.johnzon.mapper.access.FieldAccessMode;
import org.apache.johnzon.mapper.access.MethodAccessMode;
import org.apache.johnzon.mapper.reflection.Records;
import org.apache.johnzon.mapper.util.BeanUtil;

public class FieldAndMethodAccessMode
extends BaseAccessMode {
    private final FieldAccessMode fields;
    private final MethodAccessMode methods;
    private final boolean alwaysPreferMethodVisibility;
    private final boolean ignoreVisibilityFilter;

    public FieldAndMethodAccessMode(boolean useConstructor, boolean acceptHiddenConstructor, boolean useGettersAsWriter, boolean alwaysPreferMethodVisibility, boolean ignoreVisibilityFilter) {
        super(useConstructor, acceptHiddenConstructor);
        this.fields = new FieldAccessMode(useConstructor, acceptHiddenConstructor);
        this.methods = new MethodAccessMode(useConstructor, acceptHiddenConstructor, useGettersAsWriter);
        this.alwaysPreferMethodVisibility = alwaysPreferMethodVisibility;
        this.ignoreVisibilityFilter = ignoreVisibilityFilter;
    }

    @Deprecated
    public FieldAndMethodAccessMode(boolean useConstructor, boolean acceptHiddenConstructor, boolean useGettersAsWriter, boolean alwaysPreferMethodVisibility) {
        this(useConstructor, acceptHiddenConstructor, useGettersAsWriter, alwaysPreferMethodVisibility, false);
    }

    @Deprecated
    public FieldAndMethodAccessMode(boolean useConstructor, boolean acceptHiddenConstructor, boolean useGettersAsWriter) {
        this(useConstructor, acceptHiddenConstructor, useGettersAsWriter, true, false);
    }

    @Override
    public Map<String, AccessMode.Reader> doFindReaders(Class<?> clazz) {
        Map<String, AccessMode.Reader> methodReaders = this.methods.findReaders(clazz);
        boolean record = Records.isRecord(clazz);
        if (record) {
            return methodReaders;
        }
        Map<String, AccessMode.Reader> fieldsReaders = this.fields.findReaders(clazz);
        HashMap<String, AccessMode.Reader> readers = new HashMap<String, AccessMode.Reader>();
        for (Map.Entry<String, AccessMode.Reader> entry : fieldsReaders.entrySet()) {
            Method m;
            String key = entry.getKey();
            Method method = record ? this.getMethod(key, clazz, new Class[0]) : (m = this.getMethod("get" + Character.toUpperCase(key.charAt(0)) + (key.length() > 1 ? key.substring(1) : ""), clazz, new Class[0]));
            if (!(m != null || record || Boolean.TYPE != entry.getValue().getType() && Boolean.class != entry.getValue().getType())) {
                m = this.getMethod("is" + Character.toUpperCase(key.charAt(0)) + (key.length() > 1 ? key.substring(1) : ""), clazz, new Class[0]);
            }
            boolean skip = false;
            if (m != null && (this.ignoreVisibilityFilter || Modifier.isPublic(m.getModifiers()))) {
                for (AccessMode.Reader reader : methodReaders.values()) {
                    if (!((MethodAccessMode.MethodDecoratedType)MethodAccessMode.MethodDecoratedType.class.cast(reader)).getMethod().equals(m)) continue;
                    if (reader.getAnnotation(JohnzonProperty.class) != null || reader.getAnnotation(JohnzonIgnore.class) != null) {
                        skip = true;
                    }
                    break;
                }
            } else if (!this.ignoreVisibilityFilter && m != null) continue;
            if (skip) continue;
            readers.put(entry.getKey(), entry.getValue());
        }
        for (Map.Entry<String, AccessMode.Reader> entry : methodReaders.entrySet()) {
            Method mr = ((MethodAccessMode.MethodDecoratedType)MethodAccessMode.MethodDecoratedType.class.cast(entry.getValue())).getMethod();
            String fieldName = record ? mr.getName() : BeanUtil.decapitalize(mr.getName().startsWith("is") ? mr.getName().substring(2) : mr.getName().substring(3));
            Field f = this.getField(fieldName, clazz);
            boolean skip = false;
            if (f != null) {
                for (AccessMode.Reader w : fieldsReaders.values()) {
                    if (!((FieldAccessMode.FieldDecoratedType)FieldAccessMode.FieldDecoratedType.class.cast(w)).getField().equals(f)) continue;
                    if (w.getAnnotation(JohnzonProperty.class) == null && w.getAnnotation(JohnzonIgnore.class) == null) break;
                    skip = true;
                    break;
                }
            }
            if (skip) continue;
            AccessMode.Reader reader = (AccessMode.Reader)readers.get(entry.getKey());
            if (reader == null) {
                if (f != null) {
                    readers.put(entry.getKey(), new CompositeReader(entry.getValue(), new FieldAccessMode.FieldReader(f, f.getType())));
                    continue;
                }
                readers.put(entry.getKey(), entry.getValue());
                continue;
            }
            readers.put(entry.getKey(), new CompositeReader(entry.getValue(), reader));
        }
        return readers;
    }

    private Method getMethod(String methodName, Class<?> type, Class<?> ... args) {
        try {
            if (this.alwaysPreferMethodVisibility) {
                return type.getDeclaredMethod(methodName, args);
            }
            return type.getMethod(methodName, args);
        }
        catch (NoSuchMethodException e) {
            if (this.alwaysPreferMethodVisibility) {
                try {
                    return type.getMethod(methodName, args);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    // empty catch block
                }
            }
            return null;
        }
    }

    private Field getField(String fieldName, Class<?> type) {
        for (Class<?> t = type; t != Object.class && t != null; t = t.getSuperclass()) {
            try {
                return t.getDeclaredField(fieldName);
            }
            catch (NoSuchFieldException noSuchFieldException) {
                continue;
            }
        }
        return null;
    }

    @Override
    public Map<String, AccessMode.Writer> doFindWriters(Class<?> clazz) {
        Map<String, AccessMode.Writer> fieldWriters = this.fields.findWriters(clazz);
        Map<String, AccessMode.Writer> methodWriters = this.methods.findWriters(clazz);
        HashMap<String, AccessMode.Writer> writers = new HashMap<String, AccessMode.Writer>();
        for (Map.Entry<String, AccessMode.Writer> entry : fieldWriters.entrySet()) {
            String key = entry.getKey();
            Method m = this.getMethod("set" + Character.toUpperCase(key.charAt(0)) + (key.length() > 1 ? key.substring(1) : ""), clazz, this.toType(entry.getValue().getType()));
            boolean skip = false;
            if (m != null && (this.ignoreVisibilityFilter || Modifier.isPublic(m.getModifiers()))) {
                for (AccessMode.Writer writer : methodWriters.values()) {
                    if (!((MethodAccessMode.MethodDecoratedType)MethodAccessMode.MethodDecoratedType.class.cast(writer)).getMethod().equals(m)) continue;
                    if (writer.getAnnotation(JohnzonProperty.class) != null) {
                        skip = true;
                    }
                    break;
                }
            } else if (!this.ignoreVisibilityFilter && m != null) continue;
            if (skip) continue;
            writers.put(entry.getKey(), entry.getValue());
        }
        for (Map.Entry<String, AccessMode.Writer> entry : methodWriters.entrySet()) {
            Method mr = ((MethodAccessMode.MethodDecoratedType)MethodAccessMode.MethodDecoratedType.class.cast(entry.getValue())).getMethod();
            String fieldName = BeanUtil.decapitalize(mr.getName().startsWith("is") ? mr.getName().substring(2) : mr.getName().substring(3));
            Field f = this.getField(fieldName, clazz);
            boolean skip = false;
            if (f != null) {
                for (AccessMode.Writer w : fieldWriters.values()) {
                    if (!((FieldAccessMode.FieldDecoratedType)FieldAccessMode.FieldDecoratedType.class.cast(w)).getField().equals(f)) continue;
                    if (w.getAnnotation(JohnzonProperty.class) == null) break;
                    skip = true;
                    break;
                }
            }
            if (skip) continue;
            AccessMode.Writer writer = (AccessMode.Writer)writers.get(entry.getKey());
            if (writer == null) {
                if (f != null) {
                    writers.put(entry.getKey(), new CompositeWriter(entry.getValue(), new FieldAccessMode.FieldWriter(f, f.getType())));
                    continue;
                }
                writers.put(entry.getKey(), entry.getValue());
                continue;
            }
            writers.put(entry.getKey(), new CompositeWriter(entry.getValue(), writer));
        }
        return writers;
    }

    private Class<?> toType(Type type) {
        return Class.class.isInstance(type) ? (Class<Object>)Class.class.cast(type) : (ParameterizedType.class.isInstance(type) ? this.toType(((ParameterizedType)ParameterizedType.class.cast(type)).getRawType()) : Object.class);
    }

    public static final class CompositeWriter
    extends CompositeDecoratedType<AccessMode.Writer>
    implements AccessMode.Writer {
        private CompositeWriter(AccessMode.Writer type1, AccessMode.Writer type2) {
            super(type1, type2);
        }

        @Override
        public void write(Object instance, Object value) {
            ((AccessMode.Writer)this.type1).write(instance, value);
        }

        @Override
        public ObjectConverter.Reader<?> findObjectConverterReader() {
            ObjectConverter.Reader<?> objectConverter = ((AccessMode.Writer)this.type2).findObjectConverterReader();
            return objectConverter == null ? ((AccessMode.Writer)this.type1).findObjectConverterReader() : objectConverter;
        }
    }

    public static final class CompositeReader
    extends CompositeDecoratedType<AccessMode.Reader>
    implements AccessMode.Reader {
        private CompositeReader(AccessMode.Reader type1, AccessMode.Reader type2) {
            super(type1, type2);
        }

        @Override
        public Object read(Object instance) {
            return ((AccessMode.Reader)this.type1).read(instance);
        }

        @Override
        public ObjectConverter.Writer<?> findObjectConverterWriter() {
            ObjectConverter.Writer<?> objectConverter = ((AccessMode.Reader)this.type2).findObjectConverterWriter();
            return objectConverter == null ? ((AccessMode.Reader)this.type1).findObjectConverterWriter() : objectConverter;
        }
    }

    public static abstract class CompositeDecoratedType<T extends AccessMode.DecoratedType>
    implements AccessMode.DecoratedType {
        protected final T type1;
        protected final T type2;

        private CompositeDecoratedType(T type1, T type2) {
            this.type1 = type1;
            this.type2 = type2;
        }

        @Override
        public <T extends Annotation> T getClassOrPackageAnnotation(Class<T> clazz) {
            T found = this.type1.getClassOrPackageAnnotation(clazz);
            return found == null ? this.type2.getClassOrPackageAnnotation(clazz) : found;
        }

        @Override
        public Adapter<?, ?> findConverter() {
            Adapter<?, ?> converter = this.type1.findConverter();
            return converter != null ? converter : this.type2.findConverter();
        }

        @Override
        public <T extends Annotation> T getAnnotation(Class<T> clazz) {
            T found = this.type1.getAnnotation(clazz);
            return found == null ? this.type2.getAnnotation(clazz) : found;
        }

        @Override
        public Type getType() {
            return this.type1.getType();
        }

        @Override
        public boolean isNillable(boolean global) {
            return this.type1.isNillable(global) || this.type2.isNillable(global);
        }

        public AccessMode.DecoratedType getType1() {
            return this.type1;
        }

        public AccessMode.DecoratedType getType2() {
            return this.type2;
        }

        public String toString() {
            return "CompositeDecoratedType{type1=" + this.type1 + ", type2=" + this.type2 + "}";
        }
    }
}

