/*
 * Decompiled with CFR 0.152.
 */
package org.apache.johnzon.mapper;

import java.math.BigDecimal;
import java.math.BigInteger;
import javax.json.JsonValue;
import javax.json.stream.JsonGenerator;
import org.apache.johnzon.mapper.MappingGenerator;

public class DynamicMappingGenerator
implements MappingGenerator {
    private final MappingGenerator delegate;
    private final Runnable writeStart;
    private final Runnable writeEnd;
    private final String keyName;
    protected InObjectOrPrimitiveJsonGenerator generator;

    public DynamicMappingGenerator(MappingGenerator delegate, Runnable writeStart, Runnable writeEnd, String keyName) {
        this.delegate = delegate;
        this.writeStart = writeStart;
        this.writeEnd = writeEnd;
        this.keyName = keyName;
    }

    protected JsonGenerator getRawJsonGenerator() {
        return this.delegate.getJsonGenerator();
    }

    @Override
    public JsonGenerator getJsonGenerator() {
        return this.generator == null ? (this.generator = new InObjectOrPrimitiveJsonGenerator(this.getRawJsonGenerator(), this.writeStart, this.keyName, this.writeEnd)) : this.generator;
    }

    @Override
    public MappingGenerator writeObject(String key, Object o, JsonGenerator generator) {
        return this.delegate.writeObject(key, o, this.ensureGenerator(generator));
    }

    @Override
    public MappingGenerator writeObject(Object o, JsonGenerator generator) {
        return this.delegate.writeObject(o, this.ensureGenerator(generator));
    }

    private JsonGenerator ensureGenerator(JsonGenerator generator) {
        if (this.generator != null && this.generator != generator && this.generator.delegate != generator) {
            this.generator = null;
            this.reset();
        }
        return this.getJsonGenerator();
    }

    protected void reset() {
    }

    public void flushIfNeeded() {
        if (this.generator != null) {
            this.generator.endIfNeeded();
        }
    }

    public static class SkipEnclosingWriteEnd
    extends DynamicMappingGenerator {
        private static final Runnable NOOP = () -> {};
        private final JsonGenerator rawGenerator;
        private SkipLastWriteEndGenerator skippingGenerator;

        public SkipEnclosingWriteEnd(MappingGenerator delegate, String keyName, JsonGenerator generator) {
            super(delegate, NOOP, NOOP, keyName);
            this.rawGenerator = generator;
        }

        @Override
        protected JsonGenerator getRawJsonGenerator() {
            return this.rawGenerator;
        }

        @Override
        public JsonGenerator getJsonGenerator() {
            if (this.skippingGenerator == null) {
                this.skippingGenerator = new SkipLastWriteEndGenerator(super.getJsonGenerator());
            }
            return this.skippingGenerator;
        }

        @Override
        protected void reset() {
            super.reset();
            this.skippingGenerator = null;
        }
    }

    private static class SkipLastWriteEndGenerator
    extends DelegatingGenerator {
        private int level = -1;

        private SkipLastWriteEndGenerator(JsonGenerator generator) {
            super(generator);
        }

        public JsonGenerator writeStartObject() {
            ++this.level;
            if (this.level > 0) {
                this.delegate.writeStartObject();
            }
            return this;
        }

        public JsonGenerator writeStartObject(String name) {
            ++this.level;
            if (this.level == 0) {
                ++this.level;
            }
            this.delegate.writeStartObject(name);
            return this;
        }

        public JsonGenerator writeStartArray() {
            ++this.level;
            this.delegate.writeStartArray();
            return this;
        }

        public JsonGenerator writeStartArray(String name) {
            this.delegate.writeStartArray(name);
            ++this.level;
            return this;
        }

        public JsonGenerator writeEnd() {
            if (this.level > 0) {
                this.delegate.writeEnd();
            }
            --this.level;
            return this;
        }
    }

    private static abstract class DelegatingGenerator
    implements JsonGenerator {
        protected final JsonGenerator delegate;

        protected DelegatingGenerator(JsonGenerator generator) {
            this.delegate = generator;
        }

        public JsonGenerator writeKey(String name) {
            this.delegate.writeKey(name);
            return this;
        }

        public JsonGenerator write(String name, JsonValue value) {
            this.delegate.write(name, value);
            return this;
        }

        public JsonGenerator write(String name, String value) {
            this.delegate.write(name, value);
            return this;
        }

        public JsonGenerator write(String name, BigInteger value) {
            this.delegate.write(name, value);
            return this;
        }

        public JsonGenerator write(String name, BigDecimal value) {
            this.delegate.write(name, value);
            return this;
        }

        public JsonGenerator write(String name, int value) {
            this.delegate.write(name, value);
            return this;
        }

        public JsonGenerator write(String name, long value) {
            this.delegate.write(name, value);
            return this;
        }

        public JsonGenerator write(String name, double value) {
            this.delegate.write(name, value);
            return this;
        }

        public JsonGenerator write(String name, boolean value) {
            this.delegate.write(name, value);
            return this;
        }

        public JsonGenerator writeNull(String name) {
            this.delegate.writeNull(name);
            return this;
        }

        public JsonGenerator write(JsonValue value) {
            this.delegate.write(value);
            return this;
        }

        public JsonGenerator write(String value) {
            this.delegate.write(value);
            return this;
        }

        public JsonGenerator write(BigDecimal value) {
            this.delegate.write(value);
            return this;
        }

        public JsonGenerator write(BigInteger value) {
            this.delegate.write(value);
            return this;
        }

        public JsonGenerator write(int value) {
            this.delegate.write(value);
            return this;
        }

        public JsonGenerator write(long value) {
            this.delegate.write(value);
            return this;
        }

        public JsonGenerator write(double value) {
            this.delegate.write(value);
            return this;
        }

        public JsonGenerator write(boolean value) {
            this.delegate.write(value);
            return this;
        }

        public JsonGenerator writeNull() {
            this.delegate.writeNull();
            return this;
        }

        public void close() {
            this.delegate.close();
        }

        public void flush() {
            this.delegate.flush();
        }
    }

    public static class InObjectOrPrimitiveJsonGenerator
    implements JsonGenerator {
        private final JsonGenerator delegate;
        private final Runnable writeStart;
        private final Runnable writeEnd;
        private final String keyIfNoObject;
        private WritingState state = WritingState.NONE;
        private int nested = 0;

        private InObjectOrPrimitiveJsonGenerator(JsonGenerator generator, Runnable writeStart, String keyName, Runnable writeEnd) {
            this.delegate = generator;
            this.writeStart = writeStart;
            this.writeEnd = writeEnd;
            this.keyIfNoObject = keyName;
        }

        private void ensureStart() {
            if (this.state != WritingState.NONE) {
                return;
            }
            this.writeStart.run();
            this.state = WritingState.WROTE_START;
        }

        public JsonGenerator writeStartObject() {
            if (this.state == WritingState.NONE) {
                this.ensureStart();
            } else {
                ++this.nested;
                this.delegate.writeStartObject();
            }
            return this;
        }

        public JsonGenerator writeStartObject(String name) {
            if (this.state == WritingState.NONE) {
                this.ensureStart();
            }
            ++this.nested;
            this.delegate.writeStartObject(name);
            return this;
        }

        public JsonGenerator writeStartArray() {
            if (this.state != WritingState.NONE) {
                ++this.nested;
            }
            if (this.keyIfNoObject != null && this.state == WritingState.NONE) {
                this.state = WritingState.DONT_WRITE_END;
                return this.delegate.writeStartArray(this.keyIfNoObject);
            }
            if (this.state == WritingState.NONE) {
                this.ensureStart();
                return this;
            }
            this.delegate.writeStartArray();
            return this;
        }

        public JsonGenerator writeStartArray(String name) {
            if (this.state != WritingState.NONE) {
                ++this.nested;
            }
            this.ensureStart();
            this.delegate.writeStartArray(name);
            return this;
        }

        public JsonGenerator writeKey(String name) {
            this.ensureStart();
            this.delegate.writeKey(name);
            return this;
        }

        public JsonGenerator write(String name, JsonValue value) {
            this.ensureStart();
            this.delegate.write(name, value);
            return this;
        }

        public JsonGenerator write(String name, String value) {
            this.ensureStart();
            this.delegate.write(name, value);
            return this;
        }

        public JsonGenerator write(String name, BigInteger value) {
            this.ensureStart();
            this.delegate.write(name, value);
            return this;
        }

        public JsonGenerator write(String name, BigDecimal value) {
            this.ensureStart();
            this.delegate.write(name, value);
            return this;
        }

        public JsonGenerator write(String name, int value) {
            this.ensureStart();
            this.delegate.write(name, value);
            return this;
        }

        public JsonGenerator write(String name, long value) {
            this.ensureStart();
            this.delegate.write(name, value);
            return this;
        }

        public JsonGenerator write(String name, double value) {
            this.ensureStart();
            this.delegate.write(name, value);
            return this;
        }

        public JsonGenerator write(String name, boolean value) {
            this.ensureStart();
            this.delegate.write(name, value);
            return this;
        }

        public JsonGenerator writeNull(String name) {
            this.ensureStart();
            this.delegate.writeNull(name);
            return this;
        }

        public JsonGenerator write(JsonValue value) {
            if (this.isWritingPrimitive()) {
                this.state = WritingState.DONT_WRITE_END;
                this.delegate.write(this.keyIfNoObject, value);
                return this;
            }
            this.delegate.write(value);
            return this;
        }

        public JsonGenerator write(String value) {
            if (this.isWritingPrimitive()) {
                this.state = WritingState.DONT_WRITE_END;
                this.delegate.write(this.keyIfNoObject, value);
                return this;
            }
            this.delegate.write(value);
            return this;
        }

        public JsonGenerator write(BigDecimal value) {
            if (this.isWritingPrimitive()) {
                this.state = WritingState.DONT_WRITE_END;
                this.delegate.write(this.keyIfNoObject, value);
                return this;
            }
            this.delegate.write(value);
            return this;
        }

        public JsonGenerator write(BigInteger value) {
            if (this.isWritingPrimitive()) {
                this.state = WritingState.DONT_WRITE_END;
                this.delegate.write(this.keyIfNoObject, value);
                return this;
            }
            this.delegate.write(value);
            return this;
        }

        public JsonGenerator write(int value) {
            if (this.isWritingPrimitive()) {
                this.state = WritingState.DONT_WRITE_END;
                this.delegate.write(this.keyIfNoObject, value);
                return this;
            }
            this.delegate.write(value);
            return this;
        }

        public JsonGenerator write(long value) {
            if (this.isWritingPrimitive()) {
                this.state = WritingState.DONT_WRITE_END;
                this.delegate.write(this.keyIfNoObject, value);
                return this;
            }
            this.delegate.write(value);
            return this;
        }

        public JsonGenerator write(double value) {
            if (this.isWritingPrimitive()) {
                this.state = WritingState.DONT_WRITE_END;
                this.delegate.write(this.keyIfNoObject, value);
                return this;
            }
            this.delegate.write(value);
            return this;
        }

        public JsonGenerator write(boolean value) {
            if (this.isWritingPrimitive()) {
                this.state = WritingState.DONT_WRITE_END;
                this.delegate.write(this.keyIfNoObject, value);
                return this;
            }
            this.delegate.write(value);
            return this;
        }

        public JsonGenerator writeNull() {
            if (this.isWritingPrimitive()) {
                this.state = WritingState.DONT_WRITE_END;
                this.delegate.writeNull(this.keyIfNoObject);
                return this;
            }
            this.delegate.writeNull();
            return this;
        }

        public void close() {
            this.delegate.close();
        }

        public void flush() {
            this.delegate.flush();
        }

        public JsonGenerator writeEnd() {
            return this.doWriteEnd(false);
        }

        private JsonGenerator doWriteEnd(boolean useDelegate) {
            if (this.nested == 0 && this.state == WritingState.WROTE_START) {
                this.state = WritingState.NONE;
            }
            if (this.nested > 0) {
                --this.nested;
            }
            if (!useDelegate && this.nested == 0 && SkipEnclosingWriteEnd.NOOP != this.writeEnd) {
                this.writeEnd.run();
            } else if (this.nested == 0) {
                JsonGenerator unwrap = this.unwrap(this.delegate);
                unwrap.writeEnd();
            } else {
                this.delegate.writeEnd();
            }
            return this;
        }

        private JsonGenerator unwrap(JsonGenerator delegate) {
            JsonGenerator current = delegate;
            while (SkipLastWriteEndGenerator.class.isInstance(current)) {
                current = ((SkipLastWriteEndGenerator)SkipLastWriteEndGenerator.class.cast((Object)current)).delegate;
            }
            return current;
        }

        public void endIfNeeded() {
            InObjectOrPrimitiveJsonGenerator.endIfNeeded(this);
        }

        private boolean isWritingPrimitive() {
            return this.state == WritingState.NONE && this.keyIfNoObject != null;
        }

        public static void endIfNeeded(JsonGenerator generator) {
            if (!InObjectOrPrimitiveJsonGenerator.class.isInstance(generator)) {
                return;
            }
            InObjectOrPrimitiveJsonGenerator jsonGenerator = (InObjectOrPrimitiveJsonGenerator)InObjectOrPrimitiveJsonGenerator.class.cast(generator);
            if (jsonGenerator.state == WritingState.WROTE_START) {
                jsonGenerator.doWriteEnd(true);
                jsonGenerator.state = WritingState.DONT_WRITE_END;
            }
        }
    }

    private static enum WritingState {
        NONE,
        WROTE_START,
        DONT_WRITE_END;

    }
}

