/*
 * Decompiled with CFR 0.152.
 */
package org.apache.johnzon.jsonschema.spi.builtin;

import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Stream;
import javax.json.JsonNumber;
import javax.json.JsonValue;
import org.apache.johnzon.jsonschema.ValidationResult;
import org.apache.johnzon.jsonschema.spi.ValidationContext;
import org.apache.johnzon.jsonschema.spi.ValidationExtension;
import org.apache.johnzon.jsonschema.spi.builtin.BaseNumberValidation;

public class MultipleOfValidation
implements ValidationExtension {
    @Override
    public Optional<Function<JsonValue, Stream<ValidationResult.ValidationError>>> create(ValidationContext model) {
        if (model.getSchema().getString("type", "object").equals("number")) {
            return Optional.ofNullable(model.getSchema().get((Object)"multipleOf")).filter(v -> v.getValueType() == JsonValue.ValueType.NUMBER).map(m -> new Impl(model.toPointer(), model.getValueProvider(), ((JsonNumber)JsonNumber.class.cast(m)).doubleValue()));
        }
        return Optional.empty();
    }

    static class Impl
    extends BaseNumberValidation {
        Impl(String pointer, Function<JsonValue, JsonValue> valueProvider, double multipleOf) {
            super(pointer, valueProvider, multipleOf);
        }

        @Override
        protected boolean isValid(double val) {
            double divided = val / this.bound;
            return divided == (double)((long)divided);
        }

        @Override
        protected Stream<ValidationResult.ValidationError> toError(double val) {
            return Stream.of(new ValidationResult.ValidationError(this.pointer, val + " is not a multiple of " + this.bound));
        }

        public String toString() {
            return "MultipleOf{factor=" + this.bound + ", pointer='" + this.pointer + '\'' + '}';
        }
    }
}

