/*
 * Decompiled with CFR 0.152.
 */
package org.apache.johnzon.jsonschema;

import java.util.Collection;
import java.util.Collections;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.json.JsonValue;
import org.apache.johnzon.jsonschema.ValidationResult;

public class JsonSchemaValidator
implements Function<JsonValue, ValidationResult>,
AutoCloseable {
    private static final ValidationResult SUCCESS = new ValidationResult(Collections.emptyList());
    private final Function<JsonValue, Stream<ValidationResult.ValidationError>> validationFunction;

    JsonSchemaValidator(Function<JsonValue, Stream<ValidationResult.ValidationError>> validationFunction) {
        this.validationFunction = validationFunction;
    }

    @Override
    public ValidationResult apply(JsonValue object) {
        Collection errors = this.validationFunction.apply(object).collect(Collectors.toList());
        if (!errors.isEmpty()) {
            return new ValidationResult(errors);
        }
        return SUCCESS;
    }

    @Override
    public void close() {
    }

    public String toString() {
        return "JsonSchemaValidator{validationFunction=" + this.validationFunction + '}';
    }
}

