/*
 * Decompiled with CFR 0.152.
 */
package org.apache.johnzon.jsonschema.generator;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.BiPredicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.json.JsonArray;
import javax.json.JsonNumber;
import javax.json.JsonObject;
import javax.json.JsonString;
import javax.json.JsonStructure;
import javax.json.JsonValue;
import javax.json.bind.annotation.JsonbProperty;
import javax.json.bind.annotation.JsonbTransient;
import org.apache.johnzon.jsonschema.generator.Schema;

public class SchemaProcessor {
    private final Class<?> persistenceCapable;
    private final boolean setClassAsTitle;
    private final boolean useReflectionForDefaults;

    public SchemaProcessor() {
        this(false, false);
    }

    public SchemaProcessor(boolean setClassAsTitle, boolean useReflectionForDefaults) {
        this.setClassAsTitle = setClassAsTitle;
        this.useReflectionForDefaults = useReflectionForDefaults;
        Class<?> pc = null;
        try {
            pc = Thread.currentThread().getContextClassLoader().loadClass("org.apache.openjpa.enhance.PersistenceCapable");
        }
        catch (ClassNotFoundException | NoClassDefFoundError throwable) {
            // empty catch block
        }
        this.persistenceCapable = pc;
    }

    public Schema mapSchemaFromClass(Type model) {
        return this.mapSchemaFromClass(model, new InMemoryCache());
    }

    public Schema mapSchemaFromClass(Type model, Cache cache) {
        ReflectionValueExtractor reflectionValueExtractor = this.useReflectionForDefaults ? new ReflectionValueExtractor() : null;
        return this.doMapSchemaFromClass(model, cache, reflectionValueExtractor, this.useReflectionForDefaults ? reflectionValueExtractor.createInstance(model) : null);
    }

    private Schema doMapSchemaFromClass(Type model, Cache cache, ReflectionValueExtractor reflectionValueExtractor, Instance instance) {
        Schema schema = new Schema();
        this.fillSchema(model, schema, cache, reflectionValueExtractor, instance);
        return schema;
    }

    public void fillSchema(Type rawModel, Schema schema, Cache cache, ReflectionValueExtractor reflectionValueExtractor, Instance instance) {
        Type model = this.unwrapType(rawModel);
        if (Class.class.isInstance(model)) {
            if (Boolean.TYPE == model) {
                schema.setType(Schema.SchemaType.bool);
            } else if (Boolean.class == model) {
                schema.setType(Schema.SchemaType.bool);
                schema.setNullable(true);
            } else if (String.class == model || JsonString.class == model) {
                schema.setType(Schema.SchemaType.string);
            } else if (Double.TYPE == model || Float.TYPE == model) {
                schema.setType(Schema.SchemaType.number);
            } else if (Double.class == model || Float.class == model || JsonNumber.class == model) {
                schema.setType(Schema.SchemaType.number);
                schema.setNullable(true);
            } else if (Integer.TYPE == model || Short.TYPE == model || Byte.TYPE == model || Long.TYPE == model) {
                schema.setType(Schema.SchemaType.integer);
            } else if (Integer.class == model || Short.class == model || Byte.class == model || Long.class == model) {
                schema.setType(Schema.SchemaType.integer);
                schema.setNullable(true);
            } else if (JsonObject.class == model || JsonValue.class == model || JsonStructure.class == model) {
                schema.setType(Schema.SchemaType.object);
                schema.setNullable(true);
                schema.setProperties(new TreeMap<String, Schema>());
            } else if (JsonArray.class == model) {
                schema.setType(Schema.SchemaType.array);
                schema.setNullable(true);
                Schema items = new Schema();
                items.setType(Schema.SchemaType.object);
                items.setProperties(new TreeMap<String, Schema>());
            } else if (this.isStringable(model)) {
                schema.setType(Schema.SchemaType.string);
                schema.setNullable(true);
            } else {
                Class from = (Class)Class.class.cast(model);
                if (from.isEnum()) {
                    schema.setId(from.getName().replace('.', '_').replace('$', '_'));
                    schema.setType(Schema.SchemaType.string);
                    schema.setEnumeration(Arrays.asList(from.getEnumConstants()));
                    schema.setNullable(true);
                } else if (from.isArray()) {
                    schema.setType(Schema.SchemaType.array);
                    Schema items = new Schema();
                    this.fillSchema(from.getComponentType(), items, cache, reflectionValueExtractor, instance);
                    schema.setItems(items);
                } else if (Collection.class.isAssignableFrom(from)) {
                    schema.setType(Schema.SchemaType.array);
                    Schema items = new Schema();
                    this.fillSchema((Type)((Object)Object.class), items, cache, reflectionValueExtractor, instance);
                    schema.setItems(items);
                } else {
                    schema.setType(Schema.SchemaType.object);
                    this.getOrCreateReusableObjectComponent(from, schema, cache, reflectionValueExtractor, instance);
                }
            }
        } else if (ParameterizedType.class.isInstance(model)) {
            ParameterizedType pt = (ParameterizedType)ParameterizedType.class.cast(model);
            if (Class.class.isInstance(pt.getRawType()) && Map.class.isAssignableFrom((Class)Class.class.cast(pt.getRawType()))) {
                schema.setType(Schema.SchemaType.object);
                this.getOrCreateReusableObjectComponent(Object.class, schema, cache, reflectionValueExtractor, instance);
            } else if (pt.getActualTypeArguments().length == 1 && Class.class.isInstance(pt.getActualTypeArguments()[0])) {
                schema.setType(Schema.SchemaType.array);
                Schema items = new Schema();
                Class type = (Class)Class.class.cast(pt.getActualTypeArguments()[0]);
                Instance item = instance != null && Collection.class.isInstance(instance.value) && !((Collection)Collection.class.cast(instance.value)).isEmpty() ? new Instance(((Collection)Collection.class.cast(instance.value)).iterator().next(), instance.isCreated()) : null;
                this.fillSchema(type, items, cache, reflectionValueExtractor, item);
                schema.setItems(items);
            } else {
                schema.setType(Schema.SchemaType.array);
            }
        } else if (TypeVariable.class.isInstance(model)) {
            schema.setType(Schema.SchemaType.object);
        } else {
            schema.setType(Schema.SchemaType.array);
            schema.setItems(new Schema());
        }
    }

    private void getOrCreateReusableObjectComponent(Class<?> from, Schema schema, Cache cache, ReflectionValueExtractor reflectionValueExtractor, Instance instance) {
        schema.setType(Schema.SchemaType.object);
        String ref = cache.findRef(from);
        if (ref != null) {
            schema.setRef(ref);
            cache.initDefinitions(from);
            return;
        }
        if (Object.class == from) {
            schema.setProperties(new TreeMap<String, Schema>());
            return;
        }
        if (this.setClassAsTitle) {
            schema.setTitle(from.getName());
        }
        BiPredicate<Type, String> ignored = this.createIgnorePredicate(from);
        cache.onClass(from);
        schema.setProperties(new TreeMap<String, Schema>());
        for (Class<?> current = from; current != null && current != Object.class; current = current.getSuperclass()) {
            Map<String, String> fields = Stream.of(current.getDeclaredFields()).filter(it -> this.isVisible((AnnotatedElement)it, it.getModifiers())).peek(f -> {
                if (Modifier.isFinal(f.getModifiers())) {
                    this.handleRequired(schema, () -> this.findFieldName((Field)f));
                }
            }).peek(f -> {
                String fieldName = this.findFieldName((Field)f);
                if (!ignored.test(f.getGenericType(), fieldName)) {
                    Instance fieldInstance = reflectionValueExtractor != null ? reflectionValueExtractor.createDemoInstance(instance == null ? null : instance.value, f) : null;
                    Schema value = this.doMapSchemaFromClass(this.resolveType(f.getGenericType(), from), cache, reflectionValueExtractor, fieldInstance);
                    this.fillMeta((Field)f, value);
                    if (fieldInstance != null && !fieldInstance.isCreated()) {
                        switch (value.getType()) {
                            case array: 
                            case object: {
                                break;
                            }
                            default: {
                                value.setDefaultValue(fieldInstance.value);
                            }
                        }
                    }
                    schema.getProperties().put(fieldName, value);
                } else {
                    this.onIgnored(schema, (Field)f, cache);
                }
            }).collect(Collectors.toMap(Field::getName, this::findFieldName));
            Stream.of(current.getDeclaredMethods()).filter(it -> this.isVisible((AnnotatedElement)it, it.getModifiers())).filter(it -> (it.getName().startsWith("get") || it.getName().startsWith("is")) && it.getName().length() > 2).forEach(m -> {
                String methodName = this.findMethodName((Method)m);
                String key = fields.getOrDefault(methodName, methodName);
                if (!ignored.test(this.resolveType(m.getGenericReturnType(), from), key) && !schema.getProperties().containsKey(key)) {
                    schema.getProperties().put(key, this.doMapSchemaFromClass(m.getGenericReturnType(), cache, null, null));
                }
            });
        }
        cache.onSchemaCreated(from, schema);
    }

    protected void fillMeta(Field f, Schema schema) {
        this.findDocAnnotation(f).ifPresent(doc -> {
            this.find("title", (Annotation)doc).ifPresent(schema::setTitle);
            if (schema.getTitle() == null) {
                this.find("value", (Annotation)doc).ifPresent(schema::setTitle);
            }
            this.find("description", (Annotation)doc).ifPresent(schema::setDescription);
        });
        Optional.ofNullable(f.getAnnotation(Deprecated.class)).map(it -> true).ifPresent(schema::setDeprecated);
    }

    protected Optional<Annotation> findDocAnnotation(Field f) {
        return Stream.of(f.getAnnotations()).filter(it -> it.annotationType().getSimpleName().startsWith("Doc") || it.annotationType().getSimpleName().startsWith("Desc")).min(Comparator.comparing(a -> a.annotationType().getName()));
    }

    private Optional<String> find(String method, Annotation doc) {
        try {
            String value = String.valueOf(doc.annotationType().getMethod(method, new Class[0]).invoke((Object)doc, new Object[0]));
            return value.isEmpty() ? Optional.empty() : Optional.of(value);
        }
        catch (Exception ex) {
            return Optional.empty();
        }
    }

    protected void onIgnored(Schema schema, Field f, Cache cache) {
    }

    protected BiPredicate<Type, String> createIgnorePredicate(Class<?> from) {
        return this.persistenceCapable != null && this.persistenceCapable.isAssignableFrom(from) ? (t, v) -> v.startsWith("pc") : (t, v) -> false;
    }

    private boolean isVisible(AnnotatedElement elt, int modifiers) {
        return !Modifier.isStatic(modifiers) && !elt.isAnnotationPresent(JsonbTransient.class);
    }

    private Type unwrapType(Type rawModel) {
        if (ParameterizedType.class.isInstance(rawModel)) {
            ParameterizedType parameterizedType = (ParameterizedType)ParameterizedType.class.cast(rawModel);
            if (Stream.of(parameterizedType.getActualTypeArguments()).allMatch(WildcardType.class::isInstance)) {
                return parameterizedType.getRawType();
            }
            if (Class.class.isInstance(parameterizedType.getRawType()) && CompletionStage.class.isAssignableFrom((Class)Class.class.cast(parameterizedType.getRawType()))) {
                return parameterizedType.getActualTypeArguments()[0];
            }
        }
        return rawModel;
    }

    private boolean isStringable(Type model) {
        return Date.class == model || model.getTypeName().startsWith("java.time.") || Class.class == model || Type.class == model || BigInteger.class == model || BigDecimal.class == model;
    }

    private void handleRequired(Schema schema, Supplier<String> nameSupplier) {
        if (schema.getRequired() == null) {
            schema.setRequired(new ArrayList<String>());
        }
        String name = nameSupplier.get();
        if (!schema.getRequired().contains(name)) {
            schema.getRequired().add(name);
        }
    }

    private String findFieldName(Field f) {
        String fName;
        block7: {
            if (f.isAnnotationPresent(JsonbProperty.class)) {
                return f.getAnnotation(JsonbProperty.class).value();
            }
            fName = f.getName();
            String subName = Character.toUpperCase(fName.charAt(0)) + (fName.length() > 1 ? fName.substring(1) : "");
            try {
                Method getter = f.getDeclaringClass().getMethod("get" + subName, new Class[0]);
                if (getter.isAnnotationPresent(JsonbProperty.class)) {
                    return getter.getAnnotation(JsonbProperty.class).value();
                }
            }
            catch (NoSuchMethodException e) {
                if (Boolean.TYPE != f.getType()) break block7;
                try {
                    Method isser = f.getDeclaringClass().getMethod("is" + subName, new Class[0]);
                    if (isser.isAnnotationPresent(JsonbProperty.class)) {
                        return isser.getAnnotation(JsonbProperty.class).value();
                    }
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    // empty catch block
                }
            }
        }
        return fName;
    }

    private String findMethodName(Method m) {
        if (m.isAnnotationPresent(JsonbProperty.class)) {
            return m.getAnnotation(JsonbProperty.class).value();
        }
        String name = m.getName();
        if (name.startsWith("get")) {
            return this.decapitalize(name.substring("get".length()));
        }
        if (name.startsWith("is")) {
            try {
                m.getDeclaringClass().getDeclaredField(name);
                return name;
            }
            catch (NoSuchFieldException nsme) {
                return this.decapitalize(name.substring("is".length()));
            }
        }
        return this.decapitalize(name);
    }

    private String decapitalize(String name) {
        return Character.toLowerCase(name.charAt(0)) + name.substring(1);
    }

    private Type resolveType(Type type, Class<?> declaringClass) {
        block6: {
            block7: {
                Type realType = this.extractRealType(declaringClass, type);
                if (!ParameterizedType.class.isInstance(type)) break block6;
                if (realType != type) break block7;
                if (!Stream.of(((ParameterizedType)ParameterizedType.class.cast(type)).getActualTypeArguments()).anyMatch(TypeVariable.class::isInstance)) break block6;
            }
            return this.resolveParameterizedType(type, declaringClass);
        }
        if (TypeVariable.class.isInstance(type) && declaringClass.getSuperclass() != null) {
            ParameterizedType pt;
            TypeVariable tv = (TypeVariable)TypeVariable.class.cast(type);
            TypeVariable<Class<?>>[] typeParameters = declaringClass.getSuperclass().getTypeParameters();
            if (typeParameters != null && ParameterizedType.class.isInstance(declaringClass.getGenericSuperclass()) && typeParameters.length == (pt = (ParameterizedType)ParameterizedType.class.cast(declaringClass.getGenericSuperclass())).getActualTypeArguments().length) {
                for (int i = 0; i < typeParameters.length; ++i) {
                    if (tv != typeParameters[i]) continue;
                    return pt.getActualTypeArguments()[i];
                }
            }
        }
        return type;
    }

    private Type resolveParameterizedType(Type type, Class<?> declaringClass) {
        ParameterizedType pt = (ParameterizedType)ParameterizedType.class.cast(type);
        Type resolvedParam = this.resolveType(pt.getActualTypeArguments()[0], declaringClass);
        if (pt.getActualTypeArguments()[0] != resolvedParam) {
            return new ParameterizedTypeImpl(pt.getRawType(), new Type[]{resolvedParam});
        }
        return type;
    }

    private Map<Type, Type> toResolvedTypes(Type clazz, int maxIt) {
        if (maxIt > 15) {
            return Collections.emptyMap();
        }
        if (Class.class.isInstance(clazz)) {
            return this.toResolvedTypes(((Class)Class.class.cast(clazz)).getGenericSuperclass(), maxIt + 1);
        }
        if (ParameterizedType.class.isInstance(clazz)) {
            ParameterizedType parameterizedType = (ParameterizedType)ParameterizedType.class.cast(clazz);
            if (!Class.class.isInstance(parameterizedType.getRawType())) {
                return Collections.emptyMap();
            }
            Class raw = (Class)Class.class.cast(parameterizedType.getRawType());
            Type[] arguments = parameterizedType.getActualTypeArguments();
            if (arguments.length > 0) {
                TypeVariable<Class<T>>[] parameters = raw.getTypeParameters();
                HashMap map = new HashMap(parameters.length);
                for (int i = 0; i < parameters.length && i < arguments.length; ++i) {
                    map.put(parameters[i], arguments[i]);
                }
                return Stream.concat(map.entrySet().stream(), this.toResolvedTypes(raw, maxIt + 1).entrySet().stream()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (a, b) -> a));
            }
        }
        return Collections.emptyMap();
    }

    private Type extractRealType(Class<?> root, Type type) {
        if (ParameterizedType.class.isInstance(type)) {
            ParameterizedType pt = (ParameterizedType)ParameterizedType.class.cast(type);
            return Stream.of(Optional.class, CompletionStage.class, CompletableFuture.class).anyMatch(gt -> pt.getRawType() == gt) ? (ParameterizedType.class.isInstance(pt.getActualTypeArguments()[0]) ? this.resolveParameterizedType(pt.getActualTypeArguments()[0], root) : pt.getActualTypeArguments()[0]) : pt;
        }
        if (TypeVariable.class.isInstance(type)) {
            Map<Type, Type> resolution = this.toResolvedTypes(root, 0);
            Type value = type;
            int max = 15;
            do {
                value = resolution.get(value);
            } while (--max > 0 && value != null && resolution.containsKey(value));
            return Optional.ofNullable(value).orElse(type);
        }
        return type;
    }

    public static class Instance {
        private final Object value;
        private final boolean created;

        public Instance(Object value, boolean created) {
            this.value = value;
            this.created = created;
        }

        public Object getValue() {
            return this.value;
        }

        public boolean isCreated() {
            return this.created;
        }
    }

    public static class ReflectionValueExtractor {
        private Instance createDemoInstance(Object rootInstance, Field field) {
            ParameterizedType pt;
            Type rawType;
            Type javaType;
            if (rootInstance != null && field != null) {
                try {
                    Object value;
                    if (!field.isAccessible()) {
                        field.setAccessible(true);
                    }
                    if ((value = field.get(rootInstance)) != null) {
                        return new Instance(value, false);
                    }
                }
                catch (IllegalAccessException e) {
                    throw new IllegalStateException(e);
                }
            }
            if (Class.class.isInstance(javaType = field.getGenericType())) {
                return new Instance(this.tryCreatingObjectInstance(javaType), true);
            }
            if (ParameterizedType.class.isInstance(javaType) && Class.class.isInstance(rawType = (pt = (ParameterizedType)ParameterizedType.class.cast(javaType)).getRawType()) && Collection.class.isAssignableFrom((Class)Class.class.cast(rawType)) && pt.getActualTypeArguments().length == 1 && Class.class.isInstance(pt.getActualTypeArguments()[0])) {
                Object instance = this.tryCreatingObjectInstance(pt.getActualTypeArguments()[0]);
                Class collectionType = (Class)Class.class.cast(rawType);
                if (Set.class == collectionType) {
                    return new Instance(Collections.singleton(instance), true);
                }
                if (SortedSet.class == collectionType) {
                    return new Instance(new TreeSet<Object>(Collections.singletonList(instance)), true);
                }
                if (List.class == collectionType || Collection.class == collectionType) {
                    return new Instance(Collections.singletonList(instance), true);
                }
                return null;
            }
            return null;
        }

        private Object tryCreatingObjectInstance(Type javaType) {
            Class type = (Class)Class.class.cast(javaType);
            if (type.isPrimitive()) {
                if (Integer.TYPE == type) {
                    return 0;
                }
                if (Long.TYPE == type) {
                    return 0L;
                }
                if (Double.TYPE == type) {
                    return 0.0;
                }
                if (Float.TYPE == type) {
                    return Float.valueOf(0.0f);
                }
                if (Short.TYPE == type) {
                    return (short)0;
                }
                if (Byte.TYPE == type) {
                    return (byte)0;
                }
                if (Boolean.TYPE == type) {
                    return false;
                }
                throw new IllegalArgumentException("Not a primitive: " + type);
            }
            if (Integer.class == type) {
                return 0;
            }
            if (Long.class == type) {
                return 0L;
            }
            if (Double.class == type) {
                return 0.0;
            }
            if (Float.class == type) {
                return Float.valueOf(0.0f);
            }
            if (Short.class == type) {
                return (short)0;
            }
            if (Byte.class == type) {
                return (byte)0;
            }
            if (Boolean.class == type) {
                return false;
            }
            if (type.getName().startsWith("java.") || type.getName().startsWith("javax.")) {
                return null;
            }
            try {
                return type.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
                return null;
            }
        }

        private Instance createInstance(Type model) {
            if (Class.class.isInstance(model)) {
                try {
                    return new Instance(((Class)Class.class.cast(model)).getConstructor(new Class[0]).newInstance(new Object[0]), true);
                }
                catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
                    // empty catch block
                }
            }
            return null;
        }
    }

    public static class InMemoryCache
    implements Cache {
        private final Map<Class<?>, String> refs = new HashMap();
        private final Map<Class<?>, Schema> schemas = new HashMap();
        private final Map<String, Schema> definitions = new TreeMap<String, Schema>();

        public Map<Class<?>, Schema> getSchemas() {
            return this.schemas;
        }

        public Map<String, Schema> getDefinitions() {
            return this.definitions;
        }

        @Override
        public String findRef(Class<?> type) {
            if (type != Object.class) {
                return this.refs.get(type);
            }
            return null;
        }

        @Override
        public void onClass(Class<?> type) {
            this.refs.putIfAbsent(type, this.sanitize(type));
        }

        @Override
        public void onSchemaCreated(Class<?> type, Schema schema) {
            String ref;
            if (this.schemas.putIfAbsent(type, schema) == null) {
                String ref2;
                if (schema.getId() == null && (ref2 = this.findRef(type)) != null) {
                    schema.setId(ref2.substring(this.getRefPrefix().length()));
                }
            } else if (schema.getRef() == null && (ref = this.findRef(type)) != null) {
                schema.setRef(ref);
            }
        }

        @Override
        public void initDefinitions(Class<?> from) {
            if (from == Object.class) {
                return;
            }
            Optional.ofNullable(this.schemas.get(from)).ifPresent(s -> this.definitions.put(this.findRef(from).substring(this.getRefPrefix().length()), (Schema)s));
        }

        private String sanitize(Class<?> type) {
            return this.getRefPrefix() + type.getName().replace('$', '_').replace('.', '_');
        }

        protected String getRefPrefix() {
            return "#/definitions/";
        }
    }

    public static interface Cache {
        public String findRef(Class<?> var1);

        public void onClass(Class<?> var1);

        public void onSchemaCreated(Class<?> var1, Schema var2);

        public void initDefinitions(Class<?> var1);
    }

    private static class ParameterizedTypeImpl
    implements ParameterizedType {
        private final Type rawType;
        private final Type[] actualTypeArguments;

        private ParameterizedTypeImpl(Type rawType, Type[] actualTypeArguments) {
            this.rawType = rawType;
            this.actualTypeArguments = actualTypeArguments;
        }

        @Override
        public Type getRawType() {
            return this.rawType;
        }

        @Override
        public Type[] getActualTypeArguments() {
            return this.actualTypeArguments;
        }

        @Override
        public Type getOwnerType() {
            return null;
        }

        public String toString() {
            StringBuilder buffer = new StringBuilder();
            buffer.append(((Class)this.rawType).getSimpleName());
            Type[] actualTypes = this.getActualTypeArguments();
            if (actualTypes.length > 0) {
                buffer.append("<");
                int length = actualTypes.length;
                for (int i = 0; i < length; ++i) {
                    buffer.append(actualTypes[i].toString());
                    if (i == actualTypes.length - 1) continue;
                    buffer.append(",");
                }
                buffer.append(">");
            }
            return buffer.toString();
        }
    }
}

