/*
 * Decompiled with CFR 0.152.
 */
package org.apache.johnzon.jsonb.polymorphism;

import jakarta.json.JsonObject;
import jakarta.json.JsonString;
import jakarta.json.JsonValue;
import jakarta.json.bind.JsonbException;
import jakarta.json.bind.annotation.JsonbSubtype;
import jakarta.json.bind.annotation.JsonbTypeInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.johnzon.jsonb.polymorphism.JsonbPolymorphismTypeInfo;
import org.apache.johnzon.mapper.access.Meta;

public class JsonbPolymorphismHandler {
    private final Map<Class<?>, JsonbPolymorphismTypeInfo> typeInfoCache = new HashMap();

    public boolean hasPolymorphism(Class<?> clazz) {
        return Meta.getAnnotation(clazz, JsonbTypeInfo.class) != null || this.getParentWithTypeInfo(clazz) != null;
    }

    public Map.Entry<String, String>[] getPolymorphismPropertiesToSerialize(Class<?> clazz, Collection<String> otherProperties) {
        ArrayList<Map.Entry<String, Object>> result = new ArrayList<Map.Entry<String, Object>>();
        Class<?> current = clazz;
        while (current != null) {
            JsonbTypeInfo typeInfo = (JsonbTypeInfo)Meta.getAnnotation(current, JsonbTypeInfo.class);
            if (typeInfo != null) {
                if (otherProperties.contains(typeInfo.key())) {
                    throw new JsonbException("JsonbTypeInfo key '" + typeInfo.key() + "' collides with other properties in json");
                }
                String bestMatchingAlias = null;
                for (JsonbSubtype subtype : typeInfo.value()) {
                    if (!subtype.type().isAssignableFrom(clazz)) continue;
                    bestMatchingAlias = subtype.alias();
                    if (clazz == subtype.type()) break;
                }
                if (bestMatchingAlias != null) {
                    result.add(0, Map.entry(typeInfo.key(), bestMatchingAlias));
                }
            }
            current = this.getParentWithTypeInfo(current);
        }
        return (Map.Entry[])result.toArray(Map.Entry[]::new);
    }

    public Class<?> getTypeToDeserialize(JsonObject jsonObject, Class<?> clazz) {
        JsonbPolymorphismTypeInfo typeInfo = this.typeInfoCache.get(clazz);
        if (typeInfo == null) {
            return clazz;
        }
        JsonValue typeValue = (JsonValue)jsonObject.get((Object)typeInfo.getTypeKey());
        if (typeValue == null) {
            return clazz;
        }
        if (typeValue.getValueType() != JsonValue.ValueType.STRING) {
            throw new JsonbException("Property '" + typeInfo.getTypeKey() + "' isn't a String, resolving JsonbSubtype is impossible");
        }
        String typeValueString = ((JsonString)typeValue).getString();
        Class<?> result = typeInfo.getAliases().get(typeValueString);
        if (result == null) {
            throw new JsonbException("No JsonbSubtype found for alias '" + typeValueString + "' on " + clazz.getName());
        }
        return result;
    }

    public void populateTypeInfoCache(Class<?> clazz) {
        if (this.typeInfoCache.containsKey(clazz)) {
            return;
        }
        JsonbTypeInfo annotation = (JsonbTypeInfo)Meta.getAnnotation(clazz, JsonbTypeInfo.class);
        if (annotation != null) {
            this.typeInfoCache.put(clazz, new JsonbPolymorphismTypeInfo(annotation));
        }
    }

    public void validateJsonbPolymorphismAnnotations(Class<?> classToValidate) {
        this.validateSubtypeCompatibility(classToValidate);
        this.validateOnlyOneParentWithTypeInfo(classToValidate);
        this.validateNoTypeInfoKeyCollision(classToValidate);
    }

    protected void validateSubtypeCompatibility(Class<?> classToValidate) {
        JsonbTypeInfo typeInfo = (JsonbTypeInfo)Meta.getAnnotation(classToValidate, JsonbTypeInfo.class);
        if (typeInfo == null) {
            return;
        }
        for (JsonbSubtype subtype : typeInfo.value()) {
            if (classToValidate.isAssignableFrom(subtype.type())) continue;
            throw new JsonbException("JsonbSubtype '" + subtype.alias() + "' (" + subtype.type().getName() + ") is not a subclass of " + classToValidate);
        }
    }

    protected void validateOnlyOneParentWithTypeInfo(Class<?> classToValidate) {
        boolean found = classToValidate.getSuperclass() != null && Meta.getAnnotation(classToValidate.getSuperclass(), JsonbTypeInfo.class) != null;
        for (Class<?> iface : classToValidate.getInterfaces()) {
            if (iface == null || Meta.getAnnotation(iface, JsonbTypeInfo.class) == null) continue;
            if (found) {
                throw new JsonbException("More than one interface/superclass of " + classToValidate.getName() + " has JsonbTypeInfo Annotation");
            }
            found = true;
        }
    }

    protected void validateNoTypeInfoKeyCollision(Class<?> classToValidate) {
        HashMap keyToDefiningClass = new HashMap();
        Class<?> current = classToValidate;
        while (current != null) {
            String key;
            Class<?> existing;
            JsonbTypeInfo annotation = (JsonbTypeInfo)Meta.getAnnotation(current, JsonbTypeInfo.class);
            if (annotation != null && (existing = keyToDefiningClass.put(key = annotation.key(), current)) != null) {
                throw new JsonbException("JsonbTypeInfo key '" + key + "' found more than once in type hierarchy of " + classToValidate + " (first defined in " + existing.getName() + ", then defined again in " + current.getName() + ")");
            }
            current = this.getParentWithTypeInfo(current);
        }
    }

    protected Class<?> getParentWithTypeInfo(Class<?> clazz) {
        if (clazz.getSuperclass() != null && Meta.getAnnotation(clazz.getSuperclass(), JsonbTypeInfo.class) != null) {
            return clazz.getSuperclass();
        }
        for (Class<?> iface : clazz.getInterfaces()) {
            if (Meta.getAnnotation(iface, JsonbTypeInfo.class) == null) continue;
            return iface;
        }
        return null;
    }
}

