/*
 * Decompiled with CFR 0.152.
 */
package org.apache.johnzon.jaxrs;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import javax.json.JsonReaderFactory;
import javax.json.stream.JsonGeneratorFactory;
import javax.ws.rs.Consumes;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Provider;
import org.apache.johnzon.jaxrs.JohnzonProvider;
import org.apache.johnzon.mapper.MapperBuilder;
import org.apache.johnzon.mapper.SerializeValueFilter;
import org.apache.johnzon.mapper.access.AccessMode;

@Provider
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public class ConfigurableJohnzonProvider<T>
implements MessageBodyWriter<T>,
MessageBodyReader<T> {
    private MapperBuilder builder = new MapperBuilder();
    private List<String> ignores;
    private AtomicReference<JohnzonProvider<T>> delegate = new AtomicReference();

    private JohnzonProvider<T> instance() {
        JohnzonProvider<T> instance;
        do {
            instance = this.delegate.get();
            if (this.builder == null || !this.delegate.compareAndSet(null, new JohnzonProvider(this.builder.build(), this.ignores))) continue;
            this.builder = null;
            this.ignores = null;
        } while (instance == null);
        return instance;
    }

    public boolean isReadable(Class<?> rawType, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return this.instance().isReadable(rawType, genericType, annotations, mediaType);
    }

    public T readFrom(Class<T> rawType, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream entityStream) throws IOException {
        return this.instance().readFrom(rawType, genericType, annotations, mediaType, httpHeaders, entityStream);
    }

    public long getSize(T t, Class<?> rawType, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return this.instance().getSize(t, rawType, genericType, annotations, mediaType);
    }

    public boolean isWriteable(Class<?> rawType, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return this.instance().isWriteable(rawType, genericType, annotations, mediaType);
    }

    public void writeTo(T t, Class<?> rawType, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException {
        this.instance().writeTo(t, rawType, genericType, annotations, mediaType, httpHeaders, entityStream);
    }

    public void setIgnoreFieldsForType(String mapping) {
        for (String config : mapping.split(" *| *")) {
            String[] parts = config.split(" *= *");
            try {
                Class<?> type = Thread.currentThread().getContextClassLoader().loadClass(parts[0]);
                if (parts.length == 1) {
                    this.builder.setIgnoreFieldsForType(type, new String[0]);
                    continue;
                }
                this.builder.setIgnoreFieldsForType(type, parts[1].split(" *, *"));
            }
            catch (ClassNotFoundException e) {
                throw new IllegalArgumentException(e);
            }
        }
    }

    public void setFailOnUnknownProperties(boolean active) {
        this.builder.setFailOnUnknownProperties(active);
    }

    public void setSupportConstructors(boolean supportConstructors) {
        this.builder.setSupportConstructors(supportConstructors);
    }

    public void setPretty(boolean pretty) {
        this.builder.setPretty(pretty);
    }

    public void setSupportGetterForCollections(boolean supportGetterForCollections) {
        this.builder.setSupportGetterForCollections(supportGetterForCollections);
    }

    public void setSupportsComments(boolean supportsComments) {
        this.builder.setSupportsComments(supportsComments);
    }

    public void setIgnores(String ignores) {
        this.ignores = ignores == null ? null : Arrays.asList(ignores.split(" *, *"));
    }

    public void setAccessMode(AccessMode mode) {
        this.builder.setAccessMode(mode);
    }

    public void setAccessModeName(String mode) {
        this.builder.setAccessModeName(mode);
    }

    public void setSupportHiddenAccess(boolean supportHiddenAccess) {
        this.builder.setSupportHiddenAccess(supportHiddenAccess);
    }

    public void setAttributeOrder(Comparator<String> attributeOrder) {
        this.builder.setAttributeOrder(attributeOrder);
    }

    public void setReaderFactory(JsonReaderFactory readerFactory) {
        this.builder.setReaderFactory(readerFactory);
    }

    public void setGeneratorFactory(JsonGeneratorFactory generatorFactory) {
        this.builder.setGeneratorFactory(generatorFactory);
    }

    public void setDoCloseOnStreams(boolean doCloseOnStreams) {
        this.builder.setDoCloseOnStreams(doCloseOnStreams);
    }

    public void setVersion(int version) {
        this.builder.setVersion(version);
    }

    public void setSkipNull(boolean skipNull) {
        this.builder.setSkipNull(skipNull);
    }

    public void setSkipEmptyArray(boolean skipEmptyArray) {
        this.builder.setSkipEmptyArray(skipEmptyArray);
    }

    public void setBufferSize(int bufferSize) {
        this.builder.setBufferSize(bufferSize);
    }

    public void setBufferStrategy(String bufferStrategy) {
        this.builder.setBufferStrategy(bufferStrategy);
    }

    public void setMaxSize(int size) {
        this.builder.setMaxSize(size);
    }

    public void setTreatByteArrayAsBase64(boolean treatByteArrayAsBase64) {
        this.builder.setTreatByteArrayAsBase64(treatByteArrayAsBase64);
    }

    public void setEncoding(String encoding) {
        this.builder.setEncoding(encoding);
    }

    public void setReadAttributeBeforeWrite(boolean rabw) {
        this.builder.setReadAttributeBeforeWrite(rabw);
    }

    public void setEnforceQuoteString(boolean val) {
        this.builder.setEnforceQuoteString(val);
    }

    public void setPrimitiveConverters(boolean val) {
        this.builder.setPrimitiveConverters(val);
    }

    public MapperBuilder setDeduplicateObjects(boolean deduplicateObjects) {
        return this.builder.setDeduplicateObjects(Boolean.valueOf(deduplicateObjects));
    }

    public void setSerializeValueFilter(String val) {
        try {
            this.builder.setSerializeValueFilter((SerializeValueFilter)SerializeValueFilter.class.cast(Thread.currentThread().getContextClassLoader().loadClass(val).getConstructor(new Class[0]).newInstance(new Object[0])));
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException e) {
            throw new IllegalArgumentException(e);
        }
        catch (InvocationTargetException e) {
            throw new IllegalArgumentException(e.getCause());
        }
    }

    public void setUseBigDecimalForFloats(boolean useBigDecimalForFloats) {
        this.builder.setUseBigDecimalForFloats(useBigDecimalForFloats);
    }

    public void setAutoAdjustStringBuffers(boolean autoAdjustStringBuffers) {
        this.builder.setAutoAdjustStringBuffers(autoAdjustStringBuffers);
    }
}

